const { Op, fn, col } = require('sequelize');
const bcrypt = require('bcryptjs');
const jwt = require('jsonwebtoken');
const axios = require('axios');
const date = require('date-and-time');
const db = require('../config/db.config');
const moment = require('moment-timezone');
const crypto = require('crypto')
const Transactions = require('../models/Associations')
const allowedIps = [
    '64.23.248.125',
    '64.23.252.143',
    '64.23.252.78',
    '164.92.113.159',
    '165.22.106.229',
    '139.59.84.138',
    '159.223.195.188',
    '159.223.198.138',
    '159.223.196.167',
    '146.190.152.146'
];
const allowedDomains = new Set([
    'dummy.logiclane.tech',
    'bend.logiclane.tech',
    'swback.logiclane.tech',
    // 'localhost',
]);

exports.getSessionKey = async (req, res) => {
    try {
        const { userId } = req.body
        const response = await axios.get('https://api-sandbox.coinflow.cash/api/auth/session-key', {
            headers: {
                'Authorization': 'coinflow_sandbox_ae009956adfa4fa18c3adb36edbdf470_e1199272cb694bd69399bd57816f32f5',
                'accept': 'application/json',
                'x-coinflow-auth-user-id': userId.toString()
            }
        });
        res.json(response?.data)
        console.log('Session Key Response:', response.data);
    } catch (error) {
        res.json({ status: "error", data: error?.response?.data })

        console.error('Error fetching session key:', error.response ? error.response.data : error.message);
    }
}
const getSessionKey = async (req, res) => {
    try {
        const response = await axios.get('https://api-sandbox.coinflow.cash/api/auth/session-key', {
            headers: {
                'Authorization': 'coinflow_sandbox_ae009956adfa4fa18c3adb36edbdf470_e1199272cb694bd69399bd57816f32f5',
                'accept': 'application/json',
                'x-coinflow-auth-user-id': 'xyz1123'
            }
        });
        return response?.data
        // res.json(response?.data)
        // console.log('Session Key Response:', response.data);
    } catch (error) {
        // return error?.response?.data
        // res.json({ status: "error", data: error?.response?.data })
        console.error('Error fetching session key:', error.response ? error.response.data : error.message);
    }
}

exports.createCoinFlowTransaction = async (req, res) => {
    const {
        userid,
        amount,
        site,
        card,
        subtotalCents,
        authentication3DS
    } = req.body;

    const tx = await Transactions.create({
        userid: userid.toString(),
        txnby: 'SELF',
        type: 1,
        amount: subtotalCents / 100,
        paidmethod: 'CoinFlow',
        paidto: 'Credit Card',
        status: 0,
    });

    const pcodecc = `SW-${tx.id}`;
    tx.p_codecc = pcodecc;
    await tx.save();

    // const txnidnew = tx.id;

    const {

    } = req.body;

    // const tx = await Transactions.create({
    //     amount: subtotalCents,
    //     status: 'initiated',
    // });

    const payload = {
        subtotal: { cents: subtotalCents },
        authentication3DS,
        card,
        saveCard: true,
    };

    try {
        const sessionKey = await getSessionKey()
        const response = await axios.post(
            'https://api-sandbox.coinflow.cash/api/checkout/card/rc-amusement',
            payload,
            {
                headers: {
                    accept: 'application/json',
                    'content-type': 'application/json',
                    'x-coinflow-auth-session-key': sessionKey?.key,
                    // 'x-coinflow-auth-blockchain': 'ENTER_BLOCKCHAIN',
                    // 'x-coinflow-auth-wallet': 'ENTER_USER_WALLET_ADDRESS',
                },
            }
        );
        await paymentStatusAPay(userid, pcodecc, 'success', site);

        // await tx.update({
        //     status: 'completed',
        //     paymentId: response.data.paymentId,
        // });

        return res.json({
            status: 'success',
            paymentId: response.data.paymentId,
        });
    } catch (error) {
        if (error.response?.status === 412) {
            const { transactionId, creq, url } = error.response.data;

            // await tx.update({
            //     transactionId,
            //     status: 'challenge_required',
            // });

            return res.status(412).json({
                p_code: pcodecc,
                status: 'challenge_required',
                transactionId,
                creq,
                url,
            });
        }

        console.error(error.message);
        await tx.update({ status: 'failed' });

        return res.status(500).json({
            status: 'failed',
            message: 'Internal error or invalid card details',
        });
    }
}
exports.completeCoinFlowTransaction = async (req, res) => {

    const { transactionId, card, subtotalCents, pcodecc } = req.body;

    if (!transactionId || !card || !subtotalCents || !pcodecc) {
        return res.status(400).json({ status: 'error', message: 'Missing fields' });
    }

    const tx = await Transactions.findOne({ where: { p_codecc: pcodecc } });

    if (!tx) {
        return res.status(404).json({ status: 'error', message: 'Transaction not found' });
    }

    const payload = {
        subtotal: { cents: subtotalCents },
        authentication3DS: { transactionId },
        card,
        saveCard: true,
    };

    try {
        const sessionKey = await getSessionKey()
        const response = await axios.post(
            'https://api-sandbox.coinflow.cash/api/checkout/card/rc-amusement',
            payload,
            {
                headers: {
                    accept: 'application/json',
                    'content-type': 'application/json',
                    'x-coinflow-auth-session-key': sessionKey?.key,
                    // 'x-coinflow-auth-blockchain': 'ENTER_BLOCKCHAIN',
                    // 'x-coinflow-auth-wallet': 'ENTER_USER_WALLET_ADDRESS',
                },
            }
        );

        await paymentStatusAPay(userid, pcodecc, 'success', site);


        // await tx.update({
        //     status: 'completed',
        //     paymentId: response.data.paymentId,
        // });

        return res.json({
            status: 'success',
            paymentId: response.data.paymentId,
        });
    } catch (error) {
        console.error('Complete error:', error.message);
        await paymentStatusAPay(userid, pcodecc, 'failed', site);

        // await tx.update({ status: 'failed' });

        return res.status(500).json({
            status: 'failed',
            message: 'Could not complete payment',
        });
    }
}