// const User = require('../models/User')
const Admin = require('../models/Admin')
const PaymentMethods = require('../models/PaymentMethods');
const BlockedBins = require('../models/BlockedBins');
const BlockedCards = require('../models/BlockedCards');
const BrDeposit = require('../models/BRTransactions');
const HappyHour = require('../models/HappyHour');
const DecBonus = require('../models/DecBonus');
const NYBonus = require('../models/NYBonus');
const NBonus = require('../models/NBonus');
const WheelSpin = require('../models/WheelSpin')
const FlaggedPayments = require('../models/FlaggedPayments');
const Sharer = require('../models/Sharer');
const Refs = require('../models/Referrals');
const bcrypt = require('bcryptjs');
const crypto = require('crypto');
const jwt = require('jsonwebtoken');
const axios = require('axios');
const date = require('date-and-time')
const xss = require('xss');
const lockfile = require('proper-lockfile');
const validator = require('validator');
const { Op, QueryTypes, fn, col } = require('sequelize');
const db = require('../config/db.config')
const fs = require("fs");
const path = require('path');
const base64url = require('base64url');
const moment = require('moment-timezone');
const dayjs = require('dayjs');
const {
    User,
    Game,
    Transactions,
    Withdraw,
    Redeem,
    BRTransactions,
    LinkedGames,
    SavedCards,
    ActivityLog,
    Creation,
    RefCodes,
    GamePassReset,
    WheelTxn,
    RaffleWins,
    Raffles,
    Bonus
} = require('../models/Associations');
const AllBonuses = require('../models/AllBonuses');
const PayoutMethods = require('../models/PayoutMethods');
const { PDFDocument, rgb, StandardFonts } = require('pdf-lib');
const BonusRaffle = require('../models/BonusRaffles');
// const { createPnmPaymentMethod } = require('./Users');
const ENC_KEY = process.env.ENC_KEY;
const JWT_SECRET = process.env.JWT_SECRET;
const CARD_ENC_KEY = process.env.CARD_ENC_KEY;

require('dotenv').config()

function generateID(length) {
    const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    let result = '';
    for (let i = 0; i < length; i++) {
        result += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    return result;
}
function generateRandomString(length) {
    const characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    return Array.from({ length }, () => characters[Math.floor(Math.random() * characters.length)]).join('');
}
function decrypt(encodedText, cryptKey) {
    const cipher = 'aes-256-cbc';

    const keyBuffer = Buffer.from(cryptKey, 'utf8');
    let key = keyBuffer;
    if (key.length < 32) {
        key = Buffer.concat([key, Buffer.alloc(32 - key.length)], 32);
    } else if (key.length > 32) {
        key = key.slice(0, 32);
    }
    const encryptedBuffer = Buffer.from(encodedText, 'base64');
    const ivlen = 16;
    const iv = encryptedBuffer.slice(0, ivlen);
    const hmac = encryptedBuffer.slice(ivlen, ivlen + 32);
    const ciphertext = encryptedBuffer.slice(ivlen + 32);

    const decipher = crypto.createDecipheriv(cipher, key, iv);
    let decrypted = decipher.update(ciphertext, 'binary', 'utf8');
    decrypted += decipher.final('utf8');

    const verify = crypto.createHmac('sha256', key);
    verify.update(ciphertext);
    const calculatedHmac = verify.digest();

    if (!crypto.timingSafeEqual(hmac, calculatedHmac)) {
        throw new Error('Integrity check failed.');
    }

    return decrypted;
}
function encrypt(plainText, cryptKey) {
    const cipher = 'aes-256-cbc';

    // Prepare key
    const keyBuffer = Buffer.from(cryptKey, 'utf8');
    let key = keyBuffer;
    if (key.length < 32) {
        key = Buffer.concat([key, Buffer.alloc(32 - key.length)], 32);
    } else if (key.length > 32) {
        key = key.slice(0, 32);
    }

    // Generate a random IV
    const ivlen = 16;
    const iv = crypto.randomBytes(ivlen);

    // Create cipher
    const cipherInstance = crypto.createCipheriv(cipher, key, iv);
    let encrypted = cipherInstance.update(plainText, 'utf8', 'binary');
    encrypted += cipherInstance.final('binary');
    const ciphertext = Buffer.from(encrypted, 'binary');

    // Generate HMAC for integrity verification
    const hmac = crypto.createHmac('sha256', key);
    hmac.update(ciphertext);
    const hmacDigest = hmac.digest();

    // Combine IV, HMAC, and ciphertext
    const resultBuffer = Buffer.concat([iv, hmacDigest, ciphertext]);
    return resultBuffer.toString('base64');
}

const getSessionKey = async (userId) => {
    try {

        const response = await axios.get('https://api-sandbox.coinflow.cash/api/auth/session-key', {
            headers: {
                'Authorization': 'coinflow_sandbox_ae009956adfa4fa18c3adb36edbdf470_e1199272cb694bd69399bd57816f32f5',
                'accept': 'application/json',
                'x-coinflow-auth-user-id': userId
            }
        });
        // const response = await axios.get('https://api.coinflow.cash/api/auth/session-key', {
        //     headers: {
        //         'Authorization': 'coinflow_prod_fb228961487143f6867d324ff6e58dd7_49d72e1213644a06becae93b36a36fad',
        //         'accept': 'application/json',
        //         'x-coinflow-auth-user-id': userId
        //     }
        // });
        return response?.data
        // res.json(response?.data)
        // console.log('Session Key Response:', response.data);
    } catch (error) {
        // return error?.response?.data
        // res.json({ status: "error", data: error?.response?.data })
        console.error('Error fetching session key:', error.response ? error.response.data : error.message);
    }
}
function isRawCardNumber(token) {
    return /^\d{13,19}$/.test(token);
}

exports.tokenizeCardEndpoint = async (req, res) => {
    try {
        const { card } = req.body
        const response = await axios.post(
            'https://api-sandbox.coinflow.cash/api/tokenize',
            {
                data: card.cardNumber,
                cvv: card.cvv
            },
            {
                headers: {
                    'Authorization': 'coinflow_sandbox_ae009956adfa4fa18c3adb36edbdf470_e1199272cb694bd69399bd57816f32f5',
                    'accept': 'application/json',
                    'content-type': 'application/json',
                    'tx-apikey': 'jFQQ2yjKrLMcPeQVrBdixtle34nA6YTsYQXSy8Cv',
                    'tx-token-scheme': 'sixANTOKENfour',
                    'tx-tokenex-id': '4582952996979143'
                }
            }
        );
        console.log(card)
        // const response = await axios.post(
        //     'https://api.coinflow.cash/api/tokenize',
        //     {
        //         data: card.cardNumber,
        //         cvv: card.cvv
        //     },
        //     {
        //         headers: {
        //             'Authorization': 'coinflow_prod_fb228961487143f6867d324ff6e58dd7_49d72e1213644a06becae93b36a36fad',
        //             'accept': 'application/json',
        //             'content-type': 'application/json',
        //             'tx-apikey': 'EM5jll4lASrdDyKuRaPHzMojHstWZAisVsu7DtEM',
        //             'tx-token-scheme': 'sixANTOKENfour',
        //             'tx-tokenex-id': '2781185452603874'
        //         }
        //     }
        // );

        if (response.data.success) {
            res.json(response.data.token);
        } else {
            res.json(response.data.error ?? response.data.message)
        }

    } catch (error) {
        return res.json(error?.message)

        console.error('Tokenization error:', error.message || error);
        throw error;
    }
}

async function tokenizeCard(cardNumber, cvv) {
    try {
        const response = await axios.post(
            'https://api-sandbox.coinflow.cash/api/tokenize',
            {
                data: cardNumber,
                cvv: cvv
            },
            {
                headers: {
                    'Authorization': 'coinflow_sandbox_ae009956adfa4fa18c3adb36edbdf470_e1199272cb694bd69399bd57816f32f5',
                    'accept': 'application/json',
                    'content-type': 'application/json',
                    'tx-apikey': 'jFQQ2yjKrLMcPeQVrBdixtle34nA6YTsYQXSy8Cv',
                    'tx-token-scheme': 'sixANTOKENfour',
                    'tx-tokenex-id': '4582952996979143'
                }
            }
        );

        // const response = await axios.post(
        //     'https://api.coinflow.cash/api/tokenize',
        //     {
        //         data: cardNumber,
        //         cvv: cvv
        //     },
        //     {
        //         headers: {
        //             'Authorization': 'coinflow_prod_fb228961487143f6867d324ff6e58dd7_49d72e1213644a06becae93b36a36fad',
        //             'accept': 'application/json',
        //             'content-type': 'application/json',
        //             'tx-apikey': 'EM5jll4lASrdDyKuRaPHzMojHstWZAisVsu7DtEM',
        //             'tx-token-scheme': 'sixANTOKENfour',
        //             'tx-tokenex-id': '2781185452603874'
        //         }
        //     }
        // );

        if (response.data.success) {
            return response.data.token;
        } else {
            throw new Error(`Tokenization failed: ${response.data.message || response.data.error}`);
        }
    } catch (error) {
        console.error('Tokenization error:', error.message || error);
        throw error;
    }
}
exports.createCoinFlowTransaction = async (req, res) => {
    const {
        userid,
        card_id,
        site,
        card,
        subtotal,
        authentication3DS,
        x_device_id,
        x_coinflow_client_ip
    } = req.body;
    console.log(req.body)

    const user = await User.findOne({ where: { id: userid } })
    if (!user) {
        return res.json({
            status: 'error',
            message: 'User not found',
        });
    }

    const tx = await Transactions.create({
        userid: userid.toString(),
        txnby: 'SELF',
        type: 1,
        amount: parseFloat(subtotal?.cents) / 100,
        paidmethod: 'CoinFlow',
        paidto: 'Credit Card',
        status: 0,
    });

    const pcodecc = `SW-${tx.id}`;
    tx.p_codecc = pcodecc;
    await tx.save();

    const txnidnew = tx.id;

    const refs = await Refs.findOne({ where: { userid } });
    if (refs && !refs.first_txn) {
        refs.txn_amount = parseFloat(subtotal?.cents) / 100;
        refs.txn_id = txnidnew;
        await refs.save();
    }

    const cardData = await SavedCards.findOne({ where: { id: card_id } })
    if (!cardData) {
        return res.json({
            status: 'error',
            message: 'Card not found',
        });
    }
    if (cardData.cfToken) {
        card.cardToken = cardData.cfToken
        delete card.cvv;
    }

    console.log(card)

    const payload = {
        subtotal: { cents: subtotal?.cents },
        authentication3DS,
        card: {
            ...card,
            email: user.email
        },
        saveCard: true,
        webhookInfo: {
            p_code: pcodecc,
        },
        transactionData: {
            type: "token",
            destination: "0xRecipientAddressHere"
        },
        chargebackProtectionData: [
            {
                productType: "topUp",
                productName: "Credits",
                quantity: 1,
                rawProductData: {
                    productID: "cred12",
                    productDescription: "Purchase Credits to Play",
                    productCategory: "Credits",
                    weight: "1 lbs",
                    dimensions: "1 in x 1 in",
                    origin: "United States",
                    craftedBy: "SweepStake Mobi",
                    craftingDate: "2025-08-27"
                }
            }
        ]
    };

    try {
        const sessionKey = await getSessionKey(userid.toString())
        console.log(sessionKey)
        console.log(sessionKey?.key)

        if (isRawCardNumber(card.cardToken)) {
            console.log('Raw card number detected. Tokenizing...');
            const token = await tokenizeCard(card.cardToken, card.cvv);
            card.cardToken = token;

            cardData.cfToken = token;
            await cardData.save()
        }

        const response = await axios.post(
            'https://api-sandbox.coinflow.cash/api/checkout/card/rc-amusement',
            // 'https://api.coinflow.cash/api/checkout/card/Rcamusement',

            payload,
            {
                headers: {
                    accept: 'application/json',
                    'content-type': 'application/json',
                    'x-coinflow-auth-session-key': sessionKey?.key,
                    'x-device-id': x_device_id,
                    'x-coinflow-client-ip': x_coinflow_client_ip,
                    // 'x-coinflow-auth-blockchain': 'solana',
                    // 'x-coinflow-auth-wallet': '9rpv2W6qyShwcwTgZXpiFuC5kFGYpzhYugmpKK5Ls4Kt',

                },
            }
        );
        await paymentStatusAPay(userid, pcodecc, 'success', site);

        // await tx.update({
        //     status: 'completed',
        //     paymentId: response.data.paymentId,
        // });
        console.log(response?.data)
        return res.json({
            status: 'success',
            paymentId: response.data?.paymentId,
        });
    } catch (error) {

        if (error.response?.status === 412) {
            const { transactionId, creq, url } = error.response.data;

            // await tx.update({
            //     transactionId,
            //     status: 'challenge_required',
            // });
            console.log(error?.response?.data)

            return res.status(412).json({
                p_code: pcodecc,
                status: 'challenge_required',
                transactionId,
                creq,
                url,
            });
        }

        console.error(error?.response?.data);
        // await tx.update({ status: 'failed' });
        await paymentStatusAPay(userid, pcodecc, 'failed', site);

        return res.status(500).json({
            status: 'failed',
            message: 'Internal error or invalid card details',
        });
    }
}
exports.completeCoinFlowTransaction = async (req, res) => {

    const { authentication3DS, card, card_id, subtotal, p_code, userid, site, x_device_id, x_coinflow_client_ip } = req.body;
    console.log(req.body)
    if (!authentication3DS || !card || !subtotal || !p_code || !userid) {
        return res.status(400).json({ status: 'error', message: 'Missing fields' });
    }

    const tx = await Transactions.findOne({ where: { p_codecc: p_code } });

    if (!tx) {
        return res.status(404).json({ status: 'error', message: 'Transaction not found' });
    }

    const user = await User.findOne({ where: { id: userid } })
    if (!user) {
        return res.json({
            status: 'error',
            message: 'User not found',
        });
    }
    const cardData = await SavedCards.findOne({ where: { id: card_id } })
    if (!cardData) {
        return res.json({
            status: 'error',
            message: 'Card not found',
        });
    }
    const tdsData = authentication3DS?.transactionId

    if (cardData.cfToken) {
        card.cardToken = cardData.cfToken
        delete card.cvv;
    }
    // const payload = {
    //     subtotal: { cents: subtotal?.cents },
    //     authentication3DS: { transactionId: tdsData },
    //     card,
    //     saveCard: true,
    // };

    const payload = {
        subtotal: { cents: subtotal?.cents },
        authentication3DS: { transactionId: tdsData },
        card: {
            ...card,
            email: user.email
        },
        saveCard: true,
        webhookInfo: {
            p_code: p_code,
        },
        transactionData: {
            type: "token",
            destination: "0xRecipientAddressHere"
        },
        chargebackProtectionData: [
            {
                productType: "topUp",
                productName: "Credits",
                quantity: 1,
                rawProductData: {
                    productID: "cred12",
                    productDescription: "Purchase Credits to Play",
                    productCategory: "Credits",
                    weight: "1 lbs",
                    dimensions: "1 in x 1 in",
                    origin: "United States",
                    craftedBy: "SweepStake Mobi",
                    craftingDate: "2025-08-27"
                }
            }
        ]
    };

    try {
        const sessionKey = await getSessionKey(userid.toString())
        const response = await axios.post(
            'https://api-sandbox.coinflow.cash/api/checkout/card/rc-amusement',
            // 'https://api.coinflow.cash/api/checkout/card/Rcamusement',

            payload,
            {
                headers: {
                    accept: 'application/json',
                    'content-type': 'application/json',
                    'x-coinflow-auth-session-key': sessionKey?.key,
                    'x-device-id': x_device_id,
                    'x-coinflow-client-ip': x_coinflow_client_ip,
                    // 'x-coinflow-auth-blockchain': 'solana',
                    // 'x-coinflow-auth-wallet': '9rpv2W6qyShwcwTgZXpiFuC5kFGYpzhYugmpKK5Ls4Kt',
                    // 'x-coinflow-auth-blockchain': 'ENTER_BLOCKCHAIN',
                    // 'x-coinflow-auth-wallet': 'ENTER_USER_WALLET_ADDRESS',
                },
            }
        );

        await paymentStatusAPay(userid, p_code, 'success', site);


        // await tx.update({
        //     status: 'completed',
        //     paymentId: response.data.paymentId,
        // });

        return res.json({
            status: 'success',
            paymentId: response.data.paymentId,
        });
    } catch (error) {
        console.error('Complete error:', error);
        await paymentStatusAPay(userid, p_code, 'failed', site);

        // await tx.update({ status: 'failed' });

        return res.status(500).json({
            status: 'failed',
            message: 'Could not complete payment',
        });
    }
}
exports.registerCoinFlowUser = async (req, res) => {
    try {
        const { userId, physicalAddress, city, state, zip, country, dob, ssn } = req.body;
        const user = await User.findOne({ where: { id: userId } });
        if (!user) {
            return res.status(404).json({ error: "User not found" });
        }

        const data = {
            info: {
                email: user.email,
                firstName: user.first,
                surName: user.last,
                physicalAddress,
                city,
                state,
                zip,
                country,
                dob,
                ssn,
            },
            // merchantId: "Rcamusement",
            merchantId: "rc-amusement",

        };

        const headers = {
            Authorization: "coinflow_sandbox_ae009956adfa4fa18c3adb36edbdf470_e1199272cb694bd69399bd57816f32f5",
            accept: "application/json",
            "content-type": "application/json",
            "x-coinflow-auth-user-id": userId.toString(),
        };

        // const headers = {
        //     Authorization: "coinflow_prod_fb228961487143f6867d324ff6e58dd7_49d72e1213644a06becae93b36a36fad",
        //     accept: "application/json",
        //     "content-type": "application/json",
        //     "x-coinflow-auth-user-id": userId.toString(),
        // };
        const response = await axios.post(
            "https://api-sandbox.coinflow.cash/api/withdraw/kyc",
            // "https://api.coinflow.cash/api/withdraw/kyc",

            data,
            { headers }
        );

        return res.json(response.data);
    } catch (error) {
        console.error("CoinFlow KYC error:", error.response?.data || error.message);
        return res.status(500).json({
            error: "CoinFlow KYC request failed",
            details: error.response?.data || error.message,
        });
    }
}
exports.getCoinFlowRedirectUrl = async (req, res) => {
    try {
        const { userId, site } = req.body;
        const merchantId = "rc-amusement";
        // const merchantId = "Rcamusement";

        if (!userId) {
            return res.status(400).json({ error: "userId is required" });
        }
        const sessionKey = await getSessionKey(userId.toString());

        if (!sessionKey) {
            return res.status(500).json({ error: "Failed to generate session key" });
        }

        const redirectUrl = encodeURIComponent(site);
        const coinflowUrl = `https://sandbox.coinflow.cash/solana/withdraw/${merchantId}?sessionKey=${sessionKey?.key}&bankAccountLinkRedirect=${redirectUrl}`;
        // const coinflowUrl = `https://coinflow.cash/solana/withdraw/${merchantId}?sessionKey=${sessionKey?.key}&bankAccountLinkRedirect=${redirectUrl}`;

        return res.json({ status: 'success', redirectUrl: coinflowUrl });
    } catch (error) {
        console.error("Error generating CoinFlow redirect URL:", error);
        return res.status(500).json({ error: "Internal server error" });
    }
};

async function getCoinFlowWithdrawer(userId) {
    try {
        const url = "https://api-sandbox.coinflow.cash/api/withdraw";
        // const url = "https://api.coinflow.cash/api/withdraw";


        const headers = {
            Authorization: "coinflow_sandbox_ae009956adfa4fa18c3adb36edbdf470_e1199272cb694bd69399bd57816f32f5",
            accept: "application/json",
            "x-coinflow-auth-user-id": userId,
        };
        // const headers = {
        //     Authorization: "coinflow_prod_fb228961487143f6867d324ff6e58dd7_49d72e1213644a06becae93b36a36fad",
        //     accept: "application/json",
        //     "x-coinflow-auth-user-id": userId,
        // };
        const response = await axios.get(url, { headers });
        return response.data; // should include sessionKey and other withdraw info
    } catch (error) {
        console.error("Error in getCoinFlowWithdrawer:", error.response?.data || error.message);
        throw error;
    }
}
exports.getCoinFlowWithdrawer = async (req, res) => {
    try {
        const url = "https://api-sandbox.coinflow.cash/api/withdraw";
        // const url = "https://api.coinflow.cash/api/withdraw";
        const { userId } = req.body;

        const headers = {
            Authorization: "coinflow_sandbox_ae009956adfa4fa18c3adb36edbdf470_e1199272cb694bd69399bd57816f32f5",
            accept: "application/json",
            "x-coinflow-auth-user-id": userId,
        };
        // const headers = {
        //     Authorization: "coinflow_prod_fb228961487143f6867d324ff6e58dd7_49d72e1213644a06becae93b36a36fad",
        //     accept: "application/json",
        //     "x-coinflow-auth-user-id": userId,
        // };
        const response = await axios.get(url, { headers });
        res.json(response.data); // should include sessionKey and other withdraw info
    } catch (error) {
        console.error("Error in getCoinFlowWithdrawer:", error.response?.data || error.message);
        return res.json(error.response?.data || error.message)
        throw error;
    }
}
exports.storeCoinFlowBankToken = async (req, res) => {
    try {
        const { userId } = req.body
        if (!userId) {
            return res.status(404).json({ status: 'error', message: "UserId is required" });
        }
        const user = await User.findOne({ where: { id: userId } })
        if (!user) {
            return res.status(404).json({ status: 'error', message: "User not found" });
        }
        const userInfo = await getCoinFlowWithdrawer(userId.toString());

        if (!userInfo?.withdrawer) {
            return res.status(404).json({ status: "error", message: "Withdrawer not found" });
        }

        // separate bankAccounts
        const bankAccounts = userInfo.withdrawer.bankAccounts || [];

        // get the last bank account in the array
        const lastBankAccount = bankAccounts.length > 0 ? bankAccounts[bankAccounts.length - 1] : null;
        if (lastBankAccount?.token) {
            user.cfAccountToken = lastBankAccount?.token
            await user.save()
        }
        return res.json({
            status: "success",
            bankAccount: lastBankAccount,
        });
    } catch (error) {
        console.error("CoinFlow KYC error:", error.response?.data || error.message);
        return res.status(500).json({
            error: "CoinFlow KYC request failed",
            details: error.response?.data || error.message,
        });
    }
}

exports.createCoinFlowPayout = async (req, res) => {
    try {
        const { amount, userId } = req.body;

        if (!amount || !userId) {
            return res.status(400).json({ error: "amount and userId are required" });
        }

        const user = await User.findOne({ where: { id: userId } });

        if (!user) {
            return res.status(404).json({ error: "User not found" });
        }

        if (!user.cfAccountToken) {
            return res.status(400).json({ error: "User does not have a CoinFlow account token (cfAccountToken)" });
        }

        const cents = Math.round(parseFloat(amount) * 100);

        const url = "https://api-sandbox.coinflow.cash/api/merchant/withdraws/payout/delegated";
        // const url = "https://api.coinflow.cash/api/merchant/withdraws/payout/delegated";


        const data = {
            speed: "asap",
            amount: {
                cents,
            },
            idempotencyKey: "",
            userId: userId.toString(),
            // merchantId: "Rcamusement",
            merchantId: "rc-amusement",

            account: user.cfAccountToken,
        };

        const headers = {
            accept: "application/json",
            "content-type": "application/json",
            Authorization:
                "coinflow_sandbox_ae009956adfa4fa18c3adb36edbdf470_e1199272cb694bd69399bd57816f32f5",
        };
        // const headers = {
        //     accept: "application/json",
        //     "content-type": "application/json",
        //     Authorization:
        //         "coinflow_prod_fb228961487143f6867d324ff6e58dd7_49d72e1213644a06becae93b36a36fad",
        // };

        const response = await axios.post(url, data, { headers });

        return res.json(response.data);
    } catch (error) {
        console.error("CoinFlow payout error:", error.response?.data || error.message);
        return res.status(500).json({
            error: "CoinFlow payout request failed",
            details: error.response?.data || error.message,
        });
    }
};
exports.depositCash = async (req, res) => {
    const { userid, amount, site = 'http://localhost:3000', login_id } = req.body
    console.log(req.body)
    const user = await User.findOne({ where: { id: userid } })
    if (!user) {
        return res.json({
            status: 'error',
            message: 'User not found',
        });
    }
    try {
        const tx = await Transactions.create({
            userid: userid.toString(),
            txnby: 'SELF',
            type: 1,
            amount: parseFloat(amount),
            paidmethod: 'Cash',
            paidto: 'Cash',
            status: 0,
        });

        const pcodecc = `SW-${tx.id}`;
        tx.p_codecc = pcodecc;
        await tx.save();

        const txnidnew = tx.id;

        const refs = await Refs.findOne({ where: { userid } });
        if (refs && !refs.first_txn) {
            refs.txn_amount = parseFloat(amount);
            refs.txn_id = txnidnew;
            await refs.save();
        }
        const resx = await axios.post('https://kapi.logiclane.tech/api/kiosk/depositDone', { login_id }, {
            headers: {
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            }
        })

        await paymentStatusAPay(userid, pcodecc, 'success', site);
        return res.json({
            status: 'success',
            message: 'Cash deposit successful',
        });
    } catch (error) {
        console.log(error)
        console.log(error?.message)
        return res.json({
            status: 'failed',
            message: 'Cash deposit failed',
        });
    }


}
exports.depositCashInit = async (req, res) => {
    const { userid, site = 'http://localhost:3000', login_id } = req.body
    console.log(req.body)
    const user = await User.findOne({ where: { id: userid } })
    if (!user) {
        return res.json({
            status: 'error',
            message: 'User not found',
        });
    }
    try {
        const tx = await Transactions.create({
            userid: userid.toString(),
            txnby: 'SELF',
            type: 1,
            amount: 0,
            paidmethod: 'Cash',
            paidto: 'Cash',
            status: 0,
        });

        // const pcodecc = `SW-${tx.id}`;
        // tx.p_codecc = pcodecc;
        // await tx.save();

        // const txnidnew = tx.id;

        // const refs = await Refs.findOne({ where: { userid } });
        // if (refs && !refs.first_txn) {
        //     refs.txn_amount = parseFloat(amount);
        //     refs.txn_id = txnidnew;
        //     await refs.save();
        // }
        // const resx = await axios.post('https://kapi.logiclane.tech/api/kiosk/depositDone', { login_id }, {
        //     headers: {
        //         'Accept': 'application/json',
        //         'Content-Type': 'application/json'
        //     }
        // })

        tx.p_codecc = login_id;
        await tx.save();
        // await paymentStatusAPay(userid, pcodecc, 'success', site);
        return res.json({
            status: 'success',
            p_code: login_id,
            message: 'Cash deposit initiated',
        });
    } catch (error) {
        console.log(error)
        console.log(error?.message)
        return res.json({
            status: 'failed',
            message: 'Cash deposit failed',
        });
    }
}
exports.depositCashComplete = async (req, res) => {
    const { userid, amount, site = 'http://localhost:3000', login_id } = req.body
    console.log(req.body)
    const user = await User.findOne({ where: { id: userid } })
    if (!user) {
        return res.json({
            status: 'error',
            message: 'User not found',
        });
    }
    try {
        const tx = await Transactions.findOne({ where: { p_codecc: login_id } })
        if (!tx) {
            return res.json({
                status: 'error',
                message: 'Transaction not found',
            });
        }
        tx.amount = parseFloat(amount)
        await tx.save();
        const resx = await axios.post('https://kapi.logiclane.tech/api/kiosk/depositDone', { login_id }, {
            headers: {
                'Accept': 'application/json',
                'Content-Type': 'application/json'
            }
        })
        await paymentStatusAPay(userid, login_id, 'success', site);
        return res.json({
            status: 'success',
            p_code: login_id,
            message: 'Cash deposit completed',
        });
    } catch (error) {
        console.log(error)
        console.log(error?.message)
        return res.json({
            status: 'failed',
            message: 'Cash deposit failed',
        });
    }
}
exports.encryptData = (req, res) => {
    try {
        const { data: encdata, code: encCode } = req.body; // Destructure request body
        const enc = encrypt(encdata, ENC_KEY); // encrypt data
        res.json({ data: enc }); // Send response
    } catch (error) {
        res.status(200).json({ error: error.message }); // Handle errors
    }
};
exports.paymentMethods = async (req, res) => {

    // Extract and verify token from the Authorization header
    const { userid } = req.body;
    const sanitizedUserId = parseInt(userid, 10);

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }
    try {
        const user = await User.findByPk(userid);
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }
        const methods = await PaymentMethods.findOne();
        if (!methods) {
            return res.status(200).json({ status: 'error', message: 'Payment settings not found!' });
        }

        // Initialize payment method flags
        const paymentMethods = {
            cc1: methods.credit === 1 && user.cardallowed === 1 ? 1 : 0,
            cc2: methods.credit2 === 1 && user.card2allowed === 1 ? 1 : 0,
            crypto: methods.crypto === 1 && user.cryptoallowed === 1 ? 1 : 0,
            crypto2: methods.crypto2 === 1 && user.crypto2allowed === 1 ? 1 : 0,
            gtw: methods.gtw === 1 && user.gtallowed === 1 ? 1 : 0,
            cashapp: methods.cashapp === 1 ? 1 : 0,
            paypal: methods.paypal === 1 && user.ppallowed === 1 ? 1 : 0,
            nowpay: methods.nowpay === 1 ? 1 : 0,
            gpay: methods.gpay === 1 && user.gpallowed === 1 ? 1 : 0,
            apay: methods.apay === 1 && user.apallowed === 1 ? 1 : 0,
            fpay: methods.forumpay === 1 && user.fpallowed === 1 ? 1 : 0,
            cflow: methods.coinflow === 1 && user.cfallowed === 1 ? 1 : 0,

        };
        console.log('forumpay:', methods.forumpay, 'fpallowed:', user.fpallowed);

        // Send response
        const responseData = {
            status: 'success',
            methods: paymentMethods,
        };

        // Encrypt response data if needed
        const encryptedResponse = encrypt(JSON.stringify(responseData), process.env.ENC_KEY);
        return res.status(200).json(encryptedResponse);
    } catch (error) {
        console.error('Error in paymentMethods:', error);
        return res.status(200).json({ status: 'error', message: 'An internal server error occurred.' });
    }
}
// exports.recentAnnouncements = async (req, res) => {
//     const { userid } = req.body;
//     const sanitizedUserId = parseInt(userid, 10);

//     const authHeader = req.headers['authorization'] || req.headers['Authorization'];
//     if (!authHeader) {
//         const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
//         return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
//     }

//     const token = authHeader.split(' ')[1];
//     let decoded;
//     try {
//         decoded = jwt.verify(token, process.env.JWT_SECRET);
//     } catch (err) {
//         const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
//         return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
//     }

//     if (decoded.id !== sanitizedUserId) {
//         const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
//         return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
//     }

//     try {
//         const user = await User.findByPk(sanitizedUserId);
//         if (!user) {
//             const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
//             return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
//         }

//         const bonus = await Bonus.findOne({ where: { userid: sanitizedUserId } });
//         const bonuses = await AllBonuses.findAndCountAll({ order: [['id', 'DESC']] });

//         const formattedBonuses = await Promise.all(
//             bonuses.rows.map(async (bonus) => {
//                 let claimed = false;

//                 if (bonus.table) {
//                     try {
//                         // Check if table exists
//                         const [tableExists] = await db.query(
//                             `SHOW TABLES LIKE :tableName`,
//                             {
//                                 replacements: { tableName: bonus.table },
//                                 type: db.QueryTypes.SELECT,
//                             }
//                         );

//                         if (tableExists) {
//                             // Check if user has a record in the table
//                             const [result] = await db.query(
//                                 `SELECT COUNT(*) AS count FROM \`${bonus.table}\` WHERE userid = :userid LIMIT 1`,
//                                 {
//                                     replacements: { userid: sanitizedUserId },
//                                     type: db.QueryTypes.SELECT,
//                                 }
//                             );

//                             claimed = result.count > 0 ? '1' : '0';
//                         }
//                     } catch (err) {
//                         console.warn(`Error checking table "${bonus.table}":`, err.message);
//                         claimed = '0'; // default to false if any error occurs
//                     }
//                 }

//                 return {
//                     id: bonus.id,
//                     name: bonus.bonus,
//                     enabled: bonus.enabled,
//                     info: bonus.info,
//                     // table: bonus.table,
//                     claimed
//                 };
//             })
//         );

//         const responseData = {
//             status: 'success',
//             userid: user.id,
//             data: formattedBonuses,
//         };

//         const encryptedResponse = encrypt(JSON.stringify(responseData), process.env.ENC_KEY);
//         return res.status(200).json(encryptedResponse);
//     } catch (error) {
//         console.error('recentAnnouncements error:', error);
//         return res.status(200).json({ error: 'Internal server error' });
//     }
// };
exports.recentAnnouncements = async (req, res) => {
    const { userid } = req.body;
    const sanitizedUserId = parseInt(userid, 10);

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id !== sanitizedUserId) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    try {
        const user = await User.findByPk(sanitizedUserId);
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }

        // Fetch user's signup bonus if exists
        const signupBonusEntry = await Bonus.findOne({ where: { userid: sanitizedUserId } });

        const signupBonus = {
            id: signupBonusEntry?.id || null,
            name: 'Signup Bonus',
            info: 'Get upto $50 by requesting the signup bonus',
            link: '/bonus',
            enabled: "1",
            claimed: signupBonusEntry?.status || '0'
        };

        // Fetch all available bonuses
        const bonuses = await AllBonuses.findAndCountAll({ order: [['id', 'DESC']] });

        const formattedBonuses = await Promise.all(
            bonuses.rows.map(async (bonus) => {
                let claimed = false;

                if (bonus.table) {
                    try {
                        const [tableExists] = await db.query(
                            `SHOW TABLES LIKE :tableName`,
                            {
                                replacements: { tableName: bonus.table },
                                type: db.QueryTypes.SELECT,
                            }
                        );

                        if (tableExists) {
                            const [result] = await db.query(
                                `SELECT COUNT(*) AS count FROM \`${bonus.table}\` WHERE userid = :userid LIMIT 1`,
                                {
                                    replacements: { userid: sanitizedUserId },
                                    type: db.QueryTypes.SELECT,
                                }
                            );

                            claimed = result.count > 0 ? '1' : '0';
                        }
                    } catch (err) {
                        console.warn(`Error checking table "${bonus.table}":`, err.message);
                        claimed = '0';
                    }
                }

                return {
                    id: bonus.id,
                    name: bonus.bonus,
                    enabled: bonus.enabled,
                    info: bonus.info,
                    link: bonus.link,
                    claimed
                };
            })
        );

        // Add signupBonus to the list
        // formattedBonuses.unshift(signupBonus);

        const responseData = {
            status: 'success',
            userid: user.id,
            data: formattedBonuses,
        };

        const encryptedResponse = encrypt(JSON.stringify(responseData), process.env.ENC_KEY);
        return res.status(200).json(encryptedResponse);
    } catch (error) {
        console.error('recentAnnouncements error:', error);
        return res.status(200).json({ error: 'Internal server error' });
    }
};

const getLatestTransaction = async (userId) => {
    // Fetch latest of each transaction type
    const [latestRedeem, latestCashout, latestDeposit] = await Promise.all([
        Redeem.findOne({
            where: { userid: userId },
            order: [['date', 'DESC']],
        }),
        Withdraw.findOne({
            where: { userid: userId },
            order: [['date', 'DESC']],
        }),
        Transactions.findOne({
            where: { userid: userId, type: '1' },
            order: [['date', 'DESC']],
        }),
    ]);

    // Collect non-null results
    const allTransactions = [
        latestRedeem && {
            type: 'redeem',
            status: latestRedeem.status,
            amount: latestRedeem.amount,
            time: new Date(latestRedeem.date).toISOString(),
        },
        latestCashout && {
            type: 'cashout',
            status: latestCashout.status,
            amount: latestCashout.amount,

            time: new Date(latestCashout.date).toISOString(),
        },
        latestDeposit && {
            type: 'deposit',
            status: latestDeposit.status,
            amount: latestDeposit.amount,

            time: new Date(latestDeposit.date).toISOString(),
        },
    ].filter(Boolean);

    // Return the one with the most recent time
    const latest = allTransactions.sort((a, b) => new Date(b.time) - new Date(a.time))[0];

    return latest || null;
};
exports.getLatestStatus = async (req, res) => {
    const { userid } = req.body;
    const sanitizedUserId = parseInt(userid, 10);

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != sanitizedUserId) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    try {
        const user = await User.findByPk(sanitizedUserId);
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }
        const latestTransaction = await getLatestTransaction(sanitizedUserId);

        const responseData = {
            status: 'success',
            userid: user.id,
            data: latestTransaction,
        };

        const encryptedResponse = encrypt(JSON.stringify(responseData), process.env.ENC_KEY);
        return res.status(200).json(encryptedResponse);
    } catch (error) {
        console.error('Error in latestStatus:', error);
        return res.status(200).json({ status: 'error', message: 'An internal server error occurred.' });
    }
}
function formatDateTime(date) {
    const d = new Date(date);
    const yyyy = d.getFullYear();
    const mm = String(d.getMonth() + 1).padStart(2, '0');
    const dd = String(d.getDate()).padStart(2, '0');
    const hh = String(d.getHours()).padStart(2, '0');
    const ii = String(d.getMinutes()).padStart(2, '0');
    const ss = String(d.getSeconds()).padStart(2, '0');
    return `${yyyy}-${mm}-${dd} ${hh}:${ii}:${ss}`;
}
function timeAgo(date) {
    const now = new Date();
    const past = new Date(date);
    const seconds = Math.floor((now - past) / 1000);

    if (seconds < 60) return `${seconds} second${seconds !== 1 ? 's' : ''} ago`;
    const minutes = Math.floor(seconds / 60);
    if (minutes < 60) return `${minutes} minute${minutes !== 1 ? 's' : ''} ago`;
    const hours = Math.floor(minutes / 60);
    if (hours < 24) return `${hours} hour${hours !== 1 ? 's' : ''} ago`;
    const days = Math.floor(hours / 24);
    if (days < 7) return `${days} day${days !== 1 ? 's' : ''} ago`;
    const weeks = Math.floor(days / 7);
    if (weeks < 4) return `${weeks} week${weeks !== 1 ? 's' : ''} ago`;
    const months = Math.floor(days / 30);
    const years = Math.floor(days / 365);
    if (years >= 1) return `${years} year${years !== 1 ? 's' : ''} ago`;
    if (months >= 1) return `${months} month${months !== 1 ? 's' : ''} ago`;
    return `${weeks} week${weeks !== 1 ? 's' : ''} ago`; // fallback if months = 0 but weeks exist

}
exports.latestStatus = async (req, res) => {
    const { userid } = req.body;
    const sanitizedUserId = parseInt(userid, 10);

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != sanitizedUserId) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    try {
        const user = await User.findByPk(sanitizedUserId);
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }

        // Fetch the latest statuses
        const latestRedeem = await Redeem.findOne({
            where: { userid: sanitizedUserId },
            order: [['id', 'DESC']],
        });
        const latestCashout = await Withdraw.findOne({
            where: { userid: sanitizedUserId },
            order: [['id', 'DESC']],
        });
        const latestDeposit = await Transactions.findOne({
            where: { userid: sanitizedUserId, type: '1' },
            order: [['id', 'DESC']],
        });

        // Prepare status data
        // const redeemStatus = latestRedeem ? latestRedeem.status : '';
        // const redeemDate = latestRedeem ? new Date(latestRedeem.date).toISOString() : '';
        // const depositStatus = latestDeposit ? latestDeposit.status : '';
        // const depositDate = latestDeposit ? new Date(latestDeposit.date).toISOString() : '';
        // const cashoutStatus = latestCashout ? latestCashout.status : '';
        // const cashoutDate = latestCashout ? new Date(latestCashout.date).toISOString() : '';
        const redeemStatus = latestRedeem ? latestRedeem.status : '';
        const redeemAmount = latestRedeem ? latestRedeem.amount : '';

        const redeemDate = latestRedeem ? formatDateTime(latestRedeem.date) : '';
        const redeemAgo = latestRedeem ? timeAgo(latestRedeem.date) : '';

        const depositStatus = latestDeposit ? latestDeposit.status : '';
        const depositAmount = latestDeposit ? latestDeposit.amount : '';

        const depositDate = latestDeposit ? formatDateTime(latestDeposit.date) : '';
        const depositAgo = latestDeposit ? timeAgo(latestDeposit.date) : '';

        const cashoutStatus = latestCashout ? latestCashout.status : '';
        const cashoutAmount = latestCashout ? latestCashout.amount : '';

        const cashoutDate = latestCashout ? formatDateTime(latestCashout.date) : '';
        const cashoutAgo = latestCashout ? timeAgo(latestCashout.date) : '';

        const data = {
            redeem: {
                status: redeemStatus.toString(),
                // time: redeemDate,
                amount: redeemAmount,
                time: redeemAgo
            },
            deposit: {
                status: depositStatus.toString(),
                // time: depositDate,
                amount: depositAmount,
                time: depositAgo
            },
            cashout: {
                status: cashoutStatus.toString(),
                // time: cashoutDate,
                amount: cashoutAmount,
                time: cashoutAgo
            }
        };
        const responseData = {
            status: 'success',
            userid: user.id,
            data,
        };

        const encryptedResponse = encrypt(JSON.stringify(responseData), process.env.ENC_KEY);
        return res.status(200).json(encryptedResponse);
    } catch (error) {
        console.error('Error in latestStatus:', error);
        return res.status(200).json({ status: 'error', message: 'An internal server error occurred.' });
    }
};
exports.applePay = async (req, res) => {

    try {
        const { userid, site, amount, payment_token } = req.body;
        // const reqData = req.body

        const data = JSON.stringify({
            userid, site, amount, payment_token
        })
        const [result] = await db.query(
            'INSERT INTO `apaytest` (`data`) VALUES (?)',
            {
                replacements: [data],
                type: db.QueryTypes.INSERT
            }
        );
        // Create a new transaction log
        const deposit = await Transactions.create({
            userid: userid.toString(),
            txnby: 'SELF',
            type: 1,
            amount,
            paidmethod: 'Apple Pay',
            paidto: 'Credit Card',
            status: 0,
        });

        const pcodecc = `SW-${deposit.id}`;
        deposit.p_codecc = pcodecc;
        await deposit.save();

        const txnidnew = deposit.id;

        // Update the Ref table if necessary
        const refs = await Refs.findOne({ where: { userid } });
        if (refs && !refs.first_txn) {
            refs.txn_amount = amount;
            refs.txn_id = txnidnew;
            await refs.save();
        }

        // Log the request data
        // await Refs.create({
        //     data: JSON.stringify({ userid, site, amount, payment_token }),
        // });

        // Prepare data for external API request
        const fields = {
            security_key: process.env.NMI_LOGIN_ID, // Replace with your NMI login ID
            payment_token: payment_token.toString(),
            amount: amount.toString(),
            orderid: pcodecc,
            orderdescription: pcodecc,
        };

        // Make the external API request
        const response = await axios.post('https://bend.logiclane.tech/api/nmi2', fields, {
            headers: { 'Content-Type': 'application/json' },
        });
        const responseDatax = response.data;
        console.log("nmi", responseDatax)
        const responseData = Object.fromEntries(new URLSearchParams(responseDatax));
        console.log("nmi2", responseData)

        // console.log("nmi", responseData);
        // if (responseData.response_code == '100') {
        // const decodedResponse = new URLSearchParams(response.data);

        // const responseCode = decodedResponse.get('response_code');
        // const authCode = decodedResponse.get('authcode');
        // const transactionId = decodedResponse.get('transactionid');
        // const orderId = decodedResponse.get('orderid');

        if (responseData.response_code === '100') {
            console.log(responseData)
            await paymentStatusAPay(userid, responseData.orderid, 'success', site);

            const encdata = JSON.stringify({
                status: 'success',
                auth_code: responseData.authcode,
                txn_id: responseData.transactionid,
                p_code: responseData.orderid,
            });
            const encryptedResponse = encrypt(encdata, process.env.ENC_KEY);
            return res.redirect(`${site}/success`);
        } else {
            await paymentStatusAPay(userid, responseData.orderid, 'failed', site);

            const encdata = JSON.stringify({
                status: 'failed',
                message: 'Invalid response',
                p_code: responseData.orderid,
            });
            const encryptedResponse = encrypt(encdata, process.env.ENC_KEY);
            return res.redirect(`${site}/failed`);
        }
    } catch (error) {
        console.error('Error in applePay:', error);
        return res.status(200).json({
            status: 'error',
            message: 'An internal server error occurred.',
        });
    }
};
exports.googlePay = async (req, res) => {

    try {
        const { userid, site, amount, payment_token } = req.body;

        const data = JSON.stringify({
            userid, site, amount, payment_token
        })
        const [result] = await db.query(
            'INSERT INTO `apaytest` (`data`) VALUES (?)',
            {
                replacements: [data],
                type: db.QueryTypes.INSERT
            }
        );
        // Create a new transaction log
        const deposit = await Transactions.create({
            userid: userid.toString(),
            txnby: 'SELF',
            type: 1,
            amount,
            paidmethod: 'Google Pay',
            paidto: 'Credit Card',
            status: 0,
        });

        const pcodecc = `SW-${deposit.id}`;
        deposit.p_codecc = pcodecc;
        await deposit.save();

        const txnidnew = deposit.id;

        // Update the Ref table if necessary
        const refs = await Refs.findOne({ where: { userid } });
        if (refs && !refs.first_txn) {
            refs.txn_amount = amount;
            refs.txn_id = txnidnew;
            await refs.save();
        }

        // Fetch user details
        const user = await User.findOne({ where: { id: userid } });
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }

        // Prepare data for external API request
        const fields = {
            security_key: process.env.NMI_LOGIN_ID,
            payment_token: payment_token.toString(),
            amount: amount.toString(),
            orderid: pcodecc,
            orderdescription: pcodecc,
            email: user.email,
            phone: user.phone,
            first_name: user.first,
            last_name: user.last,
        };

        // Make the external API request
        const response = await axios.post('https://bend.logiclane.tech/api/nmi2', fields, {
            headers: { 'Content-Type': 'application/json' },
        });
        const responseDatax = response.data;
        console.log("nmi", responseDatax)
        const responseData = Object.fromEntries(new URLSearchParams(responseDatax));
        // const decodedResponse = new URLSearchParams(response.data);

        // const responseCode = decodedResponse.get('response_code');
        // const authCode = decodedResponse.get('authcode');
        // const transactionId = decodedResponse.get('transactionid');
        // const orderId = decodedResponse.get('orderid');

        if (responseData.response_code === '100') {
            await paymentStatusAPay(userid, responseData.orderid, 'success', site);

            const encdata = JSON.stringify({
                status: 'success',
                auth_code: responseData.authcode,
                txn_id: responseData.transactionid,
                p_code: responseData.orderid,
            });
            return res.redirect(`${site}/success`);
        } else {
            await paymentStatusAPay(userid, responseData.orderid, 'failed', site);

            const encdata = JSON.stringify({
                status: 'failed',
                message: 'Invalid response',
                p_code: responseData.orderid,
            });
            return res.redirect(`${site}/failed`);
        }
    } catch (error) {
        console.error('Error in googlePay:', error);
        return res.status(200).json({
            status: 'error',
            message: 'An internal server error occurred.',
        });
    }
};
// async function paymentStatusAPay(userid, orderId, status, site) {
//     // Implement logic to update payment status

//     console.log(`Payment status for User: ${userid}, Order: ${orderId} set to: ${status}`);
// }

async function paymentStatusAPay(userId, pCode, status, site) {
    try {
        if (!userId || !pCode || !status) {
            throw new Error('Missing required parameters');
        }

        const user = await User.findOne({ where: { id: userId } });
        const txn = await Transactions.findOne({ where: { p_codecc: pCode } });

        if (!txn) {
            throw new Error('Transaction not found');
        }
        if (txn.status == '0') {
            if (status === 'failed') {
                await txn.update({ status: '2', webhookdata: 'api_call' });
                return { status: 'success', message: 'Transaction Failed' };
            }

            else if (status === 'success') {
                const firstTxn = await Transactions.findOne({
                    where: {
                        userid: user.id,
                        paidmethod: { [Op.in]: ['CreditCard2', 'GameTimeWallet', 'Crypto', 'Apple Pay', 'Google Pay', 'ForumPay'] },
                        status: '1',
                        date: { [Op.gte]: '2024-05-21' },
                    },
                });

                const existingBonus = await NBonus.findOne({ where: { userid: user.id } });
                const happyHour = await BrDeposit.findOne({
                    where: {
                        userid: user.id,
                        // cdate: moment().tz('America/Denver').format('YYYY-MM-DD'),
                    },
                });

                if (txn.amount >= 4) {
                    const ref = await Refs.findOne({ where: { txn_id: txn.id } });
                    if (ref) {
                        await Refs.update({ first_txn: 1, status: 1 }, { where: { txn_id: txn.id } });

                        const refUser = await User.findOne({ where: { refcode: ref.refcode } });
                        if (refUser) {
                            await refUser.increment('bonusbal', { by: 5 });

                            await BrDeposit.create({
                                userid: userId,
                                txnby: 'SELF',
                                type: 1,
                                amount: 5,
                                method: 'Referral Bonus',
                                status: 1,
                                cbalance: user.balance,
                                ubalance: user.balance,
                                crebalance: user.rebalance,
                                urebalance: user.rebalance,
                                cbonusbal: user.bonusbal,
                                ubonusbal: parseFloat(user.bonusbal) + parseFloat(5),
                            });
                        }
                    }
                } else {
                    const ref = await Refs.findOne({ where: { txn_id: txn.id } });
                    if (ref) {
                        await Refs.update({ first_txn: 1, status: 2 }, { where: { txn_id: txn.id } });
                    }
                }

                const currentHour = moment().tz('America/Denver').format('H');
                // const currentHour = moment.tz('America/Denver').hour();
                const currDate = moment.tz('America/Denver').format('YYYY-MM-DD');
                const getnb = await checkBonusConditions(user.id); // Placeholder for bonus conditions
                const gethh = await checkHappyHour(user.id); // Placeholder for Happy Hour check
                if (!firstTxn && !existingBonus) {
                    await NBonus.create({
                        userid: user.id,
                        first: 1,
                        created_at: new Date(),
                        updated_at: new Date(),
                    });

                    const bonusAmount = parseFloat(txn.amount) + parseFloat(5);
                    await BrDeposit.create({
                        userid: user.id,
                        txnby: 'SELF',
                        type: 1,
                        amount: bonusAmount,
                        method: 'First Deposit Bonus',
                        status: 1,
                        cbalance: user.balance,
                        ubalance: parseFloat(user.balance) + parseFloat(txn.amount),
                        crebalance: user.rebalance,
                        urebalance: user.rebalance,
                        cbonusbal: user.bonusbal,
                        ubonusbal: parseFloat(user.bonusbal) + parseFloat(bonusAmount),
                    });

                    await user.update({
                        bonusbal: parseFloat(user.bonusbal) + parseFloat(bonusAmount),
                    });
                } else if (existingBonus && existingBonus.first == 1 && existingBonus.second == 0) {
                    await existingBonus.update({ second: 1, updatedAt: new Date() });

                    const bonusAmount = parseFloat(txn.amount) * parseFloat(0.2) + parseFloat(5);
                    await BrDeposit.create({
                        userid: user.id,
                        txnby: 'SELF',
                        type: 1,
                        amount: bonusAmount,
                        method: 'Second Deposit Bonus',
                        status: 1,
                        cbalance: user.balance,
                        ubalance: parseFloat(user.balance) + parseFloat(txn.amount),
                        crebalance: user.rebalance,
                        urebalance: user.rebalance,
                        cbonusbal: user.bonusbal,
                        ubonusbal: parseFloat(user.bonusbal) + parseFloat(bonusAmount),
                    });

                    await user.update({
                        bonusbal: parseFloat(user.bonusbal) + parseFloat(bonusAmount),
                    });
                } else if (existingBonus && existingBonus.first == 1 && existingBonus.second == 1 && existingBonus.third == 0) {
                    await existingBonus.update({ third: 1, updatedAt: new Date() });

                    // const bonusAmount = txn.amount * 0.1 + 15;
                    const bonusAmount = parseFloat(txn.amount) * parseFloat(0.1) + parseFloat(15);

                    await BrDeposit.create({
                        userid: user.id,
                        txnby: 'SELF',
                        type: 1,
                        amount: bonusAmount,
                        method: 'Third Deposit Bonus',
                        status: 1,
                        cbalance: user.balance,
                        ubalance: parseFloat(user.balance) + parseFloat(txn.amount),
                        crebalance: user.rebalance,
                        urebalance: user.rebalance,
                        cbonusbal: user.bonusbal,
                        ubonusbal: parseFloat(user.bonusbal) + parseFloat(bonusAmount),
                    });

                    await user.update({
                        bonusbal: parseFloat(user.bonusbal) + parseFloat(bonusAmount),
                    });
                } else if (
                    (!getnb) ||
                    (existingBonus && existingBonus.first == 1 && existingBonus.second == 1 && existingBonus.third == 1)
                ) {

                    console.log("gethh", gethh)

                    if (currentHour >= 3 && currentHour < 9) {
                        if (gethh && gethh.eligible == true) {
                            console.log("current hour2", currentHour)
                            const bonus = parseFloat(txn.amount) * parseFloat(0.1);
                            const updatedBonusBalance = parseFloat(user.bonusbal) + parseFloat(bonus);
                            const updatedBalance = parseFloat(user.balance) + parseFloat(txn.amount) + parseFloat(bonus);

                            if (!site) {
                                await user.increment('balance', { by: parseFloat(txn.amount) + parseFloat(bonus) });
                            }

                            await BrDeposit.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: bonus,
                                method: 'Happy Hour Bonus',
                                status: 1,
                                cbalance: user.balance,
                                ubalance: parseFloat(user.balance) + parseFloat(txn.amount),
                                crebalance: user.rebalance,
                                urebalance: user.rebalance,
                                cbonusbal: user.bonusbal,
                                ubonusbal: updatedBonusBalance,
                            });

                            await HappyHour.create({ userid: user.id, cdate: currDate });
                            await user.increment('bonusbal', { by: bonus });
                        } else {
                            await handleSpecialBonuses(txn, user, currDate);
                        }
                    } else {
                        await handleSpecialBonuses(txn, user, currDate);
                    }


                }
                const updatedTxn = await txn.update({
                    status: '1',
                    webhookdata: 'api_call',
                    cbalance: user.balance,
                    ubalance: parseFloat(user.balance) + parseFloat(txn.amount),
                    crebalance: user.rebalance,
                    urebalance: user.rebalance,
                });

                if (updatedTxn) {
                    await user.increment('balance', { by: parseFloat(txn.amount) });
                    return { status: 'success', message: 'Transaction Success' };
                }
                else {
                    return { status: 'error', message: 'Transaction Failed' };
                }
            }
        }
    } catch (err) {
        console.log(err)
        return
    }
}
async function checkBonusConditions(userId) {
    try {
        // Fetch user data
        const user = await User.findOne({ where: { id: userId } });

        // Check if the user exists
        if (!user) {
            throw new Error('User not found');
        }

        // Check if the user has any bonus conditions (e.g., from deposits or specific bonuses)
        const bonus = await BrDeposit.findOne({
            where: {
                userid: user.id,
                method: {
                    [Op.in]: ['Happy Hour Bonus', 'First Deposit Bonus', 'Second Deposit Bonus', 'Third Deposit Bonus', 'Bonus SweepCoins']
                }
            }
        });

        // If a bonus is found, return relevant bonus data
        if (bonus) {
            return {
                status: 'success',
                bonusName: bonus.method,
                bonusAmount: user.bonusbal
            };
        } else {
            return {
                status: 'success',
                bonusName: null,
                bonusAmount: 0
            };
        }
    } catch (error) {
        console.error('Error checking bonus conditions:', error.message);
        return {
            status: 'error',
            message: error.message || 'Failed to check bonus conditions'
        };
    }
}
async function handleSpecialBonuses(txn, user, currDate) {
    const userID = user.id;

    // New Year Bonus
    if (currDate >= '2024-12-21' && currDate <= '2025-01-01') {
        const bonusExists = await NYBonus.findOne({
            where: { userid: userID, cdate: currDate },
        });

        if (!bonusExists && txn.amount >= 20) {
            const updatedBonusBalance = parseFloat(user.bonusbal) + parseFloat(5);
            await NYBonus.create({ userid: userID, cdate: currDate });
            await BrDeposit.create({
                userid: userID,
                txnby: 'SELF',
                type: 1,
                amount: 5,
                method: 'New Year Bonus',
                status: 1,
                cbalance: user.balance,
                ubalance: parseFloat(user.balance) + parseFloat(txn.amount),
                crebalance: user.rebalance,
                urebalance: user.rebalance,
                cbonusbal: user.bonusbal,
                ubonusbal: updatedBonusBalance,
            });
            await user.increment('bonusbal', { by: 5 });
        }
    }

    // Payday Bonus
    if (currDate >= '2024-07-31' && currDate <= '2024-08-30') {
        const txnTotal = await Transactions.sum('amount', {
            where: {
                userid: userID,
                paidmethod: { [Op.in]: ['CreditCard2', 'GameTimeWallet', 'Crypto', 'Apple Pay', 'Google Pay'] },
                status: '1',
                date: { [Op.between]: ['2024-08-01', '2024-08-30'] },
            },
        });

        if (txnTotal >= 100) {
            const bonusExists = await DecBonus.findOne({
                where: { userid: userID, cdate: currDate },
            });

            if (!bonusExists) {
                const updatedBonusBalance = parseFloat(user.bonusbal) + parseFloat(10);
                await DecBonus.create({ userid: userID, cdate: currDate });
                await BrDeposit.create({
                    userid: userID,
                    txnby: 'SELF',
                    type: 1,
                    amount: 10,
                    method: 'Payday Bonus',
                    status: 1,
                    cbalance: user.balance,
                    ubalance: parseFloat(user.balance) + parseFloat(txn.amount),
                    crebalance: user.rebalance,
                    urebalance: user.rebalance,
                    cbonusbal: user.bonusbal,
                    ubonusbal: updatedBonusBalance,
                });
                await user.increment('bonusbal', { by: 10 });
            }
        }
    }

    // September Bonus
    if (currDate >= '2025-08-26' && currDate <= '2025-09-05') {
        const bonusExists = await NYBonus.findOne({
            where: { userid: userID, cdate: currDate },
        });

        if (!bonusExists && txn.amount >= 20) {
            const updatedBonusBalance = parseFloat(user.bonusbal) + parseFloat(5);
            await NYBonus.create({ userid: userID, cdate: currDate });
            await BrDeposit.create({
                userid: userID,
                txnby: 'SELF',
                type: 1,
                amount: 5,
                method: 'Fall Bonus',
                status: 1,
                cbalance: user.balance,
                ubalance: parseFloat(user.balance) + parseFloat(txn.amount),
                crebalance: user.rebalance,
                urebalance: user.rebalance,
                cbonusbal: user.bonusbal,
                ubonusbal: updatedBonusBalance,
            });
            await user.increment('bonusbal', { by: 5 });
        }
    }
}
// async function checkHappyHour(userId) {
//     try {
//         // Fetch user data (if needed for additional checks like user status)
//         const user = await User.findOne({ where: { id: userId } });

//         // Check if the user exists
//         if (!user) {
//             throw new Error('User not found');
//         }

//         // Define Happy Hour time window (example: 6 PM to 8 PM)
//         const happyHourStart = moment().set({ hour: 18, minute: 0, second: 0 }); // 6 PM today
//         const happyHourEnd = moment().set({ hour: 20, minute: 0, second: 0 }); // 8 PM today

//         // Check if any deposits were made within the Happy Hour window
//         const happyHourDeposit = await BrDeposit.findOne({
//             where: {
//                 userid: user.id,
//                 created_at: {
//                     [Op.between]: [happyHourStart.toDate(), happyHourEnd.toDate()]
//                 },
//                 method: 'Happy Hour Bonus' // Assuming the method is stored in the deposit table
//             }
//         });

//         // If a Happy Hour deposit is found, return details
//         if (happyHourDeposit) {
//             return {
//                 status: 'success',
//                 eligible: true,
//                 bonusAmount: happyHourDeposit.amount
//             };
//         } else {
//             return {
//                 status: 'success',
//                 eligible: false,
//                 bonusAmount: 0
//             };
//         }
//     } catch (error) {
//         console.error('Error checking Happy Hour eligibility:', error.message);
//         return {
//             status: 'error',
//             message: error.message || 'Failed to check Happy Hour eligibility'
//         };
//     }
// }
async function checkHappyHour(userId) {
    try {
        const user = await User.findOne({ where: { id: userId } });
        if (!user) throw new Error('User not found');

        // Set timezone and Happy Hour window (3:00 AM - 9:00 AM America/Denver)
        const now = moment().tz('America/Denver');
        const happyHourStart = now.clone().set({ hour: 3, minute: 0, second: 0, millisecond: 0 });
        const happyHourEnd = now.clone().set({ hour: 9, minute: 0, second: 0, millisecond: 0 });

        // If current time is after 9 AM, assume next day 3 AM to 9 AM (optional, based on logic)
        if (now.isAfter(happyHourEnd)) {
            happyHourStart.add(1, 'day');
            happyHourEnd.add(1, 'day');
        }

        const happyHourDeposit = await BrDeposit.findOne({
            where: {
                userid: user.id,
                created_at: {
                    [Op.between]: [happyHourStart.toDate(), happyHourEnd.toDate()]
                },
                method: 'Happy Hour Bonus'
            }
        });
        console.log("happyHourDeposit", happyHourDeposit)
        if (!happyHourDeposit) {
            return {
                status: 'success',
                eligible: true,
                bonusAmount: happyHourDeposit?.amount
            };
        } else {
            return {
                status: 'success',
                eligible: false,
                bonusAmount: 0
            };
        }
    } catch (error) {
        console.log("happyHourDeposit", error)

        console.error('Error checking Happy Hour eligibility:', error.message);
        return {
            status: 'error',
            message: error.message || 'Failed to check Happy Hour eligibility'
        };
    }
}
exports.paymentStatus = async (req, res) => {
    try {

        const { userid: userId, p_code: pCode, status, site } = req.body;
        console.log(pCode, userId, status)
        // return await paymentStatusAPay(userId, pCode, status, site)

        if (!userId || !pCode || !status) {
            return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Missing required parameters' }), ENC_KEY));

            throw new Error('Missing required parameters');
        }

        const user = await User.findOne({ where: { id: userId } });
        const txn = await Transactions.findOne({ where: { p_codecc: pCode } });

        if (!txn) {
            return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Transaction not found' }), ENC_KEY));

            throw new Error('Transaction not found');
        }

        if (status === 'failed') {
            await txn.update({ status: '2', webhookdata: 'api_call' });
            return res.json(encrypt(JSON.stringify({ status: 'success', message: 'Transaction Failed' }), ENC_KEY));
        }

        else if (status === 'success') {
            const firstTxn = await Transactions.findOne({
                where: {
                    userid: user.id,
                    paidmethod: { [Op.in]: ['CreditCard2', 'GameTimeWallet', 'Crypto', 'Apple Pay', 'Google Pay', 'ForumPay'] },
                    status: '1',
                    date: { [Op.gte]: '2024-05-21' },
                },
            });

            const existingBonus = await NBonus.findOne({ where: { userid: user.id } });
            const happyHour = await BrDeposit.findOne({
                where: {
                    userid: user.id,
                    // cdate: moment().tz('America/Denver').format('YYYY-MM-DD'),
                },
            });

            if (txn.amount >= 4) {
                const ref = await Refs.findOne({ where: { txn_id: txn.id } });
                if (ref) {
                    await Refs.update({ first_txn: 1, status: 1 }, { where: { txn_id: txn.id } });

                    const refUser = await User.findOne({ where: { refcode: ref.refcode } });
                    if (refUser) {
                        await refUser.increment('bonusbal', { by: 5 });

                        await BrDeposit.create({
                            userid: userId,
                            txnby: 'SELF',
                            type: 1,
                            amount: 5,
                            method: 'Referral Bonus',
                            status: 1,
                            cbalance: user.balance,
                            ubalance: user.balance,
                            crebalance: user.rebalance,
                            urebalance: user.rebalance,
                            cbonusbal: user.bonusbal,
                            ubonusbal: parseFloat(user.bonusbal) + parseFloat(5),
                        });
                    }
                }
            } else {
                const ref = await Refs.findOne({ where: { txn_id: txn.id } });
                if (ref) {
                    await Refs.update({ first_txn: 1, status: 2 }, { where: { txn_id: txn.id } });
                }
            }

            const currentHour = moment().tz('America/Denver').format('H');
            console.log('firstCH', currentHour)
            // const currentHour = moment.tz('America/Denver').hour();
            const currDate = moment.tz('America/Denver').format('YYYY-MM-DD');
            const getnb = await checkBonusConditions(user.id); // Placeholder for bonus conditions
            const gethh = await checkHappyHour(user.id); // Placeholder for Happy Hour check
            if (!firstTxn && !existingBonus) {
                await NBonus.create({
                    userid: user.id,
                    first: 1,
                    created_at: new Date(),
                    updated_at: new Date(),
                });

                const bonusAmount = parseFloat(txn.amount) + parseFloat(5);
                await BrDeposit.create({
                    userid: user.id,
                    txnby: 'SELF',
                    type: 1,
                    amount: bonusAmount,
                    method: 'First Deposit Bonus',
                    status: 1,
                    cbalance: user.balance,
                    ubalance: parseFloat(user.balance) + parseFloat(txn.amount),
                    crebalance: user.rebalance,
                    urebalance: user.rebalance,
                    cbonusbal: user.bonusbal,
                    ubonusbal: parseFloat(user.bonusbal) + parseFloat(bonusAmount),
                });

                await user.update({
                    bonusbal: parseFloat(user.bonusbal) + parseFloat(bonusAmount),
                });
                // return res.json({ status: 'success', message: 'Transaction Success' });

            } else if (existingBonus && existingBonus.first == 1 && existingBonus.second == 0) {
                await existingBonus.update({ second: 1, updatedAt: new Date() });

                const bonusAmount = parseFloat(txn.amount) * parseFloat(0.2) + parseFloat(5);
                await BrDeposit.create({
                    userid: user.id,
                    txnby: 'SELF',
                    type: 1,
                    amount: bonusAmount,
                    method: 'Second Deposit Bonus',
                    status: 1,
                    cbalance: user.balance,
                    ubalance: parseFloat(user.balance) + parseFloat(txn.amount),
                    crebalance: user.rebalance,
                    urebalance: user.rebalance,
                    cbonusbal: user.bonusbal,
                    ubonusbal: parseFloat(user.bonusbal) + parseFloat(bonusAmount),
                });

                await user.update({
                    bonusbal: parseFloat(user.bonusbal) + parseFloat(bonusAmount),
                });
                // return res.json({ status: 'success', message: 'Transaction Success' });

            } else if (existingBonus && existingBonus.first == 1 && existingBonus.second == 1 && existingBonus.third == 0) {
                await existingBonus.update({ third: 1, updatedAt: new Date() });

                const bonusAmount = parseFloat(txn.amount) * parseFloat(0.1) + parseFloat(15);

                await BrDeposit.create({
                    userid: user.id,
                    txnby: 'SELF',
                    type: 1,
                    amount: bonusAmount,
                    method: 'Third Deposit Bonus',
                    status: 1,
                    cbalance: user.balance,
                    ubalance: parseFloat(user.balance) + parseFloat(txn.amount),
                    crebalance: user.rebalance,
                    urebalance: user.rebalance,
                    cbonusbal: user.bonusbal,
                    ubonusbal: parseFloat(user.bonusbal) + parseFloat(bonusAmount),
                });

                await user.update({
                    bonusbal: parseFloat(user.bonusbal) + parseFloat(bonusAmount),
                });
                // return res.json({ status: 'success', message: 'Transaction Success' });

            } else if (
                (!getnb) ||
                (existingBonus && existingBonus.first == 1 && existingBonus.second == 1 && existingBonus.third == 1)
            ) {
                console.log("current hour", currentHour)
                console.log("existing bonus", existingBonus)

                if (currentHour >= 3 && currentHour < 9) {
                    console.log("current hour2", currentHour)
                    console.log("gethh", gethh)
                    if (gethh && gethh.eligible == true) {
                        console.log("current hour3", currentHour)

                        const bonus = parseFloat(txn.amount) * parseFloat(0.1);
                        const updatedBonusBalance = parseFloat(user.bonusbal) + parseFloat(bonus);
                        const updatedBalance = parseFloat(user.balance) + parseFloat(txn.amount) + parseFloat(bonus);

                        if (!site) {
                            await user.increment('balance', { by: parseFloat(txn.amount) + parseFloat(bonus) });
                        }

                        await BrDeposit.create({
                            userid: user.id,
                            txnby: 'SELF',
                            type: 1,
                            amount: bonus,
                            method: 'Happy Hour Bonus',
                            status: 1,
                            cbalance: user.balance,
                            ubalance: parseFloat(user.balance) + parseFloat(txn.amount),
                            crebalance: user.rebalance,
                            urebalance: user.rebalance,
                            cbonusbal: user.bonusbal,
                            ubonusbal: updatedBonusBalance,
                        });

                        await HappyHour.create({ userid: user.id, cdate: currDate });
                        await user.increment('bonusbal', { by: bonus });
                    } else {
                        console.log("current hour4", currentHour)

                        await handleSpecialBonuses(txn, user, currDate);
                    }
                } else {
                    await handleSpecialBonuses(txn, user, currDate);
                    // return res.json({ status: 'success', message: 'Transaction Success' });
                }


            }
            const updatedTxn = await txn.update({
                status: '1',
                webhookdata: 'api_call',
                cbalance: user.balance,
                ubalance: parseFloat(user.balance) + parseFloat(txn.amount),
                crebalance: user.rebalance,
                urebalance: user.rebalance,
            });

            if (updatedTxn) {
                await user.increment('balance', { by: parseFloat(txn.amount) });
                return res.json(encrypt(JSON.stringify({ status: 'success', message: 'Transaction Success' }), ENC_KEY));
            }

        }
        else {
            return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Transaction Failed' }), ENC_KEY));
        }
    } catch (err) {
        console.log(err)
        return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Unexpected error occured' }), ENC_KEY));

    }
}
exports.getBonuses = async (req, res) => {
    const { userid } = req.body; // Assuming the request body contains a JSON object
    const sanitizedUserId = parseInt(userid, 10); // Sanitizing user ID input

    // Check for Authorization header
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1]; // Extract token from header
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET); // Verify token
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    // Check if the user ID from the token matches the provided user ID
    if (decoded.id != sanitizedUserId) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findByPk(sanitizedUserId);
            if (!user) {
                const encdata = JSON.stringify({ status: 'error', message: 'User not found!' });
                return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
            }

            const bonus = await BrDeposit.findOne({
                where: {
                    userid: user.id,
                    method: [
                        'Happy Hour Bonus',
                        'First Deposit Bonus',
                        'Second Deposit Bonus',
                        'Third Deposit Bonus',
                        'Bonus SweepCoins',
                    ],
                },
                order: [['id', 'DESC']],
            });

            const returnData = {
                status: 'success',
                bonus_name: bonus ? bonus.method : '',
                amount: user.bonusbal,
            };

            const enc = encrypt(JSON.stringify(returnData), process.env.ENC_KEY);
            return res.status(200).json(enc); // Return encrypted response
        } catch (error) {
            console.error('Error fetching bonuses:', error);
            const encdata = JSON.stringify({ status: 'error', message: 'An error occurred.' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY)); // Internal Server Error
        }
    } else {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid user ID provided!' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY)); // Bad Request
    }
}
exports.getBlockedBins = async (req, res) => {
    try {
        const bins = await BlockedBins.findAll(); // Assuming a Sequelize model query for all blocked bins

        const encdata = JSON.stringify({ status: 'success', bins });
        const enc = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(enc); // Return encrypted response
    } catch (error) {
        console.error('Error fetching blocked bins:', error);
        const encdata = JSON.stringify({ status: 'error', message: 'An error occurred.' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY)); // Internal Server Error
    }
};
exports.getBlockedCards = async (req, res) => {
    try {
        const cards = await BlockedCards.findAll();

        const encdata = JSON.stringify({ status: 'success', cards });
        const enc = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(enc);
    } catch (error) {
        console.error('Error fetching blocked cards:', error);
        const encdata = JSON.stringify({ status: 'error', message: 'An error occurred.' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }
};
function customHash(data) {
    return crypto.createHash('sha256').update(data).digest('hex');
}
exports.nmi2 = async (req, res) => {
    const { userid, cardData, moreData, addressData } = req.body;

    // Validate inputs
    if (!userid || !cardData || !addressData) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Missing required parameters' }), ENC_KEY));
    }

    // Authorization header
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Unauthorized action' }), ENC_KEY));
    }

    const lockFilePath = path.join('/', `nmi_${userid}.lock`);
    let releaseLock;

    try {

        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);
        // Fetch user
        const user = await User.findOne({ where: { id: userid } });
        if (!user) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'User not found' }), ENC_KEY));

            // throw new Error('User not found');
        }

        // Decrypt card data
        const decData = JSON.parse(decrypt(cardData, process.env.ENC_KEY));
        const { p_code: pCode, card, expiry, cvv, amount } = decData;

        if (!pCode || !card || !expiry || !cvv || !amount || !moreData || !addressData) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid card or transaction data' }), ENC_KEY));

            // throw new Error('Invalid card or transaction data');
        }

        const bin = card.substring(0, 6);
        const last4 = card.substring(card.length - 4);
        const binHash = customHash(bin);
        const last4Hash = customHash(last4);
        const date = new Date();

        // Check for existing record
        const existingRecord = await db.query(
            `SELECT * FROM cardpayments WHERE bin = :bin AND last4 = :last4 AND userid != :userid`,
            {
                replacements: { bin: binHash, last4: last4Hash, userid: user.id },
                type: db.QueryTypes.SELECT,
            }
        );

        if (existingRecord.length) {
            await db.query(
                `INSERT INTO flaggedpayments (firstuser, seconduser, bin, last4, txnid, txnid2, created_at) 
                 VALUES (:firstuser, :seconduser, :bin, :last4, :txnid, :txnid2, :created_at)`,
                {
                    replacements: {
                        firstuser: existingRecord[0].userid,
                        seconduser: user.id,
                        bin: binHash,
                        last4: last4Hash,
                        txnid: pCode,
                        txnid2: existingRecord[0].txn_id,
                        created_at: date,
                    },
                }
            );
        }

        // Insert into cardpayments table
        await db.query(
            `INSERT INTO cardpayments (userid, bin, last4, txn_id, created_at) 
             VALUES (:userid, :bin, :last4, :txnid, :created_at)`,
            {
                replacements: { userid: user.id, bin: binHash, last4: last4Hash, txnid: pCode, created_at: date },
            }
        );

        // Prepare payment data for API call
        const fields = {
            security_key: process.env.NMI_LOGIN_ID,
            ccnumber: card,
            ccexp: expiry,
            amount,
            email: user.email,
            phone: user.phone,
            city: addressData.city,
            state: addressData.state,
            orderid: pCode,
            orderdescription: pCode,
            address1: addressData.addr1,
            country: addressData.country,
            first_name: user.first,
            last_name: user.last,
            zip: addressData.zipcode,
            cavv: moreData.cavv,
            xid: moreData.xid,
            eci: moreData.eci,
            cardholder_auth: moreData.cardHolderAuth,
            three_ds_version: moreData.threeDsVersion,
            directory_server_id: moreData.directoryServerId,
            cardholder_info: cvv,
        };

        // API call
        const response = await axios.post('https://bend.logiclane.tech/api/nmi2', fields, {
            headers: { 'Content-Type': 'application/json' },
        });

        const responseDatax = response.data;
        console.log("nmi", responseDatax)

        // Convert to object using URLSearchParams
        const responseData = Object.fromEntries(new URLSearchParams(responseDatax));

        console.log("nmi", responseData);
        if (responseData.response_code == '100') {
            // return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'User not found' }), ENC_KEY));

            return res.status(200).json(encrypt(JSON.stringify({
                status: 'success',
                auth_code: responseData.authcode,
                txn_id: responseData.transactionid,
                p_code: responseData.orderid,
                addressData,
            }), ENC_KEY));
        } else {
            return res.status(200).json(encrypt(JSON.stringify({
                status: 'failed',
                message: 'Invalid response',
                p_code: responseData.orderid,
                addressData,
            }), ENC_KEY));
        }
    } catch (err) {
        console.error(err);
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: err.message }), ENC_KEY));
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }
            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}
exports.gtwCheck = async (req, res) => {
    const { txnID, pending } = req.body;

    if (!txnID) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Transaction ID is required' }), ENC_KEY));
    }

    try {
        // Step 1: Authenticate and retrieve the access token
        const authResponse = await axios.post(
            'https://dawn.dfssys.net/dawnauth/v1/device/authenticate',
            {
                organizationidentifier: process.env.GTOID,
                deviceidentifier: process.env.GTDID,
            }
        );

        const accessToken = authResponse.data.accessToken;

        // Step 2: Handle pending cancellation or fetch transaction results
        if (pending == true) {
            const postData = {
                transactionId: txnID,
                organizationId: process.env.GTOID,
            };

            const cancelResponse = await axios.post(
                'https://dawn.dfssys.net/dawnapi/v1/gtw-transactions/cancelTransaction',
                postData,
                {
                    headers: {
                        'Content-Type': 'application/json',
                        Authorization: `Bearer ${accessToken}`,
                    },
                }
            );

            const encdata = JSON.stringify({
                status: 'success',
                message: 'canceled',
            });
            const enc = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(enc);
        } else {
            const resultResponse = await axios.get(
                `https://dawn.dfssys.net/dawnapi/v1/gtw-transactions/results?transactionIds=${txnID}`,
                {
                    headers: {
                        'Content-Type': 'application/json',
                        Authorization: `Bearer ${accessToken}`,
                    },
                }
            );

            const transactionData = resultResponse.data[0];
            if (transactionData.transactionId == txnID) {
                const { state, result: status } = transactionData;

                if (status == 'Success') {
                    const encdata = JSON.stringify({
                        status: 'success',
                        gtw_state: state,
                        gtw_status: status,
                    });
                    const enc = encrypt(encdata, process.env.ENC_KEY);
                    return res.status(200).json(enc);
                } else if (['Failed', 'Cancelled', 'Canceled', 'DeclinedByUser'].includes(status)) {
                    const encdata = JSON.stringify({
                        status: 'failed',
                        gtw_state: state,
                        gtw_status: status,
                    });
                    const enc = encrypt(encdata, process.env.ENC_KEY);
                    return res.status(200).json(enc);
                } else {
                    const encdata = JSON.stringify({
                        status: 'waiting',
                        gtw_state: state,
                        gtw_status: status,
                    });
                    const enc = encrypt(encdata, process.env.ENC_KEY);
                    return res.status(200).json(enc);
                }
            } else {
                return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Transaction not found' }), ENC_KEY));
            }
        }
    } catch (error) {
        console.error(error);
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Internal Server Error' }), ENC_KEY));
    }
}
function formatPaidMethod(method) {
    switch (method) {
        case 'CreditCard':
        case 'CreditCard2':
            return 'Credit Card';
        case 'GameTimeWallet':
            return 'GameTime Wallet';
        case 'Crypto2':
            return 'Crypto';
        case 'SweepCoins':
            return 'GoldCoins';
        case 'N/A':
        default:
            return method;
    }
}
exports.allTxns = async (req, res) => {
    const { userid, page = 1, limit = 10 } = req.body;
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Unauthorized action' }), ENC_KEY));
    }

    if (!userid) {
        return res.status(200).json({
            status: 'error',
            message: 'user ID missing!',
        });
    }

    const offset = (page - 1) * limit;

    try {

        // Combine all transactions with UNION queries
        const startDate = '2023-08-01';

        // Query for total transaction count
        const totalCount = await db.query(
            `
            SELECT COUNT(*) AS total FROM (
                SELECT 1 FROM brdeposits WHERE userid = :userid AND time >= :startDate
                UNION ALL
                SELECT 1 FROM wheeltxn WHERE userid = :userid AND date >= :startDate
                UNION ALL
                SELECT 1 FROM txnlog WHERE userid = :userid AND date >= :startDate
                UNION ALL
                SELECT 1 FROM redeem WHERE userid = :userid AND date >= :startDate
                UNION ALL
                SELECT 1 FROM withdraw WHERE userid = :userid AND date >= :startDate
            ) AS total_count_query
            `,
            {
                replacements: { userid, startDate },
                type: db.QueryTypes.SELECT,
            }
        );

        // Query for paginated transaction data
        const transactions = await db.query(
            `
            SELECT * FROM (
                SELECT id, userid, txnby, '5' AS type, type AS type2, 'N/A' AS gameid,
                       'N/A' AS gameuser, method AS paidmethod, 'N/A' AS paidmethod2, amount,
                       'N/A' AS ctip, status, time, cbalance, ubalance, crebalance, urebalance,
                       'N/A' AS p_status, 'N/A' AS p_code
                FROM brdeposits WHERE userid = :userid AND time >= :startDate
                UNION ALL
                SELECT id, userid, 'N/A' AS txnby, '4' AS type, NULL AS type2, 'N/A' AS gameid,
                       'N/A' AS gameuser, 'N/A' AS paidmethod, 'N/A' AS paidmethod2, amount,
                       'N/A' AS ctip, status, date, cbalance, ubalance, crebalance, urebalance,
                       'N/A' AS p_status, 'N/A' AS p_code
                FROM wheeltxn WHERE userid = :userid AND date >= :startDate
                UNION ALL
                SELECT id, userid, txnby, type, NULL AS type2, gameid, gameuser, paidto AS paidmethod,
                       paidmethod AS paidmethod2, amount, 'N/A' AS ctip, status, date, cbalance, ubalance,
                       crebalance, urebalance, p_status, p_code
                FROM txnlog WHERE userid = :userid AND date >= :startDate
                UNION ALL
                SELECT id, userid, 'N/A' AS txnby, '3' AS type, NULL AS type2, game, gameuser,
                       'N/A' AS paidmethod, 'N/A' AS paidmethod2, amount, 'N/A' AS ctip, status, date,
                       cbalance, ubalance, crebalance, urebalance, 'N/A' AS p_status, 'N/A' AS p_code
                FROM redeem WHERE userid = :userid AND date >= :startDate
                UNION ALL
                SELECT id, userid, 'N/A' AS txnby, '2' AS type, NULL AS type2, 'N/A' AS gameid,
                       'N/A' AS gameuser, pmeth AS paidmethod, 'N/A' AS paidmethod2, amount, ctip,
                       status, date, cbalance, ubalance, crebalance, urebalance, 'N/A' AS p_status,
                       'N/A' AS p_code
                FROM withdraw WHERE userid = :userid AND date >= :startDate
            ) AS combined_results
            ORDER BY time DESC
            LIMIT :limit OFFSET :offset
            `,
            {
                replacements: { userid, startDate, limit, offset },
                type: db.QueryTypes.SELECT,
            }
        );

        // Post-process transactions
        const txnM = transactions.map((txn) => {
            txn.paidmethod2 = formatPaidMethod(txn.paidmethod2);
            txn.paidmethod = formatPaidMethod(txn.paidmethod);
            txn.gameuser = txn.gameuser == 'N/A' ? '' : txn.gameuser;
            txn.amount = parseFloat(txn.amount).toFixed(2);
            return txn;
        });

        const encdata = JSON.stringify({
            status: 'success',
            data: txnM,
            current_page: page,
            limit,
            total: totalCount[0].total,
        });

        const enc = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(enc);
    } catch (error) {
        console.error(error);
        return res.status(200).json({
            status: 'error',
            message: 'Internal Server Error',
        });
    }
}
exports.withdrawalTxns = async (req, res) => {
    const { userid, page = 1, limit = 10 } = req.body;
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    const ENC_KEY = process.env.ENC_KEY;

    if (!authHeader) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Unauthorized action' }), ENC_KEY));
    }

    if (!userid) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'User ID missing!' }), ENC_KEY));
    }

    const offset = (page - 1) * limit;
    const startDate = '2023-08-01';

    try {
        const totalCountResult = await db.query(
            `SELECT COUNT(*) AS total FROM withdraw WHERE userid = :userid AND date >= :startDate`,
            {
                replacements: { userid, startDate },
                type: db.QueryTypes.SELECT,
            }
        );
        const totalCount = totalCountResult[0].total;

        const transactions = await db.query(
            `
            SELECT 
                id, userid, 'N/A' AS txnby, '2' AS type, NULL AS type2, 
                'N/A' AS gameid, 'N/A' AS gameuser, pmeth AS paidmethod,
                'N/A' AS paidmethod2, amount, ctip, status, date, cbalance,
                ubalance, crebalance, urebalance, 'N/A' AS p_status,
                missing_report, missing_report_status, 'N/A' AS p_code
            FROM withdraw
            WHERE userid = :userid AND date >= :startDate
            ORDER BY date DESC
            LIMIT :limit OFFSET :offset
            `,
            {
                replacements: { userid, startDate, limit, offset },
                type: db.QueryTypes.SELECT,
            }
        );

        const txnM = transactions.map((txn) => {
            if (['Credit Card', 'GameTimeWallet', 'Crypto'].includes(txn.paidmethod)) {
                txn.paidmethod = 'GoldCoins';
            } else if (txn.paidmethod === 'N/A') {
                txn.paidmethod = '';
            }

            txn.paidmethod2 = '';
            txn.gameuser = '';
            txn.amount = parseFloat(txn.amount).toFixed(2);

            return txn;
        });

        const encdata = JSON.stringify({
            status: 'success',
            data: txnM,
            current_page: page,
            limit,
            total: totalCount,
        });

        const enc = encrypt(encdata, ENC_KEY);
        return res.status(200).json(enc);
    } catch (error) {
        console.error(error);
        return res.status(200).json(encrypt(JSON.stringify({
            status: 'error',
            message: 'Internal Server Error',
        }), ENC_KEY));
    }
};
exports.gameDepositTxns = async (req, res) => {
    const { userid, page = 1, limit = 10 } = req.body;
    const offset = (page - 1) * limit;
    const ENC_KEY = process.env.ENC_KEY;
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];

    if (!authHeader) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
    }

    if (decoded.id != parseInt(userid) || !userid) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid token provided!' }), ENC_KEY));
    }

    const startDate = '2023-08-01';
    const excludedMethods = ['Google Pay', 'Apple Pay', 'ForumPay', 'Crypto', 'CreditCard', 'CreditCard2', 'GameTimeWallet', 'SweepCoin'];

    try {
        // Count matching records
        const totalCountResult = await db.query(
            `SELECT COUNT(*) AS total FROM txnlog 
             WHERE userid = :userid 
             AND date >= :startDate 
             AND type = 1
             AND paidmethod NOT IN (:excludedMethods)`,
            {
                replacements: { userid, startDate, excludedMethods },
                type: db.QueryTypes.SELECT,
            }
        );
        const totalCount = totalCountResult[0].total;

        // Get paginated records
        const transactions = await db.query(
            `
            SELECT 
                id,
                userid,
                txnby,
                type,
                NULL AS type2,
                gameid,
                gameuser,
                paidto,
                paidmethod,
                amount,
                'N/A' AS ctip,
                status,
                date,
                cbalance,
                ubalance,
                crebalance,
                urebalance,
                p_status,
                p_code,
                missing_report,
                missing_report_status
            FROM txnlog 
            WHERE userid = :userid 
              AND date >= :startDate 
              AND paidmethod NOT IN (:excludedMethods)
              AND type = 1
            ORDER BY date DESC
            LIMIT :limit OFFSET :offset
            `,
            {
                replacements: { userid, startDate, excludedMethods, limit, offset },
                type: db.QueryTypes.SELECT,
            }
        );

        // Format transactions
        const txnM = transactions.map((txn) => {
            if (['Credit Card', 'GameTimeWallet', 'Crypto', 'SweepCoins'].includes(txn.paidmethod)) {
                txn.paidmethod = 'GoldCoins';
            } else if (txn.paidmethod === 'N/A') {
                txn.paidmethod = '';
            }

            txn.paidmethod2 = '';
            txn.gameuser = '';
            txn.amount = parseFloat(txn.amount).toFixed(2);

            return txn;
        });

        const encdata = JSON.stringify({
            status: 'success',
            data: txnM,
            current_page: page,
            limit,
            total: totalCount,
        });

        return res.status(200).json(encrypt(encdata, ENC_KEY));
    } catch (error) {
        console.error(error);
        return res.status(200).json(encrypt(JSON.stringify({
            status: 'error',
            message: 'Internal Server Error',
        }), ENC_KEY));
    }
};
exports.reportCashout = async (req, res) => {
    const { userid, withid } = req.body;
    if (!userid || !withid) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Missing parameters!' }), ENC_KEY));
    }
    // const offset = (page - 1) * limit;
    const ENC_KEY = process.env.ENC_KEY;
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];

    if (!authHeader) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
    }

    if (decoded.id != parseInt(userid) || !userid) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid token provided!' }), ENC_KEY));
    }
    const lockFilePath = path.join('/', `report_cashout_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);
        const cashout = await Withdraw.findOne({
            where: { userid, id: withid },
            order: [['id', 'DESC']],
        });

        if (!cashout) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Cashout not found!' }), ENC_KEY));
        }

        const user = await User.findByPk(userid);
        if (!user || user.isVerified != '1') {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' }), ENC_KEY));
        }

        const lastReport = await Withdraw.findOne({
            where: {
                userid,
                last_reported_at: { [Op.not]: null },
            },
            order: [['last_reported_at', 'DESC']],
        });

        if (lastReport) {
            const lastReportDate = dayjs(lastReport.last_reported_at);
            if (dayjs().diff(lastReportDate, 'day') < 7) {
                return res.status(200).json(encrypt(JSON.stringify({
                    status: 'error',
                    message: 'You can only report once every 7 days'
                }), ENC_KEY));
            }
        }

        const twoMonthsAgo = dayjs().subtract(2, 'month');
        if (dayjs(cashout.date).isBefore(twoMonthsAgo)) {
            return res.status(200).json(encrypt(JSON.stringify({
                status: 'error',
                message: 'Cashout cannot be older than 2 months!'
            }), ENC_KEY));
        }

        await cashout.update({
            missing_report: '1',
            last_reported_at: dayjs().toDate(),
        });
        const emailPayload = {
            subject: 'CashOut status!',
            email: user.email,
            name: `${user.first} ${user.last}`,
            mail: `<!DOCTYPE html>
                                                                                  <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                                                                  
                                                                                  <head>
                                                                                    <meta charset='utf-8'>
                                                                                    <meta name='x-apple-disable-message-reformatting'>
                                                                                    <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                                                    <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                                                    <title>CashOut status!</title>
                                                                                    <style>
                                                                                    .hover-text-brand-200:hover {
                                                                                        color: #0052E2 !important;
                                                                                      }
                                                                                  
                                                                                      .hover-text-brand-700:hover {
                                                                                        color: #003CA5 !important;
                                                                                      }
                                                                                  
                                                                                      .hover-text-decoration-underline:hover {
                                                                                        text-decoration: underline !important;
                                                                                      }
                                                                                  
                                                                                      @media (max-width: 768px) {
                                                                                        .sm-mt-4 {
                                                                                          margin-top: 16px !important;
                                                                                        }
                                                                                  
                                                                                        .sm-block {
                                                                                          display: block !important;
                                                                                        }
                                                                                  
                                                                                        .sm-inline-block {
                                                                                          display: inline-block !important;
                                                                                        }
                                                                                  
                                                                                        .sm-w-auto {
                                                                                          width: auto !important;
                                                                                        }
                                                                                  
                                                                                        .sm-w-full {
                                                                                          width: 100% !important;
                                                                                        }
                                                                                  
                                                                                        .sm-px-0 {
                                                                                          padding-left: 0 !important;
                                                                                          padding-right: 0 !important;
                                                                                        }
                                                                                  
                                                                                        .sm-px-4 {
                                                                                          padding-left: 16px !important;
                                                                                          padding-right: 16px !important;
                                                                                        }
                                                                                  
                                                                                        .sm-py-6 {
                                                                                          padding-top: 24px !important;
                                                                                          padding-bottom: 24px !important;
                                                                                        }
                                                                                  
                                                                                        .sm-pb-8 {
                                                                                          padding-bottom: 32px !important;
                                                                                        }
                                                                                  
                                                                                        .sm-align-top {
                                                                                          vertical-align: top !important;
                                                                                        }
                                                                                      }
                                                                                    </style>
                                                                                  </head>
                                                                                  
                                                                                  <body
                                                                                    style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                                                    <div style='display: none'>
                                                                                    Game Recharge request submitted!
                                                                                  
                                                                                    </div>
                                                                                    <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                                                      <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                                                        cellpadding='0' cellspacing='0' role='none'>
                                                                                        <tr>
                                                                                          <td align='center' style='background-color: #fff;'>
                                                                                            <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                                                              <tr>
                                                                                                <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                                                  <div style='margin-bottom: 24px'>
                                                                                                    <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                                                      <p>SweepStake Mobi</p>
                                                                                                    </a>
                                                                                                  </div>
                                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                                    Hi <b>${user.first}</b>,
                                                                                                  </p>
                                                                                                  <br>
                                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                                  Your cashout dispute has been successfully reported for review.<br/>We have received your request regarding the cashout of $${cashout.amount}, and it is now under processing.
                                                                                                  </p>
                                                                                                 <br>
                                                                                                 <br>
                                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                                                  Thank you for choosing SweepStake Mobi!
                                                                                                  </p>
                                                                                                  <div role='separator' style='line-height: 16px'>&zwj;</div> 
                                                                                                 
                                                                                                  <div style='text-align: center;'>
                                                                                                    <div role='separator'
                                                                                                      style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                                                    <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                                                      This email was sent to you as a registered member of
                                                                                                      <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                        style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                                                        class='sm-block sm-mt-4'>
                                                                                                        Use of the service and website is subject to our
                                                                                                        <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                          style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                                                        and
                                                                                                        <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                          style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                                                      </span>
                                                                                                    </p>
                                                                                                    <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                                                      rights reserved.</p>
                                                                                                  </div>
                                                                                                </td>
                                                                                              </tr>
                                                                                            </table>
                                                                                          </td>
                                                                                        </tr>
                                                                                      </table>
                                                                                    </div>
                                                                                  </body>
                                                                                  
                                                                                  </html>`,
        };
        try {
            await axios.post('https://bend.logiclane.tech/api/email', emailPayload, {
                headers: {
                    'Content-Type': 'application/json',
                    Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
                },
            });
        } catch (error) {
            console.error('Error sending email:', error);
        }
        return res.status(200).json(encrypt(JSON.stringify({
            status: 'success',
            message: 'Cashout reported!',
        }), ENC_KEY));
    } catch (error) {
        console.error(error);
        return res.status(200).json(encrypt(JSON.stringify({
            status: 'error',
            message: 'Internal Server Error',
        }), ENC_KEY));
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.reportDeposit = async (req, res) => {
    const { userid, depositid } = req.body;
    if (!userid || !depositid) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Missing parameters!' }), ENC_KEY));
    }
    // const offset = (page - 1) * limit;
    const ENC_KEY = process.env.ENC_KEY;
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];

    if (!authHeader) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
    }

    if (decoded.id != parseInt(userid) || !userid) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid token provided!' }), ENC_KEY));
    }
    const lockFilePath = path.join('/', `report_deposit_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);
        // const cashout = await Withdraw.findOne({
        //     where: { userid, id: withid },
        //     order: [['id', 'DESC']],
        // });

        // if (!cashout) {
        //     return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Cashout not found!' }), ENC_KEY));
        // }

        const user = await User.findByPk(userid);
        if (!user || user.isVerified != '1') {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' }), ENC_KEY));
        }

        const deposit = await db.query(
            `SELECT * FROM txnlog WHERE id = :depositid AND userid = :userid LIMIT 1`,
            {
                replacements: { depositid, userid },
                type: db.QueryTypes.SELECT,
            }
        );

        if (!deposit.length) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Deposit not found!' }), ENC_KEY));
        }

        const depositDate = dayjs(deposit[0].date);
        if (depositDate.isBefore(dayjs().subtract(2, 'day'))) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Deposit cannot be older than 2 days!' }), ENC_KEY));
        }

        const today = dayjs().format('YYYY-MM-DD');
        const reportCount = await db.query(
            `SELECT COUNT(*) AS count FROM txnlog WHERE userid = :userid AND DATE(last_reported_at) = :today`,
            {
                replacements: { userid, today },
                type: db.QueryTypes.SELECT,
            }
        );

        if (reportCount[0].count >= 2) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'You can only report up to 2 deposits per day.' }), ENC_KEY));
        }

        await db.query(
            `UPDATE txnlog SET missing_report = '1', last_reported_at = :now WHERE id = :depositid`,
            {
                replacements: {
                    depositid,
                    now: dayjs().format('YYYY-MM-DD HH:mm:ss'),
                },
                type: db.QueryTypes.UPDATE,
            }
        );

        const emailPayload = {
            subject: 'Deposit info!',
            email: user.email,
            name: `${user.first} ${user.last}`,
            mail: `<!DOCTYPE html>
                                                                                  <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                                                                  
                                                                                  <head>
                                                                                    <meta charset='utf-8'>
                                                                                    <meta name='x-apple-disable-message-reformatting'>
                                                                                    <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                                                    <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                                                    <title>Deposit info!</title>
                                                                                    <style>
                                                                                    .hover-text-brand-200:hover {
                                                                                        color: #0052E2 !important;
                                                                                      }
                                                                                  
                                                                                      .hover-text-brand-700:hover {
                                                                                        color: #003CA5 !important;
                                                                                      }
                                                                                  
                                                                                      .hover-text-decoration-underline:hover {
                                                                                        text-decoration: underline !important;
                                                                                      }
                                                                                  
                                                                                      @media (max-width: 768px) {
                                                                                        .sm-mt-4 {
                                                                                          margin-top: 16px !important;
                                                                                        }
                                                                                  
                                                                                        .sm-block {
                                                                                          display: block !important;
                                                                                        }
                                                                                  
                                                                                        .sm-inline-block {
                                                                                          display: inline-block !important;
                                                                                        }
                                                                                  
                                                                                        .sm-w-auto {
                                                                                          width: auto !important;
                                                                                        }
                                                                                  
                                                                                        .sm-w-full {
                                                                                          width: 100% !important;
                                                                                        }
                                                                                  
                                                                                        .sm-px-0 {
                                                                                          padding-left: 0 !important;
                                                                                          padding-right: 0 !important;
                                                                                        }
                                                                                  
                                                                                        .sm-px-4 {
                                                                                          padding-left: 16px !important;
                                                                                          padding-right: 16px !important;
                                                                                        }
                                                                                  
                                                                                        .sm-py-6 {
                                                                                          padding-top: 24px !important;
                                                                                          padding-bottom: 24px !important;
                                                                                        }
                                                                                  
                                                                                        .sm-pb-8 {
                                                                                          padding-bottom: 32px !important;
                                                                                        }
                                                                                  
                                                                                        .sm-align-top {
                                                                                          vertical-align: top !important;
                                                                                        }
                                                                                      }
                                                                                    </style>
                                                                                  </head>
                                                                                  
                                                                                  <body
                                                                                    style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                                                    <div style='display: none'>
                                                                                    Game Recharge request submitted!
                                                                                  
                                                                                    </div>
                                                                                    <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                                                      <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                                                        cellpadding='0' cellspacing='0' role='none'>
                                                                                        <tr>
                                                                                          <td align='center' style='background-color: #fff;'>
                                                                                            <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                                                              <tr>
                                                                                                <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                                                  <div style='margin-bottom: 24px'>
                                                                                                    <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                                                      <p>SweepStake Mobi</p>
                                                                                                    </a>
                                                                                                  </div>
                                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                                    Hi <b>${user.first}</b>,
                                                                                                  </p>
                                                                                                  <br>
                                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                                  Your deposit dispute has been successfully reported for review.<br/>We have received your request regarding the deposit of $${deposit.amount}, and it is now under processing.
                                                                                                  </p>
                                                                                                 <br>
                                                                                                 <br>
                                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                                                  Thank you for choosing SweepStake Mobi!
                                                                                                  </p>
                                                                                                  <div role='separator' style='line-height: 16px'>&zwj;</div> 
                                                                                                 
                                                                                                  <div style='text-align: center;'>
                                                                                                    <div role='separator'
                                                                                                      style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                                                    <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                                                      This email was sent to you as a registered member of
                                                                                                      <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                        style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                                                        class='sm-block sm-mt-4'>
                                                                                                        Use of the service and website is subject to our
                                                                                                        <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                          style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                                                        and
                                                                                                        <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                          style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                                                      </span>
                                                                                                    </p>
                                                                                                    <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                                                      rights reserved.</p>
                                                                                                  </div>
                                                                                                </td>
                                                                                              </tr>
                                                                                            </table>
                                                                                          </td>
                                                                                        </tr>
                                                                                      </table>
                                                                                    </div>
                                                                                  </body>
                                                                                  
                                                                                  </html>`,
        };
        try {
            await axios.post('https://bend.logiclane.tech/api/email', emailPayload, {
                headers: {
                    'Content-Type': 'application/json',
                    Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
                },
            });
        } catch (error) {
            console.error('Error sending email:', error);
        }
        return res.status(200).json(encrypt(JSON.stringify({
            status: 'success',
            message: 'Cashout reported!',
        }), ENC_KEY));
    } catch (error) {
        console.error(error);
        return res.status(200).json(encrypt(JSON.stringify({
            status: 'error',
            message: 'Internal Server Error',
        }), ENC_KEY));
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
async function generatePDF(data, user, res) {

    // return res.json(data.forEach((item) => { item.get(); console.log(item) }));
    const pdfDoc = await PDFDocument.create();

    // Load fonts
    const font = await pdfDoc.embedFont(StandardFonts.Helvetica);
    const boldFont = await pdfDoc.embedFont(StandardFonts.HelveticaBold);

    // Define styling constants
    const fontSizeHeader = 18;
    const fontSizeTable = 12;
    const pageWidth = 595.28;  // A4 size in points
    const pageHeight = 860;
    const tableMargin = 20; // Margin for table
    const columnWidths = [30, 75, 120, 55, 205, 75]; // Define column widths
    const rowHeight = 25; // Height of each row in the table
    const padding = 7; // Padding inside the cells

    // Define color mappings
    const typeColor = {
        'Backroom Deposit': rgb(0, 0.7, 0),
        'Deposit': rgb(0, 0.7, 0),
        'Backroom Withdraw': rgb(1, 0, 0),  // Green for Deposit
        'Withdraw': rgb(1, 0, 0),  // Red for Withdraw
        'Redeem': rgb(0, 0, 1),    // Blue for Redeem
        'Wheel Spin': rgb(0, 1, 1), // Blue for Wheel Spin
    };

    const statusColor = {
        'Processed': rgb(0, 0.7, 0),  // Green for Processed
        'Failed': rgb(1, 0, 0),     // Red for Failed
        'Pending': rgb(1, 0.647, 0), // Orange for Pending
    };

    const amountColor = {
        'Backroom Deposit': rgb(0, 0.7, 0),
        'Deposit': rgb(0, 0.7, 0),
        'Backroom Withdraw': rgb(1, 0, 0),  // Green for Deposit Amount
        'Withdraw': rgb(1, 0, 0),  // Red for Withdraw Amount
        'Redeem': rgb(0, 0, 1),    // Blue for Redeem Amount
        'Wheel Spin': rgb(0, 1, 1), // Blue for Wheel Spin Amount
    };

    // Add a page
    let page = pdfDoc.addPage([pageWidth, pageHeight]);
    const { width, height } = page.getSize();

    // Add header
    const header = 'Shooting Fish Games';
    page.drawText(header, {
        x: 40,
        y: height - 50,
        size: fontSizeHeader,
        font: boldFont,  // Use the bold font for the header
        color: rgb(0, 0, 0),  // Black color for the header
    });

    // Add User Info
    const userInfo = `Full Name: ${user.first} ${user.last}\nEmail: ${user.email}\nPhone No: ${user.phone}`;
    page.drawText(userInfo, {
        x: 40,
        y: height - 80,
        size: fontSizeTable,
        font: font,  // Use the regular font for user info
        color: rgb(0, 0, 0),  // Black color for user info
    });

    // Add Table Header
    const tableHeader = ['ID', 'Date', 'Type', 'Amount', 'Payment Method', 'Status'];
    let tableY = height - 130;

    // Set the style for the table header
    tableHeader.forEach((header, index) => {
        page.drawText(header, {
            x: tableMargin + columnWidths.slice(0, index).reduce((a, b) => a + b, 0) + padding, // Added padding to X position
            y: tableY - 42, // Added padding to Y position
            size: fontSizeTable,
            font: boldFont,  // Use the bold font for the header
            color: rgb(0, 0, 0),  // Black color for table header
        });

        // Draw header cell borders with padding
        page.drawRectangle({
            x: tableMargin + columnWidths.slice(0, index).reduce((a, b) => a + b, 0),
            y: tableY - 50,
            width: columnWidths[index],
            height: rowHeight,
            borderColor: rgb(0, 0, 0),
            borderWidth: 1,
        });
    });

    // Draw horizontal line below the header
    tableY -= rowHeight;
    page.drawRectangle({
        x: tableMargin,
        y: tableY,
        width: columnWidths.reduce((a, b) => a + b, 0),
        height: 1,
        color: rgb(0, 0, 0),
    });

    // Add Table Data
    tableY -= rowHeight;
    data.forEach((item, index) => {
        const id = (index + 1).toString();
        const date = moment(item.time).format('MM-DD-YYYY');
        let type = '';
        let amount = '';
        let status = '';
        let methodx = '';

        // Determine Type & Amount
        if (item.type === '1') {
            type = 'Deposit';
            amount = `$${Number(item.amount).toFixed(2)}`;
        } else if (item.type === '2') {
            type = 'Withdraw';
            amount = `-$${Number(item.amount).toFixed(2)}`;
        } else if (item.type === '3') {
            type = 'Redeem';
            amount = `$${Number(item.amount).toFixed(2)}`;
        } else if (item.type === '4') {
            type = 'Wheel Spin';
            amount = `$${Number(item.amount).toFixed(2)}`;
        } else if (item.type === '5' && item.type2 === '1') {
            type = 'Backroom Deposit';
            amount = `$${Number(item.amount).toFixed(2)}`;
        } else if (item.type === '5' && item.type2 === '2') {
            type = 'Backroom Withdraw';
            amount = `$${Number(item.amount).toFixed(2)}`;
        }

        // Determine Status
        if (item.status === '1') {
            status = 'Processed';
        } else if (item.status === '2') {
            status = 'Failed';
        } else if (item.status === '0') {
            status = 'Pending';
        }

        // Payment Method
        let pmethod = '';
        let pmethod2 = '';
        const paidmethod2 = item.paidmethod2;
        const paidmethod = item.paidmethod;
        const gameuser = item.gameuser;

        // Handle paidmethod2
        if (['CreditCard', 'CreditCard2'].includes(paidmethod2)) {
            pmethod = 'Credit Card';
        } else if (paidmethod2 === 'GameTimeWallet') {
            pmethod = 'GameTime Wallet';
        } else if (paidmethod2 === 'Crypto2') {
            pmethod = 'Crypto';
        } else if (paidmethod2 === 'SweepCoins') {
            pmethod = 'GoldCoins';
        } else if (paidmethod2 && paidmethod2 !== 'N/A') {
            pmethod = paidmethod2;
        }

        // Handle paidmethod
        if (['Credit Card', 'GameTimeWallet', 'Crypto'].includes(paidmethod)) {
            pmethod2 = 'GoldCoin';
        } else if (paidmethod && paidmethod !== 'N/A') {
            pmethod2 = paidmethod;
        }

        // Compose methodx
        if (pmethod && gameuser && pmethod2) {
            methodx = `${pmethod} - ${pmethod2} - ${gameuser}`;
        } else if (pmethod && gameuser) {
            methodx = `${pmethod} - ${gameuser}`;
        } else if (pmethod && pmethod2) {
            methodx = `${pmethod} - ${pmethod2}`;
        } else {
            methodx = pmethod || pmethod2 || '';
        }

        // Row Data
        const rowData = [id, date, type, amount, methodx, status];

        // Draw Table Row
        rowData.forEach((data, columnIndex) => {
            let textColor = rgb(0, 0, 0);
            if (columnIndex === 2) textColor = typeColor[type] || rgb(0, 0, 0);
            if (columnIndex === 3) textColor = amountColor[type] || rgb(0, 0, 0);
            if (columnIndex === 5) textColor = statusColor[status] || rgb(0, 0, 0);

            page.drawText(data, {
                x: tableMargin + columnWidths.slice(0, columnIndex).reduce((a, b) => a + b, 0) + padding,
                y: tableY - 17,
                size: fontSizeTable,
                font: font,
                color: textColor,
            });

            page.drawRectangle({
                x: tableMargin + columnWidths.slice(0, columnIndex).reduce((a, b) => a + b, 0),
                y: tableY - rowHeight,
                width: columnWidths[columnIndex],
                height: rowHeight,
                borderColor: rgb(0, 0, 0),
                borderWidth: 1,
            });
        });

        tableY -= rowHeight;

        // Draw row separator
        page.drawRectangle({
            x: tableMargin,
            y: tableY,
            width: columnWidths.reduce((a, b) => a + b, 0),
            height: 1,
            color: rgb(0, 0, 0),
        });

        // Add new page if needed
        if (tableY < 50) {
            page = pdfDoc.addPage([pageWidth, pageHeight]);
            tableY = height - 50;

            tableHeader.forEach((header, index) => {
                page.drawText(header, {
                    x: tableMargin + columnWidths.slice(0, index).reduce((a, b) => a + b, 0) + padding,
                    y: tableY - 17,
                    size: fontSizeTable,
                    font: boldFont,
                    color: rgb(0, 0, 0),
                });

                page.drawRectangle({
                    x: tableMargin + columnWidths.slice(0, index).reduce((a, b) => a + b, 0),
                    y: tableY - rowHeight,
                    width: columnWidths[index],
                    height: rowHeight,
                    borderColor: rgb(0, 0, 0),
                    borderWidth: 1,
                });
            });

            tableY -= rowHeight;
        }
    });
    // Generate PDF
    const pdfBytes = await pdfDoc.save();
    const filename = `report_${moment().format('YYYYMMDD_HHmmss')}.pdf`;

    // Send PDF as a response
    res.setHeader('Content-Disposition', `attachment; filename="${filename}"`);
    res.setHeader('Content-Type', 'application/pdf');
    res.send(Buffer.from(pdfBytes));
}
exports.exportReport = async (req, res) => {
    const { userid, from, to } = req.body;
    console.log(from, to)
    // Verify Token
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Unauthorized action' }), ENC_KEY));
    }

    if (!userid) {
        return res.status(200).json({
            status: 'error',
            message: 'user ID missing!',
        });
    }


    if (!userid || !from || !to) {
        return res.status(200).json({ status: 'error', message: 'Missing required parameters!' });
    }

    try {
        // Date Range Validation
        let fromDate = moment(from).isBefore('2023-08-01')
            ? moment('2023-08-01')
            : moment(from).startOf('day').format('YYYY-MM-DD');

        let toDate = moment(to).endOf('day').format('YYYY-MM-DD');

        const user = await User.findOne({ where: { id: userid } });
        if (!user) {
            return res.status(200).json({ status: 'error', message: 'User not found!' });
        }
        let endDate = toDate
        let startDate = fromDate

        // Query for paginated transaction data
        const transactions = await db.query(
            `
            SELECT * FROM (
                SELECT id, userid, txnby, '5' AS type, type AS type2, 'N/A' AS gameid,
                       'N/A' AS gameuser, method AS paidmethod, 'N/A' AS paidmethod2, amount,
                       'N/A' AS ctip, status, time, cbalance, ubalance, crebalance, urebalance,
                       'N/A' AS p_status, 'N/A' AS p_code
                FROM brdeposits WHERE userid = :userid AND time >= :startDate AND time <= :endDate
                UNION ALL
                SELECT id, userid, 'N/A' AS txnby, '4' AS type, NULL AS type2, 'N/A' AS gameid,
                       'N/A' AS gameuser, 'N/A' AS paidmethod, 'N/A' AS paidmethod2, amount,
                       'N/A' AS ctip, status, date, cbalance, ubalance, crebalance, urebalance,
                       'N/A' AS p_status, 'N/A' AS p_code
                FROM wheeltxn WHERE userid = :userid AND date >= :startDate AND date <= :endDate
                UNION ALL
                SELECT id, userid, txnby, type, NULL AS type2, gameid, gameuser, paidto AS paidmethod,
                       paidmethod AS paidmethod2, amount, 'N/A' AS ctip, status, date, cbalance, ubalance,
                       crebalance, urebalance, p_status, p_code
                FROM txnlog WHERE userid = :userid AND date >= :startDate AND date <= :endDate
                UNION ALL
                SELECT id, userid, 'N/A' AS txnby, '3' AS type, NULL AS type2, game, gameuser,
                       'N/A' AS paidmethod, 'N/A' AS paidmethod2, amount, 'N/A' AS ctip, status, date,
                       cbalance, ubalance, crebalance, urebalance, 'N/A' AS p_status, 'N/A' AS p_code
                FROM redeem WHERE userid = :userid AND date >= :startDate AND date <= :endDate
                UNION ALL
                SELECT id, userid, 'N/A' AS txnby, '2' AS type, NULL AS type2, 'N/A' AS gameid,
                       'N/A' AS gameuser, pmeth AS paidmethod, 'N/A' AS paidmethod2, amount, ctip,
                       status, date, cbalance, ubalance, crebalance, urebalance, 'N/A' AS p_status,
                       'N/A' AS p_code
                FROM withdraw WHERE userid = :userid AND date >= :startDate AND date <= :endDate
            ) AS combined_results
           
            `,
            {
                replacements: { userid, startDate, endDate },
                type: db.QueryTypes.SELECT,
            }
        );

        // Post-process transactions
        const txnM = transactions.map((txn) => {
            txn.paidmethod2 = formatPaidMethod(txn.paidmethod2);
            txn.paidmethod = formatPaidMethod(txn.paidmethod);
            txn.gameuser = txn.gameuser == 'N/A' ? '' : txn.gameuser;
            txn.amount = parseFloat(txn.amount).toFixed(2);
            return txn;
        });
        // console.log(txnM)

        await generatePDF(txnM, user, res);


    } catch (error) {
        console.error(error);
        return res.status(200).json({ status: 'error', message: 'An error occurred!' });
    }
};
exports.raffleWins = async (req, res) => {
    try {
        // Fetch the latest 10 raffle wins
        const wins = await RaffleWins.findAll({
            attributes: ['id', 'userid', 'name', 'profilephoto', 'amount'],
            order: [['id', 'DESC']], // Sort by 'id' in descending order
            limit: 10, // Limit to the latest 10 entries
        });

        // Prepare the response data
        const responseData = {
            status: 'success',
            data: wins
        };

        // Encrypt the response data
        const encKey = process.env.ENC_KEY; // Ensure ENC_KEY is defined in your .env file
        const encryptedData = encrypt(JSON.stringify(responseData), encKey);

        // Send the encrypted data as JSON response
        res.json(encryptedData);
    } catch (error) {
        console.error('Error fetching raffle wins:', error);
        res.status(200).json({ status: 'error', message: 'An error occurred while fetching raffle wins' });
    }
}
async function sendWinnerEmail(user) {
    const emailPayload = {
        subject: 'Raffle Games',
        email: user.email,
        name: `${user.first} ${user.last}`,
        mail: `<p>Congratulations ${usrr.first}!<br>You are this weeks Raffle winner, your winnings has been added to your wallet.</p>
                            <p>Thank you for choosing SweepStake Mobi!</p>
                            <a href='https://playgds.mobi/raffle'>Check this week raffle winners</a>
                                               <p><b>Please do not reply to this email!</b></p>`,
    };

    try {
        await axios.post('https://bend.logiclane.tech/api/email', emailPayload, {
            headers: {
                'Content-Type': 'application/json',
                Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
            },
        });
    } catch (error) {
        console.error('Error sending email:', error);
    }
}
async function processRaffle(raffleAmount) {
    try {
        // Get the current date and calculate the start date (3 weeks ago)
        const currentDate = moment().format('YYYY-MM-DD');
        const startDate = moment().subtract(1, 'weeks').format('YYYY-MM-DD');

        // Fetch raffle bonus data for users meeting criteria
        const inserts = await Raffles.findAll({
            where: {
                created_at: { [Op.gte]: startDate },
                amount: raffleAmount,
            },
            attributes: [
                'userid',
                [db.fn('COUNT', db.col('userid')), 'entry_count'],
                [db.fn('SUM', db.col('amount')), 'total_amount'],
            ],
            group: ['userid'],
        });

        let users = [];
        let winningUsers = [];
        let maxEntries = 0;

        for (const result of inserts) {
            const user = await User.findByPk(result.userid);
            if (!user) continue;

            const entryCount = result.dataValues.entry_count;
            const totalAmount = result.dataValues.total_amount;

            // Check if the user already won in a previous raffle
            const win = await RaffleWins.findOne({
                where: {
                    userid: user.id,
                    raffle_amount: raffleAmount,
                    date: { [Op.gte]: startDate },
                },
                order: [['id', 'DESC']],
            });

            if (win) continue; // Skip users who already won

            users.push({
                userid: user.id,
                email: user.email,
                first: user.first,
                last: user.last,
                entries: entryCount,
                total_amount: totalAmount,
            });

            maxEntries = Math.max(maxEntries, entryCount);
        }

        // Shuffle users to randomize selection
        users = users.sort(() => 0.5 - Math.random());

        // Select up to 3 winning users
        for (let i = 0; i < Math.min(3, users.length); i++) {
            const winner = users[i];
            winningUsers.push(winner);

            // Update or create a RaffleWins record for the winner
            let raffleWin = await RaffleWins.findOne({
                where: {
                    userid: winner.userid,
                    raffle_amount: raffleAmount,
                },
            });

            if (raffleWin) {
                await raffleWin.update({
                    amount: 100, // Adjust as needed
                    profilephoto: winner.profilephoto,
                });
            } else {
                raffleWin = await RaffleWins.create({
                    userid: winner.userid,
                    name: `${winner.first} ${winner.last}`,
                    amount: 100, // Adjust as needed
                    profilephoto: winner.profilephoto,
                    raffle_amount: raffleAmount,
                    entry_count: winner.entries,
                });
            }

            // Optionally update the user's balance or perform other actions
        }

        // Notify non-winning users
        for (const user of users) {
            const isWinner = winningUsers.some(winner => winner.userid === user.userid);
            if (!isWinner) {
                const usr = await User.findByPk(user.userid);
                if (!usr) continue;

                // Example action for non-winners: just log or notify
            } else {
                const usr = await User.findByPk(user.userid);
                if (!usr) continue;

                const updatedBalance = usr.balance + 100;

                // Create a BRDeposit record
                await BrDeposit.create({
                    userid: usr.id,
                    txnby: 'SELF',
                    type: 1,
                    amount: 100,
                    method: 'Raffle Win',
                    cbalance: usr.balance,
                    ubalance: updatedBalance,
                    crebalance: usr.rebalance,
                    urebalance: usr.rebalance,
                });

                // Update user's balance
                await usr.increment('balance', { by: 100 });

                // Send email to the winner
                // await sendWinnerEmail(usr);
            }
        }

        return {
            winningUsers,
            nonWinningUsers: users.filter(user => !winningUsers.includes(user)),
        };
    } catch (error) {
        console.error('Error processing raffle:', error);
        throw error;
    }
}
exports.raffleWinCron = async (req, res) => {
    try {
        // Process raffles for different amounts
        const users0 = await processRaffle(0);
        const users5 = await processRaffle(5);
        const users10 = await processRaffle(10);
        const users20 = await processRaffle(20);

        // Return response in JSON format
        res.json({
            status: 'success',
            data: {
                users_0: users0,
                users_5: users5,
                users_10: users10,
                users_20: users20,
            },
        });
    } catch (error) {
        console.error('Error processing raffles:', error);

        // Handle errors
        res.status(200).json({
            status: 'error',
            message: 'An error occurred while processing raffles.',
        });
    }
};
exports.requestRedeem = async (req, res) => {
    const { userid, amount, game } = req.body;

    const lockFilePath = path.join('/', `request_redeem_${userid}.lock`);
    let releaseLock;

    try {
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const sanitizedUserId = parseInt(userid);
        const sanitizedAmount = parseInt(amount);
        const sanitizedGame = game && game.trim();

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
        }

        const token = authHeader.split(' ')[1];
        let decoded;
        try {
            decoded = jwt.verify(token, process.env.JWT_SECRET);
        } catch (err) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
        }

        if (decoded.id != parseInt(userid)) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Unauthorized action' }), ENC_KEY));
        }


        if (!sanitizedUserId || !sanitizedAmount || !sanitizedGame) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: "Invalid request data" }), ENC_KEY));
        }

        const transactions = await Transactions.findAll({ where: { userid: sanitizedUserId } });
        const hasValidTransaction = transactions.some(
            (transaction) =>
                ["CreditCard", "CreditCard2", "Crypto", "GameTimeWallet", "Apple Pay", "Google Pay", 'ForumPay'].includes(transaction.paidmethod) &&
                transaction.status == 1
        );

        if (!hasValidTransaction) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: "You need at least one successful deposit to wallet to redeem." }), ENC_KEY));
        }

        const [gameName, gameUser] = sanitizedGame.split(":");
        const gameDetails = await Game.findOne({ where: { name: gameName }, attributes: ['id', 'name', 'status', 'enabled', 'isShow'] });

        // console.log(gameName, gameUser, sanitizedGame)
        if (!gameName || !gameUser) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: `Game name / Game user is missing` }), ENC_KEY));
        }

        if (!gameDetails || gameDetails.enabled == 0) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: `Deposits to the game ${gameName} are temporarily disabled.` }), ENC_KEY));
        }

        const linkedGame = await LinkedGames.findOne({
            where: { userid: sanitizedUserId, gameid: gameDetails.id },
            order: [["id", "DESC"]]
        });

        if (linkedGame && linkedGame.enabled == 0) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: `Deposits to the game ${gameName} are temporarily disabled.` }), ENC_KEY));
        }

        if (sanitizedAmount < 30 || sanitizedAmount > 500) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: "Invalid amount. Amount must be between $30 and $500." }), ENC_KEY));
        }

        const redeems = await Redeem.findAll({
            where: { userid: sanitizedUserId },
            order: [["id", "DESC"]]
        });

        const pendingRedeem = redeems.find((redeem) => redeem.status == 0);

        if (pendingRedeem) {
            return res.status(200).json(encrypt(JSON.stringify({
                status: "error",
                message: "You have a pending redeem request. Please wait until it's processed."
            }), ENC_KEY));
        }

        const now = new Date();
        const twentyFourHoursAgo = new Date(now.getTime() - 24 * 60 * 60 * 1000);

        const recentRedeems = await Redeem.findAll({
            where: {
                userid: sanitizedUserId,
                status: 1,
                date: {
                    [Op.between]: [twentyFourHoursAgo, now]
                }
            }
        });

        const totalAmountRedeemed = recentRedeems.reduce((sum, redeem) => parseFloat(sum) + parseFloat(redeem.amount), 0);

        if (totalAmountRedeemed >= 500 || parseFloat(sanitizedAmount) + parseFloat(totalAmountRedeemed) > 500) {
            const remainingAmount = 500 - parseFloat(totalAmountRedeemed);
            return res.status(200).json(encrypt(JSON.stringify({
                status: "error",
                message: `You can redeem up to $${remainingAmount} within the next 24 hours.`
            }), ENC_KEY));
        }

        const user = await User.findByPk(sanitizedUserId);

        if (!user) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: "User not found." }), ENC_KEY));
        }

        const newRedeem = await Redeem.create({
            userid: sanitizedUserId,
            email: user.email,
            amount: sanitizedAmount,
            game: gameName,
            gameuser: gameUser
        });

        if (newRedeem) {
            await sendRedeemNotification(user, sanitizedAmount, gameName);
            return res.status(200).json(encrypt(JSON.stringify({ status: "success", message: "Your redeem request has been successfully submitted." }), ENC_KEY));
        } else {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: "Failed to submit redeem request." }), ENC_KEY));
        }

    } catch (err) {
        console.error(err);
        return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: "An error occurred while processing the request." }), ENC_KEY));
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }
            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}
exports.redeemFromGame = async (req, res) => {
    const { userid, amount, gameid } = req.body;

    const lockFilePath = path.join('/', `request_redeem_${userid}.lock`);
    let releaseLock;

    try {
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const sanitizedUserId = parseInt(userid);
        const sanitizedAmount = parseInt(amount);
        const sanitizedGame = gameid && gameid.trim();

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
        }

        const token = authHeader.split(' ')[1];
        let decoded;
        try {
            decoded = jwt.verify(token, process.env.JWT_SECRET);
        } catch (err) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
        }

        if (decoded.id != parseInt(userid)) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Unauthorized action' }), ENC_KEY));
        }


        if (!sanitizedUserId || !sanitizedAmount || !sanitizedGame) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: "Invalid request data" }), ENC_KEY));
        }

        const transactions = await Transactions.findAll({ where: { userid: sanitizedUserId } });
        const hasValidTransaction = transactions.some(
            (transaction) =>
                ["CreditCard", "CreditCard2", "Crypto", "GameTimeWallet", "Apple Pay", "Google Pay", 'ForumPay'].includes(transaction.paidmethod) &&
                transaction.status == 1
        );

        if (!hasValidTransaction) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: "You need at least one successful deposit to wallet to redeem." }), ENC_KEY));
        }

        // const [gameName, gameUser] = sanitizedGame.split(":");
        const gameDetails = await Game.findOne({ where: { id: sanitizedGame }, attributes: ['id', 'name', 'status', 'enabled', 'isShow'] });
        const linkedGame = await LinkedGames.findOne({
            where: { userid: sanitizedUserId, gameid: sanitizedGame },
            order: [["id", "DESC"]]
        });
        // console.log(gameName, gameUser, sanitizedGame)
        if (!gameDetails.name || !linkedGame.gameuser) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: `Game name / Game user is missing` }), ENC_KEY));
        }

        if (!gameDetails || gameDetails.enabled == 0) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: `Deposits to the game ${gameDetails.name} are temporarily disabled.` }), ENC_KEY));
        }

        if (linkedGame && linkedGame.enabled == 0) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: `Deposits to the game ${gameDetails.name} are temporarily disabled.` }), ENC_KEY));
        }

        if (sanitizedAmount < 30 || sanitizedAmount > 500) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: "Invalid amount. Amount must be between $30 and $500." }), ENC_KEY));
        }

        const redeems = await Redeem.findAll({
            where: { userid: sanitizedUserId },
            order: [["id", "DESC"]]
        });

        const pendingRedeem = redeems.find((redeem) => redeem.status == 0);

        if (pendingRedeem) {
            return res.status(200).json(encrypt(JSON.stringify({
                status: "error",
                message: "You have a pending redeem request. Please wait until it's processed."
            }), ENC_KEY));
        }

        const now = moment(); // local current time
        const twentyFourHoursAgo = moment().subtract(24, 'hours');

        // console.log('Fetching redeems for user:', sanitizedUserId);
        // console.log('From:', twentyFourHoursAgo.format('YYYY-MM-DD HH:mm:ss'));
        // console.log('To:', now.format('YYYY-MM-DD HH:mm:ss'));

        const recentRedeems = await Redeem.findAll({
            where: {
                userid: sanitizedUserId,
                date: {
                    [Op.between]: [twentyFourHoursAgo.toDate(), now.toDate()]
                },
                status: '1'
            },
            order: [['date', 'DESC']]
        });

        // Log them
        // console.log(`Found ${recentRedeems.length} redeems for user ${sanitizedUserId} in the last 24 hours:\n`);
        // recentRedeems.forEach(txn => {
        //     console.log(`Amount: ${txn.amount} | Status: ${txn.status} | Date: ${moment(txn.date).format('YYYY-MM-DD HH:mm:ss')}`);
        // });
        const totalAmountRedeemed = recentRedeems.reduce((sum, redeem) => parseFloat(sum) + parseFloat(redeem.amount), 0);

        if (totalAmountRedeemed >= 500 || parseFloat(sanitizedAmount) + parseFloat(totalAmountRedeemed) > 500) {
            const remainingAmount = Math.max(0, 500 - parseFloat(totalAmountRedeemed));

            return res.status(200).json(encrypt(JSON.stringify({
                status: "error",
                // message: `You can redeem up to $${remainingAmount} within the next 24 hours.`
                message: `You can redeem only $500 in 24 hours.`

            }), ENC_KEY));
        }

        const user = await User.findByPk(sanitizedUserId);

        if (!user) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: "User not found." }), ENC_KEY));
        }

        const newRedeem = await Redeem.create({
            userid: sanitizedUserId,
            email: user.email,
            amount: sanitizedAmount,
            game: gameDetails.name,
            gameuser: linkedGame.gameuser
        });

        if (newRedeem) {
            await sendRedeemNotification(user, sanitizedAmount, gameDetails.name);
            return res.status(200).json(encrypt(JSON.stringify({ status: "success", message: "Your redeem request has been successfully submitted." }), ENC_KEY));
        } else {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: "Failed to submit redeem request." }), ENC_KEY));
        }

    } catch (err) {
        console.error(err);
        return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: "An error occurred while processing the request." }), ENC_KEY));
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }
            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}
async function sendRedeemNotification(user, amount, game) {
    const payload = {
        subject: "Redeem Request Placed!",
        email: user.email,
        name: `${user.first} ${user.last}`,
        mail: `<!DOCTYPE html>
                                                                      <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                                                      
                                                                      <head>
                                                                        <meta charset='utf-8'>
                                                                        <meta name='x-apple-disable-message-reformatting'>
                                                                        <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                                        <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                                        <title>Redeem Request Placed!</title>
                                                                        <style>
                                                                          .hover-bg-brand-600:hover {
                                                                            background-color: #0047C3 !important;
                                                                          }
                                                                      
                                                                          .hover-text-brand-700:hover {
                                                                            color: #003CA5 !important;
                                                                          }
                                                                      
                                                                          .hover-text-decoration-underline:hover {
                                                                            text-decoration: underline !important;
                                                                          }
                                                                      
                                                                          @media (max-width: 768px) {
                                                                            .sm-mt-4 {
                                                                              margin-top: 16px !important;
                                                                            }
                                                                      
                                                                            .sm-block {
                                                                              display: block !important;
                                                                            }
                                                                      
                                                                            .sm-w-full {
                                                                              width: 100% !important;
                                                                            }
                                                                      
                                                                            .sm-px-4 {
                                                                              padding-left: 16px !important;
                                                                              padding-right: 16px !important;
                                                                            }
                                                                      
                                                                            .sm-py-6 {
                                                                              padding-top: 24px !important;
                                                                              padding-bottom: 24px !important;
                                                                            }
                                                                          }
                                                                        </style>
                                                                      </head>
                                                                      
                                                                      <body
                                                                        style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                                        <div style='display: none'>
                                                                        Redeem Request Placed!
                                                                      
                                                                        </div>
                                                                        <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                                          <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                                            cellpadding='0' cellspacing='0' role='none'>
                                                                            <tr>
                                                                              <td align='center' style='background-color: #fff;'>
                                                                                <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                                                  <tr>
                                                                                    <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                                      <div style='margin-bottom: 24px'>
                                                                                        <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                                          <p>SweepStake Mobi</p>
                                                                                        </a>
                                                                                      </div>
                                                                                      <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                        Hi <b>${user.first}</b>,
                                                                                      </p>
                                                                                      <br>
                                                                                      <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                      Your Redeem request of <b>$${amount}</b> from the game <b>${game}</b> has been successfully received by us. 
                                                                                      Once processed you will receive a confirmation email!
                                                                                      </p>
                                                                                     <br>
                                                                                     <br>
                                                                                      <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                                      Thank you for choosing SweepStake Mobi!
                                                                                      </p>
                                                                                      <div role='separator' style='line-height: 16px'>&zwj;</div> 
                                                                                     
                                                                                      <div style='text-align: center;'>
                                                                                        <div role='separator'
                                                                                          style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                                        <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                                          This email was sent to you as a registered member of
                                                                                          <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                            style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                                            class='sm-block sm-mt-4'>
                                                                                            Use of the service and website is subject to our
                                                                                            <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                              style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                                            and
                                                                                            <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                              style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                                          </span>
                                                                                        </p>
                                                                                        <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                                          rights reserved.</p>
                                                                                      </div>
                                                                                    </td>
                                                                                  </tr>
                                                                                </table>
                                                                              </td>
                                                                            </tr>
                                                                          </table>
                                                                        </div>
                                                                      </body>
                                                                      
                                                                      </html>`
    };

    try {
        await axios.post("https://bend.logiclane.tech/api/email", payload, {
            headers: {
                "Content-Type": "application/json",
                Authorization: "Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61"
            }
        });
    } catch (error) {
        console.error("Failed to send email:", error);
    }
}

exports.depositGame = async (req, res) => {
    const { userid, amount, game, method, skip_bonus = '' } = req.body;
    const sanitizedUserId = parseInt(userid);
    const sanitizedAmount = parseInt(amount);
    const sanitizedGame = game.trim();
    const sanitizedMethod = method.trim();
    const sanitizedSkipBonus = skip_bonus;

    const lockFilePath = path.join('/', `deposit_game_${userid}.lock`);
    let releaseLock;

    try {
        // Lock file to prevent concurrent requests
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
        }

        const token = authHeader.split(' ')[1];
        let decoded;
        try {
            decoded = jwt.verify(token, process.env.JWT_SECRET);
        } catch (err) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
        }

        if (decoded.id != parseInt(userid)) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Unauthorized action' }), ENC_KEY));
        }


        if (!sanitizedUserId || !sanitizedAmount || !sanitizedGame || !sanitizedMethod) {
            return res.json(encrypt(JSON.stringify({ status: "error", message: "Invalid input!" }), process.env.ENC_KEY));
        }

        const [gameID, gameName, gameUser] = sanitizedGame.split(":");
        const gameRecord = await Game.findByPk(gameID, { attributes: ['id', 'name', 'status', 'enabled', 'isShow'] });
        const linkedGame = await LinkedGames.findOne({
            where: { userid: sanitizedUserId, gameid: gameID },
            order: [["id", "DESC"]]
        });
        const redeem = await Redeem.findOne({
            where: { userid: sanitizedUserId, status: 1 },
            order: [["id", "DESC"]]
        });

        if (!gameRecord || gameRecord.enabled == 0 || (linkedGame && linkedGame.enabled == 0)) {
            return res.json(encrypt(JSON.stringify({ status: "error", message: `Deposits to the game ${gameName} are temporarily disabled` }), process.env.ENC_KEY));
        }

        const user = await User.findByPk(sanitizedUserId);
        if (!user || user.avsstatus == "2") {
            return res.json(encrypt(JSON.stringify({ status: "error", message: "Game deposits are temporarily disabled. Please call support." }), process.env.ENC_KEY));
        }

        if (user.namev == 1 && user.pidv == 1) {

            if (gameID == "15" && sanitizedSkipBonus == "false") {

                const lastDeposit = await Transactions.findOne({
                    where: {
                        userid: sanitizedUserId,
                        gameid: "15",
                        status: "1",
                    },
                    order: [["id", "DESC"]]
                });

                if (lastDeposit) {
                    const currentTime = moment();
                    const acceptTime = moment(lastDeposit.accept_time);

                    if (acceptTime.isValid() && currentTime.diff(acceptTime, "minutes") <= 60) {
                        const encdata = JSON.stringify({
                            status: "info",
                            message: "You won't be eligible for the wager bonus since wager bonus has a cooldown of 60 minutes"
                        });
                        const enc = encrypt(encdata, process.env.ENC_KEY);
                        return res.json(enc);
                    }
                }
            }


            if (sanitizedMethod == "SweepCoins") {
                await handleSweepCoinsDeposit(user, sanitizedAmount, gameID, gameName, gameUser, res);
            } else if (sanitizedMethod == "Wallet Balance") {
                await handleWalletBalanceDeposit(user, sanitizedAmount, gameID, gameName, gameUser, redeem, res);
            } else {
                return res.json(encrypt(JSON.stringify({ status: "error", message: "Invalid payment method!" }), process.env.ENC_KEY));
            }
        } else {
            return res.json(encrypt(JSON.stringify({ status: "error", message: "Please contact live chat to verify your account to deposit." }), process.env.ENC_KEY));
        }
    } catch (error) {
        console.error("Error processing deposit:", error);
        return res.json(encrypt(JSON.stringify({ status: "error", message: "An error occurred while processing your request." }), process.env.ENC_KEY));
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }
            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.depositToGame = async (req, res) => {
    const { userid, amount, gameid, method, skip_bonus = '' } = req.body;
    const sanitizedUserId = parseInt(userid);
    const sanitizedAmount = parseInt(amount);
    const sanitizedGame = gameid.trim();
    const sanitizedMethod = method.trim();
    const sanitizedSkipBonus = skip_bonus;

    const lockFilePath = path.join('/', `deposit_game_${userid}.lock`);
    let releaseLock;

    try {
        // Lock file to prevent concurrent requests
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
        }

        const token = authHeader.split(' ')[1];
        let decoded;
        try {
            decoded = jwt.verify(token, process.env.JWT_SECRET);
        } catch (err) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
        }

        if (decoded.id != parseInt(userid)) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Unauthorized action' }), ENC_KEY));
        }


        if (!sanitizedUserId || !sanitizedAmount || !sanitizedGame || !sanitizedMethod) {
            return res.json(encrypt(JSON.stringify({ status: "error", message: "Invalid input!" }), process.env.ENC_KEY));
        }

        const gameID = sanitizedGame;
        // const [gameID, gameName, gameUser] = sanitizedGame.split(":");
        const gameRecord = await Game.findByPk(gameID, { attributes: ['id', 'name', 'status', 'enabled', 'isShow'] });
        const linkedGame = await LinkedGames.findOne({
            where: { userid: sanitizedUserId, gameid: gameID },
            order: [["id", "DESC"]]
        });
        const redeem = await Redeem.findOne({
            where: { userid: sanitizedUserId, status: 1 },
            order: [["id", "DESC"]]
        });

        if (!gameRecord || gameRecord.enabled == 0 || (linkedGame && linkedGame.enabled == 0)) {
            return res.json(encrypt(JSON.stringify({ status: "error", message: `Deposits to the game ${gameRecord.name} are temporarily disabled` }), process.env.ENC_KEY));
        }

        const user = await User.findByPk(sanitizedUserId);
        if (!user || user.avsstatus == "2") {
            return res.json(encrypt(JSON.stringify({ status: "error", message: "Game deposits are temporarily disabled. Please call support." }), process.env.ENC_KEY));
        }

        if (user.namev == 1 && user.pidv == 1) {

            if (gameID == "15" && sanitizedSkipBonus == "false") {

                const lastDeposit = await Transactions.findOne({
                    where: {
                        userid: sanitizedUserId,
                        gameid: "15",
                        status: "1",
                    },
                    order: [["id", "DESC"]]
                });

                if (lastDeposit) {
                    const currentTime = moment();
                    const acceptTime = moment(lastDeposit.accept_time);

                    if (acceptTime.isValid() && currentTime.diff(acceptTime, "minutes") <= 60) {
                        const encdata = JSON.stringify({
                            status: "info",
                            message: "You won't be eligible for the wager bonus since wager bonus has a cooldown of 60 minutes"
                        });
                        const enc = encrypt(encdata, process.env.ENC_KEY);
                        return res.json(enc);
                    }
                }
            }
            if (sanitizedMethod == "1") {
                await handleSweepCoinsDeposit(user, sanitizedAmount, gameID, gameRecord.name, linkedGame.gameuser, res);
            } else if (sanitizedMethod == "2") {
                await handleWalletBalanceDeposit(user, sanitizedAmount, gameID, gameRecord.name, linkedGame.gameuser, redeem, res);
            } else {
                return res.json(encrypt(JSON.stringify({ status: "error", message: "Invalid payment method!" }), process.env.ENC_KEY));
            }
        } else {
            return res.json(encrypt(JSON.stringify({ status: "error", message: "Please contact live chat to verify your account to deposit." }), process.env.ENC_KEY));
        }
    } catch (error) {
        console.error("Error processing deposit:", error);
        return res.json(encrypt(JSON.stringify({ status: "error", message: "An error occurred while processing your request." }), process.env.ENC_KEY));
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }
            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
const handleSweepCoinsDeposit = async (user, amount, gameID, gameName, gameUser, res) => {
    const userBalance = parseFloat(user.balance) + parseFloat(user.bonusbal);

    if (amount < 5 || amount > 100) {
        return res.json(encrypt(JSON.stringify({ status: "error", message: "Minimum deposit amount for SweepCoins is $5" }), process.env.ENC_KEY));
    }

    if (amount > userBalance) {
        return res.json(encrypt(JSON.stringify({ status: "error", message: "Insufficient balance." }), process.env.ENC_KEY));
    }

    const remainingBonus = amount > user.balance ? parseFloat(amount) - parseFloat(user.balance) : 0;
    const newBalance = Math.max(0, parseFloat(user.balance) - parseFloat(amount));
    const newBonusBalance = parseFloat(user.bonusbal) - parseFloat(remainingBonus);

    await Transactions.create({
        userid: user.id,
        txnby: "SELF",
        type: 1,
        amount,
        gameid: gameID,
        gameuser: gameUser,
        paidmethod: "SweepCoins",
        paidto: gameName,
        status: 0,
        cbalance: user.balance,
        ubalance: newBalance,
        cbonusbal: user.bonusbal,
        ubonusbal: newBonusBalance,
    });

    await user.update({ balance: newBalance, bonusbal: newBonusBalance });

    // sendDepositGameEmail(user, gameName, "Game Recharge request submitted!");
    sendDepositGameEmail(user, gameName, amount, "Game Recharge request submitted!");

    return res.json(encrypt(JSON.stringify({ status: "success", message: "Deposit Request Submitted" }), process.env.ENC_KEY));
};

const handleWalletBalanceDeposit = async (user, amount, gameID, gameName, gameUser, redeem, res) => {
    if (redeem && redeem.game == gameName) {
        return res.json(encrypt(JSON.stringify({ status: "error", message: "Redeems from the same game cannot be deposited to the same game. Try using GoldCoins." }), process.env.ENC_KEY));
    }

    if (amount < 5 || amount > 100 || amount > user.rebalance) {
        return res.json(encrypt(JSON.stringify({ status: "error", message: "Insufficient or invalid Wallet Balance amount." }), process.env.ENC_KEY));
    }

    const newRebalance = parseFloat(user.rebalance) - parseFloat(amount);

    await Transactions.create({
        userid: user.id,
        txnby: "SELF",
        type: 1,
        amount,
        gameid: gameID,
        gameuser: gameUser,
        paidmethod: "Wallet Balance",
        paidto: gameName,
        status: 0,
        cbalance: user.balance,
        ubalance: user.balance,
        crebalance: user.rebalance,
        urebalance: newRebalance
    });

    await user.update({ rebalance: newRebalance });

    sendDepositGameEmail(user, gameName, amount, "Game Recharge request submitted!");
    return res.json(encrypt(JSON.stringify({ status: "success", message: "Deposit Request Submitted" }), process.env.ENC_KEY));
};

const sendDepositGameEmail = async (user, gameName, amount, subject) => {
    try {
        await axios.post("https://bend.logiclane.tech/api/email", {
            subject,
            email: user.email,
            name: `${user.first} ${user.last}`,
            mail: `
            <!DOCTYPE html>
                                                                                  <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                                                                  
                                                                                  <head>
                                                                                    <meta charset='utf-8'>
                                                                                    <meta name='x-apple-disable-message-reformatting'>
                                                                                    <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                                                    <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                                                    <title>Game Recharge request submitted!</title>
                                                                                    <style>
                                                                                    .hover-text-brand-200:hover {
                                                                                        color: #0052E2 !important;
                                                                                      }
                                                                                  
                                                                                      .hover-text-brand-700:hover {
                                                                                        color: #003CA5 !important;
                                                                                      }
                                                                                  
                                                                                      .hover-text-decoration-underline:hover {
                                                                                        text-decoration: underline !important;
                                                                                      }
                                                                                  
                                                                                      @media (max-width: 768px) {
                                                                                        .sm-mt-4 {
                                                                                          margin-top: 16px !important;
                                                                                        }
                                                                                  
                                                                                        .sm-block {
                                                                                          display: block !important;
                                                                                        }
                                                                                  
                                                                                        .sm-inline-block {
                                                                                          display: inline-block !important;
                                                                                        }
                                                                                  
                                                                                        .sm-w-auto {
                                                                                          width: auto !important;
                                                                                        }
                                                                                  
                                                                                        .sm-w-full {
                                                                                          width: 100% !important;
                                                                                        }
                                                                                  
                                                                                        .sm-px-0 {
                                                                                          padding-left: 0 !important;
                                                                                          padding-right: 0 !important;
                                                                                        }
                                                                                  
                                                                                        .sm-px-4 {
                                                                                          padding-left: 16px !important;
                                                                                          padding-right: 16px !important;
                                                                                        }
                                                                                  
                                                                                        .sm-py-6 {
                                                                                          padding-top: 24px !important;
                                                                                          padding-bottom: 24px !important;
                                                                                        }
                                                                                  
                                                                                        .sm-pb-8 {
                                                                                          padding-bottom: 32px !important;
                                                                                        }
                                                                                  
                                                                                        .sm-align-top {
                                                                                          vertical-align: top !important;
                                                                                        }
                                                                                      }
                                                                                    </style>
                                                                                  </head>
                                                                                  
                                                                                  <body
                                                                                    style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                                                    <div style='display: none'>
                                                                                    Game Recharge request submitted!
                                                                                  
                                                                                    </div>
                                                                                    <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                                                      <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                                                        cellpadding='0' cellspacing='0' role='none'>
                                                                                        <tr>
                                                                                          <td align='center' style='background-color: #fff;'>
                                                                                            <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                                                              <tr>
                                                                                                <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                                                  <div style='margin-bottom: 24px'>
                                                                                                    <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                                                      <p>SweepStake Mobi</p>
                                                                                                    </a>
                                                                                                  </div>
                                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                                    Hi <b>${user.first}</b>,
                                                                                                  </p>
                                                                                                  <br>
                                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                                  Your Game Recharge request to <b>${gameName}</b> with <b>$${amount}</b> been submitted successfully
                                                                                                  </p>
                                                                                                 <br>
                                                                                                 <br>
                                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                                                  Thank you for choosing SweepStake Mobi!
                                                                                                  </p>
                                                                                                  <div role='separator' style='line-height: 16px'>&zwj;</div> 
                                                                                                 
                                                                                                  <div style='text-align: center;'>
                                                                                                    <div role='separator'
                                                                                                      style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                                                    <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                                                      This email was sent to you as a registered member of
                                                                                                      <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                        style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                                                        class='sm-block sm-mt-4'>
                                                                                                        Use of the service and website is subject to our
                                                                                                        <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                          style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                                                        and
                                                                                                        <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                          style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                                                      </span>
                                                                                                    </p>
                                                                                                    <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                                                      rights reserved.</p>
                                                                                                  </div>
                                                                                                </td>
                                                                                              </tr>
                                                                                            </table>
                                                                                          </td>
                                                                                        </tr>
                                                                                      </table>
                                                                                    </div>
                                                                                  </body>
                                                                                  
                                                                                  </html>
            `
        }, {
            headers: {
                "Content-Type": "application/json",
                Authorization: `Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61`
            }
        });
    } catch (error) {
        console.error("Error sending email:", error);
    }
};
exports.depositWallet = async (req, res) => {
    const { userid, amount, method, crypto: cryptoCurrency, gtw, currency, site, user_ip } = req.body;

    // Sanitize inputs
    const sanitizedUserid = parseInt(userid, 10) || null;
    const sanitizedAmount = parseInt(amount, 10) || null;

    if (!sanitizedUserid || !sanitizedAmount || !method || !site) {
        return res.json({ status: 'error', message: 'Invalid request data.' });
    }

    const lockFilePath = path.join('/', `deposit_game_${userid}.lock`);
    let releaseLock;

    try {
        // Lock file to prevent concurrent requests
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
        }

        const token = authHeader.split(' ')[1];
        let decoded;
        try {
            decoded = jwt.verify(token, process.env.JWT_SECRET);
        } catch (err) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
        }

        if (decoded.id != parseInt(userid)) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Unauthorized action' }), ENC_KEY));
        }
        const user = await User.findByPk(sanitizedUserid);
        if (!user) {
            return res.json({ status: 'error', message: 'User not found.' });
        }

        const settings = await PaymentMethods.findOne();
        const generateCode = () => `SW-${crypto.randomBytes(8).toString('hex')}`;

        if (method == 'CreditCard2') {
            if (user.namev != 1 || user.pidv != 1) {
                return res.json({ status: 'error', message: 'Please contact live chat to verify your account to deposit.' });
            }

            const isAllowedMethod = method == 'CreditCard2' ? user.card2allowed : user.card2allowed;
            const isAllowedCredit = method == 'CreditCard2' ? settings.credit2 : settings.credit2;

            if (!isAllowedMethod || !isAllowedCredit) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'This payment method is not allowed.' }), ENC_KEY));
            }

            if (sanitizedAmount < 5) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Amount cannot be less than $5.' }), ENC_KEY));
            }

            if (sanitizedAmount > 100) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Amount cannot be greater than $100.' }), ENC_KEY));
            }

            const recentTransactions = await Transactions.findAll({
                where: { userid: user.id, paidmethod: 'CreditCard2' },
                order: [['id', 'DESC']],
                limit: 5,
            });

            const pendingTransactions = recentTransactions.filter(txn => txn.status == '0');
            if (pendingTransactions.length >= 5) {
                return res.json(encrypt(JSON.stringify({
                    status: 'error',
                    message: 'You have 5 pending credit card deposit requests. Complete previous requests before submitting a new one.',
                }), ENC_KEY));
            }

            const deposit = await Transactions.create({
                userid: user.id,
                txnby: 'SELF',
                type: 1,
                amount: sanitizedAmount,
                paidmethod: method,
                paidto: 'Credit Card',
                status: 0,
            });

            const pCode = `SW-${deposit.id}`;
            deposit.p_codecc = pCode;
            await deposit.save();

            const ref = await Refs.findOne({ where: { userid: user.id } });
            if (ref && !ref.first_txn) {
                ref.txn_amount = sanitizedAmount;
                ref.txn_id = deposit.id;
                await ref.save();
            }

            return res.json(encrypt(JSON.stringify({
                status: 'success',
                amount: sanitizedAmount,
                p_code: pCode,
            }), ENC_KEY));
        } else if (method == 'GameTimeWallet') {
            if (user.namev != 1 || user.pidv != 1) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Please contact live chat to verify your account to deposit.' }), ENC_KEY));
            }
            if (!gtw) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'GameTime Wallet Phone No. is missing' }), ENC_KEY));

            }
            const isAllowedMethod = method == 'GameTimeWallet' ? user.gtallowed : user.gtallowed;
            const isAllowedGameTime = method == 'GameTimeWallet' ? settings.gtw : settings.gtw;

            if (!isAllowedMethod || !isAllowedGameTime) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'This payment method is not allowed.' }), ENC_KEY));
            }

            if (sanitizedAmount < 5) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Amount cannot be less than $5.' }), ENC_KEY));
            }

            if (sanitizedAmount > 100) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Amount cannot be greater than $100.' }), ENC_KEY));
            }
            const recentTransactions = await Transactions.findAll({
                where: { userid: user.id, paidmethod: 'GameTimeWallet' },
                order: [['id', 'DESC']],
                limit: 5,
            });

            const pendingTransactions = recentTransactions.filter(txn => txn.status == '0');
            if (pendingTransactions.length >= 2) {
                return res.json(encrypt(JSON.stringify({
                    status: 'error',
                    message: 'You have 2 pending GameTime Wallet deposit requests. Complete previous requests before submitting a new one.',
                }), ENC_KEY));
            }

            const np_code = Math.floor(Math.random() * (99999 - 11111 + 1)) + 11111;

            const postData = {
                amount,
                gtwid: gtw,
                p_code: np_code,
                gtoid: process.env.GTOID,
                gtdid: process.env.GTDID,
            };

            try {
                const response = await axios.post(
                    'https://bend.logiclane.tech/api/gametime',
                    postData,
                    {
                        headers: {
                            'Content-Type': 'application/json',
                            Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
                        },
                    }
                );

                const { data: decTxn } = response;
                const txnRes = decTxn?.txn_data;

                if (decTxn?.status == 'success') {
                    let transactionCreated = false;
                    const retryAttempts = 3;

                    for (let i = 0; i < retryAttempts; i++) {
                        try {
                            const deposit = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount,
                                paidmethod: method,
                                paidto: 'GameTimeWallet',
                                status: 0,
                                p_code: decTxn.txn_id,
                                gtxid: gtw,
                            });

                            if (deposit) {
                                const txnidnew = deposit.id;
                                transactionCreated = true;

                                const ref = await Refs.findOne({ where: { userid: user.id } });
                                if (ref && !ref.first_txn) {
                                    ref.txn_amount = amount;
                                    ref.txn_id = txnidnew;
                                    await ref.save();
                                }
                                break;
                            }
                        } catch (error) {
                            console.error('Transaction creation failed, retrying...', error);
                        }
                    }

                    if (transactionCreated) {
                        const encdata = JSON.stringify({
                            status: 'success',
                            amount,
                            p_code: decTxn.txn_id,
                        });
                        const enc = encrypt(encdata, ENC_KEY);
                        return res.json(enc);
                    } else {
                        const encdata = JSON.stringify({
                            status: 'error',
                            message: 'Unable to create transaction log after multiple attempts. Please try again later.',
                        });
                        const enc = encrypt(encdata, ENC_KEY);
                        return res.json(enc);
                    }
                } else {
                    const encdata = JSON.stringify({
                        status: 'error',
                        message: 'You do not have a GameTime Wallet account. Please download the app and sign up or check the number you have entered.',
                        res: txnRes,
                    });
                    const enc = encrypt(encdata, ENC_KEY);
                    return res.json(enc);
                }
            } catch (error) {
                console.error('Error processing request:', error);
                const encdata = JSON.stringify({
                    status: 'error',
                    message: 'An unexpected error occurred. Please try again later.',
                });
                const enc = encrypt(encdata, ENC_KEY);
                return res.json(enc);
            }
        } else if (method == 'Crypto') {
            if (user.namev != 1 || user.pidv != 1) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Please contact live chat to verify your account to deposit.' }), ENC_KEY));
            }

            const isAllowedMethod = method == 'Crypto' ? settings.crypto : settings.crypto;
            // const isAllowedGameTime = method == 'Crypto' ? settings.gtw : settings.gtw;

            if (!isAllowedMethod) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'This payment method is not allowed.' }), ENC_KEY));
            }

            if (sanitizedAmount < 5) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Amount cannot be less than $5.' }), ENC_KEY));
            }

            if (sanitizedAmount > 100) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Amount cannot be greater than $100.' }), ENC_KEY));
            }
            const recentTransactions = await Transactions.findAll({
                where: { userid: user.id, paidmethod: 'Crypto' },
                order: [['id', 'DESC']],
                limit: 3,
            });

            const pendingTransactions = recentTransactions.filter(txn => txn.status == '0');
            if (pendingTransactions.length == 1) {
                return res.json(encrypt(JSON.stringify({
                    status: 'error',
                    message: 'You have a pending Crypto deposit requests. Complete previous requests before submitting a new one.',
                }), ENC_KEY));
            }
            const postData = {
                data: {
                    name: "Deposit Request",
                    description: "Deposit To Wallet",
                    pricing_type: "fixed_price",
                    local_price: {
                        amount,
                        currency: "usd",
                    },
                    redirect_url: `${site}/dashboard`,
                    cancel_url: `${site}/dashboard`,
                },
            };

            try {
                const response = await axios.post('https://bend.logiclane.tech/api/crypto', postData, {
                    headers: {
                        'Content-Type': 'application/json',
                        Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
                    },
                });

                const adata = response.data;

                if (adata.hosted_url) {
                    const hurl = adata.hosted_url;
                    const px_code = adata.code;

                    const deposit = await Transactions.create({
                        userid: user.id,
                        txnby: 'SELF',
                        type: 1,
                        amount,
                        paidmethod: method,
                        paidto: 'Crypto',
                        status: 0,
                        p_code: px_code,
                    });

                    if (deposit) {
                        const txnidnew = deposit.id;
                        const ref = await Refs.findOne({ where: { userid: user.id } });

                        if (ref && !ref.first_txn) {
                            ref.txn_amount = amount;
                            ref.txn_id = txnidnew;
                            await ref.save();
                        }

                        const encdata = JSON.stringify({
                            status: 'success',
                            amount,
                            p_code: px_code,
                            h_url: hurl,
                        });
                        const enc = encrypt(encdata, ENC_KEY);
                        return res.json(enc);
                    }
                } else {
                    const encdata = JSON.stringify({
                        status: 'error',
                        message: 'Unable to generate transaction.',
                        res: adata,
                    });
                    const enc = encrypt(encdata, ENC_KEY);
                    return res.json(enc);
                }
            } catch (error) {
                console.error('Error processing crypto request:', error);
                const encdata = JSON.stringify({
                    status: 'error',
                    message: 'An unexpected error occurred. Please try again later.',
                });
                const enc = encrypt(encdata, ENC_KEY);
                return res.json(enc);
            }
        } else if (method == 'ForumPay') {
            const px_code = 'FPay' + crypto.randomBytes(8).toString('hex');
            if (user.namev != 1 || user.pidv != 1) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Please contact live chat to verify your account to deposit.' }), ENC_KEY));
            }

            const isAllowedMethod = method == 'ForumPay' ? user.fpallowed : user.fpallowed;
            const isAllowedForumPay = method == 'ForumPay' ? settings.forumpay : settings.forumpay;

            if (!isAllowedMethod || !isAllowedForumPay) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'This payment method is not allowed.' }), ENC_KEY));
            }

            if (sanitizedAmount < 5) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Amount cannot be less than $5.' }), ENC_KEY));
            }

            if (sanitizedAmount > 100) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Amount cannot be greater than $100.' }), ENC_KEY));
            }
            const recentTransactions = await Transactions.findAll({
                where: { userid: user.id, paidmethod: 'ForumPay' },
                order: [['id', 'DESC']],
                limit: 3,
            });

            const pendingTransactions = recentTransactions.filter(txn => txn.status == '0');
            if (pendingTransactions.length == 1) {
                return res.json(encrypt(JSON.stringify({
                    status: 'error',
                    message: 'You have a pending Crypto deposit requests. Complete previous requests before submitting a new one.',
                }), ENC_KEY));
            }
            const postData = {
                amount: amount,
                crypto: cryptoCurrency,
                user_id: userid,
                user_ip,
                px_code,
            };

            try {
                // First Request: Get Rate
                const response = await axios.post('https://fp.logiclane.tech/fpay/requestPayment.php', postData, {
                    headers: {
                        'Content-Type': 'application/json',
                        Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
                    },
                });

                const adata = response.data;
                console.log('adata', adata)
                if (adata?.data?.access_url) {
                    const hurl = adata.data.access_url;

                    const deposit = await Transactions.create({
                        userid: user.id,
                        txnby: 'SELF',
                        type: 1,
                        amount,
                        paidmethod: method,
                        paidto: 'GoldCoins',
                        status: 0,
                        p_code: px_code,
                    });

                    if (deposit) {
                        const txnidnew = deposit.id;
                        const ref = await Refs.findOne({ where: { userid: user.id } });

                        if (ref && !ref.first_txn) {
                            ref.txn_amount = amount;
                            ref.txn_id = txnidnew;
                            await ref.save();
                        }

                        const encdata = JSON.stringify({
                            status: 'success',
                            amount,
                            p_code: px_code,
                            h_url: hurl,
                            f_data: adata?.data
                        });
                        const enc = encrypt(encdata, ENC_KEY);
                        return res.json(enc);
                    }
                } else {
                    const encdata = JSON.stringify({
                        status: 'error',
                        message: 'Unable to generate transaction',
                    });
                    const enc = encrypt(encdata, ENC_KEY);
                    return res.json(enc);
                }
            } catch (error) {
                console.error('Error processing GoldCoins request:', error);
                const encdata = JSON.stringify({
                    status: 'error',
                    message: 'An unexpected error occurred. Please try again later.',
                });
                const enc = encrypt(encdata, ENC_KEY);
                return res.json(enc);
            }
        }

        return res.json({ status: 'error', message: 'Unsupported payment method.' });

    } catch (error) {
        console.error('Error in depositWallet:', error);
        return res.json({ status: 'error', message: 'An error occurred. Please try again later.' });
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }
            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.forumPayCheck = async (req, res) => {
    const { payment_id, address, currency, pending } = req.body;

    if (!payment_id || !address || !currency) {
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Payment ID / Address / Currency is required' }), ENC_KEY));
    }

    try {
        const postData = {
            currency,
            payment_id,
            address,
        };

        const response = await axios.post('https://fp.logiclane.tech/fpay/checkPayment.php', postData, {
            headers: {
                'Content-Type': 'application/json',
                Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
            },
        });
        const adata = response.data;
        console.log('adata', adata)
        res.json(encrypt(JSON.stringify(adata), ENC_KEY))
    } catch (error) {
        console.error(error);
        return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Internal Server Error' }), ENC_KEY));
    }
}
function pnm_signature(secretKey, params) {
    const requiredParams = ["version", "site_identifier", "timestamp"];
    const exemptParams = ["format", "signature", "call", "secret_key"];

    const missingParams = requiredParams.filter(p => !(p in params));
    if (missingParams.length > 0) {
        throw new Error(`Missing required parameter(s): ${missingParams.join(', ')}`);
    }

    // Sort params by key
    const sortedKeys = Object.keys(params).sort();

    // Build string to sign, excluding exempted params
    let stringToSign = '';
    for (const key of sortedKeys) {
        if (exemptParams.includes(key)) continue;
        stringToSign += key + params[key];
    }

    // Generate HMAC SHA-256 signature
    return crypto.createHmac('sha256', secretKey).update(stringToSign).digest('hex');
}
async function createPnmPaymentMethod(data) {
    console.log(data)
    const siteIdentifier = 'S1305824156';
    const version = '3.0';
    const secretKey = '4ebaffb3f0a3481d4616fa9f5';
    const url = 'https://api.paynearme-sandbox.com/json-api/create_payment_method';
    const timestamp = Math.floor(Date.now() / 1000).toString();
    const user = await User.findByPk(data.userid)
    const datax = data.datax;
    if (datax.type === 'ach') {
        const {
            accountHolder,
            accountNumber,
            routingNumber,
            pnm_order_identifier,
            zipcode,
            addr1
        } = datax;

        const params = {
            pnm_order_identifier,
            payment_method_type: 'ach',
            payment_method_billing_name: accountHolder,
            payment_method_billing_zipcode: zipcode,
            payment_method_ach_account_pii: accountNumber,
            payment_method_ach_aba_pii: routingNumber,
            site_identifier: siteIdentifier,
            version,
            timestamp
        };

        const signature = pnm_signature(secretKey, params);
        const requestData = { ...params, signature };

        const response = await axios.post(url, requestData);
        const resx = response.data;
        console.log(resx);
        if (resx.status === 'ok') {
            const paymentMethods = resx.order?.electronic_payments?.payment_methods || [];
            for (const method of paymentMethods) {
                if (method.type === 'ach_push') {
                    const paymentMethodId = method.accounts?.[0]?.payment_method_identifier;
                    if (paymentMethodId) {
                        user.pnm_ach_id = paymentMethodId;
                        await user.save(); // assuming `user` is a Sequelize or Mongoose model
                    }
                }
            }
        }

        return resx;

    } else if (datax.type === 'savecard') {
        const {
            card,
            cardholderName,
            cvv,
            expiry,
            pnm_order_identifier,
            zipcode,
            addr1,
            card_id
        } = datax;

        const cardRecord = await SavedCards.findOne({ where: { id: card_id } });

        let hdata = {};
        let paymentMethodId = cardRecord?.pnm_method_id;

        if (!paymentMethodId) {
            const params = {
                pnm_order_identifier,
                payment_method_type: 'card',
                payment_method_billing_name: cardholderName,
                payment_method_billing_zipcode: zipcode,
                payment_method_card_number_pii: card,
                payment_method_card_expiry_pii: expiry,
                payment_method_cvv_pii: cvv,
                payment_method_billing_address: addr1,
                payment_method_billing_phone: '7135555555',
                site_identifier: siteIdentifier,
                version,
                timestamp
            };

            const signature = pnm_signature(secretKey, params);
            const requestData = { ...params, signature };

            const response = await axios.post(url, requestData);
            hdata = response.data;
            console.log(hdata);

            if (hdata.status === 'ok') {
                const paymentMethods = hdata.order?.electronic_payments?.payment_methods || [];
                for (const method of paymentMethods) {
                    if (method.type === 'debit') {
                        paymentMethodId = method.accounts?.[0]?.payment_method_identifier;
                        if (paymentMethodId) {
                            cardRecord.pnm_method_id = paymentMethodId
                            await cardRecord.save()
                            // await capsule('saved_cards').where({ id: card_id }).update({ pnm_method_id: paymentMethodId });
                        }
                    }
                }
            }
        }

        return {
            status: 'success',
            pnm_method_id: paymentMethodId || cardRecord?.pnm_method_id || null
        };
    }

    // throw new Error('Unsupported type');
}
exports.cashout = async (req, res) => {
    const {
        userid,
        amount,
        ctip = 0,
        method,
        gtw,
        cvv = '',
        card_id = '',
        yob = '',
        street = '',
        city = '',
        state = '',
        zip = '',
        country = ''
    } = req.body;

    const sanitizedUserid = parseInt(userid, 10);
    const sanitizedAmount = parseInt(amount, 10);
    const sanitizedCtip = parseInt(ctip, 10);

    if (!sanitizedUserid || !sanitizedAmount || !method) {
        return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid input' }), ENC_KEY));
    }

    const lockFilePath = path.join('/', `cashout_${userid}.lock`);
    let releaseLock;
    try {
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
        }

        const token = authHeader.split(' ')[1];
        let decoded;
        try {
            decoded = jwt.verify(token, process.env.JWT_SECRET);
        } catch (err) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
        }

        if (decoded.id != parseInt(userid)) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Unauthorized action' }), ENC_KEY));
        }

        const user = await User.findByPk(sanitizedUserid);
        if (!user || user.pidv != '1' || user.namev != '1') {
            return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' }), ENC_KEY));
        }

        const lastCashout = await Withdraw.findOne({
            where: { userid: sanitizedUserid },
            order: [['id', 'DESC']],
        });

        if (lastCashout && lastCashout.status == 0) {
            return res.json(encrypt(JSON.stringify({
                status: 'error',
                message: 'You have a pending cashout. Please wait for it to be processed or rejected.',
            }), ENC_KEY));
        }

        if (method == 'ACH' && !user.account_number) {
            return res.json(encrypt(JSON.stringify({
                status: 'info',
                message: 'We noticed that your bank details are not linked. Please fill in the information.',
            }), ENC_KEY));
        }
        let gtwCard = gtw;
        if (method === 'PNMCARD') {
            const card = await SavedCards.findOne({ where: { id: card_id } });

            if (card) {
                let timestamp = Math.floor(Date.now() / 1000);

                // Step 1: Create Order if not exists
                if (!user.pnm_order_id) {
                    const orderPayload = {
                        order_currency: 'USD',
                        order_type: 'any',
                        order_is_standing: 'true',
                        site_customer_identifier: user.id,
                        site_identifier: 'S1305824156',
                        version: '3.0',
                        site_customer_first_name: user.first,
                        site_customer_last_name: user.last,
                        site_customer_year_of_birth: yob,
                        site_customer_email: user.email,
                        site_customer_phone: user.phone,
                        site_customer_street: street,
                        site_customer_city: city,
                        site_customer_state: state,
                        site_customer_postal_code: zip,
                        timestamp
                    };

                    const orderSignature = pnm_signature('4ebaffb3f0a3481d4616fa9f5', orderPayload);

                    const createOrder = await axios.post(
                        'https://api.paynearme-sandbox.com/json-api/create_order',
                        { ...orderPayload, signature: orderSignature }
                    );

                    user.pnm_order_id = createOrder.data?.order?.pnm_order_identifier;
                    await user.save();
                }

                // Step 2: Create Push Order if not exists
                if (!user.pnm_push_order_id && user.pnm_order_id) {
                    const pushPayload = {
                        order_currency: 'USD',
                        order_type: 'any',
                        order_is_standing: 'true',
                        site_identifier: 'S1305824156',
                        version: '3.0',
                        push_user_identifier: user.id,
                        site_customer_identifier: user.id,
                        push_city: city,
                        push_country: country,
                        push_first_name: user.first,
                        push_last_name: user.last,
                        push_postal_code: zip,
                        push_street: street,
                        push_year_of_birth: yob,
                        site_customer_email: user.email,
                        site_customer_phone: user.phone,
                        timestamp
                    };

                    const pushSignature = pnm_signature('4ebaffb3f0a3481d4616fa9f5', pushPayload);

                    const createPushOrder = await axios.post(
                        'https://api.paynearme-sandbox.com/json-api/create_push_order',
                        { ...pushPayload, signature: pushSignature }
                    );

                    const pushOrderId = createPushOrder.data?.order?.pnm_order_identifier;
                    user.pnm_push_order_id = pushOrderId;
                    await user.save();
                }

                // Set gtwCard for final submission
                gtwCard = card_id;

                // Decrypt card data
                const cardData = {
                    id: card.id,
                    bin: decrypt(card.bin, CARD_ENC_KEY),
                    last4: decrypt(card.last4, CARD_ENC_KEY),
                    expiry: decrypt(card.expiry, CARD_ENC_KEY),
                    card_number: decrypt(card.card_number, CARD_ENC_KEY),
                    pnm_method_id: card.pnm_method_id
                };

                let pnm_method_id = card.pnm_method_id;

                // Step 3: Create payment method if not already saved
                if (!pnm_method_id) {
                    const pnmMethod = {
                        userid: user.id,
                        datax: {
                            type: 'savecard',
                            accountHolder: `${user.first} ${user.last}`,
                            card: cardData.card_number,
                            cardholderName: `${user.first} ${user.last}`,
                            cvv: cvv, // make sure this is defined earlier
                            expiry: cardData.expiry,
                            pnm_order_identifier: user.pnm_order_id,
                            card_id: card_id,
                            site_identifier: 'S1305824156',
                            zipcode: zip,
                            addr1: street
                        }
                    };

                    const created = await createPnmPaymentMethod(pnmMethod);
                    if (created && created.pnm_method_id) {
                        pnm_method_id = created.pnm_method_id;

                        // Optionally update card in DB with new method ID
                        await card.update({ pnm_method_id });
                    }
                }

                // pnm_method_id is now available for use in the payment request if needed later
            }
        }
        if (method === 'CoinFlow') {
            if (!user.cfAccountToken) {
                return res.status(400).json({ error: "User does not have a CoinFlow account token (cfAccountToken)" });
            }

            const cents = Math.round(parseFloat(amount) * 100);

            const url = "https://api-sandbox.coinflow.cash/api/merchant/withdraws/payout/delegated";

            const data = {
                speed: "asap",
                amount: {
                    cents,
                },
                idempotencyKey: "",
                userId: sanitizedUserid.toString(),
                merchantId: "rc-amusement",
                account: user?.cfAccountToken,
            };

            const headers = {
                accept: "application/json",
                "content-type": "application/json",
                Authorization:
                    "coinflow_sandbox_ae009956adfa4fa18c3adb36edbdf470_e1199272cb694bd69399bd57816f32f5",
            };


            const totalAmount = parseFloat(sanitizedAmount) + parseFloat(sanitizedCtip);
            if (totalAmount > parseFloat(user.rebalance)) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Insufficient balance' }), ENC_KEY));
            }


            const now = moment(); // local current time
            const twentyFourHoursAgo = moment().subtract(24, 'hours');
            const recentWithdraw = await Withdraw.findAll({
                where: {
                    userid: sanitizedUserid,
                    date: {
                        [Op.between]: [twentyFourHoursAgo.toDate(), now.toDate()]
                    },
                    status: '1'
                },
                order: [['date', 'DESC']]
            });


            const totalAmountWithdraw = recentWithdraw.reduce((sum, withdraw) => parseFloat(sum) + parseFloat(withdraw.amount), 0);

            if (totalAmountWithdraw >= 500 || parseFloat(sanitizedAmount) + parseFloat(totalAmountWithdraw) > 500) {
                const remainingAmount = Math.max(0, 500 - parseFloat(totalAmountWithdraw));

                return res.status(200).json(encrypt(JSON.stringify({
                    status: "error",
                    message: `You can cashout up to $${remainingAmount} within the next 24 hours.`
                }), ENC_KEY));
            }
            if (sanitizedAmount < 50 || sanitizedAmount > 500) {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid amount. Amount must be between $50 and $500.' }), ENC_KEY));
            }
            const updatedRebalance = parseFloat(user.rebalance) - parseFloat(totalAmount);

            const resx = await axios.post(url, data, { headers });
            console.log(resx?.data)

            const newCashout = await Withdraw.create({
                userid: user.id,
                email: user.email,
                amount: sanitizedAmount,
                ctip: sanitizedCtip,
                cashtag: '',
                pmeth: method,
                cbalance: user.balance,
                ubalance: user.balance,
                crebalance: user.rebalance,
                urebalance: updatedRebalance,
            });

            if (newCashout) {

                await user.decrement('rebalance', { by: totalAmount });
                await axios.post(
                    'https://bend.logiclane.tech/api/email',
                    {
                        subject: 'CashOut status!',
                        email: user.email,
                        name: `${user.first} ${user.last}`,
                        mail: `
                    <!DOCTYPE html>
                                                                          <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>

                                                                          <head>
                                                                            <meta charset='utf-8'>
                                                                            <meta name='x-apple-disable-message-reformatting'>
                                                                            <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                                            <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                                            <title>CashOut status!</title>
                                                                            <style>
                                                                              .hover-bg-brand-600:hover {
                                                                                background-color: #0047C3 !important;
                                                                              }

                                                                              .hover-text-brand-700:hover {
                                                                                color: #003CA5 !important;
                                                                              }

                                                                              .hover-text-decoration-underline:hover {
                                                                                text-decoration: underline !important;
                                                                              }

                                                                              @media (max-width: 768px) {
                                                                                .sm-mt-4 {
                                                                                  margin-top: 16px !important;
                                                                                }

                                                                                .sm-block {
                                                                                  display: block !important;
                                                                                }

                                                                                .sm-w-full {
                                                                                  width: 100% !important;
                                                                                }

                                                                                .sm-px-4 {
                                                                                  padding-left: 16px !important;
                                                                                  padding-right: 16px !important;
                                                                                }

                                                                                .sm-py-6 {
                                                                                  padding-top: 24px !important;
                                                                                  padding-bottom: 24px !important;
                                                                                }
                                                                              }
                                                                            </style>
                                                                          </head>

                                                                          <body
                                                                            style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                                            <div style='display: none'>
                                                                            CashOut status!

                                                                            </div>
                                                                            <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                                              <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                                                cellpadding='0' cellspacing='0' role='none'>
                                                                                <tr>
                                                                                  <td align='center' style='background-color: #fff;'>
                                                                                    <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                                                      <tr>
                                                                                        <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                                          <div style='margin-bottom: 24px'>
                                                                                            <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                                              <p>SweepStake Mobi</p>
                                                                                            </a>
                                                                                          </div>
                                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                            Hi <b>${user.first}</b>,
                                                                                          </p>
                                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                          We appreciate your request to cash out with SweepStake Mobi.</p>
                                                                                          <p>Please be aware that the processing of cashouts may take up to 2 business days.</p>
                                                                                          <p>For this transfer, you've opted for <b>${method}</b> as your preferred cashout method. 
                                                                                          </p>

                                                                                         <br>
                                                                                         <br>
                                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                                          Thank you for choosing SweepStake Mobi!
                                                                                          </p>
                                                                                          <div role='separator' style='line-height: 16px'>&zwj;</div> 

                                                                                          <div style='text-align: center;'>
                                                                                            <div role='separator'
                                                                                              style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                                            <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                                              This email was sent to you as a registered member of
                                                                                              <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                                                class='sm-block sm-mt-4'>
                                                                                                Use of the service and website is subject to our
                                                                                                <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                  style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                                                and
                                                                                                <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                  style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                                              </span>
                                                                                            </p>
                                                                                            <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                                              rights reserved.</p>
                                                                                          </div>
                                                                                        </td>
                                                                                      </tr>
                                                                                    </table>
                                                                                  </td>
                                                                                </tr>
                                                                              </table>
                                                                            </div>
                                                                          </body>

                                                                          </html>
                    `,
                    },
                    {
                        headers: {
                            'Content-Type': 'application/json',
                            Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
                        },
                    }
                );

                return res.json(encrypt(JSON.stringify({ status: 'success', message: 'Your cash out request has been successfully submitted' }), ENC_KEY));
            } else {
                return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Failed to submit the cashout request' }), ENC_KEY));
            }
            return res.json(response.data);
        }
        const totalAmount = parseFloat(sanitizedAmount) + parseFloat(sanitizedCtip);
        if (totalAmount > parseFloat(user.rebalance)) {
            return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Insufficient balance' }), ENC_KEY));
        }

        // const cashouts = await Withdraw.findAll({
        //     where: { userid: sanitizedUserid },
        //     order: [['id', 'DESC']],
        // });

        const now = moment(); // local current time
        const twentyFourHoursAgo = moment().subtract(24, 'hours');

        // console.log('Fetching redeems for user:', sanitizedUserId);
        // console.log('From:', twentyFourHoursAgo.format('YYYY-MM-DD HH:mm:ss'));
        // console.log('To:', now.format('YYYY-MM-DD HH:mm:ss'));

        const recentWithdraw = await Withdraw.findAll({
            where: {
                userid: sanitizedUserid,
                date: {
                    [Op.between]: [twentyFourHoursAgo.toDate(), now.toDate()]
                },
                status: '1'
            },
            order: [['date', 'DESC']]
        });


        const totalAmountWithdraw = recentWithdraw.reduce((sum, withdraw) => parseFloat(sum) + parseFloat(withdraw.amount), 0);

        if (totalAmountWithdraw >= 500 || parseFloat(sanitizedAmount) + parseFloat(totalAmountWithdraw) > 500) {
            const remainingAmount = Math.max(0, 500 - parseFloat(totalAmountWithdraw));

            return res.status(200).json(encrypt(JSON.stringify({
                status: "error",
                message: `You can cashout up to $${remainingAmount} within the next 24 hours.`
            }), ENC_KEY));
        }

        // const todayMinus24Hours = new Date(Date.now() - 24 * 60 * 60 * 1000);
        // const qAmt = await Withdraw.findAll({
        //     where: {
        //         userid: sanitizedUserid,
        //         status: 1,
        //         date: { [Op.between]: [todayMinus24Hours, new Date()] },
        //     },
        // });

        // const totalAmountLast24Hours = qAmt.reduce((sum, cashout) => parseFloat(sum) + parseFloat(cashout.amount), 0);

        // if (totalAmountLast24Hours >= 500) {
        //     return res.json(encrypt(JSON.stringify({ status: 'error', message: 'You can cash out up to $500 in a 24-hour period.' }), ENC_KEY));
        // }

        if (sanitizedAmount < 50 || sanitizedAmount > 500) {
            return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid amount. Amount must be between $50 and $500.' }), ENC_KEY));
        }

        // const remainingLimit = 500 - parseFloat(totalAmountLast24Hours);
        // if (totalAmount > remainingLimit) {
        //     return res.json(encrypt(JSON.stringify({
        //         status: 'error',
        //         message: `You can cash out up to: $${remainingLimit}.`,
        //     }), ENC_KEY));
        // }

        const updatedRebalance = parseFloat(user.rebalance) - parseFloat(totalAmount);

        const newCashout = await Withdraw.create({
            userid: user.id,
            email: user.email,
            amount: sanitizedAmount,
            ctip: sanitizedCtip,
            cashtag: gtwCard,
            pmeth: method,
            cbalance: user.balance,
            ubalance: user.balance,
            crebalance: user.rebalance,
            urebalance: updatedRebalance,
        });

        if (newCashout) {
            await user.decrement('rebalance', { by: totalAmount });

            await axios.post(
                'https://bend.logiclane.tech/api/email',
                {
                    subject: 'CashOut status!',
                    email: user.email,
                    name: `${user.first} ${user.last}`,
                    mail: `
                    <!DOCTYPE html>
                                                                          <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>

                                                                          <head>
                                                                            <meta charset='utf-8'>
                                                                            <meta name='x-apple-disable-message-reformatting'>
                                                                            <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                                            <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                                            <title>CashOut status!</title>
                                                                            <style>
                                                                              .hover-bg-brand-600:hover {
                                                                                background-color: #0047C3 !important;
                                                                              }

                                                                              .hover-text-brand-700:hover {
                                                                                color: #003CA5 !important;
                                                                              }

                                                                              .hover-text-decoration-underline:hover {
                                                                                text-decoration: underline !important;
                                                                              }

                                                                              @media (max-width: 768px) {
                                                                                .sm-mt-4 {
                                                                                  margin-top: 16px !important;
                                                                                }

                                                                                .sm-block {
                                                                                  display: block !important;
                                                                                }

                                                                                .sm-w-full {
                                                                                  width: 100% !important;
                                                                                }

                                                                                .sm-px-4 {
                                                                                  padding-left: 16px !important;
                                                                                  padding-right: 16px !important;
                                                                                }

                                                                                .sm-py-6 {
                                                                                  padding-top: 24px !important;
                                                                                  padding-bottom: 24px !important;
                                                                                }
                                                                              }
                                                                            </style>
                                                                          </head>

                                                                          <body
                                                                            style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                                            <div style='display: none'>
                                                                            CashOut status!

                                                                            </div>
                                                                            <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                                              <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                                                cellpadding='0' cellspacing='0' role='none'>
                                                                                <tr>
                                                                                  <td align='center' style='background-color: #fff;'>
                                                                                    <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                                                      <tr>
                                                                                        <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                                          <div style='margin-bottom: 24px'>
                                                                                            <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                                              <p>SweepStake Mobi</p>
                                                                                            </a>
                                                                                          </div>
                                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                            Hi <b>${user.first}</b>,
                                                                                          </p>
                                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                          We appreciate your request to cash out with SweepStake Mobi.</p>
                                                                                          <p>Please be aware that the processing of cashouts may take up to 2 business days.</p>
                                                                                          <p>For this transfer, you've opted for <b>${method}</b> as your preferred cashout method. 
                                                                                          </p>

                                                                                         <br>
                                                                                         <br>
                                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                                          Thank you for choosing SweepStake Mobi!
                                                                                          </p>
                                                                                          <div role='separator' style='line-height: 16px'>&zwj;</div> 

                                                                                          <div style='text-align: center;'>
                                                                                            <div role='separator'
                                                                                              style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                                            <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                                              This email was sent to you as a registered member of
                                                                                              <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                                                class='sm-block sm-mt-4'>
                                                                                                Use of the service and website is subject to our
                                                                                                <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                  style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                                                and
                                                                                                <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                  style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                                              </span>
                                                                                            </p>
                                                                                            <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                                              rights reserved.</p>
                                                                                          </div>
                                                                                        </td>
                                                                                      </tr>
                                                                                    </table>
                                                                                  </td>
                                                                                </tr>
                                                                              </table>
                                                                            </div>
                                                                          </body>

                                                                          </html>
                    `,
                },
                {
                    headers: {
                        'Content-Type': 'application/json',
                        Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
                    },
                }
            );

            return res.json(encrypt(JSON.stringify({ status: 'success', message: 'Your cash out request has been successfully submitted' }), ENC_KEY));
        } else {
            return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Failed to submit the cashout request' }), ENC_KEY));
        }
    } catch (err) {
        console.error(err?.response?.data);
        if (err?.response?.data?.details == 'Insufficient Funds') {
            return res.json(encrypt(JSON.stringify({ status: 'error', message: 'Failed to submit cashout request', err: err?.response?.data?.details }), ENC_KEY));
        }
        else {
            return res.json(encrypt(JSON.stringify({ status: 'success', message: 'Processing...', err: err.message }), ENC_KEY));
        }
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }
            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.cashoutCancel = async (req, res) => {
    const data = req.body || {};
    const userId = data.userid || '';

    const lockFilePath = path.join('/', `cancel_cashout_${userId}.lock`);
    let releaseLock;

    try {
        // Acquire an exclusive lock
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
        }

        const token = authHeader.split(' ')[1];
        let decoded;
        try {
            decoded = jwt.verify(token, process.env.JWT_SECRET);
        } catch (err) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
        }

        if (decoded.id != parseInt(userId)) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Unauthorized action' }), ENC_KEY));
        }

        const user = await User.findOne({ where: { id: userId } });
        if (!user) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'User not found!' }), ENC_KEY);
            return res.status(200).json(encData);
        }

        const lastCashout = await Withdraw.findOne({
            where: { userid: userId },
            order: [['id', 'DESC']],
        });

        if (!lastCashout || lastCashout.status != 0) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'No pending cashout!' }), ENC_KEY);
            return res.status(200).json(encData);
        }

        const totalAmount = parseFloat(lastCashout.amount) + parseFloat(lastCashout.ctip);
        const updatedRebalance = parseFloat(user.rebalance) + parseFloat(totalAmount);

        // Update cashout status
        await lastCashout.update({ status: 3 });

        // Increment user's rebalance
        await user.increment('rebalance', { by: totalAmount });

        // Create a new BRDeposit record
        await BrDeposit.create({
            userid: user.id,
            txnby: 'SELF',
            type: 1,
            amount: totalAmount,
            method: 'CashOut Cancel',
            cbalance: user.balance,
            ubalance: user.balance,
            crebalance: user.rebalance,
            urebalance: updatedRebalance,
            ccancelbal: user.cancelbal,
            ucancelbal: user.cancelbal,
        });

        const encData = encrypt(JSON.stringify({ status: 'success', message: 'Cash Out Canceled!' }), ENC_KEY);
        return res.status(200).json(encData);

    } catch (err) {
        console.error('Error processing cashoutCancel:', err);
        const encData = encrypt(JSON.stringify({ status: 'error', message: 'An error occurred during the process.' }), ENC_KEY);
        return res.status(200).json(encData);
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }
            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}
exports.insertRaffle = async (req, res) => {
    const data = req.body;
    const user = data.userid;
    const amount = data.amount;

    const lockFilePath = path.join('/', `insert_raffle_${user}.lock`);
    let releaseLock;
    try {
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
        }

        const token = authHeader.split(' ')[1];
        let decoded;
        try {
            decoded = jwt.verify(token, process.env.JWT_SECRET);
        } catch (err) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
        }

        if (decoded.id != parseInt(user)) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Unauthorized action' }), ENC_KEY));
        }

        const userData = await User.findByPk(user);
        if (!userData || !amount.toString()) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'Invalid User Provided / Amount not provided!' }), ENC_KEY);
            return res.json(encData);
        }

        if (userData.pidv == '1' && userData.namev == '1') {
            const balance = userData.balance;
            const allowedAmounts = [0, 5, 10, 20];

            if (!allowedAmounts.includes(parseInt(amount))) {
                const encData = encrypt(JSON.stringify({ status: 'error', message: 'Invalid Amount!' }), ENC_KEY);
                return res.json(encData);
            }

            const currentDate = new Date();
            const weekAgo = new Date(currentDate);
            weekAgo.setDate(currentDate.getDate() - 7);

            const insertCount = await Raffles.count({
                where: {
                    userid: user,
                    amount,
                    created_at: { [Op.gte]: weekAgo },
                },
            });

            if (amount > 0 && insertCount >= 2) {
                const encData = encrypt(JSON.stringify({ status: 'error', message: 'Maximum insert count reached for this amount!' }), ENC_KEY);
                return res.json(encData);
            }

            if (amount == 0 && insertCount >= 1) {
                const encData = encrypt(JSON.stringify({ status: 'error', message: 'Maximum free inserts reached!' }), ENC_KEY);
                return res.json(encData);
            }

            if (parseFloat(balance) < parseFloat(amount)) {
                const encData = encrypt(JSON.stringify({ status: 'error', message: 'Insufficient Balance!' }), ENC_KEY);
                return res.json(encData);
            }

            const t = await db.transaction();
            try {
                await User.decrement('balance', { by: amount, where: { id: user }, transaction: t });

                const transactionLog = await Transactions.create({
                    userid: user,
                    txnby: 'SELF',
                    type: '2',
                    amount,
                    cbalance: balance,
                    ubalance: parseFloat(balance) - parseFloat(amount),
                    crebalance: userData.rebalance,
                    urebalance: userData.rebalance,
                    paidmethod: 'SweepCoin',
                    paidto: 'Raffle Entry',
                    status: 1,
                }, { transaction: t });

                await Raffles.create({ userid: user, amount }, { transaction: t });

                await t.commit();

                const encData = encrypt(JSON.stringify({ status: 'success', message: 'Raffle Entry Inserted!' }), ENC_KEY);
                return res.json(encData);
            } catch (error) {
                await t.rollback();
                const encData = encrypt(JSON.stringify({ status: 'error', message: 'Unable to Insert Entry!' }), ENC_KEY);
                return res.json(encData);
            }
        } else {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' }), ENC_KEY);
            return res.json(encData);
        }
    } catch (error) {
        const encData = encrypt(JSON.stringify({ status: 'error', message: 'Processing...' }), ENC_KEY);
        return res.json(encData);
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }
            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}
exports.getBonusEntries = async (req, res) => {
    const { userid } = req.body;

    const lockFilePath = path.join('/', `get_bonus_entries_${userid}.lock`);
    let releaseLock;

    try {
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const sanitizedUserId = parseInt(userid);

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Authorization token missing' }), ENC_KEY));
        }

        const token = authHeader.split(' ')[1];
        let decoded;
        try {
            decoded = jwt.verify(token, process.env.JWT_SECRET);
        } catch (err) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Invalid or expired token' }), ENC_KEY));
        }

        if (decoded.id != parseInt(userid)) {
            return res.status(200).json(encrypt(JSON.stringify({ status: 'error', message: 'Unauthorized action' }), ENC_KEY));
        }

        const user = await User.findByPk(sanitizedUserId);
        if (!user) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: "User not found." }), ENC_KEY));
        }
        const bonusRaffles = await BonusRaffle.findAndCountAll({ where: { userid: user.id } })
        if (bonusRaffles) {
            return res.status(200).json(encrypt(JSON.stringify({ status: "success", count: bonusRaffles.count }), ENC_KEY));
        } else {
            return res.status(200).json(encrypt(JSON.stringify({ status: "error", count: 0 }), ENC_KEY));
        }

    } catch (err) {
        console.error(err);
        return res.status(200).json(encrypt(JSON.stringify({ status: "error", message: "An error occurred while processing the request." }), ENC_KEY));
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }
            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}