const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');

const Admin = db.define('Admin', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    username: {
        type: DataTypes.STRING,
        allowNull: false
    },
    email: {
        type: DataTypes.STRING,
        allowNull: false
    },
    password: {
        type: DataTypes.STRING,
        allowNull: false
    },
    phone: {
        type: DataTypes.STRING,
        allowNull: false
    },
    first: {
        type: DataTypes.STRING,
        allowNull: false
    },
    last: {
        type: DataTypes.STRING,
        allowNull: true
    },
    role: {
        type: DataTypes.STRING,
        allowNull: true
    },
    is_loggedin: {
        type: DataTypes.STRING,
        allowNull: true
    },
    ban: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    otp: {
        type: DataTypes.STRING,
        allowNull: true
    },
    reason: {
        type: DataTypes.STRING,
        allowNull: true
    },
    first_login: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: 0
    },
    pref: {
        type: DataTypes.STRING,
        allowNull: true,
        defaultValue: 'magiclink'
    },


    latest_activity: {
        type: DataTypes.STRING,
        allowNull: true
    },
    retry_count: {
        type: DataTypes.INTEGER,
        allowNull: true
    }
    ,
    user: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    creation: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    deposit: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    redeem: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    games: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    userip: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    addnote: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    verify: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    userpaymentmethods: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    userwheel: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    usergifting: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    usermodify: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    userskipmob: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    useractivities: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    withdraw: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    ach: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    bonus: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    raffles: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    paymentmethods: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    paymentmethodsupdate: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    payoutmethods: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    payoutmethodsupdate: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    flaggedpayments: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    avsban: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    codb: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    fraudusers: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    wheelspins: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    giftcards: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    refferals: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    blockedbins: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    uips: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    gamelinks: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    searchtxn: {
        type: DataTypes.INTEGER,
        allowNull: true
    }
}, {
    tableName: 'admin',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = Admin;