const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const ApiLogs = db.define('ApiLogs', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    ip: {
        type: DataTypes.STRING,
        allowNull: true
    },
    api: {
        type: DataTypes.STRING,
        allowNull: true
    },
    request: {
        type: DataTypes.STRING,
        allowNull: true
    },
    response: {
        type: DataTypes.STRING,
        allowNull: true
    }

}, {
    tableName: 'apilogs',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});



module.exports = ApiLogs;