const Creation = require('./Creation');
const User = require('./User');
const Game = require('./Game');
const Redeem = require('./Redeems');
const Withdraw = require('./Withdraw');
const WithdrawData = require('./WithdrawData');
const Bonus = require('./Bonus');
const Transactions = require('./Transactions');
const BRTransactions = require('./BRTransactions');
const LinkedGames = require('./LinkedGames');
const SavedCards = require('./SavedCards');
const GamePassReset = require('./GamePassReset');
const Webhook = require('./Webhook');
const UserIPS = require('./UserIPS');
const FailedVers = require('./FailedVers');
const Raffles = require('./Raffles');
const RaffleWins = require('./RaffleWins');
const FlaggedPayments = require('./FlaggedPayments');
const Referrals = require('./Referrals');
const RefCodes = require('./RefCodes');
const WheelTxn = require('./WheelTxn');
const ActivityLog = require('./ActivityLog');
// Associations
Creation.belongsTo(User, { foreignKey: 'userid' });
Creation.belongsTo(Game, { foreignKey: 'game' });

GamePassReset.belongsTo(User, { foreignKey: 'userid' });
GamePassReset.belongsTo(Game, { foreignKey: 'gameid' });

User.hasMany(Creation, { foreignKey: 'userid' });
Game.hasMany(Creation, { foreignKey: 'game' });

Transactions.belongsTo(Game, { foreignKey: 'paidto', targetKey: 'name' });
Transactions.belongsTo(User, { foreignKey: 'userid' });

Webhook.belongsTo(Transactions, { foreignKey: 'txn_id', targetKey: 'p_code' })

User.hasMany(Transactions, { targetKey: 'userid' })
User.hasMany(BRTransactions, { targetKey: 'userid' })
User.hasMany(Redeem, { targetKey: 'userid' })
User.hasMany(Withdraw, { targetKey: 'userid' })
User.hasMany(LinkedGames, { targetKey: 'userid' })

SavedCards.belongsTo(User, { foreignKey: 'userid' });

LinkedGames.belongsTo(Game, { targetKey: 'id', foreignKey: 'gameid' })

Redeem.belongsTo(Game, { foreignKey: 'game', targetKey: 'name' });
Redeem.belongsTo(User, { foreignKey: 'userid' });

Withdraw.belongsTo(User, { foreignKey: 'userid' });
Withdraw.belongsTo(WithdrawData, { foreignKey: 'id', targetKey: 'wid' });

Bonus.belongsTo(User, { foreignKey: 'userid' });
Bonus.belongsTo(Transactions, { foreignKey: 'userid', targetKey: 'userid' });
BRTransactions.belongsTo(User, { foreignKey: 'userid' });

UserIPS.belongsTo(User, { foreignKey: 'userid', targetKey: 'id' })

FailedVers.belongsTo(User, { foreignKey: 'userid', targetKey: 'id' })

Raffles.belongsTo(User, { foreignKey: 'userid', targetKey: 'id' });
RaffleWins.belongsTo(User, { foreignKey: 'userid', targetKey: 'id' });

FlaggedPayments.belongsTo(User, { foreignKey: 'firstuser', targetKey: 'id' })
FlaggedPayments.belongsTo(User, { foreignKey: 'seconduser', targetKey: 'id' })
FlaggedPayments.belongsTo(Transactions, { foreignKey: 'txnid', targetKey: 'p_codecc' })
FlaggedPayments.belongsTo(Transactions, { foreignKey: 'txnid2', targetKey: 'p_codecc' })
Referrals.belongsTo(User, { foreignKey: 'userid', targetKey: 'id' });
Referrals.belongsTo(RefCodes, { foreignKey: 'refcode', targetKey: 'refcode' });
RefCodes.belongsTo(User, { foreignKey: 'userid', targetKey: 'id' });
RefCodes.belongsTo(Referrals, { foreignKey: 'refcode', targetKey: 'refcode' });

WheelTxn.belongsTo(User, { foreignKey: 'userid', targetKey: 'id' });
ActivityLog.belongsTo(User, { foreignKey: 'userid', targetKey: 'id' });
module.exports = {
    Creation, User, Game, Withdraw,
    WithdrawData, Bonus, Transactions, Redeem,
    BRTransactions, LinkedGames, SavedCards,
    GamePassReset, Webhook, UserIPS, FailedVers,
    RaffleWins, Raffles, FlaggedPayments, Referrals,
    RefCodes, WheelTxn, ActivityLog
};