const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const User = require('./User')
const Transactions = db.define('Transactions', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    txn_id: {
        type: DataTypes.STRING,
        allowNull: true
    },
    userid: {
        type: DataTypes.STRING,
        allowNull: false
    },
    date: {
        type: DataTypes.DATE,
        allowNull: true
    },
    txnby: {
        type: DataTypes.STRING,
        allowNull: false
    },
    type: {
        type: DataTypes.STRING,
        allowNull: false
    },
    amount: {
        type: DataTypes.DECIMAL,
        allowNull: false
    },
    ctip: {
        type: DataTypes.STRING,
        allowNull: true
    },
    gameid: {
        type: DataTypes.STRING,
        allowNull: true
    },
    gameuser: {
        type: DataTypes.STRING,
        allowNull: true
    },
    paidmethod: {
        type: DataTypes.STRING,
        allowNull: true
    },
    capp: {
        type: DataTypes.STRING,
        allowNull: true
    },
    p_code: {
        type: DataTypes.STRING,
        allowNull: true
    },
    p_codecc: {
        type: DataTypes.STRING,
        allowNull: true
    },
    paidto: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cashier: {
        type: DataTypes.STRING,
        allowNull: true
    },
    status: {
        type: DataTypes.STRING,
        allowNull: true
    },
    p_status: {
        type: DataTypes.STRING,
        allowNull: true
    },
    webhookdata: {
        type: DataTypes.TEXT,
        allowNull: true
    },
    checkid: {
        type: DataTypes.STRING,
        allowNull: true
    },
    gtxid: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cbalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    ubalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    crebalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    urebalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    ccancelbal: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    ucancelbal: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    last_reported_at: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    missing_report: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    missing_report_status: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
}, {
    tableName: 'txnlog',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});
Transactions.belongsTo(User, { foreignKey: 'userid' });

module.exports = Transactions;