const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const WebhookIpLogs = db.define('WebhookIpLogs', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    ip: {
        type: DataTypes.STRING,
        allowNull: true
    },
    webhook: {
        type: DataTypes.STRING,
        allowNull: true
    },
    data: {
        type: DataTypes.STRING,
        allowNull: true
    }
}, {
    tableName: 'webhookiplog',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = WebhookIpLogs;