const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const User = require('./User')
const Withdraw = db.define('Withdraw', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },

    userid: {
        type: DataTypes.STRING,
        allowNull: false
    },
    date: {
        type: DataTypes.DATE,
        allowNull: true
    },
    email: {
        type: DataTypes.STRING,
        allowNull: false
    },
    amount: {
        type: DataTypes.DECIMAL,
        allowNull: false
    },
    ctip: {
        type: DataTypes.STRING,
        allowNull: true
    },

    cashtag: {
        type: DataTypes.STRING,
        allowNull: true
    },
    ref_amount: {
        type: DataTypes.STRING,
        allowNull: true
    },
    ref_cashtag: {
        type: DataTypes.STRING,
        allowNull: true
    },

    cname: {
        type: DataTypes.STRING,
        allowNull: true
    },
    pmeth: {
        type: DataTypes.STRING,
        allowNull: true
    },
    reason: {
        type: DataTypes.STRING,
        allowNull: true
    },
    status: {
        type: DataTypes.STRING,
        allowNull: true
    },
    paypal_status: {
        type: DataTypes.STRING,
        allowNull: true
    },
    ach_status: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cbalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    ubalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    crebalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    urebalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    last_reported_at: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    missing_report: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    missing_report_status: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
}, {
    tableName: 'withdraw',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = Withdraw;