import CodeDialog from '@/app/components/shared/CodeDialog'
import React from 'react'
const BasicIconsCode = () => {
  return (
    <>
      <CodeDialog>
        {`
"use client";
import React from 'react';
import { Grid, InputAdornment, Button } from '@mui/material';
import { styled } from '@mui/material/styles';
import { Typography } from '@mui/material';
import { OutlinedInput } from '@mui/material';
import { IconBuildingArch, IconMail, IconMessage2, IconPhone, IconUser } from '@tabler/icons-react';

const CustomFormLabel = styled((props) => (
  <Typography
    variant="subtitle1"
    fontWeight={600}
    {...props}
    component="label"
    htmlFor={props.htmlFor}
  />
))(() => ({
  marginBottom: '5px',
  marginTop: '25px',
  display: 'block',
}));

const CustomOutlinedInput = styled((props) => <OutlinedInput {...props} />)(({ theme }) => ({
  '& .MuiOutlinedInput-input::-webkit-input-placeholder': {
    color: theme.palette.text.secondary,
    opacity: '0.8',
  },

  '& .MuiTypography-root': {
    color: theme.palette.text.secondary,
  },

  '& .MuiOutlinedInput-input.Mui-disabled::-webkit-input-placeholder': {
    color: theme.palette.text.secondary,
    opacity: '1',
  },
}));

<div>
  <Grid container>
    {/* 1 */}
    <Grid size={12}>
      <CustomFormLabel htmlFor="bi-name" sx={{ mt: 0 }}>
        Name
      </CustomFormLabel>
    </Grid>
    <Grid size={12}>
      <CustomOutlinedInput
        startAdornment={
          <InputAdornment position="start">
            <IconUser size="20" />
          </InputAdornment>
        }
        id="bi-name"
        placeholder="John Deo"
        fullWidth
      />
    </Grid>
    {/* 2 */}
    <Grid size={12}>
      <CustomFormLabel htmlFor="bi-company">
        Company
      </CustomFormLabel>
    </Grid>
    <Grid size={12}>
      <CustomOutlinedInput
        startAdornment={
          <InputAdornment position="start">
            <IconBuildingArch size="20" />
          </InputAdornment>
        }
        id="bi-company"
        placeholder="ACME Inc."
        fullWidth
      />
    </Grid>
    {/* 3 */}
    <Grid size={12}>
      <CustomFormLabel htmlFor="bi-email">
        Email
      </CustomFormLabel>
    </Grid>
    <Grid size={12}>
      <CustomOutlinedInput
        startAdornment={
          <InputAdornment position="start">
            <IconMail size="20" />
          </InputAdornment>
        }
        id="bi-email"
        placeholder="john.deo"
        fullWidth
      />
    </Grid>
    {/* 4 */}
    <Grid size={12}>
      <CustomFormLabel htmlFor="bi-phone">
        Phone No
      </CustomFormLabel>
    </Grid>
    <Grid size={12}>
      <CustomOutlinedInput
        startAdornment={
          <InputAdornment position="start">
            <IconPhone size="20" />
          </InputAdornment>
        }
        id="bi-phone"
        placeholder="412 2150 451"
        fullWidth
      />
    </Grid>
    {/* 5 */}
    <Grid size={12}>
      <CustomFormLabel htmlFor="bi-message">
        Message
      </CustomFormLabel>
    </Grid>
    <Grid size={12}>
      <CustomOutlinedInput
        id="bi-message"
        startAdornment={
          <InputAdornment position="start">
            <IconMessage2 size="20" />
          </InputAdornment>
        }
        placeholder="Hi, Do you  have a moment to talk Jeo ?"
        multiline
        fullWidth
      />
    </Grid>
    <Grid mt={3} size={12}>
      <Button variant="contained" color="primary">
        Send
      </Button>
    </Grid>
  </Grid>
</div>
`}
      </CodeDialog>
    </>
  )
}

export default BasicIconsCode
