"use client"
import React, { useContext } from 'react';
import { Card, CardHeader, CardContent, Divider, Box } from '@mui/material';
import { CustomizerContext } from '@/app/context/customizerContext';


type Props = {
  title: string;
  children: React.ReactNode;
};

const BaseCard = ({ title, children, searchBar }: any) => {
  const { isCardShadow } = useContext(CustomizerContext);

  return (
    <Card
      sx={{ padding: 0 }}
      elevation={isCardShadow ? 9 : 0}
      variant={!isCardShadow ? 'outlined' : undefined}
    >
      <CardHeader
        title={<Box fontWeight={600}>{title}</Box>}
        action={<Box sx={{ mt: 1 }}>{searchBar}</Box>}
        sx={{
          '& .MuiCardHeader-action': {
            alignSelf: 'center',
            marginTop: 0,
          },
        }}
      />
      <Divider />
      <CardContent>{children}</CardContent>
    </Card>
  );
};

export default BaseCard;
