
"use client";
import Box from "@mui/material/Box";
import Container from "@mui/material/Container";
import { styled, useTheme } from "@mui/material/styles";
import React, { useContext } from "react";
import Header from "../layout/vertical/header/Header";
import Sidebar from "../layout/vertical/sidebar/Sidebar";
import Customizer from "../layout/shared/customizer/Customizer";
import Navigation from "../layout/horizontal/navbar/Navigation";
import HorizontalHeader from "../layout/horizontal/header/Header";
import { CustomizerContext } from "@/app/context/customizerContext";
import config from "@/app/context/config";
import { useSearchParams } from "next/navigation";
import { LocalizationProvider } from "@mui/x-date-pickers";
import { AdapterDayjs } from "@mui/x-date-pickers/AdapterDayjs";
import ClientProviders from "../ClientProviders";
const MainWrapper = styled("div")(() => ({
    display: "flex",
    minHeight: "100vh",
    width: "100%",
}));

const PageWrapper = styled("div")(() => ({
    display: "flex",
    flexGrow: 1,
    paddingBottom: "60px",
    flexDirection: "column",
    zIndex: 1,
    width: "100%",
    backgroundColor: "transparent",
}));

export default function RootLayout({ children }: { children: React.ReactNode; }) {
    const { activeLayout, isLayout, activeMode, isCollapse } = useContext(CustomizerContext);
    const theme = useTheme();
    const searchParams = useSearchParams();
    const kioskId = searchParams?.get("kioskId") || searchParams?.get("kiosk_id"); // null if not present

    return (
        <LocalizationProvider dateAdapter={AdapterDayjs}>
            <ClientProviders>

                {children}
            </ClientProviders>
        </LocalizationProvider>
    );
}

