"use client"
import {
  Box,
  Typography,
  Avatar,
  Stack,
  ButtonGroup,
  Button,
  Table,
  TableContainer,
  TableHead,
  TableRow,
  TableCell,
  TableBody,
  IconButton,
} from "@mui/material";
import Link from "next/link";
import { IconMinus, IconPlus, IconTrash } from "@tabler/icons-react";

import emptyCart from "/public/images/products/empty-shopping-cart.svg";

import { ProductType } from "../../../../(DashboardLayout)/types/apps/eCommerce";
import Image from "next/image";
import { ProductContext } from "@/app/context/Ecommercecontext/index";
import { useContext } from "react";

const AddToCart = () => {

  const {
    cartItems,
    incrementQuantity,
    removeFromCart,
    decrementQuantity,
  } = useContext(ProductContext);



  return (
    <Box>
      {cartItems.length > 0 ? (
        <>
          <Box>
            <TableContainer sx={{ minWidth: 350 }}>
              <Table>
                <TableHead>
                  <TableRow>
                    <TableCell>Product</TableCell>

                    <TableCell align="left">Quantity</TableCell>
                    <TableCell align="right">Price</TableCell>
                  </TableRow>
                </TableHead>

                <TableBody>
                  {cartItems.map((product) => (
                    <TableRow key={product.id}>
                      {/* ------------------------------------------- */}
                      {/* Product Image & Title */}
                      {/* ------------------------------------------- */}
                      <TableCell>
                        <Stack direction="row" alignItems="center" gap={2}>
                          <Avatar
                            src={product.photo}
                            alt={product.photo}
                            sx={{
                              borderRadius: "10px",
                              height: "80px",
                              width: "90px",
                            }}
                          />
                          <Box>
                            <Typography variant="h6">
                              {product.title}
                            </Typography>{" "}
                            <Typography color="textSecondary" variant="body1">
                              {product.category}
                            </Typography>
                            <IconButton
                              size="small"
                              color="error"
                              onClick={() => removeFromCart(product.id)}
                            >
                              <IconTrash size="1rem" />
                            </IconButton>
                          </Box>
                        </Stack>
                      </TableCell>

                      <TableCell>
                        <ButtonGroup
                          size="small"
                          color="success"
                          aria-label="small button group"
                        >
                          <Button
                            onClick={() => decrementQuantity(product.id)}
                            disabled={product.qty < 2}
                          >
                            <IconMinus stroke={1.5} size="0.8rem" />
                          </Button>
                          <Button>{product.qty}</Button>
                          <Button onClick={() => incrementQuantity(product.id)}>
                            <IconPlus stroke={1.5} size="0.8rem" />
                          </Button>
                        </ButtonGroup>
                      </TableCell>
                      <TableCell align="right">
                        <Typography variant="h6">
                          ${product.price * product.qty}
                        </Typography>
                      </TableCell>
                    </TableRow>
                  ))}
                </TableBody>
              </Table>
            </TableContainer>
          </Box>
        </>
      ) : (
        <Box textAlign="center" mb={3}>
          <Image src={emptyCart} alt="cart" width={200} />
          <Typography variant="h5" mb={2}>
            Cart is Empty
          </Typography>
          <Button
            component={Link}
            href="/apps/ecommerce/shop"
            variant="contained"
          >
            Go back to Shopping
          </Button>
        </Box>
      )}
    </Box>
  );
};

export default AddToCart;
