const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');

const Admin = db.define('Admin', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    username: {
        type: DataTypes.STRING,
        allowNull: true
    },
    password: {
        type: DataTypes.STRING,
        allowNull: true
    },
    first: {
        type: DataTypes.STRING,
        allowNull: true
    },
    last: {
        type: DataTypes.STRING,
        allowNull: true
    },
    email: {
        type: DataTypes.STRING,
        allowNull: true
    },
    phone: {
        type: DataTypes.STRING,
        allowNull: true
    },

    role: {
        type: DataTypes.STRING,
        allowNull: true
    },

    remember_token: {
        type: DataTypes.STRING,
        allowNull: true
    },
    is_loggedin: {
        type: DataTypes.STRING,
        allowNull: true
    },
    ban: {
        type: DataTypes.STRING,
        allowNull: true
    },
    otp: {
        type: DataTypes.STRING,
        allowNull: true
    },
    reason: {
        type: DataTypes.STRING,
        allowNull: true
    },
    first_login: {
        type: DataTypes.STRING,
        allowNull: true
    },
    pref: {
        type: DataTypes.STRING,
        allowNull: true
    },
    wage: {
        type: DataTypes.STRING,
        allowNull: true
    },
    indian_wage: {
        type: DataTypes.STRING,
        allowNull: true
    },
    mobile_login: {
        type: DataTypes.STRING,
        allowNull: true
    },
    latest_activity: {
        type: DataTypes.STRING,
        allowNull: true
    },
    api_token: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cfAccount: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cfAccountToken: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cfPaypalToken: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cfVenmoToken: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cfAccountAllowed: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cfPaypalAllowed: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cfVenmoAllowed: {
        type: DataTypes.STRING,
        allowNull: true
    },
    balance: {
        type: DataTypes.STRING,
        allowNull: true
    },
    login_in_progress: {
        type: DataTypes.INTEGER,
        allowNull: true
    }
}, {
    tableName: 'admin',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = Admin;