const Admin = require('./Admin')
const Logins = require('./Logins')
const Schedule = require('./Schedule')
const Days = require('./Days')
const LinkedAccounts = require('./LinkedAccounts')
const Transactions = require('./Transactions')
const LeaveApplication = require('./LeaveApplication')

Admin.hasMany(Logins, { foreignKey: 'userid', as: 'logins' });
Admin.hasMany(Transactions, { foreignKey: 'admin_id', as: 'transactions' });

Logins.belongsTo(Admin, { foreignKey: 'userid', as: 'admin' });

Admin.hasMany(Schedule, { foreignKey: 'adminid', as: 'schedules' });
Schedule.belongsToMany(Days, {
    through: 'schedule_days',
    foreignKey: 'schedule_id',
    otherKey: 'day_id',
    as: 'days'
});

Days.belongsToMany(Schedule, {
    through: 'schedule_days',
    foreignKey: 'day_id',
    otherKey: 'schedule_id',
    as: 'schedules'
});

Schedule.belongsTo(Admin, { foreignKey: 'adminid', as: 'admin' });
Admin.hasMany(LinkedAccounts, { foreignKey: 'adminid', as: 'linkedAccounts' });
LinkedAccounts.belongsTo(Admin, { foreignKey: 'adminid', as: 'admin' });
Transactions.belongsTo(Admin, { foreignKey: 'admin_id', as: 'admin' });
LeaveApplication.belongsTo(Admin, { foreignKey: 'admin_id', as: 'admin' });

module.exports = { Logins, Admin, Schedule, LinkedAccounts, Transactions, Schedule, Days, LeaveApplication };