const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const KioskNotes = db.define('KioskNotes', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    kiosk_name: {
        type: DataTypes.STRING,
        allowNull: true
    },
    denomination: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    note_count: {
        type: DataTypes.BIGINT,
        allowNull: true
    },
   
}, {
    tableName: 'StackingNoteCounts',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});



module.exports = KioskNotes;