const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const LinkedAccounts = db.define('LinkedAccounts', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    adminid: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    account_token: {
        type: DataTypes.STRING,
        allowNull: true
    },
    routing_number: {
        type: DataTypes.STRING,
        allowNull: true
    },
    alias: {
        type: DataTypes.STRING,
        allowNull: true
    },
    last4: {
        type: DataTypes.STRING,
        allowNull: true
    }

}, {
    tableName: 'linkedAccounts',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});



module.exports = LinkedAccounts;