const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const SweepLoginToken = db.define('SweepLoginToken', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    token: {
        type: DataTypes.STRING,
        allowNull: true
    },
    status: {
        type: DataTypes.STRING,
        allowNull: true
    },
    login: {
        type: DataTypes.STRING,
        allowNull: true
    },
    logout: {
        type: DataTypes.STRING,
        allowNull: true
    },
    userid: {
        type: DataTypes.STRING,
        allowNull: true
    },
    phone: {
        type: DataTypes.STRING,
        allowNull: true
    },
}, {
    tableName: 'sweep_login_token',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});



module.exports = SweepLoginToken;