const express = require('express');
const router = express.Router();
const multer = require('multer');

const rateLimit = require('express-rate-limit');
const upload = multer();

const Auth = require('../controllers/Auth');
const OAuth = require('../controllers/OAuth');

const ipLock = require('../middleware/ipLockMiddleware');
const ipLockWare = ipLock.ipLockMiddleware;

router.post('/login', Auth.login)
router.post('/makeLogin', Auth.makeLogin)
router.post('/makeLogout', Auth.makeLogout)
router.post('/updateTime', Auth.updateTime)
router.post('/deleteTime', Auth.deleteTime)
router.post('/deleteEmployee', Auth.deleteEmployee)
router.post('/addEmployee', Auth.addEmployee)
router.get('/employeeLogins', Auth.employeeLogins)
router.get('/getAdmins', Auth.getAdmins)
router.get('/getAdminsWithLogins', Auth.getAdminsWithLogins)
router.get('/getAdminsWorkDays', Auth.getAdminsWorkDays)

router.post('/updateMobileLogin', Auth.updateMobileLogin)
router.get('/getHourlyWages', Auth.getHourlyWages)
router.get('/getHourlyIndianWages', Auth.getHourlyIndianWages)


router.post('/updateWage', Auth.updateWage)
router.post('/updateIndianWage', Auth.updateIndianWage)

router.get('/loginTimes', Auth.loginTimes)
router.get('/weeklyReport', Auth.weeklyReport)
router.get('/report', Auth.report)
router.post('/exportReport', Auth.exportReport)
router.post('/quickAddBalance', Auth.quickAddBalance)

router.post('/addBalance', Auth.addBalance)
router.post('/removeBalance', Auth.removeBalance)

router.post('/wagesCharts', Auth.wagesCharts)
router.post('/getCFBankAccounts', Auth.getCFBankAccounts)
router.post('/registerVenmoToken', Auth.registerVenmoToken)
router.post('/registerPaypalToken', Auth.registerPaypalToken)
router.post('/storeCoinFlowBankToken', Auth.storeCoinFlowBankToken)
router.post('/getCoinFlowRedirectUrl', Auth.getCoinFlowRedirectUrl)
router.post('/registerCoinFlowUser', Auth.registerCoinFlowUser)
router.post('/requestWithdraw', Auth.requestWithdraw)
router.get('/getTransactions', Auth.getTransactions)
router.get('/getTransactionsByUser', Auth.getTransactionsByUser)

router.get('/getAdmin', Auth.getAdmin)
router.post('/viewTransaction', Auth.viewTransaction)

router.post('/oauth/token', OAuth.token)
router.post('/oauth/checkLogin', OAuth.checkLogin)
router.post('/oLogin', OAuth.oLogin)
router.get('/oLogin', OAuth.oLogin)
router.get('/makeOLogin', OAuth.makeOLogin)
router.get('/makeOLogout', OAuth.makeOLogout)
router.get('/checkOLogin', OAuth.checkOLogin)

router.get('/schedules', Auth.schedules)
router.post('/getAdminSchedule', Auth.getAdminSchedule)
router.post('/createSchedule', Auth.createSchedule)
router.post('/updateSchedule', Auth.updateSchedule)
router.post('/getSchedules', Auth.getSchedules)
router.post('/deleteSchedule', Auth.deleteSchedule)
router.get('/leaveApplications', Auth.leaveApplications)
router.post('/approveLeave', Auth.approveLeave)
router.post('/rejectLeave', Auth.rejectLeave)
router.post('/requestLeave', Auth.requestLeave)

router.get('/payoutMethods', Auth.payoutMethods)
router.post('/updatePayoutMethodStatus', Auth.updatePayoutMethodStatus)
router.post('/updateEmployeePayoutMethods', Auth.updateEmployeePayoutMethods)

const otpLoginLimiter = rateLimit({
    windowMs: 1 * 60 * 1000, // 1 minutes
    max: 5, // Limit each IP to 1 requests per windowMs
    message: 'Too many requests from this IP, please try again later.',
});
// Route to get all admins
// router.get('/admins', authController.getAllAdmins);


module.exports = router;