// if (process.env.NODE_ENV !== 'development') {
//     console.log = function () { };
//     console.error = function () { };
//     console.warn = function () { };
// }

const express = require('express');
const cors = require('cors');
const helmet = require('helmet');
const db = require('./config/db.config');
// const Auth = require('./controllers/Auth')
const session = require('express-session');
const SequelizeStore = require('connect-session-sequelize')(session.Store);
require('dotenv').config()
const routes = require('./routes/routes');
// const requestHandler = require('./middleware/processRequest');
const path = require('path');

const sessionStore = new SequelizeStore({
    db: db,
    tableName: 'node_ses',
});

const app = express();
app.use(cors());

app.use(helmet({
    contentSecurityPolicy: {
        directives: {
            defaultSrc: ["'self'"],
            scriptSrc: ["'self'", "'unsafe-inline'", "'unsafe-eval'"],
            styleSrc: ["'self'", "'unsafe-inline'"],
            frameAncestors: ["*"], // ✅ Allow all iframe embedding
        },
    },
}));

app.use(
    session({
        secret: "test11235@", // Change this to a strong secret
        store: sessionStore,
        resave: false,
        saveUninitialized: false, // Prevent empty sessions
        cookie: { secure: false }, // Set to `true` if using HTTPS
    })
);

// Sync the session table
sessionStore.sync();
app.use(express.json());
app.use(express.urlencoded({ extended: true }));
// app.use(requestHandler);

app.set('trust proxy', 1);
app.use('/public', express.static(path.join(__dirname, 'public')));
app.use("/reports", express.static(path.join(__dirname, "public", "reports")));

// Define a simple route
app.get('/', (req, res) => {
    res.send('Hello World!');
});
app.use('/api', routes);
// Start the server
const PORT = process.env.PORT || 80;
app.listen(PORT, () => {
    console.log(`Server is running on port ${PORT}`);
});
