"use client";

import { AwaitedReactNode, ClassAttributes, HTMLAttributes, JSX, JSXElementConstructor, Key, ReactElement, ReactNode, ReactPortal, TdHTMLAttributes, useMemo, useState } from "react";
import { useTable, useGlobalFilter, useSortBy, usePagination, Row as R, TableInstance } from "react-table";
import { Alert, Button, Col, Container, Form, Modal, Row, Table } from "react-bootstrap";

import axios from "axios";
export const GlobalFilter = ({ filter, setFilter }: any) => {
    return (
        <span className="d-flex ms-auto">
            <input
                value={filter || ""}
                onChange={(e) => setFilter(e.target.value)}
                className="form-control mb-4"
                placeholder="Search..."
            />
        </span>
    );
};
export const BasicTable = ({ data, fetchTxns }: { data: any[], fetchTxns: any }) => {
    const [showOTPModal, setShowOTPModal] = useState(false);
    const [showBanModal, setShowBanModal] = useState(false);
    const [showUnbanModal, setShowUnbanModal] = useState(false);
    const [showDeleteModal, setShowDeleteModal] = useState(false);
    const [showCreateModal, setShowCreateModal] = useState(false)

    const [allowedOTP, setAllowedOTP] = useState<any[]>([]);
    const [selectedUserId, setSelectedUserId] = useState<number | null>(null);
    const [settings, setSettings] = useState<any>({});
    const [isLoading, setIsLoading] = useState<any>(false)
    const [err, setError] = useState<any>('')
    const [selectedName, setSelectedName] = useState<any>('')

    const [firstName, setFirstName] = useState('')
    const [lastName, setLastName] = useState('')
    const [email, setEmail] = useState('')
    const [phone, setPhone] = useState('')
    const [username, setUsername] = useState('')

    const handleOTPChange = async (name: any, value: any) => {
        // 1. Update the local state immediately
        const updatedSettings = {
            ...settings,
            [name]: value,
        };

        setSettings(updatedSettings);

        // 2. Build the payload using the updated settings
        const enabledNames = Object.keys(updatedSettings)
            .filter(key => updatedSettings[key])
            .map(key => key.toLowerCase())
            .join(',');

        try {
            const token = localStorage.getItem('token') ?? '';
            const response = await axios.post('/api/updateOTP', {
                otps: enabledNames,
                admin_id: selectedUserId,
                token,
            });

            if (response?.data?.status !== 'error') {
                console.log('OTP Updated');
                fetchTxns()
            }
        } catch (e: any) {
            console.error('Error updating OTP:', e.message);
        }

        console.log('Enabled OTPs:', enabledNames);
    };
    const handleBanCashier = async (e: any) => {
        e.preventDefault();
        setIsLoading(true);

        try {
            const token = localStorage.getItem('token') ?? '';
            const response = await axios.post('/api/banCashier', {
                admin_id: selectedUserId,
                token,
            });

            if (response?.data?.status !== 'error') {
                console.log('OTP Updated');
                fetchTxns();
                setIsLoading(false);

                setShowBanModal(false)
            }
        } catch (e: any) {
            setIsLoading(false);

            console.error('Error updating OTP:', e.message);
        }
    }
    const handleUnbanCashier = async (e: any) => {
        e.preventDefault();
        setIsLoading(true);

        try {
            const token = localStorage.getItem('token') ?? '';
            const response = await axios.post('/api/unbanCashier', {
                admin_id: selectedUserId,
                token,
            });

            if (response?.data?.status !== 'error') {
                console.log('OTP Updated');
                fetchTxns();
                setIsLoading(false);

                setShowUnbanModal(false)
            }
        } catch (e: any) {
            setIsLoading(false);

            console.error('Error updating OTP:', e.message);
        }
    }
    const handleDeleteCashier = async (e: any) => {
        e.preventDefault();
        setIsLoading(true);
        try {
            const token = localStorage.getItem('token') ?? '';
            const response = await axios.post('/api/deleteCashier', {
                admin_id: selectedUserId,
                token,
            });

            if (response?.data?.status !== 'error') {
                // console.log('OTP Updated');
                fetchTxns();
                setIsLoading(false);

                setShowDeleteModal(false)

            }
        } catch (e: any) {
            setIsLoading(false);

            console.error('Error updating OTP:', e.message);
        }
    }
    const handleCreateCashier = async (e: any) => {
        e.preventDefault()
        setIsLoading(true)
        // console.log(firstName, lastName, email, phone, username)
        try {
            const token = localStorage.getItem('token') ?? '';
            const response = await axios.post('/api/createCashier', {
                // admin_id: selectedUserId,
                token,
                firstName,
                lastName,
                email,
                phone,
                username
            });

            if (response?.data?.status !== 'error') {
                // console.log('OTP Updated');
                setFirstName('')
                setLastName('')
                setUsername('')
                setEmail('')
                setPhone('')
                fetchTxns();
                setIsLoading(false)
                setShowCreateModal(false)
            }
            setIsLoading(false)

        } catch (e: any) {
            setIsLoading(false)

            console.error('Error updating OTP:', e.message);
        }
    }
    const columns = useMemo(() => [
        {
            Header: "Sl No.",
            accessor: "id",
            Cell: ({ row }: any) => row.index + 1,
        },
        {
            Header: "Cashier",
            accessor: "username",
            Cell: ({ row }: any) => row.original.username,
        },
        {
            Header: "Email",
            accessor: "email",
            Cell: ({ row }: any) => row.original.email,
        },
        {
            Header: "Phone",
            accessor: "phone",
            Cell: ({ row }: any) => row.original.phone,
        },
        {
            Header: "Ban Reason (if any)",
            accessor: "reason",
            Cell: ({ row }: any) => row.original.reason,
        },
        {
            Header: "OTP Allowance",
            accessor: "otp_allow",
            Cell: ({ row }: any) => (
                <Button
                    variant="primary"
                    size="sm"
                    className="w-100"
                    onClick={() => {
                        setShowOTPModal(true);

                        const otpString = row.original.otp_allow || "";
                        const otpArray = otpString.split(",").map((x: string) => x.trim().toLowerCase());
                        const fixedNames = ["ray", "sandy", "jacqueline"];

                        setAllowedOTP(fixedNames);

                        const initialSettings: any = {};
                        fixedNames.forEach(name => {
                            initialSettings[name] = otpArray.includes(name);
                        });

                        setSettings(initialSettings);
                        setSelectedUserId(row.original.id);
                    }}
                >
                    OTPs
                </Button>
            ),
        },
        {
            Header: "Ban",
            accessor: "ban",
            Cell: ({ row }: any) => (
                <Button
                    variant={row.original.ban === 0 ? "danger" : "success"}
                    size="sm"
                    className="w-100"
                    onClick={() => {
                        setSelectedUserId(row.original.id);
                        row.original.ban === 0 ? setShowBanModal(true) : setShowUnbanModal(true);
                    }}
                >
                    {row.original.ban === 0 ? "Ban" : "Unban"}
                </Button>
            ),
        },
        {
            Header: "Delete",
            accessor: "delete",
            Cell: ({ row }: any) => (
                <Button
                    variant="danger"
                    size="sm"
                    className="w-100"
                    onClick={() => {
                        setSelectedUserId(row.original.id);
                        setShowDeleteModal(true);
                    }}
                >
                    Delete
                </Button>
            ),
        },
    ], []);

    const tableInstance = useTable<any>(
        { columns, data },
        useGlobalFilter,
        useSortBy,
        usePagination
    );
    const {
        //
        getTableProps,
        headerGroups,
        getTableBodyProps,
        prepareRow,
        setGlobalFilter,
        state,
        page,
        nextPage,
        previousPage,
        canNextPage,
        canPreviousPage,
        gotoPage,
        pageCount,

        setPageSize,
    }: any = tableInstance;
    const { globalFilter, pageIndex, pageSize } = state;

    return (

        <>
            {/* Top Bar */}
            <div className="d-flex justify-content-end mb-3">
                <Button variant="primary" onClick={() => setShowCreateModal(true)}>
                    Create Cashier
                </Button>
            </div>
            <div className="  d-flex">
                <div className="form-group">
                    <label className="me-2">Show</label>
                    <select
                        className="  selectpage  border me-1"
                        value={pageSize}
                        onChange={(e) => setPageSize(Number(e.target.value))}
                    >
                        {[10, 25, 50].map((pageSize) => (
                            <option key={pageSize} value={pageSize}>
                                {pageSize}
                            </option>
                        ))}
                    </select>  entries
                </div>

                <GlobalFilter filter={globalFilter} setFilter={setGlobalFilter} />
            </div>


            {/* Table */}
            <Table bordered hover size="sm" {...getTableProps()}>
                <thead>
                    {headerGroups.map((headerGroup: any) => (
                        <tr {...headerGroup.getHeaderGroupProps()} key={headerGroup.id}>
                            {headerGroup.headers.map((column: any) => (
                                <th
                                    {...column.getHeaderProps(column.getSortByToggleProps())}
                                    key={column.id}
                                    className="px-3 py-2" // ⬅️ add padding inside headers
                                >
                                    {column.render("Header")}
                                    <span>
                                        {column.isSorted ? (column.isSortedDesc ? " 🔽" : " 🔼") : ""}
                                    </span>
                                </th>
                            ))}
                        </tr>
                    ))}
                </thead>

                <tbody {...getTableBodyProps()}>
                    {page.length === 0 ? (
                        <tr>
                            <td colSpan={columns.length} className="text-center py-4">
                                No data available
                            </td>
                        </tr>
                    ) : (
                        page.map((row: R<object>) => {
                            prepareRow(row);
                            return (
                                <tr {...row.getRowProps()} key={row.id}>
                                    {row.cells.map((cell: any) => (
                                        <td
                                            {...cell.getCellProps()}
                                            key={cell.column.id}
                                            className="px-3 py-2" // ⬅️ add padding inside cells
                                        >
                                            {cell.render("Cell")}
                                        </td>
                                    ))}
                                </tr>
                            );
                        })
                    )}
                </tbody>
            </Table>




            <div className="d-block d-sm-flex mt-4 ">
                {/* <span className="">
                    Showing 1 to 10 of 57 entries

                </span> */}
                <span className="ms-sm-auto ">
                    <Button
                        variant=""
                        className="btn-outline-light tablebutton me-2 d-sm-inline d-block my-1"
                        onClick={() => gotoPage(0)}
                        disabled={!canPreviousPage}
                    >
                        {" Previous "}
                    </Button>
                    <Button
                        variant=""
                        className="btn-outline-light tablebutton me-2 my-1"
                        onClick={() => {
                            previousPage();
                        }}
                        disabled={!canPreviousPage}
                    >
                        {" << "}
                    </Button>
                    <Button
                        variant=""
                        className="btn-outline-light tablebutton me-2 my-1"
                        onClick={() => {
                            previousPage();
                        }}
                        disabled={!canPreviousPage}
                    >
                        {" < "}
                    </Button>
                    <Button
                        variant=""
                        className="btn-outline-light tablebutton me-2 my-1"
                        onClick={() => {
                            nextPage();
                        }}
                        disabled={!canNextPage}
                    >
                        {" > "}
                    </Button>
                    <Button
                        variant=""
                        className="btn-outline-light tablebutton me-2 my-1"
                        onClick={() => {
                            nextPage();
                        }}
                        disabled={!canNextPage}
                    >
                        {" >> "}
                    </Button>
                    <Button
                        variant=""
                        className="btn-outline-light tablebutton me-2 d-sm-inline d-block my-1"
                        onClick={() => gotoPage(pageCount - 1)}
                        disabled={!canNextPage}
                    >
                        {" Next "}
                    </Button>
                </span>
            </div>

            {/* OTP Modal */}
            <Modal centered show={showOTPModal} onHide={() => setShowOTPModal(false)} keyboard={false} >
                <Modal.Header closeButton>
                    <Modal.Title as="h6">OTP Allowance</Modal.Title>
                </Modal.Header>
                <Modal.Body>
                    <Container fluid>
                        {err && <Alert variant="danger">{err}</Alert>}
                        <form onSubmit={() => { console.log('err') }}>
                            <div className="mb-3">
                                {allowedOTP.map((name) => {
                                    const key = name.trim(); // in case there’s extra whitespace
                                    const capitalizedName = key.charAt(0).toUpperCase() + key.slice(1);
                                    const isThisButtonLoading = isLoading && selectedName === capitalizedName;

                                    return (


                                        <div key={key} className='flex items-center justify-between'>
                                            <Form.Check type="switch" className="form-check-lg form-switch"

                                                label={capitalizedName}
                                                id={key}
                                                checked={!!settings[key]}
                                                onChange={() => handleOTPChange(key, !settings[key])}
                                                disabled={isThisButtonLoading}
                                            />
                                        </div>

                                    );
                                })}

                            </div>

                        </form>

                    </Container>

                </Modal.Body>

            </Modal >
            {/* Ban Modal */}
            <Modal centered show={showBanModal} onHide={() => setShowBanModal(false)} keyboard={false} >
                <Modal.Header closeButton>
                    <Modal.Title as="h6">Ban Cashier</Modal.Title>
                </Modal.Header>
                <Modal.Body>
                    <Container fluid>
                        {err && <Alert variant="danger">{err}</Alert>}
                        <form onSubmit={handleBanCashier}>
                            <div className="mb-3">
                                <p>Are you sure you want to ban the Cashier?</p>
                                {/* <CustomTextField autoFocus fullWidth label='Enter OTP' placeholder='*****' value={otp} onChange={(e: any) => setOtp(e.target.value)} /> */}
                                <br />
                                <Button variant='contained' type='button'
                                    className="btn btn-light w-100 mb-2"
                                    disabled={isLoading}
                                    onClick={() => setShowBanModal(false)}>

                                    {isLoading ? 'Please wait...' : 'No'}
                                </Button>
                                <Button variant='contained' type='submit'
                                    className="btn btn-danger w-100 mb-2"
                                    disabled={isLoading}>
                                    {isLoading ? 'Please wait...' : 'Yes'}
                                </Button>

                            </div>

                        </form>

                    </Container>

                </Modal.Body>

            </Modal>
            {/* Unban Modal */}
            <Modal centered show={showUnbanModal} onHide={() => setShowUnbanModal(false)} keyboard={false} >
                <Modal.Header closeButton>
                    <Modal.Title as="h6">Unban Cashier</Modal.Title>
                </Modal.Header>
                <Modal.Body>
                    <Container fluid>
                        {err && <Alert variant="danger">{err}</Alert>}
                        <form onSubmit={handleUnbanCashier}>
                            <div className="mb-3">
                                <p>Are you sure you want to unban the Cashier?</p>
                                {/* <CustomTextField autoFocus fullWidth label='Enter OTP' placeholder='*****' value={otp} onChange={(e: any) => setOtp(e.target.value)} /> */}
                                <br />
                                <Button variant='contained' type='button'
                                    className="btn btn-light w-100 mb-2"
                                    disabled={isLoading}
                                    onClick={() => setShowUnbanModal(false)}>

                                    {isLoading ? 'Please wait...' : 'No'}
                                </Button>
                                <Button variant='contained' type='submit'
                                    className="btn btn-success w-100 mb-2"
                                    disabled={isLoading}>
                                    {isLoading ? 'Please wait...' : 'Yes'}
                                </Button>

                            </div>

                        </form>

                    </Container>

                </Modal.Body>

            </Modal>
            {/* Delete Modal */}
            <Modal centered show={showDeleteModal} onHide={() => setShowDeleteModal(false)} keyboard={false} >
                <Modal.Header closeButton>
                    <Modal.Title as="h6">Ban Cashier</Modal.Title>
                </Modal.Header>
                <Modal.Body>
                    <Container fluid>
                        {err && <Alert variant="danger">{err}</Alert>}
                        <form onSubmit={handleDeleteCashier}>
                            <div className="mb-3">
                                <p>Are you sure you want to delete the Cashier?</p>
                                {/* <CustomTextField autoFocus fullWidth label='Enter OTP' placeholder='*****' value={otp} onChange={(e: any) => setOtp(e.target.value)} /> */}
                                <br />
                                <Button variant='contained' type='button'
                                    className="btn btn-light w-100 mb-2"
                                    disabled={isLoading}
                                    onClick={() => setShowDeleteModal(false)}>

                                    {isLoading ? 'Please wait...' : 'No'}
                                </Button>
                                <Button variant='contained' type='submit'
                                    className="btn btn-danger w-100 mb-2"
                                    disabled={isLoading}>
                                    {isLoading ? 'Please wait...' : 'Yes'}
                                </Button>

                            </div>

                        </form>

                    </Container>

                </Modal.Body>

            </Modal>
            {/* Show create Modal */}
            <Modal centered show={showCreateModal} onHide={() => setShowCreateModal(false)} keyboard={false} >
                <Modal.Header closeButton>
                    <Modal.Title as="h6">Create Cashier</Modal.Title>
                </Modal.Header>
                <Modal.Body>
                    <Container fluid>
                        {err && <Alert variant="danger">{err}</Alert>}
                        <form onSubmit={handleCreateCashier}>
                            <div className="mb-3">
                                <Row>
                                    <Col sm={12} lg={6} md={6} xl={6}>
                                        <label className="form-label">First Name</label>
                                        <input type="text" id="input" className="form-control text-black"
                                            value={firstName} onChange={(e: any) => setFirstName(e.target.value)}
                                            placeholder="First Name" required />
                                    </Col>
                                    <Col sm={12} lg={6} md={6} xl={6}>
                                        <label className="form-label">Last Name</label>
                                        <input type="text" id="input" className="form-control text-black"
                                            value={lastName} onChange={(e: any) => setLastName(e.target.value)}
                                            placeholder="Last Name" required />
                                    </Col>
                                </Row>

                                <br />
                                <label className="form-label">Username</label>
                                <input type="text" id="input" className="form-control text-black"
                                    value={username} onChange={(e: any) => setUsername(e.target.value)}
                                    placeholder="Username" required />
                                <br />
                                <label className="form-label">Email</label>
                                <input type="text" id="input" className="form-control text-black"
                                    value={email} onChange={(e: any) => setEmail(e.target.value)}
                                    placeholder="Email" required />
                                <br />
                                <label className="form-label">Phone (including country code without + i.e 19874125125)</label>
                                <input type="text" id="input" className="form-control text-black"
                                    value={phone} onChange={(e: any) => setPhone(e.target.value)}
                                    placeholder="Phone" required />
                                <br />
                                <Button variant='contained' type='submit'
                                    className="btn btn-success w-100 mb-2"
                                    disabled={isLoading}>
                                    {isLoading ? 'Please wait...' : 'Submit'}
                                </Button>

                            </div>

                        </form>

                    </Container>

                </Modal.Body>

            </Modal>
        </>
    );
};
