"use client";
import React, { Fragment, useEffect, useState } from "react";
import { Card, Col, Row } from "react-bootstrap";
// import { BasicTable, Savetable, } from "../../../../../../shared/data/tables/datatablesdata";
import { BasicTable } from "./Table";
import Seo from "@/shared/layouts-components/seo/seo";
import PageHeader from "@/shared/layouts-components/page-header/pageheader";
// import React, { useEffect, useState } from 'react';
import axios from 'axios';
import { useRouter } from 'next/navigation';
import { getSession } from '@/app/utils/sessionData';
const Transactions = () => {
    const [session, setSessionState] = useState<any>(null);
    const [dashboardData, setDashboardData] = useState<any>([]);
    const [userData, setUserData] = useState<any>(null);
    const [data, setData] = useState<any>([]);
    const [filteredData, setFilteredData] = useState<any>([]);
    const [searchTerm, setSearchTerm] = useState('');
    const router = useRouter();

    const fetchSession = async () => {
        const sessionData = getSession();
        if (!sessionData?.token) {
            router.push('/');
        }
        setSessionState(sessionData);
    };

    const fetchDashboard = async () => {
        try {
            const token = localStorage.getItem('token') ?? '';
            const response = await axios.post('/api/dashboard', { token });
            if (response?.data?.status === 'success') {
                setDashboardData(response.data.data?.miscs || []);
            }
        } catch (e: any) {
            console.error('Error fetching dashboard:', e.message);
        }
    };

    const fetchUser = async () => {
        try {
            const token = localStorage.getItem('token') ?? ''
            const response = await axios.post('/api/getAdmin', { token })
            if (response?.data?.status != 'error') {
                if (response?.data?.role != 'Super' && response?.data?.is_loggedin == '0') {
                    const responseLogout = await axios.post('/api/logout', { token });
                    if (responseLogout?.data?.status === 'success') {
                        // setIsLoading(false);
                        localStorage.clear();
                        router.push('/');
                    } else {
                        console.log('Logout error');
                    }
                }
                setUserData(response?.data)
                setSessionState({ role: response?.data?.role, username: response?.data?.username })
                console.log('userData', response?.data)
            }
        } catch (e: any) {
            console.log('err', e.message)
        }
    }

    const fetchTxns = async () => {
        try {
            const token = localStorage.getItem('token') ?? '';
            const response = await axios.post('/api/cashiers', { token });
            if (response?.data?.status !== 'error') {
                const txns = response.data;
                setData(txns);
                setFilteredData(txns);
            }
        } catch (e: any) {
            console.error('Error fetching transactions:', e.message);
        }
    };

    useEffect(() => { fetchSession(); }, []);
    useEffect(() => { if (!dashboardData && !userData) { fetchDashboard(); fetchUser(); } }, [session]);
    useEffect(() => { fetchTxns(); }, []);


    return (
        <Fragment>
            <Seo title={"Cashiers"} />
            <PageHeader title='Cashiers' item='Home' active_item='Cashiers' />

            <Row>
                <Col xl={12}>
                    <Card className="custom-card">
                        <Card.Header>
                            {/* <div className="card-title">
                                Basic Datatable
                            </div> */}
                        </Card.Header>
                        <Card.Body>
                            <div className="table-responsive">
                                <BasicTable data={data} fetchTxns={fetchTxns} />
                            </div>
                        </Card.Body>
                    </Card>
                </Col>
            </Row>



        </Fragment>
    );
};
export default Transactions;
