"use client";
import React, { Fragment, useState, useEffect } from "react";
import { Card, Col, Row, ProgressBar, Button, Form, Dropdown, Table, Pagination, Container, Alert, Modal } from "react-bootstrap";
import Link from "next/link";
import { BudgetTask, MobileAppDesign, ProjectBudget, TASKS, WebsiteAppDesign, WebsiteDesign } from "../../../../shared/data/dashboard/dashboarddata";
import Pageheader from "@/shared/layouts-components/page-header/pageheader";
import Seo from "@/shared/layouts-components/seo/seo";
import { useRouter } from "next/navigation";
import axios from "axios";
import { getSession, setSession } from '@/app/utils/sessionData';
// import xhrAdapter from 'axios/lib/adapters/xhr';
const Dashboard = () => {
	const [session, setSession] = useState<any>();
	const [isManager, setIsManager] = useState<any>(false);
	const [dashboardData, setDashboardData] = useState<any>('');
	const [userData, setUserData] = useState<any>('');
	const [managers, setManagers] = useState<any>([]);
	const [showFillModal, setShowFillModal] = useState<any>(false)
	const [showEndShiftModal, setShowEndShiftModal] = useState<any>(false)

	const [showInitialModal, setShowInitialModal] = useState<any>(false)
	const [showResetModal, setShowResetModal] = useState<any>(false)
	const [showWithdrawModal, setShowWithdrawModal] = useState<any>(false);
	const [showShortModal, setShowShortModal] = useState<any>(false)
	const [shortAmount, setShortAmount] = useState<any>('');

	const [withdrawReason, setWithdrawReason] = useState<any>('');
	const [managerSelected, setManagerSelected] = useState<any>('');
	const [withAmount, setWithAmount] = useState<any>('');
	const [evidence, setEvidence] = useState<any>(null);
	const [selectedFileName, setSelectedFileName] = useState<any>('');
	const [selectedGDFileName, setSelectedGDFileName] = useState<any>('');
	const [selectedRSFileName, setSelectedRSFileName] = useState<any>('');
	const [selectedFSFileName, setSelectedFSFileName] = useState<any>('');

	const [gdEvidence, setGDEvidence] = useState<any>(null);
	const [fsEvidence, setFSEvidence] = useState<any>(null);
	const [rsEvidence, setRSEvidence] = useState<any>(null);

	const [fillAmount, setFillAmount] = useState<any>()
	const [initialAmount, setInitialAmount] = useState<any>()

	const [errorMessage, setErrorMessage] = useState<any>('')
	const [isLoading, setIsLoading] = useState<any>(false)

	const [showNameModal, setShowNameModal] = useState<any>(false) // State to control Name Selection Modal
	const [showOtpModal, setShowOtpModal] = useState<any>(false) // State to control OTP Modal
	const [selectedName, setSelectedName] = useState<any>('') // Store selected name
	const [otp, setOtp] = useState<any>('') // Store OTP input
	const [allowedOTP, setAllowedOTP] = useState<any>([]);
	const [err, setError] = useState("");
	const [uploadProgress, setUploadProgress] = useState<number | null>(null);
	const [values, setValues] = useState<any>({
		gdtp: '', gdtr: '', gdfb: '',
		fstp: '', fstr: '', fsfb: '',
		rstp: '', rstr: '', rsfb: ''
	});
	const handleInputChange = (e: any) => {
		const { name, value } = e.target;

		// Update input values
		setValues((prev: any) => {
			const updated = { ...prev, [name]: value };

			// Recalculate balances
			if (['gdtp', 'gdtr'].includes(name)) {
				updated.gdfb = calculate(updated.gdtp, updated.gdtr);
			} else if (['fstp', 'fstr'].includes(name)) {
				updated.fsfb = calculate(updated.fstp, updated.fstr);
			} else if (['rstp', 'rstr'].includes(name)) {
				updated.rsfb = calculate(updated.rstp, updated.rstr);
			}

			return updated;
		});
	};

	const calculate = (purchase: string, redeem: string) => {
		const p = parseFloat(purchase) || 0;
		const r = parseFloat(redeem) || 0;
		return (p - r);
	};
	const router = useRouter();

	const handleOTPSubmit = async (e: any) => {
		e.preventDefault()
		// Simulate OTP resend logic
		setIsLoading(true)
		try {
			// Close the name selection modal and show OTP modal
			const token = localStorage.getItem('token') ?? '';
			const response = await axios.post('/api/verifyEndOtp', { token, otp })
			console.log(response?.data)
			if (response?.data?.status !== 'success') {
				setIsLoading(false);
				setErrorMessage(response?.data?.message)
			} else {
				setIsLoading(false);
				setOtp('');
				setErrorMessage('');
				setShowEndShiftModal(true)
				// localStorage.setItem('otp_token', response?.data?.otpSent?.otp_token)
				// setShowNameModal(false)
				setShowOtpModal(false)
			}
		} catch (e: any) {
			console.log('err', e.message)
		}
	}
	const handleEndShiftSubmit = async (e: any) => {

		console.log(values, gdEvidence, fsEvidence, rsEvidence)
		e.preventDefault();
		setIsLoading(true);
		setErrorMessage('');
		setUploadProgress(0);

		try {
			const token = localStorage.getItem('token') ?? session?.token;

			const formData = new FormData();
			for (const [key, val] of Object.entries(values)) {
				formData.append(key, val as any);
			}
			formData.append('gdimage', gdEvidence);
			formData.append('fsimage', fsEvidence);
			formData.append('rsimage', rsEvidence);
			formData.append('token', token);
			// formData.append('values', JSON.stringify(values));

			const response = await axios.post(
				// `/api/saveEndShift`,
				`${process.env.NEXT_PUBLIC_API_BASE_URL}/saveEndShift`,
				formData,
				{
					headers: {
						'Content-Type': 'multipart/form-data',
						Authorization: `Bearer ${token}`,
					},
					onUploadProgress: (progressEvent) => {
						const percent = Math.round((progressEvent.loaded * 100) / (progressEvent.total || 1));
						console.log('uploadProgress', percent)
						setUploadProgress(percent);
					},
				}
			);

			console.log(response.data)
			if (response?.data?.status == 'success') {

				const response = await axios.post('/api/logout', { token });
				if (response?.data?.status === 'success') {

					localStorage.clear();
					router.push('/');
					setIsLoading(false);
				} else {
					setUploadProgress(null);

					console.log('Logout error');
				}
			} else {
				setIsLoading(false);
				setUploadProgress(null);

				setErrorMessage(response?.data?.message);
			}
		} catch (error) {
			console.error('Shift End error:', error);
			setErrorMessage('Something went wrong');
			setIsLoading(false);
		}
	}

	const handleInitialBalance = async (e: any) => {
		setIsLoading(true)
		e.preventDefault();
		try {
			const token = localStorage.getItem('token') ?? session?.token
			const data = {
				amount: initialAmount, token: token
			}
			console.log(data)
			const response = await axios.post('/api/initBalance', data)
			if (response?.data?.status != 'error') {
				fetchDashboard()
				setInitialAmount('')
				setIsLoading(false)
				setErrorMessage('')
				// setSuccessMessage('')
				setShowInitialModal(false)
			}
			else {
				setErrorMessage(response?.data?.message)
				setIsLoading(false)
			}

		} catch (e: any) {
			setIsLoading(false)

			console.log('err', e.message)
		}
	}
	const handleShortShift = async (e: any) => {
		setIsLoading(true)
		e.preventDefault();
		try {
			const token = localStorage.getItem('token') ?? session?.token
			const data = {
				amount: shortAmount, token: token
			}
			console.log(data)
			const response = await axios.post('/api/saveShort', data)
			if (response?.data?.status != 'error') {
				fetchDashboard()
				setShortAmount('')
				setIsLoading(false)
				setErrorMessage('')
				// setSuccessMessage('')
				setShowShortModal(false)
			}
			else {
				setErrorMessage(response?.data?.message)
				setIsLoading(false)
			}

		} catch (e: any) {
			setIsLoading(false)

			console.log('err', e.message)
		}
	}
	const handleFillBalance = async (e: any) => {
		setIsLoading(true)
		e.preventDefault();
		try {
			const token = localStorage.getItem('token') ?? session?.token
			const data = {
				amount: fillAmount, token: token
			}
			console.log(data)
			const response = await axios.post('/api/fillBalance', data)
			if (response?.data?.status != 'error') {
				fetchDashboard()
				setFillAmount('')
				setIsLoading(false)
				setErrorMessage('')
				// setSuccessMessage('')
				setShowFillModal(false)
			}
			else {
				setErrorMessage(response?.data?.message)
				setIsLoading(false)
			}

		} catch (e: any) {
			setIsLoading(false)

			console.log('err', e.message)
		}
	}
	// const handleWithdraw = async (e: any) => {
	// 	e.preventDefault();
	// 	setIsLoading(true);
	// 	setErrorMessage('');

	// 	try {
	// 		const token = localStorage.getItem('token') ?? session?.token;

	// 		const formData = new FormData();
	// 		formData.append('image', evidence);
	// 		formData.append('withamount', withAmount);
	// 		formData.append('manager', managerSelected);
	// 		formData.append('withreason', withdrawReason);
	// 		formData.append('token', token);

	// 		const response = await axios.post(
	// 			`/api/saveWithdraw`,
	// 			formData,
	// 			{
	// 				headers: {
	// 					'Content-Type': 'multipart/form-data',
	// 					Authorization: `Bearer ${token}`,
	// 				},
	// 			}
	// 		);

	// 		if (response?.data?.status !== 'error') {
	// 			fetchDashboard();
	// 			setIsLoading(false);
	// 			setShowWithdrawModal(false);
	// 			setWithAmount('')
	// 			setEvidence(null)
	// 		} else {
	// 			setErrorMessage(response?.data?.message || 'Withdrawal failed');
	// 			setIsLoading(false);
	// 		}
	// 	} catch (error: any) {
	// 		console.error('Withdrawal error:', error);
	// 		setErrorMessage('Something went wrong');
	// 		setIsLoading(false);
	// 	}
	// };

	const handleWithdraw = async (e: any) => {
		e.preventDefault();
		setIsLoading(true);
		setUploadProgress(0);
		setErrorMessage('');

		try {
			const token = localStorage.getItem('token') ?? session?.token;

			const formData = new FormData();
			formData.append('image', evidence);
			formData.append('withamount', withAmount);
			formData.append('manager', managerSelected);
			formData.append('withreason', withdrawReason);
			formData.append('token', token);

			const response = await axios.post(
				// `/api/saveWithdraw`,
				`${process.env.NEXT_PUBLIC_API_BASE_URL}/saveWithdraw`,
				formData,
				{
					headers: {
						'Content-Type': 'multipart/form-data',
						Authorization: `Bearer ${token}`,
					},
					onUploadProgress: (progressEvent) => {
						const percent = Math.round((progressEvent.loaded * 100) / (progressEvent.total || 1));
						console.log('uploadProgress', percent)
						setUploadProgress(percent);
					},
				}
			);

			if (response?.data?.status !== 'error') {
				fetchDashboard();
				setShowWithdrawModal(false);
				setWithAmount('');
				setEvidence(null);
				setSelectedFileName('');
				setUploadProgress(null);
			} else {
				setErrorMessage(response?.data?.message || 'Withdrawal failed');
			}
		} catch (error: any) {
			console.error('Withdrawal error:', error);
			setErrorMessage('Something went wrong');
		} finally {
			setIsLoading(false);
		}
	};
	const handleResetPos = async (e: any) => {
		setIsLoading(true)
		e.preventDefault();
		try {
			const token = localStorage.getItem('token') ?? session?.token
			const data = {
				token: token
			}
			console.log(data)
			const response = await axios.post('/api/resetPos', data)
			if (response?.data?.status != 'error') {
				fetchDashboard()
				setIsLoading(false)
				setErrorMessage('')
				// setSuccessMessage('')
				setShowResetModal(false)
			}
			else {
				setErrorMessage(response?.data?.message)
				setIsLoading(false)
			}

		} catch (e: any) {
			setIsLoading(false)

			console.log('err', e.message)
		}
	}
	const handleSendOTP = async (e: any) => {
		e.preventDefault();
		setIsLoading(true)

		try {
			const token = localStorage.getItem('token') ?? session?.token
			const response = await axios.post('/api/endOtp', { token });
			if (response?.data?.status != 'error') {
				fetchDashboard()
				const otp_allow = response?.data?.otpSelect?.otp_allow;
				const allowed = otp_allow.split(',').map((name: string) => name.trim().toLowerCase());
				setAllowedOTP(allowed);
				setIsLoading(false)
				setErrorMessage('')
				// setSuccessMessage('')
				setShowNameModal(true)
			}
			else {
				setErrorMessage(response?.data?.message)
				setIsLoading(false)
			}
			// setIsLoading(false)
			setIsLoading(false)

		} catch (e: any) {
			setIsLoading(false)
			console.log('err', e.message);
		}

	};

	const handleNameSelect = async (name: any) => {
		// Store the selected name
		setSelectedName(name)
		setIsLoading(true)
		// Close the name selection modal and show OTP modal
		const token = localStorage.getItem('token') ?? '';
		const response = await axios.post('/api/sendEndOtp', { selected: name, token })
		console.log(response?.data)
		if (response?.data?.status !== 'success') {
			setIsLoading(false);
			setErrorMessage(response?.data?.message)
		} else {
			setIsLoading(false);

			setErrorMessage('');
			// localStorage.setItem('otp_token', response?.data?.otpSent?.otp_token)
			setShowNameModal(false)
			setShowOtpModal(true)
		}
		console.log(name)
	}
	const handleResendOTP = async () => {
		// Simulate OTP resend logic
		setIsLoading(true)
		// Close the name selection modal and show OTP modal
		const token = localStorage.getItem('token') ?? '';
		const response = await axios.post('/api/resendEndOtp', { selected: selectedName, token })
		console.log(response?.data)
		if (response?.data?.status !== 'success') {
			setIsLoading(false);
			setErrorMessage(response?.data?.message)
		} else {
			setIsLoading(false);

			setErrorMessage('');
			// localStorage.setItem('otp_token', response?.data?.otpSent?.otp_token)
			setShowNameModal(false)
			setShowOtpModal(true)
		}
	}
	const fetchSession = async () => {
		const sessionData = getSession()
		if (!sessionData?.token) {
			router.push('/')
		}
		if (sessionData?.role == 'Manager') {
			setIsManager(true)
		}
		setSession(sessionData)
	}
	const fetchDashboard = async () => {
		try {
			const token = localStorage.getItem('token') ?? ''
			const response = await axios.post('/api/dashboard', { token })
			if (response?.data?.status == 'success') {
				setDashboardData(response?.data?.data)
				setManagers(response?.data?.data?.managers);
				if (!response?.data?.data?.miscs) {
					setShowInitialModal(true);
				}
				console.log('dbData', response?.data?.data)
			}
		} catch (e: any) {
			console.log('err', e.message)
		}
	}
	const fetchUser = async () => {
		try {
			const token = localStorage.getItem('token') ?? ''
			const response = await axios.post('/api/getAdmin', { token })
			if (response?.data?.status != 'error') {
				if (response?.data?.role != 'Super' && response?.data?.is_loggedin == '0') {
					const responseLogout = await axios.post('/api/logout', { token });
					if (responseLogout?.data?.status === 'success') {
						setIsLoading(false);
						localStorage.clear();
						router.push('/');
					} else {
						console.log('Logout error');
					}
				}
				setUserData(response?.data)
				setSession({ role: response?.data?.role, username: response?.data?.username })
				console.log('userData', response?.data)
			}
		} catch (e: any) {
			console.log('err', e.message)
		}
	}
	useEffect(() => {
		fetchSession();
	}, [])

	useEffect(() => {
		if (!dashboardData && !userData) {
			fetchDashboard()
			fetchUser();
		}
	}, [session])
	useEffect(() => {
		if (withdrawReason === 'Manager Took' && !managerSelected && managers.length > 0) {
			setManagerSelected(managers[0].username)
		}
	}, [withdrawReason, managerSelected, managers])

	// console.log(allowedOTP)
	return (
		<Fragment>
			<Seo title={"Dashboard"} />
			<Pageheader title="Welcome To Dashboard" item="Home" active_item="Dashboard" />
			{/* <!--Row--> */}
			<Row className="row-sm">
				<Col sm={12} lg={12} xl={12}>
					<Row className=" row-sm  mt-lg-3">
						<Col sm={12} lg={12} xl={12}>
							<Card className="bg-primary custom-card card-box">
								<Card.Body className="p-4">
									<Row className="align-items-center">
										<Col sm={{ offset: 0 }} xl={{ offset: 0 }} className="col-xl-12 col-sm-6 col-12 " >
											<h4 className="d-flex justify-content-center flex-column align-items-center">
												<span className="fw-bold text-fixed-white">Welcome {userData && userData?.username ? userData?.username : 'Loading...'}</span>
												<br />
												<span className="fw-bold text-fixed-white">Balance: {dashboardData && dashboardData?.miscs?.initial_amount ? `$${dashboardData?.miscs?.initial_amount}` : 'Loading...'}</span>
												{isManager && (
													<>
														<br />
														<div className="col-xl-12 col-12 text-center">
															<span className="fw-bold text-fixed-white">Owed: {dashboardData && dashboardData?.owed == 0 ? '$' + 0 : (dashboardData?.owed ? `$${dashboardData?.owed}` : 'Loading...')}</span>
														</div>
													</>
												)}
											</h4>

										</Col>
									</Row>
								</Card.Body>
							</Card>
						</Col>
					</Row>
					{/* <!--Row --> */}
					<Row>
						<Col sm={12} lg={4} xl={4}>
							<Button className="w-100 btn btn-danger mb-4" onClick={handleSendOTP}>End Shift</Button>
						</Col>
						<Col sm={12} lg={4} xl={4}>
							<Button className="w-100 btn btn-danger mb-4" onClick={() => setShowWithdrawModal(true)}>Withdraw</Button>
						</Col>
						<Col sm={12} lg={4} xl={4}>
							<Button className="w-100 btn btn-success mb-4" onClick={() => setShowFillModal(true)}>Fill</Button>
						</Col>
					</Row>
					<Row>
						<Col sm={12} lg={4} xl={4}>
							<Button className="w-100 btn btn-danger mb-4" onClick={() => setShowShortModal(true)}>Short Shift</Button>
						</Col>
						<Col sm={12} lg={4} xl={4}>
							<Button className="w-100 btn btn-danger mb-4" onClick={() => setShowResetModal(true)}>Reset POS</Button>
						</Col>
					</Row>
				</Col>
			</Row >
			{/* <!-- Row end --> */}
			{/* Show Name Modal */}
			<Modal centered show={showNameModal} onHide={() => setShowNameModal(false)} backdrop="static" keyboard={false}>
				<Modal.Header closeButton>
					<Modal.Title as="h6">Choose whom to send OTP</Modal.Title>
				</Modal.Header>
				<Modal.Body>
					<Container fluid>
						{err && <Alert variant="danger">{err}</Alert>}
						{allowedOTP.map((name: any) => {
							const capitalizedName = name.charAt(0).toUpperCase() + name.slice(1);

							const isThisButtonLoading = isLoading && selectedName === capitalizedName;

							return (
								<Button variant='contained'
									key={name}
									className="btn btn-primary w-100 mb-2"
									onClick={() => handleNameSelect(capitalizedName)}
									disabled={isLoading}>
									{isThisButtonLoading ? `Sending to ${capitalizedName}...` : capitalizedName}
								</Button>

							);
						})}
					</Container>

				</Modal.Body>

			</Modal>
			{/* Show OTP Modal */}
			<Modal centered show={showOtpModal} onHide={() => setShowOtpModal(false)} backdrop="static" keyboard={false}>
				<Modal.Header closeButton>
					<Modal.Title as="h6">OTP has been sent to {selectedName}&apos;s phone no</Modal.Title>
				</Modal.Header>
				<Modal.Body>
					<Container fluid>
						{err && <Alert variant="danger">{err}</Alert>}
						<form onSubmit={handleOTPSubmit}>
							<div className="mb-3">
								<input type="text" id="input" className="form-control text-black" value={otp} onChange={(e: any) => setOtp(e.target.value)} placeholder="OTP" required />
								{/* <CustomTextField autoFocus fullWidth label='Enter OTP' placeholder='*****' value={otp} onChange={(e: any) => setOtp(e.target.value)} /> */}
								<br />
								<Button variant='contained' type='submit'
									className="btn btn-primary w-100 mb-2"
									disabled={isLoading}>
									{isLoading ? 'Please wait...' : 'Verify OTP'}
								</Button>

							</div>

						</form>
						<Button variant='contained' type='button' color='secondary' onClick={handleResendOTP}
							className="btn btn-light w-100 mb-2"
							disabled={isLoading} >
							{isLoading ? 'Please wait...' : 'Resend OTP'}
						</Button>
					</Container>

				</Modal.Body>
				{/* <Modal.Footer>
          <Button variant="secondary" onClick={() => setShowNameModal(false)}>
            Close
          </Button>
          <Button variant="primary">Understood</Button>
        </Modal.Footer> */}
			</Modal>
			{/* Show Initial Modal */}
			<Modal centered show={showInitialModal} onHide={() => setShowInitialModal(false)} backdrop="static" keyboard={false}>
				<Modal.Header>
					<Modal.Title as="h6">Initial Balance</Modal.Title>
				</Modal.Header>
				<Modal.Body>
					<Container fluid>
						{err && <Alert variant="danger">{err}</Alert>}
						<form onSubmit={handleInitialBalance}>
							<div className="mb-3">
								<label className="form-label">Amount</label>

								<input type="text" id="input" className="form-control text-black"
									value={initialAmount} onChange={(e: any) => setInitialAmount(e.target.value)} placeholder="Amount" required />
								{/* <CustomTextField autoFocus fullWidth label='Enter OTP' placeholder='*****' value={otp} onChange={(e: any) => setOtp(e.target.value)} /> */}
								<br />
								<Button variant='contained' type='submit'
									className="btn btn-primary w-100 mb-2"
									disabled={isLoading}>
									{isLoading ? 'Please wait...' : 'Submit'}
								</Button>

							</div>

						</form>

					</Container>

				</Modal.Body>

			</Modal>
			{/* Show fill Modal */}
			<Modal centered show={showFillModal} onHide={() => setShowFillModal(false)} keyboard={false} >
				<Modal.Header closeButton>
					<Modal.Title as="h6">Fill - Current Balance ({dashboardData && dashboardData?.miscs?.initial_amount ? `$${dashboardData?.miscs?.initial_amount}` : 'Loading...'})</Modal.Title>
				</Modal.Header>
				<Modal.Body>
					<Container fluid>
						{err && <Alert variant="danger">{err}</Alert>}
						<form onSubmit={handleFillBalance}>
							<div className="mb-3">
								<label className="form-label">Amount</label>

								<input type="text" id="input" className="form-control text-black" value={fillAmount} onChange={(e: any) => setFillAmount(e.target.value)} placeholder="Amount" required />
								{/* <CustomTextField autoFocus fullWidth label='Enter OTP' placeholder='*****' value={otp} onChange={(e: any) => setOtp(e.target.value)} /> */}
								<br />
								<Button variant='contained' type='submit'
									className="btn btn-success w-100 mb-2"
									disabled={isLoading}>
									{isLoading ? 'Please wait...' : 'Submit'}
								</Button>

							</div>

						</form>

					</Container>

				</Modal.Body>

			</Modal>
			{/* Show reset Modal */}
			<Modal centered show={showResetModal} onHide={() => setShowResetModal(false)} keyboard={false} >
				<Modal.Header closeButton>
					<Modal.Title as="h6">Reset POS</Modal.Title>
				</Modal.Header>
				<Modal.Body>
					<Container fluid>
						{err && <Alert variant="danger">{err}</Alert>}
						<form onSubmit={handleResetPos}>
							<div className="mb-3">
								<p>Are you sure you want to reset the POS?</p>
								{/* <CustomTextField autoFocus fullWidth label='Enter OTP' placeholder='*****' value={otp} onChange={(e: any) => setOtp(e.target.value)} /> */}
								<br />
								<Button variant='contained' type='button'
									className="btn btn-light w-100 mb-2"
									disabled={isLoading}
									onClick={() => setShowResetModal(false)}>

									{isLoading ? 'Please wait...' : 'No'}
								</Button>
								<Button variant='contained' type='submit'
									className="btn btn-danger w-100 mb-2"
									disabled={isLoading}>
									{isLoading ? 'Please wait...' : 'Yes'}
								</Button>

							</div>

						</form>

					</Container>

				</Modal.Body>

			</Modal>
			{/* Show withdraw Modal */}
			<Modal centered show={showWithdrawModal} onHide={() => setShowWithdrawModal(false)} keyboard={false}>
				<Modal.Header closeButton>
					<Modal.Title as="h6">
						Withdraw - Current Balance (
						{dashboardData?.miscs?.initial_amount
							? `$${dashboardData.miscs.initial_amount}`
							: 'Loading...'}
						)
					</Modal.Title>
				</Modal.Header>

				<Modal.Body>
					<Container fluid>

						{errorMessage && <Alert variant="danger" className="text-center mb-3">{errorMessage}</Alert>}

						<form onSubmit={handleWithdraw} encType="multipart/form-data">
							{/* Withdraw Reason */}
							<div className="mb-3">
								<label className="form-label">Withdraw Reason</label>
								<div className="form-check">
									<input
										className="form-check-input"
										type="radio"
										name="withreason"
										value="Office Use"
										id="office"
										checked={withdrawReason === 'Office Use'}
										onChange={(e) => {
											setWithdrawReason(e.target.value);
											setManagerSelected('');
										}}
										required
									/>
									<label className="form-check-label" htmlFor="office">
										&nbsp;Office Use
									</label>
								</div>

								<div className="form-check">
									<input
										className="form-check-input"
										type="radio"
										name="withreason"
										value="Manager Took"
										id="manager"
										checked={withdrawReason === 'Manager Took'}
										onChange={(e) => {
											setWithdrawReason(e.target.value);
											setManagerSelected('');
										}}
									/>
									<label className="form-check-label" htmlFor="manager">
										&nbsp;Manager Took
									</label>
								</div>
							</div>

							{/* Manager Select */}
							{withdrawReason === 'Manager Took' && (
								<div className="mb-3">
									<label className="form-label">Manager</label>
									<select
										className="form-select"
										name="manager"
										value={managerSelected}
										onChange={(e) => setManagerSelected(e.target.value)}
										required
									>
										<option value="">Select Manager</option>
										{managers.map((manager: any) => (
											<option key={manager.username} value={manager.username}>
												{manager.username}
											</option>
										))}
									</select>
								</div>
							)}

							{/* Amount */}
							<div className="mb-3">
								<label className="form-label">Amount</label>
								<input
									type="text"
									className="form-control text-black"
									value={withAmount}
									onChange={(e) => setWithAmount(e.target.value)}
									placeholder="Enter amount"
									required
								/>
							</div>

							{/* Evidence Upload */}
							<div className="mb-3">
								<label className="form-label">Evidence</label>
								<div className="d-flex align-items-center">

									<input
										type="file"
										className="form-control"
										onChange={(e) => {
											const file = e.target.files?.[0];
											if (file) {
												setEvidence(file);
												setSelectedFileName(file.name);
											} else {
												setEvidence(null);
												setSelectedFileName('');
											}
										}}
										required
									/>

									{/* {selectedFileName && (
										<span className="text-muted small">{selectedFileName}</span>
									)} */}
								</div>
							</div>

							{/* Submit Button */}
							<div className="mb-3 mt-4">
								<Button
									type="submit"
									variant="danger"
									className="w-100"
									disabled={isLoading}
								>
									{isLoading ? 'Please wait...' : 'Withdraw'}
								</Button>
							</div>
						</form>
						{uploadProgress !== null && (
							<div className="progress mt-2">
								<div
									className="progress-bar progress-bar-striped progress-bar-animated"
									role="progressbar"
									style={{ width: `${uploadProgress}%` }}
								>
									{uploadProgress}%
								</div>
							</div>
						)}
					</Container>
				</Modal.Body>
			</Modal>
			{/* Show short Modal */}
			<Modal centered show={showShortModal} onHide={() => setShowShortModal(false)} keyboard={false} >
				<Modal.Header closeButton>
					<Modal.Title as="h6">Short Shift</Modal.Title>
				</Modal.Header>
				<Modal.Body>
					<Container fluid>
						{err && <Alert variant="danger">{err}</Alert>}
						<form onSubmit={handleShortShift}>
							<div className="mb-3">
								<label className="form-label">Amount</label>

								<input type="text" id="input" className="form-control text-black" value={shortAmount} onChange={(e: any) => setShortAmount(e.target.value)} placeholder="Amount" required />
								{/* <CustomTextField autoFocus fullWidth label='Enter OTP' placeholder='*****' value={otp} onChange={(e: any) => setOtp(e.target.value)} /> */}
								<br />
								<Button variant='contained' type='submit'
									className="btn btn-danger w-100 mb-2"
									disabled={isLoading}>
									{isLoading ? 'Please wait...' : 'Submit'}
								</Button>

							</div>

						</form>

					</Container>

				</Modal.Body>

			</Modal>
			{/* Show End Modal */}
			<Modal centered show={showEndShiftModal} onHide={() => setShowEndShiftModal(false)} backdrop="static" keyboard={false}>
				<Modal.Header closeButton>
					<Modal.Title as="h5">End Shift</Modal.Title>
				</Modal.Header>

				<Modal.Body>
					<Container fluid>
						<form onSubmit={handleEndShiftSubmit} encType="multipart/form-data">

							{/* GOLDEN DRAGON */}
							<div className="mb-4">
								<h4>Golden Dragon</h4>
								<Row>
									<Col sm={12} lg={6} md={6}>
										<input
											type="text"
											className="form-control mb-3"
											placeholder="Total Purchases ($)"
											name="gdtp"
											value={values.gdtp}
											onChange={handleInputChange}
											required
										/>
									</Col>
									<Col sm={12} lg={6} md={6}>

										<input
											type="text"
											className="form-control mb-3"
											placeholder="Total Redeems ($)"
											name="gdtr"
											value={values.gdtr}
											onChange={handleInputChange}
											required
										/>
									</Col>
								</Row>
								<input
									type="text"
									className="form-control mb-3"
									placeholder="Final Balance ($)"
									name="gdfb"
									value={values.gdfb}
									readOnly
								/>
								<label className="form-label">Receipt Image:</label>
								<div className="d-flex align-items-center">

									<input
										type="file"
										className="form-control"
										onChange={(e) => {
											const file = e.target.files?.[0];
											if (file) {
												setGDEvidence(file);
												setSelectedGDFileName(file.name);
											}
										}}
										required
									/>


								</div>
								{/* <div className="mb-2">
									<Form.Group controlId="gdReceipt">

										<Form.Label className="btn btn-secondary">
											Upload File
											<Form.Control
												type="file"
												hidden
												name="gdimage"
												onChange={(e) => {
													// const file = e.target.files?.[0];
													const file = e.target.files?.[0];

													if (file) {
														setGDEvidence(file);
														setSelectedGDFileName(file.name);
													}
												}}
												required
											/>
										</Form.Label>
									</Form.Group>
								</div>
								{selectedGDFileName && (
									<span className="ms-2 text-sm text-muted">{selectedGDFileName}</span>
								)} */}
							</div>

							<hr />

							{/* FIRE STORM */}
							<div className="mb-4">
								<h4>Fire Storm</h4>
								<Row>
									<Col sm={12} lg={6} md={6}>
										<input
											type="text"
											className="form-control mb-3"
											placeholder="Total Purchases ($)"
											name="fstp"
											value={values.fstp}
											onChange={handleInputChange}
											required
										/>
									</Col>
									<Col sm={12} lg={6} md={6}>

										<input
											type="text"
											className="form-control mb-3"
											placeholder="Total Redeems ($)"
											name="fstr"
											value={values.fstr}
											onChange={handleInputChange}
											required
										/>
									</Col>
								</Row>
								<input
									type="text"
									className="form-control mb-3"
									placeholder="Final Balance ($)"
									name="fsfb"
									value={values.fsfb}
									readOnly
								/>
								<label className="form-label">Receipt Image:</label>
								<div className="d-flex align-items-center">

									<input
										type="file"
										className="form-control"
										onChange={(e) => {
											const file = e.target.files?.[0];
											if (file) {
												setFSEvidence(file);
												setSelectedFSFileName(file.name);
											}
										}}
										required
									/>


								</div>
								{/* <div className="mb-2">
									<Form.Group controlId="fsReceipt">
										<Form.Label className="btn btn-secondary">
											Upload File
											<Form.Control
												type="file"
												hidden
												name="fsimage"
												onChange={(e) => {
													const file = e.target.files?.[0];
													if (file) {
														setFSEvidence(file);
														setSelectedFSFileName(file.name);
													}
												}}
												required
											/>
										</Form.Label>
									</Form.Group>
								</div>
								{selectedFSFileName && (
									<span className="ms-2 text-sm text-muted">{selectedFSFileName}</span>
								)} */}
							</div>

							<hr />

							{/* RIVER SWEEPS */}
							<div className="mb-4">
								<h4>River Sweeps</h4>
								<Row>
									<Col sm={12} lg={6} md={6}>
										<input
											type="text"
											className="form-control mb-3"
											placeholder="Total Purchases ($)"
											name="rstp"
											value={values.rstp}
											onChange={handleInputChange}
											required
										/>
									</Col>
									<Col sm={12} lg={6} md={6}>

										<input
											type="text"
											className="form-control mb-3"
											placeholder="Total Redeems ($)"
											name="rstr"
											value={values.rstr}
											onChange={handleInputChange}
											required
										/>
									</Col>
								</Row>
								<input
									type="text"
									className="form-control mb-3"
									placeholder="Final Balance ($)"
									name="rsfb"
									value={values.rsfb}
									readOnly
								/>
								<label className="form-label">Receipt Image:</label>
								<div className="d-flex align-items-center">

									<input
										type="file"
										className="form-control"
										onChange={(e) => {
											const file = e.target.files?.[0];
											if (file) {
												setRSEvidence(file);
												setSelectedRSFileName(file.name);
											}
										}}
										required
									/>


								</div>
								{/* <div className="mb-2">
									<Form.Group controlId="rsReceipt">
										<Form.Label className="btn btn-secondary">
											Upload File
											<Form.Control
												type="file"
												hidden
												name="rsimage"
												onChange={(e) => {
													const file = e.target.files?.[0];
													if (file) {
														setRSEvidence(file);
														setSelectedRSFileName(file.name);
													}
												}}
												required
											/>
										</Form.Label>
									</Form.Group>
								</div>
								{selectedRSFileName && (
									<span className="ms-2 text-sm text-muted">{selectedRSFileName}</span>
								)} */}
							</div>

							{/* Submit */}
							<div className="mb-3 mt-4">
								<Button
									variant="danger"
									type="submit"
									className="w-100"
									disabled={isLoading}
								>
									{isLoading ? 'Processing... Please wait' : 'End Shift'}
								</Button>
							</div>

						</form>
						{uploadProgress !== null && (
							<div className="progress mt-2">
								<div
									className="progress-bar progress-bar-striped progress-bar-animated"
									role="progressbar"
									style={{ width: `${uploadProgress}%` }}
								>
									{uploadProgress}%
								</div>
							</div>
						)}
					</Container>
				</Modal.Body>
			</Modal>

		</Fragment >
	);
};

export default Dashboard;
