import { NextResponse } from 'next/server';
import axios from 'axios';
import FormData from 'form-data';
import fs from 'fs';
import path from 'path';

export async function POST(req) {
  try {
 
    const formData = await req.formData();

    const token = formData.get('token');
    const withAmount = formData.get('withamount');
    const withReason = formData.get('withreason');
    const manager = formData.get('manager');
    const image = formData.get('image');

    if (!image) {
      return NextResponse.json({ status: 'error', message: 'Image is required' }, { status: 400 });
    }

    const imageBuffer = image instanceof Buffer ? image : Buffer.from(await image.arrayBuffer());

    const backendFormData = new FormData();

    backendFormData.append('image', imageBuffer, image.name);
    backendFormData.append('withamount', withAmount);
    backendFormData.append('manager', manager);
    backendFormData.append('withreason', withReason);
    backendFormData.append('token', token); 

    const response = await axios.post(
      `${process.env.NEXT_PUBLIC_API_BASE_URL}/saveWithdraw`, 
      backendFormData,
      {
        headers: {
          'Content-Type': 'multipart/form-data', 
          'Authorization': `Bearer ${token}`
        },
      }
    );

  
    return NextResponse.json(response.data);
  } catch (error) {
    console.error('Error in saving withdrawal:', error);
    return NextResponse.json({ status: 'error', message: 'Failed to process the request' }, { status: 500 });
  }
}

export const config = {
  api: {
    bodyParser: false,
  },
  maxBodySize: '20mb', // 📢 increase to 20MB or more
};