"use client";
const { basePath } = require("@/next.config");
// import { auth } from '@/shared/firebase/firebase';
// import Link from "next/link";
import { useRouter } from "next/navigation";
import { Fragment, useState, useEffect } from "react";
import { Alert, Card, Col, Nav, OverlayTrigger, Row, Tab, Tooltip, Form, Button, Modal, Container } from "react-bootstrap";
import { useForm } from "react-hook-form";
import { getSession } from '@/app/utils/sessionData'
import axios from 'axios';
export default function Home() {

  const [username, setUsername] = useState('')
  const [password, setPassword] = useState('')

  // const [passwordshow, setpasswordshow] = useState(false);
  const [passwordshow1, setpasswordshow1] = useState(false);

  const [err, setError] = useState("");
  const [allowedOTP, setAllowedOTP] = useState([]);
  const [isLoading, setIsLoading] = useState(false);
  const [otp, setOtp] = useState('');
  const [showNameModal, setShowNameModal] = useState(false)
  const [showOtpModal, setShowOtpModal] = useState(false);
  const [selectedName, setSelectedName] = useState('')


  //let { basePath }:any = nextConfig;
  const router = useRouter();
  const fetchSession = async () => {
    const sessionData = getSession()
    if (sessionData?.token) {
      router.push('/dashboard')
    }
  }
  useEffect(() => {
    fetchSession();
  }, [])
  const onSubmit = async (e: any) => {
    // console.log(data)
    e.preventDefault();
    setIsLoading(true);
    try {

      // Handle login (replace with actual logic)
      console.log('Login attempt', { username, password })
      const response = await axios.post('/api/login', { username, password })
      console.log(response?.data)
      if (response?.data?.status !== 'success') {
        setIsLoading(false);
        setError(response?.data?.message)
      } else {
        setIsLoading(false);

        setError('');
        const otp_allow = response?.data?.otpSelect?.otp_allow;
        const allowed = otp_allow.split(',').map((name: string) => name.trim().toLowerCase());
        localStorage.setItem('admin_id', response?.data?.otpSelect?.userid)
        setAllowedOTP(allowed);
        // setAllowedOTP(response?.data?.otpSelect?.otp_allow)
        setShowNameModal(true)
      }
    } catch (e: any) {
      console.log('err', e.message)
    }
    // console.log(username, password)
  };
  const handleNameSelect = async (name: any) => {
    // Store the selected name
    setSelectedName(name)
    setIsLoading(true)
    try {

      // Close the name selection modal and show OTP modal
      const admin_id = localStorage.getItem('admin_id') ?? '';
      const response = await axios.post('/api/sendOtp', { admin_id, selected: name })
      console.log(response?.data)
      if (response?.data?.status !== 'success') {
        setIsLoading(false);
        setError(response?.data?.message)
        console.log("msg", response?.data?.message)

      } else {
        setIsLoading(false);
        // console.log("msg", response?.data?.message)

        setError('');
        localStorage.setItem('otp_token', response?.data?.otpSent?.otp_token)
        setShowNameModal(false)
        setShowOtpModal(true)
      }
      console.log(name)
    } catch (e: any) {
      console.log('err', e.message)
    }
  }

  const handleOTPSubmit = async (e: any) => {
    e.preventDefault()
    setIsLoading(true)
    try {

      const otp_token = localStorage.getItem('otp_token') ?? '';

      // Handle OTP verification (replace with actual API call)
      console.log('OTP Submitted:', otp)
      const response = await axios.post('/api/verifyOtp', { otp_token, otp })
      console.log(response?.data)
      if (response?.data?.status !== 'success') {
        setIsLoading(false);
        setError(response?.data?.message)
        setOtp('');

      } else {
        localStorage.removeItem('otp_token');
        localStorage.setItem('token', response?.data?.token)
        localStorage.setItem('username', response?.data?.username)
        localStorage.setItem('role', response?.data?.role)


        setIsLoading(false);
        setOtp('');

        setShowOtpModal(false)
        setError('');
        router.push('/dashboard')
        // const token = localStorage.getItem('token') ?? '';
        // const responsex = await axios.post('/api/getAdmin', { token })
        // console.log(responsex?.data)
        // if (responsex?.data?.status !== 'success') {
        // } else {
        //   // console.log()
        // }
      }
    } catch (e: any) {
      console.log('err', e.message)
    }

  }

  const handleResendOTP = async () => {
    // Simulate OTP resend logic
    setIsLoading(true)
    try {

      // Close the name selection modal and show OTP modal
      const admin_id = localStorage.getItem('admin_id') ?? '';
      const response = await axios.post('/api/resendOtp', { admin_id, selected: selectedName })
      console.log(response?.data)
      if (response?.data?.status !== 'success') {
        setIsLoading(false);
        setError(response?.data?.message)
      } else {
        setIsLoading(false);

        setError('');
        localStorage.setItem('otp_token', response?.data?.otpSent?.otp_token)
        setShowNameModal(false)
        setShowOtpModal(true)
      }
    } catch (e: any) {
      console.log('err', e.message)
    }

  }
  return (
    <Fragment>
      <html>
        <head>
          <title>Login - SweepStake Admin</title>
        </head>
        <body className="authentication-background">
          <div className="page main-signin-wrapper">

            <Row className="signpages text-center">
              <Col md={12}>
                <Tab.Container id="left-tabs-example" defaultActiveKey="first">
                  {/* <Nav variant="pills" className='d-inline-flex bg-white p-2 rounded-2'>
                  
                    <Nav.Item><OverlayTrigger overlay={<Tooltip>Nextjs</Tooltip>}><Nav.Link eventKey="first"><img src={`${process.env.NODE_ENV === "production" ? basePath : ""}/assets/images/brand-logos/nextjslogo.png`} /></Nav.Link></OverlayTrigger></Nav.Item>
                    <Nav.Item><OverlayTrigger overlay={<Tooltip>Firebase</Tooltip>}><Nav.Link eventKey="second"><img src={`${process.env.NODE_ENV === "production" ? basePath : ""}/assets/images/brand-logos/firbase.png`} /></Nav.Link></OverlayTrigger></Nav.Item>
                  
                  </Nav> */}
                  <Tab.Content>

                    <Tab.Pane eventKey="first">
                      <Card className="mb-0">
                        <Row className="row-sm">

                          <Col lg={6} xl={5} className="d-none d-lg-block text-center bg-primary details">
                            <div className="mt-5 pt-4 p-2 position-relative text-center">
                              {/* <Link scroll={false} href={"/dashboard/dashboard/"}><img src={`${process.env.NODE_ENV === "production" ? basePath : ""}/assets/images/brand-logos/desktop-white.png`} className="header-brand-img mb-4" alt="logo" /></Link> */}
                              <div className="clearfix"></div>
                              <img src={`${process.env.NODE_ENV === "production" ? basePath : ""}/assets/images/svgs/user.svg`} className="ht-100 mb-0" alt="user" />
                              <h5 className="mt-4">SweepStake</h5>
                              <span className="text-white-6 fs-13 mb-5 mt-xl-0">Welcome to SweepStake Admin</span>
                            </div>
                          </Col>
                          <Col lg={6} xl={7} xs={12} sm={12} className="login_form ">
                            <div className="main-container container-fluid">
                              <Row className="row-sm">
                                <Card.Body className="mt-2 mb-2">
                                  {/* <img src={`${process.env.NODE_ENV === "production" ? basePath : ""}/assets/images/brand-logos/desktop-white.png`} className="d-lg-none header-brand-img text-start float-start mb-4 error-logo-light" alt="logo" />
                                  <img src={`${process.env.NODE_ENV === "production" ? basePath : ""}/assets/images/brand-logos/desktop-logo.png`} className="d-lg-none header-brand-img text-start float-start mb-4 error-logo" alt="logo" /> */}
                                  <div className="clearfix"></div>
                                  <form onSubmit={onSubmit}>
                                    <h5 className="text-start mb-2">Signin to Your Account</h5>
                                    <br />
                                    {/* <p className="mb-4 text-muted fs-13 ms-0 text-start">Signin to create, discover and connect with the global community</p> */}
                                    {err && <Alert variant="danger">{err}</Alert>}
                                    <Form.Group className="text-start form-group">
                                      <Form.Label>Username</Form.Label>
                                      <input type="text" className="form-control" id="signin-username" placeholder="username" name="username"
                                        value={username}
                                        onChange={(e) => setUsername(e.target.value)}
                                        required />
                                    </Form.Group>
                                    <div className="text-start form-group">
                                      <Form.Label>Password</Form.Label>
                                      <div className="input-group">
                                        <input className="form-control" id="signin-password" placeholder="password" name="password"
                                          type={(passwordshow1) ? "text" : "password"}
                                          value={password}
                                          onChange={(e) => setPassword(e.target.value)}
                                          required />

                                        <button className="btn btn-light bg-transparent" type="button"
                                          onClick={() => setpasswordshow1(!passwordshow1)} id="button-addon2">
                                          <i className={`${passwordshow1 ? "ri-eye-line" : "ri-eye-off-line"} align-middle`}></i></button>
                                      </div>
                                    </div>
                                    <div className="d-grid mt-4">
                                      <input type="submit"
                                        defaultValue="Sign In"
                                        value={isLoading ? 'Please wait...' : 'Sign In'}
                                        className="btn btn-primary" disabled={isLoading} />
                                    </div>
                                  </form>
                                  {/* <div className="text-start mt-5 ms-0">
                                    <div className="mb-1"><Link scroll={false} href={"/authentication/resetpassword/"}>Forgot password?</Link></div>
                                    <div>Don't have an account? <Link scroll={false} href={"/authentication/signup/"}>Register Here</Link></div>
                                  </div> */}
                                </Card.Body>
                              </Row>
                            </div>
                          </Col>

                        </Row>
                      </Card>
                    </Tab.Pane>
                  </Tab.Content>
                </Tab.Container>
              </Col>
            </Row>
          </div>
        </body>
      </html>
      <Modal centered show={showNameModal} onHide={() => setShowNameModal(false)} backdrop="static" keyboard={false}>
        <Modal.Header closeButton>
          <Modal.Title as="h6">Choose whom to send OTP</Modal.Title>
        </Modal.Header>
        <Modal.Body>
          <Container fluid>
            {err && <Alert variant="danger">{err}</Alert>}
            {allowedOTP.map((name: any) => {
              const capitalizedName = name.charAt(0).toUpperCase() + name.slice(1);

              const isThisButtonLoading = isLoading && selectedName === capitalizedName;

              return (
                <Button variant='contained'
                  key={name}
                  className="btn btn-primary w-100 mb-2"
                  onClick={() => handleNameSelect(capitalizedName)}
                  disabled={isLoading}>
                  {isThisButtonLoading ? `Sending to ${capitalizedName}...` : capitalizedName}
                </Button>

              );
            })}
          </Container>

        </Modal.Body>
        {/* <Modal.Footer>
          <Button variant="secondary" onClick={() => setShowNameModal(false)}>
            Close
          </Button>
          <Button variant="primary">Understood</Button>
        </Modal.Footer> */}
      </Modal>
      <Modal centered show={showOtpModal} onHide={() => setShowOtpModal(false)} backdrop="static" keyboard={false}>
        <Modal.Header closeButton>
          <Modal.Title as="h6">OTP has been sent to {selectedName}&apos;s phone no</Modal.Title>
        </Modal.Header>
        <Modal.Body>
          <Container fluid>
            {err && <Alert variant="danger">{err}</Alert>}
            <form onSubmit={handleOTPSubmit}>
              <div className="mb-3">
                <input type="text" id="input" className="form-control text-black" value={otp} onChange={(e: any) => setOtp(e.target.value)} placeholder="OTP" required />
                {/* <CustomTextField autoFocus fullWidth label='Enter OTP' placeholder='*****' value={otp} onChange={(e: any) => setOtp(e.target.value)} /> */}
                <br />
                <Button variant='contained' type='submit'
                  className="btn btn-primary w-100 mb-2"
                  disabled={isLoading}>
                  {isLoading ? 'Please wait...' : 'Verify OTP'}
                </Button>

              </div>

            </form>
            <Button variant='contained' type='button' color='secondary' onClick={handleResendOTP}
              className="btn btn-light w-100 mb-2"
              disabled={isLoading} >
              {isLoading ? 'Please wait...' : 'Resend OTP'}
            </Button>
          </Container>

        </Modal.Body>
        {/* <Modal.Footer>
          <Button variant="secondary" onClick={() => setShowNameModal(false)}>
            Close
          </Button>
          <Button variant="primary">Understood</Button>
        </Modal.Footer> */}
      </Modal>
    </Fragment>
  );
}
