export function getSession() {
    try {
        if (typeof (localStorage) !== 'undefined') {
            const token = localStorage.getItem('token');
            const username = localStorage.getItem('username');
            const role = localStorage.getItem('role');
            const admin_id = localStorage.getItem('admin_id');

            return { token, username, role, admin_id }
        } else {
            return {}
        }
    } catch (err) {
        console.log(err.message)
    }
}
export function setSession(data) {
    try {
        if (typeof localStorage !== "undefined") {
            Object.entries(data).forEach(([key, value]) => {
                localStorage.setItem(key, value);
            });
        }
    } catch (e) {
        console.error(`Error setting session data:`, e);
    }
}