/*------ accordion(prism-code for showcode purpose) start ------*/
export const accordion1 = `import { Accordion } from "react-bootstrap";
<Accordion.Item eventKey="0">
<Accordion.Header>Accordion Item #1</Accordion.Header>
<Accordion.Body> <strong>This is the first item's accordion body.</strong> It is shown by
     default, until the collapse plugin adds the appropriate classes that we
     use to style each element. These classes control the overall appearance, as
     well as the showing and hiding via CSS transitions. You can modify any of this with
     custom CSS or overriding our default variables. It's also worth noting that
     just  about any HTML can go within the <code>.accordion-body</code>, though the
     transition does limit overflow.
</Accordion.Body>
      </Accordion.Item>
      <Accordion.Item eventKey="1">
<Accordion.Header>Accordion Item #2</Accordion.Header>
<Accordion.Body><strong>This is the second item's accordion body.</strong> It is hidden
    by default, until the collapse plugin adds the appropriate classes that we
    use to style each element. These classes control the overall appearance, as
    well as the showing and hiding via CSS transitions. You can modify any of this with
    custom CSS or overriding our default variables. It's also worth noting that
    just about any HTML can go within the <code>.accordion-body</code>, though the
    transition does limit overflow.
</Accordion.Body>
      </Accordion.Item>
      <Accordion.Item eventKey="2">
<Accordion.Header>Accordion Item #3</Accordion.Header>
<Accordion.Body><strong>This is the third item's accordion body.</strong> It is hidden
  by default, until the collapse plugin adds the appropriate classes that we
  use to style each element. These classes control the overall appearance, as
  well as the showing and hiding via CSS transitions. You can modify any of this with
  custom CSS or overriding our default variables. It's also worth noting that
  just about  any HTML can go within the <code>.accordion-body</code>, though the
  transition  does limit overflow.
</Accordion.Body>
</Accordion.Item>
</Accordion>`;

export const accordion2 = `import { Accordion } from "react-bootstrap";
<Accordion defaultActiveKey={['0']} alwaysOpen>
<Accordion.Item eventKey="0">
<Accordion.Header>Accordion Item #1</Accordion.Header>
  <Accordion.Body> <strong>This is the first item's accordion body.</strong> It is shown by
 default, until the collapse plugin adds the appropriate classes that we
  use to style each element. These classes control the overall appearance, as
  well as the showing and hiding via CSS transitions. You can modify any of this with
  custom CSS or overriding our default variables. It's also worth noting that
    just  about any HTML can go within the <code>.accordion-body</code>, though the
     transition does limit overflow.
 </Accordion.Body>
</Accordion.Item>
 <Accordion.Item eventKey="1">
<Accordion.Header>Accordion Item #2</Accordion.Header>
  <Accordion.Body><strong>This is the second item's accordion body.</strong> It is hidden
   by default, until the collapse plugin adds the appropriate classes that we
   use to style each element. These classes control the overall appearance, as
   well as the showing and hiding via CSS transitions. You can modify any of this with
   custom CSS or overriding our default variables. It's also worth noting that
   just about any HTML can go within the <code>.accordion-body</code>, though the
   transition does limit overflow.
 </Accordion.Body>
</Accordion.Item>
   <Accordion.Item eventKey="2">
<Accordion.Header>Accordion Item #3</Accordion.Header>
  <Accordion.Body><strong>This is the third item's accordion body.</strong> It is hidden
   by default, until the collapse plugin adds the appropriate classes that we
   use to style each element. These classes control the overall appearance, as
   well as the showing and hiding via CSS transitions. You can modify any of this with
   custom CSS or overriding our default variables. It's also worth noting that
   just about any HTML can go within the <code>.accordion-body</code>, though the
   transition  does limit overflow.
 </Accordion.Body>
  </Accordion.Item>
</Accordion>`;

export const accordion3 = `import { Accordion } from "react-bootstrap";
<Accordion defaultActiveKey="0" flush>
<Accordion.Item eventKey="0">
  <Accordion.Header>Accordion Item #1</Accordion.Header>
  <Accordion.Body>Placeholder content for this accordion,
     which isintended to demonstrate the <code>.accordion-flush</code> class.
     This is the first item's accordion body.
  </Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="1">
  <Accordion.Header>Accordion Item #2</Accordion.Header>
  <Accordion.Body>which is intended to demonstrate the <code>.accordion-flush</code> class.
     This is thesecond item's accordion body. Let's imagine this being filled
     with some actual content.
  </Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="2">
  <Accordion.Header>Accordion Item #2</Accordion.Header>
  <Accordion.Body>Placeholder content for this accordion,
      which is intended to demonstrate the <code>.accordion-flush</code> class.
      This is the third item's accordion body. Nothing more exciting happening
      here in  terms of content, but just filling up the space to make it look, at
      least at first glance, a bit more representative of how this would look in a
      real-world application.
  </Accordion.Body>
</Accordion.Item>
</Accordion> `;

export const accordion4 = `import { Accordion } from "react-bootstrap";
<Accordion defaultActiveKey="0" className="accordion accordion-solid-primary">
<Accordion.Item eventKey="0">
  <Accordion.Header>Accordion Item #1</Accordion.Header>
    <Accordion.Body> <strong>This is the first item's accordion body.</strong> It is shown by
     default, until the collapse plugin adds the appropriate classes that we
     use to style each element. These classes control the overall appearance, as
     well as the showing and hiding via CSS transitions. You can modify any of this with
     custom CSS or overriding our default variables. It's also worth noting that
     just  about any HTML can go within the <code>.accordion-body</code>, though the
     transition does limit overflow.
</Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="1">
  <Accordion.Header>Accordion Item #2</Accordion.Header>
  <Accordion.Body><strong>This is the second item's accordion body.</strong> It is hidden
   by default, until the collapse plugin adds the appropriate classes that we
   use to style each element. These classes control the overall appearance, as
   well as the showing and hiding via CSS transitions. You can modify any of this with
   custom CSS or overriding our default variables. It's also worth noting that
   just about any HTML can go within the <code>.accordion-body</code>, though the
   transition does limit overflow.
  </Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="2">
  <Accordion.Header>Accordion Item #3</Accordion.Header>
   <Accordion.Body><strong>This is the third item's accordion body.</strong> It is hidden
    by default, until the collapse plugin adds the appropriate classes that we
    use to style each element. These classes control the overall appearance, as
    well as the showing and hiding via CSS transitions. You can modify any of this with
    custom CSS or overriding our default variables. It's also worth noting that
    just about  any HTML can go within the <code>.accordion-body</code>, though the
    transition  does limit overflow.
  </Accordion.Body>
</Accordion.Item>
</Accordion>`;

export const accordion5 = `import { Accordion } from "react-bootstrap";
<Accordion defaultActiveKey="0" className="accordion accordion-solid-secondary">
<Accordion.Item eventKey="0">
  <Accordion.Header>Accordion Item #1</Accordion.Header>
  <Accordion.Body> <strong>This is the first item's accordion body.</strong> It is shown by
     default, until the collapse plugin adds the appropriate classes that we
     use to style each element. These classes control the overall appearance, as
     well as the showing and hiding via CSS transitions. You can modify any of this with
     custom CSS or overriding our default variables. It's also worth noting that
     just  about any HTML can go within the <code>.accordion-body</code>, though the
     transition does limit overflow.
</Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="1">
<Accordion.Header>Accordion Item #2</Accordion.Header>
<Accordion.Body><strong>This is the second item's accordion body.</strong> It is hidden
  by default, until the collapse plugin adds the appropriate classes that we
  use to style each element. These classes control the overall appearance, as
  well as the showing and hiding via CSS transitions. You can modify any of this with
  custom CSS or overriding our default variables. It's also worth noting that
  just about any HTML can go within the <code>.accordion-body</code>, though the
  transition does limit overflow.
 </Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="2">
 <Accordion.Header>Accordion Item #3</Accordion.Header>
 <Accordion.Body><strong>This is the third item's accordion body.</strong> It is hidden
   by default, until the collapse plugin adds the appropriate classes that we
   use to style each element. These classes control the overall appearance, as
   well as the showing and hiding via CSS transitions. You can modify any of this with
   custom CSS or overriding our default variables. It's also worth noting that
   just about  any HTML can go within the <code>.accordion-body</code>, though the
   transition  does limit overflow.
 </Accordion.Body>
</Accordion.Item>
</Accordion>`;

export const accordion6 = `import { Accordion } from "react-bootstrap";
<Accordion defaultActiveKey="0" className="accordion accordion-primary">
<Accordion.Item eventKey="0">
  <Accordion.Header>Accordion Item #1</Accordion.Header>
  <Accordion.Body> <strong>This is the first item's accordion body.</strong> It is shown by
     default, until the collapse plugin adds the appropriate classes that we
     use to style each element. These classes control the overall appearance, as
     well as the showing and hiding via CSS transitions. You can modify any of this with
     custom CSS or overriding our default variables. It's also worth noting that
     just  about any HTML can go within the <code>.accordion-body</code>, though the
     transition does limit overflow.
 </Accordion.Body>
 </Accordion.Item>
<Accordion.Item eventKey="1">
  <Accordion.Header>Accordion Item #2</Accordion.Header>
  <Accordion.Body><strong>This is the second item's accordion body.</strong> It is hidden
  by default, until the collapse plugin adds the appropriate classes that we
  use to style each element. These classes control the overall appearance, as
  well as the showing and hiding via CSS transitions. You can modify any of this with
  custom CSS or overriding our default variables. It's also worth noting that
  just about any HTML can go within the <code>.accordion-body</code>, though the
  transition does limit overflow.
   </Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="2">
  <Accordion.Header>Accordion Item #3</Accordion.Header>
   <Accordion.Body><strong>This is the third item's accordion body.</strong> It is hidden
   by default, until the collapse plugin adds the appropriate classes that we
   use to style each element. These classes control the overall appearance, as
   well as the showing and hiding via CSS transitions. You can modify any of this with
   custom CSS or overriding our default variables. It's also worth noting that
   just about  any HTML can go within the <code>.accordion-body</code>, though the
   transition  does limit overflow.
   </Accordion.Body>
</Accordion.Item>
</Accordion>`;

export const accordion7 = `import { Accordion } from "react-bootstrap";
<Accordion defaultActiveKey="0" className="accordion accordion-secondary">
<Accordion.Item eventKey="0">
  <Accordion.Header>Accordion Item #1</Accordion.Header>
    <Accordion.Body> <strong>This is the first item's accordion body.</strong> It is shown by
     default, until the collapse plugin adds the appropriate classes that we
     use to style each element. These classes control the overall appearance, as
     well as the showing and hiding via CSS transitions. You can modify any of this with
     custom CSS or overriding our default variables. It's also worth noting that
     just  about any HTML can go within the <code>.accordion-body</code>, though the
     transition does limit overflow.
</Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="1">
  <Accordion.Header>Accordion Item #2</Accordion.Header>
  <Accordion.Body><strong>This is the second item's accordion body.</strong> It is hidden
   by default, until the collapse plugin adds the appropriate classes that we
   use to style each element. These classes control the overall appearance, as
   well as the showing and hiding via CSS transitions. You can modify any of this with
   custom CSS or overriding our default variables. It's also worth noting that
   just about any HTML can go within the <code>.accordion-body</code>, though the
   transition does limit overflow.
  </Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="2">
  <Accordion.Header>Accordion Item #3</Accordion.Header>
   <Accordion.Body><strong>This is the third item's accordion body.</strong> It is hidden
    by default, until the collapse plugin adds the appropriate classes that we
    use to style each element. These classes control the overall appearance, as
    well as the showing and hiding via CSS transitions. You can modify any of this with
    custom CSS or overriding our default variables. It's also worth noting that
    just about  any HTML can go within the <code>.accordion-body</code>, though the
    transition  does limit overflow.
  </Accordion.Body>
</Accordion.Item>
</Accordion>`;

export const accordion8 = `import { Accordion } from "react-bootstrap";
<Accordion defaultActiveKey="0" 
className="accordion accordion-customicon1 accordions-items-seperate">
<Accordion.Item eventKey="0">
  <Accordion.Header>Accordion Item #1</Accordion.Header>
    <Accordion.Body> <strong>This is the first item's accordion body.</strong> It is shown by
     default, until the collapse plugin adds the appropriate classes that we
     use to style each element. These classes control the overall appearance, as
     well as the showing and hiding via CSS transitions. You can modify any of this with
     custom CSS or overriding our default variables. It's also worth noting that
     just  about any HTML can go within the <code>.accordion-body</code>, though the
     transition does limit overflow.
</Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="1">
  <Accordion.Header>Accordion Item #2</Accordion.Header>
  <Accordion.Body><strong>This is the second item's accordion body.</strong> It is hidden
   by default, until the collapse plugin adds the appropriate classes that we
   use to style each element. These classes control the overall appearance, as
   well as the showing and hiding via CSS transitions. You can modify any of this with
   custom CSS or overriding our default variables. It's also worth noting that
   just about any HTML can go within the <code>.accordion-body</code>, though the
   transition does limit overflow.
  </Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="2">
  <Accordion.Header>Accordion Item #3</Accordion.Header>
   <Accordion.Body><strong>This is the third item's accordion body.</strong> It is hidden
    by default, until the collapse plugin adds the appropriate classes that we
    use to style each element. These classes control the overall appearance, as
    well as the showing and hiding via CSS transitions. You can modify any of this with
    custom CSS or overriding our default variables. It's also worth noting that
    just about  any HTML can go within the <code>.accordion-body</code>, though the
    transition  does limit overflow.
  </Accordion.Body>
</Accordion.Item>
</Accordion>`;

export const accordion9 = `import { Accordion } from "react-bootstrap";
<Accordion defaultActiveKey="0" className="accordion customized-accordion accordions-items-seperate">
<Accordion.Item eventKey="0" className="custom-accordion-primary">
<Accordion.Header>Accordion Item #1</Accordion.Header>
<Accordion.Body> <strong>This is the first item's accordion body.</strong> It is shown by
   default, until the collapse plugin adds the appropriate classes that we
   use to style each element. These classes control the overall appearance, as
   well as the showing and hiding via CSS transitions. You can modify any of this with
   custom CSS or overriding our default variables. It's also worth noting that
   just  about any HTML can go within the <code>.accordion-body</code>, though the
   transition does limit overflow.
</Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="1" className="accordion-item custom-accordion-secondary">
<Accordion.Header>Accordion Item #2</Accordion.Header>
 <Accordion.Body><strong>This is the second item's accordion body.</strong> It is hidden
by default, until the collapse plugin adds the appropriate classes that we
use to style each element. These classes control the overall appearance, as
well as the showing and hiding via CSS transitions. You can modify any of this with
custom CSS or overriding our default variables. It's also worth noting that
just about any HTML can go within the <code>.accordion-body</code>, though the
transition does limit overflow.
</Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="2" className="accordion-item custom-accordion-danger">
<Accordion.Header>Accordion Item #3</Accordion.Header>
<Accordion.Body><strong>This is the third item's accordion body.</strong> It is hidden
 by default, until the collapse plugin adds the appropriate classes that we
 use to style each element. These classes control the overall appearance, as
 well as the showing and hiding via CSS transitions. You can modify any of this with
 custom CSS or overriding our default variables. It's also worth noting that
 just about  any HTML can go within the <code>.accordion-body</code>, though the
 transition  does limit overflow.
</Accordion.Body>
</Accordion.Item>
</Accordion>`;

export const accordion10 = `import { Accordion } from "react-bootstrap";
<Accordion defaultActiveKey="0" className="accordion accordion-border-primary accordions-items-seperate">
<Accordion.Item eventKey="0">
  <Accordion.Header>Accordion Item #1</Accordion.Header>
    <Accordion.Body> <strong>This is the first item's accordion body.</strong> It is shown by
     default, until the collapse plugin adds the appropriate classes that we
     use to style each element. These classes control the overall appearance, as
     well as the showing and hiding via CSS transitions. You can modify any of this with
     custom CSS or overriding our default variables. It's also worth noting that
     just  about any HTML can go within the <code>.accordion-body</code>, though the
     transition does limit overflow.
</Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="1">
  <Accordion.Header>Accordion Item #2</Accordion.Header>
  <Accordion.Body><strong>This is the second item's accordion body.</strong> It is hidden
   by default, until the collapse plugin adds the appropriate classes that we
   use to style each element. These classes control the overall appearance, as
   well as the showing and hiding via CSS transitions. You can modify any of this with
   custom CSS or overriding our default variables. It's also worth noting that
   just about any HTML can go within the <code>.accordion-body</code>, though the
   transition does limit overflow.
  </Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="2">
  <Accordion.Header>Accordion Item #3</Accordion.Header>
   <Accordion.Body><strong>This is the third item's accordion body.</strong> It is hidden
    by default, until the collapse plugin adds the appropriate classes that we
    use to style each element. These classes control the overall appearance, as
    well as the showing and hiding via CSS transitions. You can modify any of this with
    custom CSS or overriding our default variables. It's also worth noting that
    just about  any HTML can go within the <code>.accordion-body</code>, though the
    transition  does limit overflow.
  </Accordion.Body>
</Accordion.Item>
</Accordion>`;

export const accordion11 = `import { Accordion } from "react-bootstrap";
<Accordion defaultActiveKey="0" className="accordion accordion-border-success accordions-items-seperate">
<Accordion.Item eventKey="0">
  <Accordion.Header>Accordion Item #1</Accordion.Header>
    <Accordion.Body> <strong>This is the first item's accordion body.</strong> It is shown by
     default, until the collapse plugin adds the appropriate classes that we
     use to style each element. These classes control the overall appearance, as
     well as the showing and hiding via CSS transitions. You can modify any of this with
     custom CSS or overriding our default variables. It's also worth noting that
     just  about any HTML can go within the <code>.accordion-body</code>, though the
     transition does limit overflow.
</Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="1">
  <Accordion.Header>Accordion Item #2</Accordion.Header>
  <Accordion.Body><strong>This is the second item's accordion body.</strong> It is hidden
   by default, until the collapse plugin adds the appropriate classes that we
   use to style each element. These classes control the overall appearance, as
   well as the showing and hiding via CSS transitions. You can modify any of this with
   custom CSS or overriding our default variables. It's also worth noting that
   just about any HTML can go within the <code>.accordion-body</code>, though the
   transition does limit overflow.
  </Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="2">
  <Accordion.Header>Accordion Item #3</Accordion.Header>
   <Accordion.Body><strong>This is the third item's accordion body.</strong> It is hidden
    by default, until the collapse plugin adds the appropriate classes that we
    use to style each element. These classes control the overall appearance, as
    well as the showing and hiding via CSS transitions. You can modify any of this with
    custom CSS or overriding our default variables. It's also worth noting that
    just about  any HTML can go within the <code>.accordion-body</code>, though the
    transition  does limit overflow.
  </Accordion.Body>
</Accordion.Item>
</Accordion>`;

export const accordion12 = `import { Accordion } from "react-bootstrap";
<Accordion defaultActiveKey="0" className="accordion accordionicon-left accordions-items-seperate">
<Accordion.Item eventKey="0">
  <Accordion.Header>Accordion Item #1</Accordion.Header>
    <Accordion.Body> <strong>This is the first item's accordion body.</strong> It is shown by
     default, until the collapse plugin adds the appropriate classes that we
     use to style each element. These classes control the overall appearance, as
     well as the showing and hiding via CSS transitions. You can modify any of this with
     custom CSS or overriding our default variables. It's also worth noting that
     just  about any HTML can go within the <code>.accordion-body</code>, though the
     transition does limit overflow.
</Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="1">
  <Accordion.Header>Accordion Item #2</Accordion.Header>
  <Accordion.Body><strong>This is the second item's accordion body.</strong> It is hidden
   by default, until the collapse plugin adds the appropriate classes that we
   use to style each element. These classes control the overall appearance, as
   well as the showing and hiding via CSS transitions. You can modify any of this with
   custom CSS or overriding our default variables. It's also worth noting that
   just about any HTML can go within the <code>.accordion-body</code>, though the
   transition does limit overflow.
  </Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="2">
  <Accordion.Header>Accordion Item #3</Accordion.Header>
   <Accordion.Body><strong>This is the third item's accordion body.</strong> It is hidden
    by default, until the collapse plugin adds the appropriate classes that we
    use to style each element. These classes control the overall appearance, as
    well as the showing and hiding via CSS transitions. You can modify any of this with
    custom CSS or overriding our default variables. It's also worth noting that
    just about  any HTML can go within the <code>.accordion-body</code>, though the
    transition  does limit overflow.
  </Accordion.Body>
</Accordion.Item>
</Accordion>`;

export const accordion13 = `import { Accordion } from "react-bootstrap";
<Accordion defaultActiveKey="0" 
className="accordion accordionicon-none accordions-items-seperate">
<Accordion.Item eventKey="0">
  <Accordion.Header>Accordion Item #1</Accordion.Header>
    <Accordion.Body> <strong>This is the first item's accordion body.</strong> It is shown by
     default, until the collapse plugin adds the appropriate classes that we
     use to style each element. These classes control the overall appearance, as
     well as the showing and hiding via CSS transitions. You can modify any of this with
     custom CSS or overriding our default variables. It's also worth noting that
     just  about any HTML can go within the <code>.accordion-body</code>, though the
     transition does limit overflow.
</Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="1">
  <Accordion.Header>Accordion Item #2</Accordion.Header>
  <Accordion.Body><strong>This is the second item's accordion body.</strong> It is hidden
   by default, until the collapse plugin adds the appropriate classes that we
   use to style each element. These classes control the overall appearance, as
   well as the showing and hiding via CSS transitions. You can modify any of this with
   custom CSS or overriding our default variables. It's also worth noting that
   just about any HTML can go within the <code>.accordion-body</code>, though the
   transition does limit overflow.
  </Accordion.Body>
</Accordion.Item>
<Accordion.Item eventKey="2">
  <Accordion.Header>Accordion Item #3</Accordion.Header>
   <Accordion.Body><strong>This is the third item's accordion body.</strong> It is hidden
    by default, until the collapse plugin adds the appropriate classes that we
    use to style each element. These classes control the overall appearance, as
    well as the showing and hiding via CSS transitions. You can modify any of this with
    custom CSS or overriding our default variables. It's also worth noting that
    just about  any HTML can go within the <code>.accordion-body</code>, though the
    transition  does limit overflow.
  </Accordion.Body>
</Accordion.Item>
</Accordion>`;

export const accordion14 = `import  { useState } from "react";
import { Accordion, Button,  Collapse } from "react-bootstrap";
//Functionality
const [openb, setOpenb] = useState(false);

<p className="mb-0">
<Button onClick={() => setOpenb(!openb)} aria-controls="example-collapse-text" aria-expanded={open}
  href="#collapseExample" className="btn btn-primary collapsed mb-2 me-1" role="button">
    Link with href</Button>
<Button  onClick={() => setOpenb(!openb)} aria-controls="example-collapse-text" aria-expanded={open}
  variant='' className="btn btn-secondary collapsed mb-2" type="button">
    Button with data-bs-target</Button>
</p> 
<Collapse in={openb}>
<div className="card card-body mb-0">
    Some placeholder content for the collapse component. This panel
    is
    hidden by default but revealed when the user activates the
    relevant
    trigger.
</div>
</Collapse>`;

export const accordion15 = `import  { useState } from "react";
import { Accordion, Button,  Collapse } from "react-bootstrap";
//Functionality
const [isFirstCollapsed, setisFirstCollapsed] = useState(false);
	const [isSecondCollapsed, setisSecondCollapsed] = useState(false);

	const first = () => {
		if (isFirstCollapsed === false) {
			setisFirstCollapsed(true);
		}
		else if (isFirstCollapsed === true) {
			setisFirstCollapsed(false);
		}
	};

	const second = () => {

		if (isSecondCollapsed === true) {
			setisSecondCollapsed(false);
		}
		else if (isSecondCollapsed === false) {
			setisSecondCollapsed(true);
		}
	};

	const both = () => {
		if (isSecondCollapsed === true) {
			setisSecondCollapsed(false);
		}
		else if (isSecondCollapsed === false) {
			setisSecondCollapsed(true);
		}
		if (isFirstCollapsed === true) {
			setisFirstCollapsed(false);
		}
		else if (isFirstCollapsed === false) {
			setisFirstCollapsed(true);
		}
	};
//Code
<p className="mb-0">
<Button className="btn btn-primary mb-2 me-1"  onClick={() => { first() }}>Toggle first element</Button>
<Button variant='' className="btn btn-success mb-2 me-1" type="button" onClick={() => { second() }}>Toggle second element</Button>
<Button variant='' className="btn btn-danger mb-2" type="button"  onClick={() => { both() }}>Toggle both elements</Button>
        </p>
<Row>
    <div className="col m-1">
{isFirstCollapsed ? (
        <div className=" multi-collapse" id="multiCollapseExample1">
            <div className="card card-body mb-0">
                Some placeholder content for the first collapse
                component of
                this multi-collapse example. This panel is hidden by
                default
                but revealed when the user activates the relevant
                trigger.
            </div>
        </div>
    ) : null}
    </div>
    <div className="col m-1">
    {isSecondCollapsed ? (
        <div className=" multi-collapse" id="multiCollapseExample2">
            <div className="card card-body mb-0">
                Some placeholder content for the second collapse
                component
                of this multi-collapse example. This panel is hidden by
                default but revealed when the user activates the
                relevant
                trigger.
            </div>
        </div>
     ) : null}
    </div>
</Row>`;

export const accordion16 = `import  { useState } from "react";
import { Accordion, Button,  Collapse ,Card} from "react-bootstrap";
//Functionality
const [open, setOpen] = useState(false);
<p><Button onClick={() => setOpen(!open)} aria-controls="example-collapse-text" aria-expanded={open}>
Toggle width collapse</Button>                   
</p><div style={{ minHeight: '120px' }}>
<Collapse in={open} dimension="width">
<div id="example-collapse-text">
    <Card body style={{ width: '230px' }}>This is some placeholder content for a horizontal collapse. It's
     hidden by default and shown when triggered.
    </Card>
</div>
</Collapse>
</div>`;

/*------ accordion(prism-code for showcode purpose) end ------*/

/*------ alerts(prism-code for showcode purpose) start ------*/
export const alert1 = `import { useState } from "react";
import {Alert} from "react-bootstrap";
//Functionality
const [alert, setAlert] = useState<{ [key: string]: boolean }>({});

const handleRemoveAlert = (alertName: string) => {
    setAlert((prevAlert) => ({ ...prevAlert, [alertName]: false }));
};

<Alert variant='warning' className="alert alert-warning alert-dismissible fade show" role="alert" show={alert['basicAlert']} >
<strong>Holy guacamole!</strong> You should check in on some of those fields
below.
<Button variant='' type="button" className="btn-close" data-bs-dismiss="alert"
aria-label="Close" onClick={() => handleRemoveAlert('basicAlert')}><i className="bi bi-x"></i>
</Button>
</Alert>`;
export const alerts2 = `import { useState } from "react";
import {Alert, Button} from "react-bootstrap";
//Functionality
const [alerts, setAlerts] = useState([]);
const handleShowAlert = () => {
    const newAlert = {
        id: new Date().getTime(), // Unique ID for each alert
    };
    setAlerts((prevAlerts) => [...prevAlerts, newAlert]);
};
<Alert key={alert.id} variant="success" className="alert alert-warning alert-dismissible fade show" role="alert">
<strong>Holy guacamole!</strong> You should check in on some of those fields below.
<Button variant="" type="button" className="btn-close" data-bs-dismiss="alert" aria-label="Close" onClick={() => setAlerts((prevAlerts) => prevAlerts.filter((a) => a.id !== alert.id))}>
    <i className="bi bi-x"></i>
</Button>
</Alert>`;

export const alerts3 = `import { useState } from "react";
import {Alert ,Button} from "react-bootstrap";
import {Additionalcontentalerts} from "../../../../../shared/data/elements/alertsdata";
//Functionality
const [additionalcontentalert, setadditionalcontentalert] = useState(Additionalcontentalerts);
const handleRemove7 = (id) => {
    const newList = additionalcontentalert.filter((list) => list.id !== id);
    setadditionalcontentalert(newList);
};
<div className="row gy-3">
{additionalcontentalert.map((idx) => (
    <Col xl={6} key={idx.id}>
        <Alert variant={idx.class} className="overflow-hidden p-0" role="alert">
            <div className={'p-3 bg-&#{idx.class} text-fixed-white d-flex justify-content-between'}>
                <h6 className="aletr-heading text-fixed-white mb-0">Thank you for reporting this.</h6>
                <Button type="button" variant='' className="btn-close p-0 text-fixed-white"
                    onClick={() => handleRemove7(idx.id)}
                    data-bs-dismiss="alert" aria-label="Close"><i className="bi bi-x"></i></Button>
            </div>
            <hr className="my-0" />
            <div className="p-3">
                <p className="mb-0">{idx.text2} <Link  scroll={false} href="#!" className="fw-semibold text-decoration-underline">
                    {idx.text3}</Link></p>
            </div>
        </Alert>
    </Col>
))}
</div>`;
export const dataalert3 = `
export const Additionalcontentalerts = [
{ id: 1, text1: "Thank you for reporting this.", text2: "We appreciate you to let us know the bug in the template and for warning us about future consequences ", text3: "Visit for support for queries ?", class: "primary" },
{ id: 2, text1: "Thank you for reporting this.", text2: "We appreciate you to let us know the bug in the template and for warning us about future consequences ", text3: "Visit for support for queries ?", class: "secondary" },
{ id: 3, text1: "Thank you for reporting this.", text2: "We appreciate you to let us know the bug in the template and for warning us about future consequences ", text3: "Visit for support for queries ?", class: "success" },
{ id: 4, text1: "Thank you for reporting this.", text2: "We appreciate you to let us know the bug in the template and for warning us about future consequences ", text3: "Visit for support for queries ?", class: "warning" }
];`

export const alerts4 = `import {Alert} from "react-bootstrap";
import {Defaultalerts} from "../../../../../shared/data/elements/alertsdata";
{Defaultalerts.map((idx) => (
    <Alert variant={idx.class} role="alert" key={idx.id}>
        {idx.text}
    </Alert>
))}`;
export const dataalert4 = `export const Defaultalerts= [
	{ text: " A simple primary alert—check it out!", class: "primary" },
	{ text: " A simple secondary alert—check it out!", class: "secondary" },
	{ text: " A simple success alert—check it out!", class: "success" },
	{ text: " A simple danger alert—check it out!", class: "danger" },
	{ text: " A simple warning alert—check it out!", class: "warning" },
	{ text: " A simple info alert—check it out!", class: "info" },
	{ text: " A simple light alert—check it out!", class: "light" },
	{ text: " A simple dark alert—check it out!", class: "dark" },
];  `

export const alerts5 = `import {Alert} from "react-bootstrap";
import {Linkalerts} from "../../../../../shared/data/elements/alertsdata";
 {Linkalerts.map((idx) => (
    <Alert variant={idx.class} role="alert" key={idx.id}>
        {idx.text1} <Link  scroll={false} href="#!" className="alert-link">{idx.text2}</Link>{idx.text3}
    </Alert>
))}`;
export const dataalert5 = `export const Linkalerts= [
{ text1: "A simple primary alert with ", text2: "an example link ", text3: "Give it a click if you like", class: "primary" },
{ text1: "A simple secondary alert with", text2: "an example link ", text3: "Give it a click if you like", class: "secondary" },
{ text1: "A simple success alert with", text2: "an example link ", text3: "Give it a click if you like", class: "success" },
{ text1: "A simple danger alert with ", text2: "an example link ", text3: "Give it a click if you like", class: "danger" },
{ text1: "A simple warning alert with ", text2: "an example link ", text3: "Give it a click if you like", class: "warning" },
{ text1: "A simple info alert with", text2: "an example link ", text3: "Give it a click if you like", class: "info" },
{ text1: "A simple light alert with ", text2: "an example link ", text3: "Give it a click if you like", class: "light" },
{ text1: "A simple dark alert with", text2: "an example link ", text3: "Give it a click if you like", class: "dark" },
]; `

export const alerts6 = `import { useState } from "react";
import {Alert} from "react-bootstrap";
import {Solidalerts} from "../../../../../shared/data/elements/alertsdata";
//Functionality
const [alert, setAlert] = useState<{ [key: string]: boolean }>({});

	const handleRemoveAlert = (alertName: string) => {
		setAlert((prevAlert) => ({ ...prevAlert, [alertName]: false }));
	};

{Solidalerts.map((idx, index) => (
    <Alert show={alert["solid#{index}"]} variant={idx.class} className={"alert alert-dismissible fade #{idx.color} show"} key={idx.id}>
        {idx.text}
        <Button variant='' type="button" className={"btn-close #{idx.color}"} data-bs-dismiss="alert" aria-label="Close"
            onClick={() => handleRemoveAlert("solid#{index}")}><i className="bi bi-x"></i></Button>
    </Alert>
))}`;
export const dataalert6 = `export const Solidalerts = [
{ id: 1, text: "A simple solid primary alert-check it out! ", class: "solid-primary" , color:""},
{ id: 2, text: "A simple solid secondary alert-check it out!", class: "solid-secondary" , color:""},
{ id: 3, text: "A simple solid info alert-check it out!", class: "solid-info" , color:""},
	{ id: 4, text: "A simple solid warning alert-check it out! ", class: "solid-warning" , color:""},
	{ id: 5, text: "A simple solid success alert-check it out!", class: "solid-success" , color:""},
	{ id: 6, text: "A simple solid danger alert-check it out! ", class: "solid-danger" , color:""},
	{ id: 7, text: "A simple solid light alert-check it out! ", class: "solid-light" , color:"text-default"},
	{ id: 8, text: "A simple solid dark alert-check it out!", class: "solid-dark" , color:"text-white"},
  
]; `

export const alerts7 = `import { useState } from "react";
import {Alert ,Button} from "react-bootstrap";
import {Outlinealerts} from "../../../../../shared/data/elements/alertsdata";
//Functionality
const [alert, setAlert] = useState<{ [key: string]: boolean }>({});

const handleRemoveAlert = (alertName: string) => {
	setAlert((prevAlert) => ({ ...prevAlert, [alertName]: false }));
};
//Code
{Outlinealerts.map((idx, index) => (
    <Alert show={alert["outline#{index}"]} variant={idx.class} className="alert alert- alert-dismissible fade show" key={idx.id}>
        {idx.text}
        <Button variant='' type="button" className="btn-close"
            onClick={() => handleRemoveAlert("outline#{index}")} data-bs-dismiss="alert" aria-label="Close"><i className="bi bi-x"></i></Button>
    </Alert>
))}
`;
export const dataalert7 = `export const Outlinealerts = [
{ id: 1, text: "A simple outline primary alert-check it out! ", class: "outline-primary" , color:""},
{ id: 2, text: "A simple outline secondary alert-check it out!", class: "outline-secondary" , color:""},
{ id: 3, text: "A simple outline info alert-check it out!", class: "outline-info" , color:""},
{ id: 4, text: "A simple outline warning alert-check it out! ", class: "outline-warning" , color:""},
{ id: 5, text: "A simple outline success alert-check it out!", class: "outline-success" , color:""},
{ id: 6, text: "A simple outline danger alert-check it out! ", class: "outline-danger" , color:""},
{ id: 7, text: "A simple outline light alert-check it out! ", class: "outline-light" , color:"text-default"},
{ id: 8, text: "A simple outline dark alert-check it out!", class: "outline-dark" , color:""},
  
]; `

export const alerts8 = `import { useState } from "react";
import {Alert ,Button} from "react-bootstrap";
import {Shadowsolidalerts} from "../../../../../shared/data/elements/alertsdata";
//Functionality
const [alert, setAlert] = useState<{ [key: string]: boolean }>({});

const handleRemoveAlert = (alertName: string) => {
	setAlert((prevAlert) => ({ ...prevAlert, [alertName]: false }));
};
//Code
{Shadowsolidalerts.map((idx, index) => (
    <Alert show={alert["shadows#{index}"]} variant={idx.class} className={"alert shadow-#{idx.size} alert-dismissible fade show"} key={idx.id}>
        {idx.text}
        <Button variant='' type="button" className="btn-close" data-bs-dismiss="alert"
            onClick={() => handleRemoveAlert("shadows#{index}")}
            aria-label="Close"><i className="bi bi-x"></i></Button>
    </Alert>
))}`;
export const dataalert8 = `export const Shadowsolidalerts = [
{ id: 1, text: "A simple solid primary alert with small shadow—check it out! ", class: "solid-primary", size: "sm" },
{ id: 2, text: "A simple solid primary alert with normal shadow—check it out! ", class: "solid-primary", size: "" },
{ id: 3, text: "A simple solid primary alert with large shadow—check it out! ", class: "solid-primary", size: "lg" },
{ id: 4, text: "A simple solid secondary alert with small shadow—check it out!", class: "solid-secondary", size: "sm" },
{ id: 5, text: "A simple solid secondary alert with normal shadow—check it out!", class: "solid-secondary", size: "" },
{ id: 6, text: "A simple solid secondary alert with large shadow—check it out!", class: "solid-secondary", size: "lg" },
  
]; `
export const alerts9 = `import {Alert} from "react-bootstrap";
import {Defaultsolidalerts} from "../../../../../shared/data/elements/alertsdata";

{Defaultsolidalerts.map((idx) => (
    <Alert variant={idx.class} className={"alert shadow-&#{idx.size}"} key={idx.id}>A simple primary alert with small shadow—check it out!</Alert>
))}`;
export const dataalert9 = `export const Defaultsolidalerts = [
{ text: "A simple solid primary alert with small shadow—check it out! ", class: "primary", size: "sm" },
{ text: "A simple solid primary alert with normal shadow—check it out! ", class: "primary", size: "" },
{ text: "A simple solid primary alert with large shadow—check it out! ", class: "primary", size: "lg" },
{ text: "A simple solid secondary alert with small shadow—check it out!", class: "secondary", size: "sm" },
{ text: "A simple solid secondary alert with normal shadow—check it out!", class: "secondary", size: "" },
{ text: "A simple solid secondary alert with large shadow—check it out!", class: "secondary", size: "lg" },
]; `
export const alerts10 = `import { useState } from "react";
import {Alert ,Button} from "react-bootstrap";
import {Roundedsolidalerts} from "../../../../../shared/data/elements/alertsdata";
//Functionality
const [alert, setAlert] = useState<{ [key: string]: boolean }>({});

const handleRemoveAlert = (alertName: string) => {
	setAlert((prevAlert) => ({ ...prevAlert, [alertName]: false }));
};
//Code
{Roundedsolidalerts.map((idx, index) => (
    <Alert show={alert["round#{index}"]} variant={idx.class} className="alert  rounded-pill alert-dismissible fade show" key={idx.id}>
        {idx.text}
        <Button variant='' type="button" className="btn-close" data-bs-dismiss="alert" aria-label="Close"
            onClick={() => handleRemoveAlert("round#{index}")}>
            <i className="bi bi-x"></i></Button>
    </Alert>
))}`;
export const dataalert10 = `export const Roundedefaultalerts = [
{ id: 1, text: "A simple rounded primary alert—check it out! ", class: "primary" },
{ id: 2, text: "A simple rounded secondary alert—check it out! ", class: "info" },
{ id: 3, text: "A simple rounded warning alert—check it out! ", class: "warning" },
{ id: 4, text: "A simple rounded danger alert—check it out!", class: "danger" }
]; `

export const alerts11 = `import { useState } from "react";
import {Alert ,Button} from "react-bootstrap";
import {Roundewithbtnalerts} from "../../../../../shared/data/elements/alertsdata";
//Functionality
const [alert, setAlert] = useState<{ [key: string]: boolean }>({});

const handleRemoveAlert = (alertName: string) => {
	setAlert((prevAlert) => ({ ...prevAlert, [alertName]: false }));
};
//Code
{Roundewithbtnalerts.map((idx,index) => (
    <Alert  show={alert["close#{index}"]} variant={idx.class} className="alert rounded-pill alert-dismissible custom-rounded-alerts fade show" key={idx.id}>
        {idx.text}
        <Button variant='' type="button" className="btn-close custom-close" data-bs-dismiss="alert" aria-label="Close"
            onClick={() => handleRemoveAlert("close#{index}")}>
            <i className="bi bi-x"></i></Button>
    </Alert>
))}`;
export const dataalert11 = `export const Roundewithbtnalerts = [
{ id: 1, text: "A simple rounded primary alert—check it out! ", class: "primary" },
{ id: 2, text: "A simple rounded secondary alert—check it out! ", class: "info" },
{ id: 3, text: "A simple rounded warning alert—check it out! ", class: "warning" },
{ id: 4, text: "A simple rounded danger alert—check it out!", class: "danger" }
]; `
export const alerts12 = `import {Alert } from "react-bootstrap";

<Alert variant='primary' className="alert d-flex align-items-center" role="alert">
<svg className="flex-shrink-0 me-2 svg-primary" xmlns="http://www.w3.org/2000/svg" height="1.5rem" viewBox="0 0 24 24" width="1.5rem" fill="#000000"><path d="M0 0h24v24H0V0z" fill="none" /><path d="M11 7h2v2h-2zm0 4h2v6h-2zm1-9C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z" /></svg>
<div>
    An example alert with an icon
</div>
</Alert>
<Alert variant='success' className="alert  d-flex align-items-center" role="alert">
<svg className="flex-shrink-0 me-2 svg-success" xmlns="http://www.w3.org/2000/svg" height="1.5rem" viewBox="0 0 24 24" width="1.5rem" fill="#000000"><path d="M0 0h24v24H0V0zm0 0h24v24H0V0z" fill="none" /><path d="M16.59 7.58L10 14.17l-3.59-3.58L5 12l5 5 8-8zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z" /></svg>
<div>
    An example success alert with an icon
</div>
</Alert>
<Alert variant='warning' className="alert  d-flex align-items-center" role="alert">
<svg className="flex-shrink-0 me-2 svg-warning" xmlns="http://www.w3.org/2000/svg" enableBackground="new 0 0 24 24" height="1.5rem" viewBox="0 0 24 24" width="1.5rem" fill="#000000"><g><rect fill="none" height="24" width="24" /></g><g><g><g><path d="M12,5.99L19.53,19H4.47L12,5.99 M12,2L1,21h22L12,2L12,2z" /><polygon points="13,16 11,16 11,18 13,18" /><polygon points="13,10 11,10 11,15 13,15" /></g></g></g></svg>
<div>
    An example warning alert with an icon
</div>
</Alert>
<Alert variant='danger' className="alert  d-flex align-items-center" role="alert">
<svg className="flex-shrink-0 me-2 svg-danger" xmlns="http://www.w3.org/2000/svg" enableBackground="new 0 0 24 24" height="1.5rem" viewBox="0 0 24 24" width="1.5rem" fill="#000000"><g><rect fill="none" height="24" width="24" /></g><g><g><g><path d="M15.73,3H8.27L3,8.27v7.46L8.27,21h7.46L21,15.73V8.27L15.73,3z M19,14.9L14.9,19H9.1L5,14.9V9.1L9.1,5h5.8L19,9.1V14.9z" /><rect height="6" width="2" x="11" y="7" /><rect height="2" width="2" x="11" y="15" /></g></g></g></svg>
<div>
    An example danger alert with an icon
</div>
</Alert>`;

export const alerts13 = `import { useState } from "react";
import {Alert ,Button} from "react-bootstrap";
import {Customizedalert1} from "../../../../../shared/data/elements/alertsdata";
//Functionality
const [alert, setAlert] = useState<{ [key: string]: boolean }>({});

const handleRemoveAlert = (alertName: string) => {
	setAlert((prevAlert) => ({ ...prevAlert, [alertName]: false }));
};
/Code
{Customizedalert1.map((idx,index) => (
    <Alert  show={alert["svg#{index}"]} variant={idx.color} className="alert alert-dismissible fade show custom-alert-icon shadow-sm" role="alert" key={idx.id}>
        <svg className={"me-2 svg-#{idx.color}"} xmlns="http://www.w3.org/2000/svg" height="1.5rem" viewBox="0 0 24 24" width="1.5rem" fill="#000000">
            <path d="M0 0h24v24H0z" fill="none" /><path d={idx.class1} /></svg>
        A customized {idx.color} alert with an icon
        <Button variant='' type="button" className="btn-close" data-bs-dismiss="alert" aria-label="Close" onClick={() => handleRemoveAlert("svg#{index}")}><i className="bi bi-x"></i></Button>
    </Alert>
))}`;
export const dataalert13 = `export const Customizedalert1 = [
{ id: 1, class1: "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z", color: "primary" },
{ id: 2, class1: "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 15l-5-5 1.41-1.41L10 14.17l7.59-7.59L19 8l-9 9z", color: "secondary", },
{ id: 3, class1: "M1 21h22L12 2 1 21zm12-3h-2v-2h2v2zm0-4h-2v-4h2v4z", color: "warning", },
{ id: 4, class1: "M15.73 3H8.27L3 8.27v7.46L8.27 21h7.46L21 15.73V8.27L15.73 3zM12 17.3c-.72 0-1.3-.58-1.3-1.3 0-.72.58-1.3 1.3-1.3.72 0 1.3.58 1.3 1.3 0 .72-.58 1.3-1.3 1.3zm1-4.3h-2V7h2v6z", color: "danger", },
]; `
export const alerts14 = `import { useState } from "react";
import {Alert ,Button} from "react-bootstrap";
import {Imagealerts} from "../../../../../shared/data/elements/alertsdata";
//Functionality
const [alert, setAlert] = useState<{ [key: string]: boolean }>({});

const handleRemoveAlert = (alertName: string) => {
	setAlert((prevAlert) => ({ ...prevAlert, [alertName]: false }));
};
//code
{Imagealerts.map((idx,index) => (
    <Alert show={alert["images#{index}"]} variant={idx.color} className="alert alert-img alert-dismissible fase show rounded-pill flex-wrap" role="alert" key={idx.id}>
        <div className="avatar avatar-sm me-3 avatar-rounded">
            <img src={idx.src1} alt="img" />
        </div>
        <div>A simple {idx.color} alert with image—check it out!</div>
        <Button variant='' type="button" className="btn-close" data-bs-dismiss="alert" aria-label="Close" onClick={() => handleRemoveAlert("images#{index}")}
        ><i className={"bi bi-x  #{idx.class}"}></i></Button>
    </Alert>
))}`;
export const dataalert14 = `export const Imagealerts= [
{ id: 1, src1: "../../../assets/images/faces/3.jpg", color: "primary" , class:""},
{ id: 2, src1: "../../../assets/images/faces/5.jpg", color: "secondary" , class:""},
{ id: 3, src1: "../../../assets/images/faces/8.jpg", color: "warning" , class:""},
{ id: 4, src1: "../../../assets/images/faces/11.jpg", color: "danger" , class:""},
{ id: 5, src1: "../../../assets/images/faces/13.jpg", color: "info" , class:""},
{ id: 6, src1: "../../../assets/images/faces/10.jpg", color: "light" , class:""},
{ id: 7, src1: "../../../assets/images/faces/15.jpg", color: "dark" , class:"text-muted"},
]; `

export const alerts15 = `import { useState } from "react";
import {Alert ,Button} from "react-bootstrap";
import {avatarsizealert} from "../../../../../shared/data/elements/alertsdata";
//Functionality
const [alert, setAlert] = useState<{ [key: string]: boolean }>({});

const handleRemoveAlert = (alertName: string) => {
	setAlert((prevAlert) => ({ ...prevAlert, [alertName]: false }));
};

{avatarsizealert.map((idx,index) => (
    <Alert show={alert["different#{index}"]} variant={idx.color} className="alert alert-img alert-dismissible fase show flex-wrap" role="alert" key={idx.id}>
        <div className={"avatar avatar-#{idx.class} me-3"}>
            <img src={idx.src1} alt="img" />
        </div>
        <div>A simple {idx.color} alert with image—check it out!</div>
        <Button variant='' type="button" className="btn-close" data-bs-dismiss="alert"
            aria-label="Close" onClick={() => handleRemoveAlert("different#{index}")}><i className={"bi bi-x #{idx.class1}"}></i></Button>
    </Alert>
))}`;
export const dataalert15 = `export const avatarsizealert = [
	{ id: 1, src1:  "../../../assets/images/faces/3.jpg", color: "primary", class: "xs" , class1:""},
	{ id: 2, src1: "../../../assets/images/faces/5.jpg", color: "secondary", class: "sm" , class1:""},
	{ id: 3, src1: "../../../assets/images/faces/8.jpg", color: "warning", class: "" , class1:""},
	{ id: 4, src1: "../../../assets/images/faces/11.jpg", color: "danger", class: "md" , class1:""},
	{ id: 5, src1: "../../../assets/images/faces/13.jpg", color: "info", class: "lg" , class1:""},
	{ id: 6, src1: "../../../assets/images/faces/14.jpg", color: "dark", class: "xl" , class1:"text-muted"},
]; `;
export const alerts16 = `import { useState } from "react";
import {Alert ,Button} from "react-bootstrap";
import {Roundedefaultalerts} from "../../../../../shared/data/elements/alertsdata";
//Functionality
const [alert, setAlert] = useState<{ [key: string]: boolean }>({});

const handleRemoveAlert = (alertName: string) => {
	setAlert((prevAlert) => ({ ...prevAlert, [alertName]: false }));
};
//Code
{Roundedefaultalerts.map((idx,index) => (
    <Alert show={alert["default#{index}"]} variant={idx.class} className="alert rounded-pill alert-dismissible fade show" key={idx.id}>
        {idx.text}
        <Button variant='' type="button" className="btn-close" data-bs-dismiss="alert" aria-label="Close"
            onClick={() => handleRemoveAlert("default#{index}")}
        ><i className="bi bi-x"></i></Button>
    </Alert>
))}`;
export const dataalert16 = `export const Roundedefaultalerts = [
{ id: 1, text: "A simple rounded primary alert—check it out! ", class: "primary" },
{ id: 2, text: "A simple rounded secondary alert—check it out! ", class: "info" },
{ id: 3, text: "A simple rounded warning alert—check it out! ", class: "warning" },
{ id: 4, text: "A simple rounded danger alert—check it out!", class: "danger" }
]; `
/*------ alerts(prism-code for showcode purpose) end ------*/

/*------ avatars(prism-code for showcode purpose) start ------*/
export const avatar = `<span className="avatar me-2 avatar-radius-0">
<img src="../../../assets/images/faces/1.jpg" alt="img" />
</span>
<span className="avatar me-2">
<img src="../../../assets/images/faces/2.jpg" alt="img" />
</span>
<span className="avatar me-2 avatar-rounded">
<img src="../../../assets/images/faces/3.jpg" alt="img" />
</span>`;

export const avatar1 = `import {Avatarsizes} from "../../../../../shared/data/elements/avatarsdata";
{Avatarsizes.map((idx) => (
<span className={"avatar avatar-" + idx.class + " me-2"} key={idx.id}>
<img src={idx.src} alt="img" />
</span>
))}
`;
export const dataavatar1 = `export const avatarsizes = [
{ id: 1, src1:  "../../../assets/images/faces/3.jpg", color: "primary", class: "xs" , class1:""},
{ id: 2, src1: "../../../assets/images/faces/5.jpg", color: "secondary", class: "sm" , class1:""},
{ id: 3, src1: "../../../assets/images/faces/8.jpg", color: "warning", class: "" , class1:""},
{ id: 4, src1: "../../../assets/images/faces/11.jpg", color: "danger", class: "md" , class1:""},
{ id: 5, src1: "../../../assets/images/faces/13.jpg", color: "info", class: "lg" , class1:""},
{ id: 6, src1: "../../../assets/images/faces/14.jpg", color: "dark", class: "xl" , class1:"text-muted"},
]; `

export const avatar2 = `import { Badge } from "react-bootstrap";
import { Avataricons} from "../../../../../shared/data/elements/avatarsdata";
{Avataricons.map((idx) => (
<span className={"avatar avatar-"+ idx.class+" me-2 avatar-rounded" key={idx.id}>
<img src={idx.src} alt="img" />
<Badge bg={idx.color} className="badge rounded-pill avatar-badge"><i className={idx.icon}></i></Badge>
</span>
))}
`;
export const dataavatar2 = `export const Avataricons = [
{ id: 1, src: "../../../assets/images/faces/2.jpg", class: "xs fs-8", color: "success", icon: "fs-10 fe fe-camera", text: "2" },
{ id: 2, src: "../../../assets/images/faces/3.jpg", class: "sm fs-10", color: "secondary", icon: "fs-10 fe fe-edit", text: "5" },
{ id: 3, src: "../../../assets/images/faces/14.jpg", class: "md fs-10", color: "warning", icon: "fs-10 fe fe-plus", text: "1" },
{ id: 4, src: "../../../assets/images/faces/13.jpg", class: "lg fs-10", color: "info", icon: "fs-10  fe fe-edit", text: "7" },
{ id: 5, src: "../../../assets/images/faces/15.jpg", class: "xl fs-10", color: "success", icon: "fs-10  fe fe-camera", text: "3" },
{ id: 6, src: "../../../assets/images/faces/9.jpg", class: "xxl fs-10", color: "danger", icon: "fs-10  fe fe-plus", text: "9" }
]; `

export const avatar3 = `import { Avatarindicators} from "../../../../../shared/data/elements/avatarsdata";
{Avatarindicators.map((idx) => (
<span className={"avatar avatar-"+ idx.class +" me-2 online avatar-rounded" key={idx.id}>
<img src={idx.src} alt="img" /> </span>
))}
`;
export const dataavatar3 = `export const Avatarindicators = [
{ id: 1, src: "../../../assets/images/faces/8.jpg", class: "xs" },
{ id: 2, src: "../../../assets/images/faces/10.jpg", class: "sm" },
{ id: 3, src: "../../../assets/images/faces/12.jpg", class: "md" },
{ id: 4, src: "../../../assets/images/faces/13.jpg", class: "lg" },
{ id: 5, src: "../../../assets/images/faces/14.jpg", class: "xl" },{ id: 6, src: "../../../assets/images/faces/15.jpg", class: "xxl" }
]; `
export const avatar4 = `import {  Avataroffline } from "../../../../../shared/data/elements/avatarsdata";
{Avataroffline.map((idx) => (
<span className={"avatar avatar-"+"idx.class}+ "me-2 offline avatar-rounded" key={idx.id}>
<img src={idx.src} alt="img" /> </span>
))}
`;
export const dataavatar4 = `export const Avataroffline = [
{ id: 1, src: "../../../assets/images/faces/2.jpg", class: "xs" },
{ id: 2, src: "../../../assets/images/faces/3.jpg", class: "sm" },
{ id: 3, src: "../../../assets/images/faces/4.jpg", class: "md" },
{ id: 4, src: "../../../assets/images/faces/5.jpg", class: "lg" },
{ id: 5, src: "../../../assets/images/faces/6.jpg", class: "xl" },
{ id: 6, src: "../../../assets/images/faces/7.jpg", class: "xxl" }
]; `
export const avatar5 = `import { Badge } from "react-bootstrap";
import { Avataricons } from "../../../../../shared/data/elements/avatarsdata";
{Avataricons.map((idx) => (
<span className="avatar avatar-"+idx.class+" me-2 avatar-rounded" key={idx.id}>
<img src={idx.src} alt="img" />
<Badge bg={idx.color} className="badge rounded-pill  avatar-badge">{idx.text}</Badge>
</span>
))}
`;
export const dataavatar5 = `export const Avataricons = [
{ id: 1, src: "../../../assets/images/faces/2.jpg", class: "xs fs-8", color: "success", icon: "fs-10 fe fe-camera", text: "2" },
{ id: 2, src: "../../../assets/images/faces/3.jpg", class: "sm fs-10", color: "secondary", icon: "fs-10 fe fe-edit", text: "5" },
{ id: 3, src: "../../../assets/images/faces/14.jpg", class: "md fs-10", color: "warning", icon: "fs-10 fe fe-plus", text: "1" },
{ id: 4, src: "../../../assets/images/faces/13.jpg", class: "lg fs-10", color: "info", icon: "fs-10  fe fe-edit", text: "7" },
{ id: 5, src: "../../../assets/images/faces/15.jpg", class: "xl fs-10", color: "success", icon: "fs-10  fe fe-camera", text: "3" },
{ id: 6, src: "../../../assets/images/faces/9.jpg", class: "xxl fs-10", color: "danger", icon: "fs-10  fe fe-plus", text: "9" }
]; `
export const avatar6 = `import {  Avatarinitials } from "../../../../../shared/data/elements/avatarsdata";
{Avatarinitials.map((idx) => (
<span className="avatar avatar-"+idx.class" m-2 bg-+"idx.color +" text-fixed-white" key={idx.id}>{idx.text}
</span>
))}
`;
export const dataavatar6 = `export const Avatarinitials = [
{ id: 1, color: "primary", class: "xs", text: "XS" },
{ id: 2, color: "secondary", class: "sm", text: "SM" },
{ id: 3, color: "warning", class: "md", text: "MD" },
{ id: 4, color: "danger", class: "lg", text: "LG" },
{ id: 5, color: "success", class: "xl", text: "XL" },
{ id: 6, color: "info", class: "xxl", text: "XXL" }
]; `
export const avatar7 = `import Link from "next/link";
import {  Avatarstacked } from "../../../../../shared/data/elements/avatarsdata";
<div className="avatar-list-stacked">
{Avatarstacked.map((idx) => (
<span className="avatar" key={idx.id}>
<img src={idx.src} alt="img" />
</span>
))}
<Link className="avatar bg-primary text-fixed-white" href="#!"> +8 </Link>
</div>
`;
export const dataavatar7 = `export const Avatarstacked = [
{ id: 1, src: "../../../assets/images/faces/2.jpg" },
{ id: 2, src: "../../../assets/images/faces/8.jpg" },
{ id: 3, src: "../../../assets/images/faces/2.jpg" },
{ id: 4, src: "../../../assets/images/faces/10.jpg" },
{ id: 5, src: "../../../assets/images/faces/4.jpg" },
{ id: 6, src: "../../../assets/images/faces/13.jpg" },
]; `
export const avatar8 = `
<div className="avatar-list-stacked">
{Avatarstacked.map((idx) => (
<span className="avatar avatar-rounded" key={idx.id}>
<img src={idx.src} alt="img" />
</span>
))}
<Link className="avatar bg-primary avatar-rounded text-fixed-white" href="#!"> +8 </Link>
</div>
`;
export const dataavatar8 = `export const Avatarstacked = [
{ id: 1, src: "../../../assets/images/faces/2.jpg" },
{ id: 2, src: "../../../assets/images/faces/8.jpg" },
{ id: 3, src: "../../../assets/images/faces/2.jpg" },
{ id: 4, src: "../../../assets/images/faces/10.jpg" },
{ id: 5, src: "../../../assets/images/faces/4.jpg" },
{ id: 6, src: "../../../assets/images/faces/13.jpg" },
];`
/*------ avatars(prism-code for showcode purpose) end ------*/

/*------ Breadcrumb(prism-code for showcode purpose) start ------*/
export const breadcrumb1 = `import { Breadcrumb } from "react-bootstrap";
<nav aria-label="breadcrumb">
<Breadcrumb>
    <Breadcrumb.Item active aria-current="page">Home</Breadcrumb.Item>
</Breadcrumb>
</nav>
<nav aria-label="breadcrumb">
<Breadcrumb>
    <Breadcrumb.Item href="#!">Home</Breadcrumb.Item>
    <Breadcrumb.Item active aria-current="page">Library</Breadcrumb.Item>
</Breadcrumb>
</nav>
<nav aria-label="breadcrumb"><Breadcrumb  className="mb-0">
    <Breadcrumb.Item href="#!">Home</Breadcrumb.Item>
    <Breadcrumb.Item href="#!">Library</Breadcrumb.Item>
    <Breadcrumb.Item active aria-current="page">Data</Breadcrumb.Item>
</Breadcrumb>
</nav>`;

export const breadcrumb2 = `import { Breadcrumb } from "react-bootstrap";
<nav aria-label="breadcrumb">
 <Breadcrumb  className="breadcrumb-example1">
     <Breadcrumb.Item active aria-current="page">Home</Breadcrumb.Item>
 </Breadcrumb>
 </nav>
 
 <nav aria-label="breadcrumb">
 <Breadcrumb  className="breadcrumb-example1">
     <Breadcrumb.Item href="#!">Home</Breadcrumb.Item>
     <Breadcrumb.Item active aria-current="page">Library</Breadcrumb.Item>
 </Breadcrumb>
 </nav>
 
 <nav aria-label="breadcrumb">
 <Breadcrumb  className="breadcrumb-example1 mb-0">
     <Breadcrumb.Item href="#!">Home</Breadcrumb.Item>
     <Breadcrumb.Item href="#!">Library</Breadcrumb.Item>
     <Breadcrumb.Item active aria-current="page">Data</Breadcrumb.Item>
 </Breadcrumb>
 </nav>`;

export const breadcrumb3 = `import { Breadcrumb } from "react-bootstrap";
//Functionality
const breadcrumbStyle = {
    "--bs-breadcrumb-divider": "'~'"
};
 <nav 
  aria-label="breadcrumb">
     <Breadcrumb  className="mb-0">
         <Breadcrumb.Item><a href="#!">Home</a></Breadcrumb.Item>
         <Breadcrumb.Item active  className="active" aria-current="page">Library</Breadcrumb.Item>
     </Breadcrumb>
 </nav>`;

export const breadcrumb4 = `import { Breadcrumb } from "react-bootstrap";
//Functionality
const breadcrumbStyle1 = {
    "--bs-breadcrumb-divider": "url(\"data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='8' height='8'%3E%3Cpath d='M2.5 0L1 1.5 3.5 4 1 6.5 2.5 8l4-4-4-4z' fill='currentColor'/%3E%3C/svg%3E\")"
};
 <nav
 aria-label="breadcrumb"  class='svg-breadcrumb'>
 <Breadcrumb  className=" mb-0">
     <Breadcrumb.Item href="#!">Home</Breadcrumb.Item>
     <Breadcrumb.Item active  className="active embedded-breadcrumb" aria-current="page">Library</Breadcrumb.Item>
 </Breadcrumb>
</nav>`;

export const breadcrumb5 = `import { Breadcrumb } from "react-bootstrap";
 <nav aria-label="breadcrumb">
<Breadcrumb  className="breadcrumb breadcrumb-style1 mb-0">
    <Breadcrumb.Item href="#!">Home</Breadcrumb.Item>
    <Breadcrumb.Item href="#!">Library</Breadcrumb.Item>
    <Breadcrumb.Item active  className="active" aria-current="page">Data</Breadcrumb.Item>
</Breadcrumb>
</nav>`;

export const breadcrumb6 = `import { Breadcrumb } from "react-bootstrap";
<nav aria-label="breadcrumb">
<Breadcrumb  className="breadcrumb breadcrumb-style2 mb-0">
    <Breadcrumb.Item href="#!"><i  className="ti ti-home-2 me-1 fs-15 d-inline-block"></i>Home</Breadcrumb.Item>
    <Breadcrumb.Item href="#!"><i  className="ti ti-apps me-1 fs-15 d-inline-block"></i>About</Breadcrumb.Item>
    <Breadcrumb.Item active  className="active" aria-current="page">Services</Breadcrumb.Item>
</Breadcrumb>
</nav>`;

export const breadcrumb7 = `import { Breadcrumb } from "react-bootstrap";
//Functionality
const breadcrumbStyle = {
    "--bs-breadcrumb-divider": "'~'"
};
<nav aria-label="breadcrumb"  className="bg-bredcrumb">
<Breadcrumb  className="breadcrumb mb-0">
    <Breadcrumb.Item href="#!">Home</Breadcrumb.Item>
    <Breadcrumb.Item active  className="active" aria-current="page">Library</Breadcrumb.Item>
</Breadcrumb>
</nav>`;
/*------ Breadcrumb(prism-code for showcode purpose) end ------*/

/*------ Buttongroup(prism-code for showcode purpose) start ------*/
export const btngroup1 = `import { Button, ButtonGroup} from "react-bootstrap";
<ButtonGroup  className="btn-group" role="group" aria-label="Basic example">
<Button variant="info" type="button"  className="btn btn-wave"><i  className="bi bi-skip-backward"></i></Button>
<Button variant="info" type="button"  className="btn btn-wave"><i  className="bi bi-pause"></i></Button>
<Button variant="info" type="button"  className="btn btn-wave"><i  className="bi bi-skip-forward"></i></Button>
</ButtonGroup>`;

export const btngroup2 = `import { Button, ButtonGroup} from "react-bootstrap"; 
<ButtonGroup  className="btn-group">
<Button variant='primary' active href="#!"  className="btn  active btn-wave" aria-current="page">Active
    link</Button>
<Button variant='primary' href="#!"  className="btn">Link</Button>
<Button variant='primary' href="#!"  className="btn ">Link</Button>
</ButtonGroup>`;

export const btngroup3 = `import { Button, ButtonGroup} from "react-bootstrap"; 
 <ButtonGroup  className="btn-group" role="group" aria-label="Basic mixed styles example">
<Button variant="danger" type="button"  className="btn btn-wave">Left</Button>
<Button variant="warning" type="button"  className="btn btn-wave">Middle</Button>
<Button variant="success" type="button"  className="btn btn-wave">Right</Button>
</ButtonGroup>`;

export const btngroup4 = `import { Button, ButtonGroup} from "react-bootstrap"; 
 <ButtonGroup  className="btn-group1" role="group" aria-label="Basic outlined example">
<Button variant="outline-primary" type="button"  className="btn btn-wave">Left</Button>
<Button variant="outline-primary" type="button"  className="btn btn-wave">Middle</Button>
<Button variant="outline-primary" type="button"  className="btn btn-wave">Right</Button>
</ButtonGroup>`;

export const btngroup5 = `import { Button, ButtonGroup} from "react-bootstrap"; 
<ButtonGroup  className="btn-group" role="group" aria-label="Basic checkbox toggle button group">
<input type="checkbox"  className="btn-check" id="btncheck1" />
<label  className="btn btn-outline-primary" htmlFor="btncheck1">Checkbox 1</label>

<input type="checkbox"  className="btn-check" id="btncheck2" />
<label  className="btn btn-outline-primary" htmlFor="btncheck2">Checkbox 2</label>

<input type="checkbox"  className="btn-check" id="btncheck3" />
<label  className="btn btn-outline-primary" htmlFor="btncheck3">Checkbox 3</label>
</ButtonGroup>`;

export const btngroup6 = `import { Button, ButtonGroup} from "react-bootstrap"; 
 <ButtonGroup  className="btn-group" role="group" aria-label="Basic radio toggle button group">
<input type="radio"  className="btn-check" name="btnradio" id="btnradio1"
    defaultChecked />
<label  className="btn btn-outline-primary" htmlFor="btnradio1">Radio 1</label>

<input type="radio"  className="btn-check" name="btnradio" id="btnradio2"
/>
<label  className="btn btn-outline-primary" htmlFor="btnradio2">Radio 2</label>

<input type="radio"  className="btn-check" name="btnradio" id="btnradio3"
/>
<label  className="btn btn-outline-primary" htmlFor="btnradio3">Radio 3</label>
</ButtonGroup>`;

export const btngroup7 = `import { Button, ButtonGroup} from "react-bootstrap"; 
 <ButtonGroup  className="btn-group btn-group-lg my-1 me-1" role="group" aria-label="Large button group">
<Button variant="outline-success" type="button"  className="btn">Left</Button>
<Button variant="outline-success" type="button"  className="btn">Middle</Button>
<Button variant="outline-success" type="button"  className="btn">Right</Button>
</ButtonGroup>
<ButtonGroup  className="btn-group my-1 me-1" role="group" aria-label="Default button group">
<Button variant="outline-success" type="button"  className="btn">Left</Button>
<Button variant="outline-success" type="button"  className="btn">Middle</Button>
<Button variant="outline-success" type="button"  className="btn">Right</Button>
</ButtonGroup>
<ButtonGroup  className="btn-group btn-group-sm my-1 me-1" role="group" aria-label="Small button group">
<Button variant="outline-success" type="button"  className="btn">Left</Button>
<Button variant="outline-success" type="button"  className="btn">Middle</Button>
<Button variant="outline-success" type="button"  className="btn">Right</Button>
</ButtonGroup>`;

export const btngroup8 = `import { Button, ButtonGroup, ButtonToolbar,  Form, InputGroup } from "react-bootstrap";
 <ButtonToolbar  className="mb-4" role="toolbar"
aria-label="Toolbar with button groups">
<ButtonGroup  className="btn-group me-2 my-1" role="group" aria-label="First group">
    <Button variant="primary" type="button"  className="btn">1</Button>
    <Button variant="primary" type="button"  className="btn">2</Button>
    <Button variant="primary" type="button"  className="btn">3</Button>
    <Button variant="primary" type="button"  className="btn">4</Button>
</ButtonGroup>
<ButtonGroup  className="btn-group me-2 my-1" role="group" aria-label="Second group">
    <Button variant="secondary" type="button"  className="btn">5</Button>
    <Button variant="secondary" type="button"  className="btn">6</Button>
    <Button variant="secondary" type="button"  className="btn">7</Button>
</ButtonGroup>
<ButtonGroup  className="btn-group my-1" role="group" aria-label="Third group">
    <Button variant="info" type="button"  className="btn btn-info">8</Button>
</ButtonGroup>
</ButtonToolbar>
<ButtonToolbar  className="mb-3" role="toolbar"
aria-label="Toolbar with button groups">
<ButtonGroup  className="btn-group me-2 my-1" role="group" aria-label="First group">
    <Button variant="outline-secondary" type="button"  className="btn">1</Button>
    <Button variant="outline-secondary" type="button"  className="btn">2</Button>
    <Button variant="outline-secondary" type="button"  className="btn">3</Button>
    <Button variant="outline-secondary" type="button"  className="btn">4</Button>
</ButtonGroup>
<InputGroup>
    <InputGroup.Text id="btnGroupAddon">@</InputGroup.Text>
    <Form.Control type="text"
        placeholder="Input group example"
        aria-label="Input group example"
        aria-describedby="btnGroupAddon" />
</InputGroup>
</ButtonToolbar>
<ButtonToolbar  className="justify-content-between" role="toolbar"
aria-label="Toolbar with button groups">
<ButtonGroup  className="btn-group my-1" role="group" aria-label="First group">
    <Button variant="outline-secondary" type="button"  className="btn">1</Button>
    <Button variant="outline-secondary" type="button"  className="btn">2</Button>
    <Button variant="outline-secondary" type="button"  className="btn">3</Button>
    <Button variant="outline-secondary" type="button"  className="btn">4</Button>
</ButtonGroup>
<InputGroup>
    <InputGroup.Text id="btnGroupAddon2">@</InputGroup.Text>
    <Form.Control type="text"
        placeholder="Input group example"
        aria-label="Input group example"
        aria-describedby="btnGroupAddon2" />
</InputGroup>
</ButtonToolbar>`;

export const btngroup9 = `import { Button, ButtonGroup,  Dropdown, DropdownButton } from "react-bootstrap";
<ButtonGroup  className="btn-group" role="group"
aria-label="Button group with nested dropdown">
<Button variant="" type="button"  className="btn btn-primary">1</Button>
<Button variant="" type="button"  className="btn btn-primary">2</Button>

<DropdownButton as={ButtonGroup} title="Dropdown" id="bg-nested-dropdown">
    <Dropdown.Item eventKey="1">Dropdown link</Dropdown.Item>
    <Dropdown.Item eventKey="2">Dropdown link</Dropdown.Item>
</DropdownButton>
</ButtonGroup>`;

export const btngroup10 = `import { Button, ButtonGroup, Col, Dropdown, DropdownButton } from "react-bootstrap";
<ButtonGroup vertical role="group" aria-label="Vertical button group">
<Button variant="primary" type="button"  className="btn ">Button</Button>
<Button variant="primary" type="button"  className="btn ">Button</Button>
<DropdownButton as={ButtonGroup} title="Dropdown" id="bg-vertical-dropdown-1">
    <Dropdown.Item eventKey="1">Dropdown link</Dropdown.Item>
    <Dropdown.Item eventKey="2">Dropdown link</Dropdown.Item>
</DropdownButton>
<Button variant="primary" type="button"  className="btn ">Button</Button>
<Button variant="primary" type="button"  className="btn ">Button</Button>
<DropdownButton as={ButtonGroup} title="Dropdown" id="bg-vertical-dropdown-1">
     <Dropdown.Item eventKey="1">Dropdown link</Dropdown.Item>
     <Dropdown.Item eventKey="2">Dropdown link</Dropdown.Item>
     </DropdownButton>
  <DropdownButton as={ButtonGroup} title="Dropdown" id="bg-vertical-dropdown-1">
     <Dropdown.Item eventKey="1">Dropdown link</Dropdown.Item>
     <Dropdown.Item eventKey="2">Dropdown link</Dropdown.Item>
     </DropdownButton>
  <DropdownButton as={ButtonGroup} title="Dropdown" id="bg-vertical-dropdown-1">
     <Dropdown.Item eventKey="1">Dropdown link</Dropdown.Item>
     <Dropdown.Item eventKey="2">Dropdown link</Dropdown.Item>
     </DropdownButton>
</ButtonGroup>
</Col>
<Col sm={3}>
<ButtonGroup vertical role="group" aria-label="Vertical button group">
 <Button variant="" type="button"  className="btn btn-info">Button</Button>
 <Button variant="" type="button"  className="btn btn-info">Button</Button>
 <Button variant="" type="button"  className="btn btn-info">Button</Button>
 <Button variant="" type="button"  className="btn btn-info">Button</Button>
 <Button variant="" type="button"  className="btn btn-info">Button</Button>
 <Button variant="" type="button"  className="btn btn-info">Button</Button>
</ButtonGroup>
</Col>
<Col sm={3}>
<ButtonGroup vertical role="group"
 aria-label="Vertical radio toggle button group">
 <input type="radio"  className="btn-check" name="vbtn-radio" id="vbtn-radio1"
     defaultChecked/>
 <Button variant='outline-danger'  className="btn btn-outline-danger" htmlFor="vbtn-radio1">Radio 1</Button>
 <input type="radio"  className="btn-check" name="vbtn-radio" id="vbtn-radio2"
    />
 <Button variant='outline-danger'  className="btn btn-outline-danger" htmlFor="vbtn-radio2">Radio 2</Button>
 <input type="radio"  className="btn-check" name="vbtn-radio" id="vbtn-radio3"
    />
 <Button variant='outline-danger'  className="btn btn-outline-danger" htmlFor="vbtn-radio3">Radio 3</Button>
</ButtonGroup>
</Col>`;

export const btngroup11 = `import { Button, ButtonGroup} from "react-bootstrap";
import { SocialIconButtons } from "../../../../../shared/data/elements/buttonsdata";
<ButtonGroup  className="btn-group" role="group" aria-label="Basic example"> 
<Button variant=""  className="btn btn-icon btn-facebook btn-wave">
<i  className="ri-facebook-line"></i>
</Button>
<Button variant=""  className="btn btn-icon btn-twitter btn-wave">
    <i  className="ri-twitter-line"></i>
</Button>
<Button variant=""  className="btn btn-icon btn-instagram btn-wave">
    <i  className="ri-instagram-line"></i>
</Button>
<Button variant=""  className="btn btn-icon btn-github btn-wave">
    <i  className="ri-github-line"></i>
</Button>
<Button variant=""  className="btn btn-icon btn-youtube btn-wave">
    <i  className="ri-youtube-line"></i>
</Button>
<Button variant=""  className="btn btn-icon btn-google btn-wave">
    <i  className="ri-google-line"></i>
</Button>
   </ButtonGroup>`;
/*------ Buttongroup(prism-code for showcode purpose) end ------*/

/*------ Buttons(prism-code for showcode purpose) start ------*/
export const button1 = `import { Button } from "react-bootstrap";
import { DefaultButtons } from "../../../../../shared/data/elements/buttonsdata";

<div className="btn-list">
    {DefaultButtons.map((idx) => (
        <Button variant={idx.class} type="button" className="btn-wave waves-effect waves-light 
        me-2" key={idx.id}>{idx.text}</Button>
    ))}
</div>`;
export const databutton1 = `export const DefaultButtons = [
	{ id: 1, class: "primary", text: " Primary" },
	{ id: 2, class: "secondary", text: "  Secondary" },
	{ id: 3, class: "success", text: " Success" },
	{ id: 4, class: "danger", text: "  Danger" },
	{ id: 5, class: "warning", text: "  Warning" },
	{ id: 6, class: "info", text: "Info" },
	{ id: 7, class: "light", text: " Light" },
	{ id: 8, class: "dark", text: "  Dark" },
	{ id: 9, class: "link", text: "Link" },
]; `
export const button2 = `import { Button } from "react-bootstrap";
import { DefaultButtons } from "../../../../../shared/data/elements/buttonsdata";

<div className="btn-list">
	{DefaultButtons.map((idx) => (
		<Button variant={idx.class} type="button" className="rounded-pill btn-wave 
                 me-2" key={idx.id}>{idx.text}</Button>
	))}
</div>`;

export const button3 = `import { Button } from "react-bootstrap";
import { LightButtons } from "../../../../../shared/data/elements/buttonsdata";

<div className="btn-list">
	{LightButtons.map((idx) => (
		<Button type="button" variant={idx.class} className="btn btn-wave 
                 me-2" key={idx.id}>{idx.text}</Button>
	))}
</div>`;
export const databutton3 = `export const LightButtons = [
	{ id: 1, class: "primary-light", text: " Primary" },
	{ id: 2, class: "secondary-light", text: "  Secondary" },
	{ id: 3, class: "success-light", text: " Success" },
	{ id: 4, class: "danger-light", text: "  Danger" },
	{ id: 5, class: "warning-light", text: "  Warning" },
	{ id: 6, class: "info-light", text: "Info" },
	{ id: 7, class: "purple-light", text: " purple" },
	{ id: 8, class: "teal-light", text: "  teal" },
	{ id: 9, class: "orange-light", text: "orange" }
]; `
export const button4 = `import { Button } from "react-bootstrap";
import { LightButtons } from "../../../../../shared/data/elements/buttonsdata";

<div className="btn-list">
{LightButtons.map((idx) => (
	<Button type="button" variant={idx.class} className="btn rounded-pill btn-wave me-2"
         key={idx.id}>{idx.text}</Button>
))}
</div>`;

export const button5 = ` import { Button } from "react-bootstrap";
import { OutlineButtons } from "../../../../../shared/data/elements/buttonsdata";

<div className="btn-list">
{OutlineButtons.map((idx) => (
    <Button type="button" variant={idx.class} className="btn  btn-wave me-2" key={idx.id}>{idx.text}</Button>
))}
</div>`;
export const databutton5 = `export const OutlineButtons= [
	{ id: 1, class: "outline-primary", text: " Primary" },
	{ id: 2, class: "outline-secondary", text: "  Secondary" },
	{ id: 3, class: "outline-success", text: " Success" },
	{ id: 4, class: "outline-danger", text: "  Danger" },
	{ id: 5, class: "outline-warning", text: "  Warning" },
	{ id: 6, class: "outline-info", text: "Info" },
	{ id: 7, class: "outline-light", text: " Light" },
	{ id: 8, class: "outline-dark", text: "  Dark" },
]; `

export const button6 = ` import { Button } from "react-bootstrap";
import { OutlineButtons } from "../../../../../shared/data/elements/buttonsdata";
<div className="btn-list">
{OutlineButtons.map((idx) => (
	<Button type="button" variant={idx.class} className="btn rounded-pill btn-wave me-2" key={idx.id}>{idx.text}</Button>
))}
</div>`;

export const button7 = `import { Button } from "react-bootstrap";
import { GradientButtons } from "../../../../../shared/data/elements/buttonsdata";

  {GradientButtons.map((idx) => (
    <Button type="button" variant={idx.class}  className="btn btn-wave me-2" 
    key={idx.id}>{idx.text}</Button>
))}`;
export const databutton7 = `export const GradientButtons= [
	{ id: 1, class: "primary-gradient", text: "Primary" },
	{ id: 2, class: "secondary-gradient", text: "Secondary" },
	{ id: 3, class: "success-gradient", text: "Success" },
	{ id: 4, class: "danger-gradient", text: "Danger" },
	{ id: 5, class: "warning-gradient", text: "Warning" },
	{ id: 6, class: "info-gradient", text: "Info" },
	{ id: 7, class: "orange-gradient", text: " Orange" },
	{ id: 8, class: "purple-gradient", text: "Purple" },
	{ id: 8, class: "teal-gradient", text: "  teal" },
]; `

export const button8 = `import { Button } from "react-bootstrap";
import { GradientButtons } from "../../../../../shared/data/elements/buttonsdata";

<div className="btn-list">
{GradientButtons.map((idx) => (
    <Button type="button" variant={idx.class}  className="btn rounded-pill btn-wave me-2"
     key={idx.id}>{idx.text}</Button>
))}
</div>`;

export const button9 = `import { Button } from "react-bootstrap";
<div  className="btn-list">
<div  className="mb-4">
    <Button type="button" variant='primary'  className="btn" disabled>Primary
        button</Button>
    <Button type="button" variant='secondary'  className="btn" disabled>Button</Button>
    <Button type="button" variant='outline-primary'  className="btn b" disabled>Primary
        button</Button>
    <Button type="button" variant='outline-secondary'  className="btn " disabled>Button</Button>
</div>

<div>
    <Button variant='primary'disabled  className="btn" role="button">Primary
        link</Button>
    <Button variant='secondary' disabled  className="btn" role="button">Link</Button>
</div>
</div>`;

export const button10 = ` import { Button } from "react-bootstrap";
<div  className="btn-list">
<div  className="mb-4">
    <Button type="button" variant='primary'  className="btn btn-wave"
    >Toggle button</Button>
    <Button type="button" variant='secondary' active  className="btn  btn-wave">
        Active toggle button</Button>
    <Button type="button" variant='teal'  className="btn btn-wave" disabled>Disabled toggle
        button</Button>
</div>
<div>
    <Button variant='primary' href="#!"  className="btn btn-wave" role="button" >Toggle
        link</Button>
    <Button href="#!" variant='secondary' active  className="btn btn-wave" role="button">
        Active toggle link</Button>
    <Button variant='teal'  className="btn  btn-wave" role="button" disabled>Disabled toggle link</Button>
</div>
</div>`;

export const button11 = `import { Button } from "react-bootstrap";
 <div  className="btn-list d-md-flex flex-wrap">
<Button variant='primary'  className="btn  btn-loader">
    <span  className="me-2">Loading</span>
    <span  className="loading"><i  className="ri-loader-2-fill fs-16"></i></span>
</Button>
<Button variant='outline-secondary'  className="btn btn-loader">
    <span  className="me-2">Loading</span>
    <span  className="loading"><i  className="ri-loader-2-fill fs-16"></i></span>
</Button>
<Button variant='info-transparent'  className="btn  btn-loader">
    <span  className="me-2">Loading</span>
    <span  className="loading"><i  className="ri-loader-4-line fs-16"></i></span>
</Button>
<Button variant='warning-transparent'  className="btn  btn-loader">
    <span  className="me-2">Loading</span>
    <span  className="loading"><i  className="ri-loader-5-line fs-16"></i></span>
</Button>
<Button variant='success'  className="btn btn-loader" disabled>
    <span  className="me-2">Disabled</span>
    <span  className="loading"><i  className="ri-refresh-line fs-16"></i></span>
</Button>
</div>`;

export const button12 = `import { Button } from "react-bootstrap";
<div  className="btn-list d-md-flex d-block">
<div  className="mb-md-0 mb-2">
    <Button variant="primary"  className="btn btn-icon  btn-wave">
        <i  className="ri-bank-fill"></i>
    </Button>
    <Button variant="info"  className="btn btn-icon  btn-wave">
        <i  className="ri-medal-line"></i>
    </Button>
    <Button variant="danger"  className="btn btn-icon  btn-wave">
        <i  className="ri-archive-line"></i>
    </Button>
    <Button variant="warning"  className="btn btn-icon  btn-wave me-5">
        <i  className="ri-calendar-2-line"></i>
    </Button>
</div>
<div  className="mb-md-0 mb-2">
    <Button variant="primary-transparent"  className="btn btn-icon rounded-pill btn-wave">
        <i  className="ri-home-smile-line"></i>
    </Button>
    <Button variant="secondary-transparent"  className="btn btn-icon  rounded-pill btn-wave">
        <i  className="ri-delete-bin-line"></i>
    </Button>
    <Button variant="success-transparent"  className="btn btn-icon  rounded-pill btn-wave">
        <i  className="ri-notification-3-line"></i>
    </Button>
    <Button variant="danger-transparent"  className="btn btn-icon  rounded-pill btn-wave me-5">
        <i  className="ri-chat-settings-line"></i>
    </Button>
</div>
<div  className="">
    <Button variant="outline-primary"  className="btn btn-icon  rounded-pill btn-wave">
        <i  className="ri-phone-line"></i>
    </Button>
    <Button variant="outline-teal"  className="btn btn-icon  rounded-pill btn-wave">
        <i  className="ri-customer-service-2-line"></i>
    </Button>
    <Button variant="outline-success"  className="btn btn-icon  rounded-pill btn-wave">
        <i  className="ri-live-line"></i>
    </Button>
    <Button variant="outline-secondary"  className="btn btn-icon  rounded-pill btn-wave">
        <i  className="ri-save-line"></i>
    </Button>
</div>
</div>`;

export const button13 = `import { Button } from "react-bootstrap";
import { GhostButtons } from "../../../../../shared/data/elements/buttonsdata";

<div className="btn-list">
{GhostButtons.map((idx) => (
    <Button type="button" variant={idx.class}  className="btn btn-wave me-2" 
    key={idx.id}>{idx.text}</Button>
))}
</div>`;
export const databutton13 = `export const GhostButtons= [
	{ id: 1, class: "primary-ghost", text: "Primary" },
	{ id: 2, class: "secondary-ghost", text: "Secondary" },
	{ id: 3, class: "success-ghost", text: "Success" },
	{ id: 4, class: "danger-ghost", text: "Danger" },
	{ id: 5, class: "warning-ghost", text: "Warning" },
	{ id: 6, class: "info-ghost", text: "Info" },
]; `
export const button14 = `import { Button } from "react-bootstrap";
<div  className="btn-list">
<Button variant='primary'  className="btn  btn-wave" href="#!" role="button">Link</Button>
<Button variant='secondary'  className="btn  btn-wave" type="submit">Button</Button>
<Button variant='info' as="input"  className="btn " type="button" value="Input" />
<Button variant='warning' as="input"  className="btn" type="submit" value="Submit" />
<Button variant='success' as="input"  className="btn " type="reset" value="Reset" />
</div>`;

export const button15 = `import { Button } from "react-bootstrap";
 <div  className="btn-list">
<Button variant='primary' disabled  className="btn" tabIndex={-1} role="button">Primary link</Button>
<Button variant='secondary' disabled  className="btn" tabIndex={-1} role="button">Link</Button>
</div>`;

export const button16 = `import { Button } from "react-bootstrap";
import { SocialIconButtons } from "../../../../../shared/data/elements/buttonsdata";

<div className="btn-list">
{SocialIconButtons.map((idx) => (
	<Button variant={idx.class1} className="btn btn-icon btn-facebook btn-wave waves-effect waves-light" key={idx.id}>
	<i className={"ri-&#{idx.class}-line"}></i>
</Button>
	))}
</div>`;
export const databutton16 = `export const SocialIconButtons= [
	{ id: 1, class: "facebook", class1: "facebook"  },
	{ id: 2, class: "twitter-x", class1: "twitter"},
	{ id: 3, class: "instagram" , class1: "instagram" },
	{ id: 4, class: "github" , class1: "github"},
	{ id: 5, class: "youtube",class1: "youtube" },
	{ id: 5, class: "google" ,class1: "google"},
  
]; `
export const button17 = `import { Button } from "react-bootstrap";
 <div  className="btn-list">
<Button type="button" variant='primary'  className="btn  btn-sm btn-wave">Small
    button</Button>
<Button type="button" variant='secondary'  className="btn  btn-wave">Default
    button</Button>
<Button type="button" variant='success'  className="btn  btn-lg btn-wave">Large
    button</Button>
</div>`;

export const button18 = `import { Button } from "react-bootstrap";
<div  className="btn-list">
<Button type="button" variant='primary'  className="btn btn-w-xs btn-wave">XS</Button>
<Button type="button" variant='secondary'  className="btn btn-w-sm btn-wave">SM</Button>
<Button type="button" variant='warning'  className="btn btn-w-md btn-wave">MD</Button>
<Button type="button" variant='info'  className="btn btn-w-lg btn-wave">LG</Button>
</div>`;

export const button19 = `import { Button } from "react-bootstrap";
<div  className="btn-list d-flex">
<div  className="me-5">
    <Button variant='primary'  className="btn  shadow-sm btn-wave">Button</Button>
    <Button variant='primary'  className="btn btn-primary shadow btn-wave">Button</Button>
    <Button variant='primary'  className="btn btn-primary shadow-lg btn-wave">Button</Button>
</div>
<div>
    <Button variant='secondary'  className="btn  btn-sm shadow-sm btn-wave">Button</Button>
    <Button variant='info'  className="btn  shadow btn-wave">Button</Button>
    <Button variant='success'  className="btn btn-lg  shadow-lg btn-wave">Button</Button>
</div>
</div>`;

export const button20 = `import { Button } from "react-bootstrap";
import { ColoredButtons } from "../../../../../shared/data/elements/buttonsdata";
<div className="btn-list">
{ColoredButtons.map((idx) => (
    <Button variant={idx.class} className={"btn shadow-&#{idx.class} btn-wave"} key={idx.id}>Button</Button>
))}
</div>`;
export const databutton20 = `export const ColoredButtons = [
	{ id: 1, class: "primary" },
	{ id: 2, class: "secondary" },
	{ id: 3, class: "success" },
	{ id: 4, class: "info" },
	{ id: 5, class: "warning" },
	{ id: 6, class: "danger" },
	{ id: 6, class: "purple" },
	{ id: 6, class: "orange" },
  
]; `
export const button21 = `import { Button } from "react-bootstrap";
<div className="btn-list">
 {ColoredButtons.map((idx) => (
    <Button variant={idx.class}  className="btn  btn-raised-shadow btn-wave" 
    key={idx.id}>Button</Button>
))}
</div>`;

export const button22 = `import { Button } from "react-bootstrap";
<div  className="btn-list">
<Button  className="btn btn-primary label-btn">
    <i  className="ri-chat-smile-line label-btn-icon me-2"></i>
    Primary
</Button>
<Button  className="btn btn-secondary label-btn">
    <i  className="ri-settings-4-line label-btn-icon me-2"></i>
    Secondary
</Button>
<Button  className="btn btn-warning label-btn rounded-pill">
    <i  className="ri-spam-2-line label-btn-icon me-2 rounded-pill"></i>
    Warning
</Button>
<Button  className="btn btn-info label-btn rounded-pill">
    <i  className="ri-phone-line label-btn-icon me-2 rounded-pill"></i>
    Info
</Button>
<Button  className="btn btn-success label-btn label-end">
    Success
    <i  className="ri-thumb-up-line label-btn-icon ms-2"></i>
</Button>
<Button  className="btn btn-danger label-btn label-end rounded-pill">
    Cancel
    <i  className="ri-close-line label-btn-icon ms-2 rounded-pill"></i>
</Button>
</div>`;

export const button23 = `import { Button } from "react-bootstrap";
<div  className="btn-list">
<Button variant='info'  className="btn  custom-button rounded-pill">
    <span  className="custom-btn-icons"><i  className="ri-twitter-line text-info"></i></span>
    Twitter
</Button>
<Button variant='teal-light'  className="btn  btn-border-down">Border</Button>
<Button variant='secondary-light'  className="btn  btn-border-start">Border</Button>
<Button variant='purple-light'  className="btn  btn-border-end">Border</Button>
<Button variant='warning-light'  className="btn  btn-border-top">Border</Button>
<Button variant='secondary'  className="btn  btn-glare"><span>Glare Button</span></Button>
<Button variant='danger'  className="btn  btn-hover btn-hover-animate">Like</Button>
<Button variant='success'  className="btn  btn-darken-hover">Hover</Button>
<Button variant='orange'  className="btn  btn-custom-border">Hover</Button>
</div>`;

export const button24 = `import { Button } from "react-bootstrap";
<div  className="btn-list">
<div  className="d-grid gap-2 mb-4">
    <Button variant='primary'  className="btn  btn-wave" type="button">Button</Button>
    <Button variant='secondary'  className="btn  btn-wave" type="button">Button</Button>
</div>
<div  className="d-grid gap-2 d-md-block">
    <Button variant='info'  className="btn  btn-wave" type="button">Button</Button>
    <Button variant='success'  className="btn  btn-wave" type="button">Button</Button>
</div>
<div  className="d-grid gap-2 col-6 mx-auto">
    <Button variant='danger'  className="btn  btn-wave" type="button">Button</Button>
    <Button variant='warning'  className="btn  btn-wave" type="button">Button</Button>
</div>
<div  className="d-grid gap-2 d-md-flex justify-content-md-end">
    <Button variant='teal'  className="btn me-md-2 btn-wave" type="button">Button</Button>
    <Button variant='purple'  className="btn  btn-wave" type="button">Button</Button>
</div>
</div>`;
/*------ Buttons(prism-code for showcode purpose) end ------*/

/*------ Badge(prism-code for showcode purpose) start ------*/
export const badge1 = `import { Badge } from "react-bootstrap";
import { badgesdata } from "../../../../../shared/data/elements/badgesdata";

{badgesdata.map((badge) => (
    <Badge key={idx.id} bg={badge.color} className={"badge bg-$#{badge.color} &#{badge.class} me-1"}>{badge.heading}</Badge>
))}`;
export const databadge1 = `export const badgesdata = [
	{ id: 1, heading: "Primary", color: "primary", class: "" },
	{ id: 2, heading: "secondary", color: "secondary", class: "" },
	{ id: 3, heading: "Success", color: "success", class: "" },
	{ id: 4, heading: "Danger", color: "danger", class: "" },
	{ id: 5, heading: "Warning", color: "warning", class: "" },
	{ id: 6, heading: "Info", color: "info", class: "" },
	{ id: 7, heading: "Light", color: "light", class: "text-dark" },
	{ id: 8, heading: "Dark", color: "dark", class: "text-white" },
]; `
export const badge2 = `import { Badge } from "react-bootstrap";
import { badgesdata } from "../../../../../shared/data/elements/badgesdata";

{badgesdata.map((badge) => (
    <Badge key={idx.id} bg={badge.color} className={"badge bg-&#{badge.color} &#{badge.class} rounded-pill me-1 "}>{badge.heading}</Badge>
))}`;

export const badge3 = `import { Badge } from "react-bootstrap";
import { Outlinebadgesdata } from "../../../../../shared/data/elements/badgesdata";

{Outlinebadgesdata.map((badge) => (
    <Badge key={idx.id} bg={badge.color} className={"badge bg-&#{badge.color}-transparent &#{badge.class} me-1"}>{badge.heading}</Badge>
))}`;
export const databadge3 = `export const Outlinebadgesdata = [
	{ id: 1, heading: "Primary", color: "primary", class: "" },
	{ id: 2, heading: "secondary", color: "secondary", class: "" },
	{ id: 3, heading: "Success", color: "success", class: "" },
	{ id: 4, heading: "Danger", color: "danger", class: "" },
	{ id: 5, heading: "Warning", color: "warning", class: "" },
	{ id: 6, heading: "Info", color: "info", class: "" },
	{ id: 7, heading: "Light", color: "light", class: "text-dark" },
	{ id: 8, heading: "Dark", color: "dark", class: "" },
]; `
export const badge4 = `import { Badge } from "react-bootstrap";
import { Outlinebadgesdata } from "../../../../../shared/data/elements/badgesdata";

{Outlinebadgesdata.map((badge) => (
    <Badge key={idx.id} bg={badge.color} className={"badge bg-&#{badge.color}-transparent &#{badge.class} rounded-pill me-1"}>{badge.heading}</Badge>
))}`;

export const badge5 = `import { Badge } from "react-bootstrap";
import { Outlinebadgesdata } from "../../../../../shared/data/elements/badgesdata";

{Outlinebadgesdata.map((badge) => (
    <Badge key={idx.id} bg={"outline-&#{badge.color}"} className={"badge outline-&#{badge.color}-transparent &#{badge.class} me-1"}>{badge.heading}</Badge>
))}`;

export const badge6 = `import { Badge } from "react-bootstrap";
import { Outlinebadgesdata } from "../../../../../shared/data/elements/badgesdata";

{Outlinebadgesdata.map((badge) => (
    <Badge key={idx.id} bg={"outline-&#{badge.color}"} className={"badge outline-&#{badge.color}-transparent &#{badge.class} rounded-pill me-1"}>{badge.heading}</Badge>
))}`;

export const badge7 = `import { Badge } from "react-bootstrap";
import { badges1 } from "../../../../../shared/data/elements/badgesdata";

{badges1.map((badge1) => (
    <Badge key={idx.id} bg={badge1.color} className={"badge bg-&#{badge1.color}-gradient me-1"}>{badge1.heading}</Badge>
))}`;
export const databadge7 = `export const badges1= [
	{ id: 1, heading: "Primary", color: "primary" },
	{ id: 2, heading: "secondary", color: "secondary" },
	{ id: 3, heading: "Success", color: "success" },
	{ id: 4, heading: "Danger", color: "danger" },
	{ id: 5, heading: "Warning", color: "warning" },
	{ id: 6, heading: "Info", color: "info" },
	{ id: 7, heading: "orange", color: "orange" },
	{ id: 8, heading: "purple", color: "purple" },
]; `
export const badge8 = `import { Badge } from "react-bootstrap";
import { badges1 } from "../../../../../shared/data/elements/badgesdata";

{badges1.map((badge1) => (
    <Badge key={idx.id} bg={badge1.color} className={"badge bg-&#{badge1.color}-gradient rounded-pill me-1"}>{badge1.heading}</Badge>
))}`;

export const badge9 = `<Button  variant='danger' type="button"  className="my-1 me-2">
Notifications <Badge bg="white"  className=" ms-2 text-danger">777</Badge>
</Button>
<Button  variant='primary' type="button"  className="my-1 me-2">
Notifications <Badge bg="white"  className=" ms-2 text-primary">4</Badge>
</Button>
<Button  variant='info' type="button"  className="my-1 me-2">
Notifications <Badge bg="white"  className=" ms-2 text-info">32</Badge>
</Button>
<Button  variant='warning' type="button"  className="my-1 me-2">
Notifications <Badge bg="white"  className=" ms-2 text-warning">7</Badge>
</Button>
<Button  variant='success' type="button"  className="my-1 me-2">
Notifications <Badge bg="white"  className=" ms-2 text-success">12</Badge>
</Button>
<Button  variant='secondary' type="button"  className="my-1 me-2">
Notifications <Badge bg="white"  className=" ms-2 text-secondary">7</Badge>
</Button>`;

export const badge10 = ` <Button variant='primary' type="button"  className=" my-1 me-2">
Notifications <Badge bg="secondary"  className="ms-2 ">4</Badge>
</Button>
<Button variant='secondary' type="button"  className=" my-1 me-2">
Notifications <Badge bg="primary"  className="ms-2 ">7</Badge>
</Button>
<Button variant='success' type="button"  className=" my-1 me-2">
Notifications <Badge bg="danger"  className="ms-2 ">12</Badge>
</Button>
<Button variant='info' type="button"  className=" my-1 me-2">
Notifications <Badge bg="warning"  className="ms-2 ">32</Badge>
</Button>`;

export const badge11 = `<Button variant='outline-primary' type="button"  className="btn  my-1 me-2">
Notifications <Badge bg=""  className="badge ms-2">4</Badge>
</Button>
<Button variant='outline-secondary' type="button"  className="btn  my-1 me-2">
Notifications <Badge bg=""  className="badge ms-2">7</Badge>
</Button>
<Button variant='outline-success' type="button"  className="btn  my-1 me-2">
Notifications <Badge bg=""  className="badge ms-2">12</Badge>
</Button>
<Button variant='outline-info' type="button"  className="btn  my-1 me-2">
Notifications <Badge bg=""  className="badge ms-2">32</Badge>
</Button>`;

export const badge12 = `<h1>Example heading <Badge bg="primary"  className="badge">New</Badge></h1>
<h2>Example heading <Badge bg="primary"  className="badge">New</Badge></h2>
<h3>Example heading <Badge bg="primary"  className="badge">New</Badge></h3>
<h4>Example heading <Badge bg="primary"  className="badge">New</Badge></h4>
<h5>Example heading <Badge bg="primary"  className="badge">New</Badge></h5>
<h6>Example heading <Badge bg="primary"  className="badge">New</Badge></h6>`;

export const badge13 = `<div  className="d-flex flex-wrap gap-4">
<button type="button"  className="btn btn-primary position-relative">
Inbox
    <span
         className="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
99+
        <span  className="visually-hidden">unread messages</span>
    </span>
</button>
<button type="button"  className="btn btn-secondary position-relative">
Profile
    <span
         className="position-absolute top-0 start-100 translate-middle p-2 bg-success border border-light rounded-circle">
        <span  className="visually-hidden">New alerts</span>
    </span>
</button>
<span  className="avatar">
    <img src="../../../assets/images/faces/2.jpg" alt="img" />
    <span
         className="position-absolute top-0 start-100 translate-middle p-1 bg-success border border-light rounded-circle">
        <span  className="visually-hidden">New alerts</span>
    </span>
</span>
<span  className="avatar avatar-rounded">
    <img src="../../../assets/images/faces/15.jpg" alt="img" />
    <span  className="position-absolute top-0 start-100 translate-middle p-1 bg-success border border-light              rounded-circle">
        <span  className="visually-hidden">New alerts</span>
    </span>
</span>
<span  className="avatar avatar-rounded">
    <img src="../../../assets/images/faces/10.jpg" alt="img" />
    <span  className="position-absolute top-0 start-100 translate-middle badge bg-secondary rounded-pill shadow-lg">1000+
        <span  className="visually-hidden">New alerts</span>
    </span>
</span>
</div>`;

export const badge14 = `<p  className="mb-xxl-0 badge bg-outline-info custom-badge fs-15 me-5">
<i  className="ti ti-home me-1 d-inline-flex"></i>Home</p>
<p  className="mb-xxl-0 badge bg-success custom-badge fs-15 me-5">
<i  className="ti ti-home me-1 d-inline-flex"></i>Home</p>
<p  className="mb-xxl-0 icon-badge me-5">
<svg  className="icon" xmlns="http://www.w3.org/2000/svg" height="24px"
 viewBox="0 0 24 24" width="24px" fill="#000000">
 <path d="M12 22c1.1 0 2-.9 2-2h-4c0 1.1.89 2 2 2zm6-6v-5c0-3.07-1.64-5.64-4.5-6.32V4c0-.83-.67-1.5-1.
 5-1.5s-1.5.67-1.5 1.5v.68C7.63 5.36 6 7.92 6 11v5l-2 2v1h16v-1l-2-2z"/></svg>
<span  className="badge rounded-pill bg-success">14</span>
</p>
<p  className="mb-xxl-0 badge border bg-light text-default custom-badge me-5"><i  className="fe fe-eye me-1 d-inline-flex"></i>13.2k</p>
<p  className="mb-xxl-0 text-badge me-5">
<span  className="text fs-18">Inbox</span>
<Badge  className="badge rounded-pill bg-success">32</Badge>
</p>`;
/*------ Badge(prism-code for showcode purpose) end ------*/

/*------ Dropdowns(prism-code for showcode purpose) start ------*/
export const dropdown1 = `import { Dropdown } from "react-bootstrap";

<div className="btn-list d-flex align-items-center flex-wrap">
<Dropdown className="dropdown">
    <Dropdown.Toggle variant='' className="btn btn-primary dropdown-toggle" type="button"
        id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false">
        Dropdown button
    </Dropdown.Toggle>
    <Dropdown.Menu as="ul" className="dropdown-menu" aria-labelledby="dropdownMenuButton1">
        <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
        <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
        <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
    </Dropdown.Menu>
</Dropdown>
<Dropdown className="dropdown">
    <Dropdown.Toggle className="btn btn-secondary dropdown-toggle" href="#!" role="button"
        id="dropdownMenuLink" data-bs-toggle="dropdown" aria-expanded="false">
        Dropdown link
    </Dropdown.Toggle>
    <Dropdown.Menu as="ul" className="dropdown-menu" aria-labelledby="dropdownMenuLink">
        <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
        <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
        <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
    </Dropdown.Menu>
</Dropdown>
</div>`;

export const dropdown2 = `import { Dropdown } from "react-bootstrap";
import {  SingleButtons } from "../../../../../shared/data/elements/dropdownsdata";

{SingleButtons.map((idx) => (
    <div  className="btn-group" key={idx.id}>
        <Dropdown>
            <Dropdown.Toggle type="button" variant={idx.class}  className="btn"
                data-bs-toggle="dropdown" aria-expanded="false">
                Action
            </Dropdown.Toggle>
            <Dropdown.Menu as="ul">
                <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
                <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
                <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
                <li>
                    <hr  className="dropdown-divider" />
                </li>
                <Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
            </Dropdown.Menu>
        </Dropdown>
    </div>
))}`;
export const datadropdown2 = `export const SingleButtons = [
	{ id: 1, class: "primary" },
	{ id: 2, class: "secondary" },
	{ id: 3, class: "success" },
	{ id: 4, class: "info" },
	{ id: 5, class: "warning" },
	{ id: 6, class: "danger" }
]; `
export const dropdown3 = `import { Dropdown } from "react-bootstrap";
import {  SingleButtons } from "../../../../../shared/data/elements/dropdownsdata";

<div className="btn-list">
	{SingleButtons.map((idx) => (
	<div className="btn-group" key={idx.id}>
			<Dropdown.Toggle variant={idx.class} type="button" className="btn dropdown-toggle rounded-pill"
						data-bs-toggle="dropdown" aria-expanded="false">
				Action
				</Dropdown.Toggle>
		<Dropdown.Menu as="ul">
			<Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
					<Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
		<Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
				<li>
					<hr className="dropdown-divider" />
						</li>
					<Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
						</Dropdown.Menu>
				</Dropdown>
				</div>
))}
</div>`;

export const dropdown4 = `import { Dropdown } from "react-bootstrap";
import {  OutlineButtons } from "../../../../../shared/data/elements/dropdownsdata";

<div className="btn-list">
{OutlineButtons.map((idx) => (
    <div  className="btn-group" key={idx.id}>
        <Dropdown>
            <Dropdown.Toggle variant={idx.class} type="button"  className="btn  dropdown-toggle"
                data-bs-toggle="dropdown" aria-expanded="false">
                Action
            </Dropdown.Toggle>
            <Dropdown.Menu as="ul">
                <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
                <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
                <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
                <li>
                    <hr  className="dropdown-divider" />
                </li>
                <Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
            </Dropdown.Menu>
        </Dropdown>
    </div>
))}
</div>`;
export const datadropdown4 = `export const OutlineButtons = [
	{ id: 1, class: "outline-primary" },
	{ id: 2, class: "outline-secondary" },
	{ id: 3, class: "outline-success" },
	{ id: 4, class: "outline-info" },
	{ id: 5, class: "outline-warning" },
	{ id: 6, class: "outline-danger" }
]; `
export const dropdown5 = ` import { Dropdown } from "react-bootstrap";
import {  OutlineButtons } from "../../../../../shared/data/elements/dropdownsdata";

<div className="btn-list">
{OutlineButtons.map((idx) => (
<div className="btn-group me-0" key={idx.id}>
<Dropdown>
<Dropdown.Toggle variant={idx.class} type="button" className="btn dropdown-toggle rounded-pill"
data-bs-toggle="dropdown" aria-expanded="false">
Action
</Dropdown.Toggle>
<Dropdown.Menu as="ul">
<Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
<Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
<Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
<Dropdown.Divider className="dropdown-divider" />
<Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
</Dropdown.Menu>
</Dropdown>
</div>
	))}
</div>`;

export const dropdown6 = `import { Dropdown ,SplitButton} from "react-bootstrap";
import {  SplitButtonsdata } from "../../../../../shared/data/elements/dropdownsdata";

 {SplitButtonsdata.map((idx) => (
    <SplitButton key={idx.id}  class='me-2 my-1'
        variant={idx.class}
        title="Action"
    >
        <Dropdown.Item eventKey="1">Action</Dropdown.Item>
        <Dropdown.Item eventKey="2">Another action</Dropdown.Item>
        <Dropdown.Item eventKey="3" active>
            Active Item
        </Dropdown.Item>
        <Dropdown.Divider />
        <Dropdown.Item eventKey="4">Separated link</Dropdown.Item>
    </SplitButton>
))}`;
export const datadropdown6 = `export const SplitButtonsdata= [
	{ id: 1, class: "primary" },
	{ id: 2, class: "secondary" },
	{ id: 3, class: "info" },
	{ id: 4, class: "success" },
	{ id: 5, class: "warning" },
	{ id: 6, class: "danger" }
]; `
export const dropdown7 = `import { Dropdown } from "react-bootstrap";

<div  className="btn-group my-1 me-2">
 <Dropdown>
     <Dropdown.Toggle variant=''  className="btn btn-primary btn-lg dropdown-toggle" type="button"
         data-bs-toggle="dropdown" aria-expanded="false">
         Large button
     </Dropdown.Toggle>
     <Dropdown.Menu as="ul">
         <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
         <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
         <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
         <Dropdown.Divider  className="dropdown-divider" />
         <Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
     </Dropdown.Menu>
 </Dropdown>
</div>
<div  className="btn-group my-1 me-2">
 <Dropdown as={ButtonGroup}>
     <Button variant="light">Large split button</Button>
     <Dropdown.Toggle split variant="light" id="dropdown-split-basic" />
     <Dropdown.Menu>
         <Dropdown.Item href="#/action-1">Action</Dropdown.Item>
         <Dropdown.Item href="#/action-2">Another action</Dropdown.Item>
         <Dropdown.Item href="#/action-3">Something else</Dropdown.Item>
         <Dropdown.Divider  className="dropdown-divider" />
         <Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
     </Dropdown.Menu>
 </Dropdown>
</div>
<div  className="btn-group my-1 me-2">
 <Dropdown>
     <Dropdown.Toggle size="sm" variant=''  className="btn btn-primary dropdown-toggle" type="button"
         data-bs-toggle="dropdown" aria-expanded="false">
         Small button
     </Dropdown.Toggle>
     <Dropdown.Menu as="ul">
         <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
         <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
         <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
         <Dropdown.Divider  className="dropdown-divider" />
         <Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
     </Dropdown.Menu>
 </Dropdown>
</div>
<div  className="btn-group my-1 me-2">
 <Dropdown as={ButtonGroup}>
     <Button size='sm' variant="light">Small split button</Button>
     <Dropdown.Toggle split variant="light" id="dropdown-split-basic" />
     <Dropdown.Menu>
         <Dropdown.Item href="#/action-1">Action</Dropdown.Item>
         <Dropdown.Item href="#/action-2">Another action</Dropdown.Item>
         <Dropdown.Item href="#/action-3">Something else</Dropdown.Item>
         <Dropdown.Divider  className="dropdown-divider" />
         <Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
     </Dropdown.Menu>
 </Dropdown>
</div>`;

export const dropdown8 = `import { Dropdown } from "react-bootstrap";

 <Dropdown drop="up"  className="btn-group dropup my-1 me-2">
 <Dropdown.Toggle variant='' type="button"  className="btn btn-primary dropdown-toggle"
     data-bs-toggle="dropdown" aria-expanded="false">
     Dropup
 </Dropdown.Toggle>
 <Dropdown.Menu as="ul">
     <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
     <Dropdown.Divider  className="dropdown-divider" />
     <Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
 </Dropdown.Menu>
</Dropdown>
<Dropdown drop="up"  className="btn-group dropup my-1">
 <Button variant='' type="button"  className="btn btn-info">
     Split dropup
 </Button>
 <Dropdown.Toggle variant='' type="button"
      className="btn btn-info dropdown-toggle dropdown-toggle-split"
     data-bs-toggle="dropdown" aria-expanded="false">
     <span  className="visually-hidden">Toggle Dropdown</span>
 </Dropdown.Toggle>
 <Dropdown.Menu as="ul">
     <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
     <Dropdown.Divider  className="dropdown-divider" />
     <Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
 </Dropdown.Menu>
</Dropdown>`;

export const dropdown9 = `import { Dropdown ,Button } from "react-bootstrap";

 <Dropdown  className="btn-group dropend my-1 me-2" drop="end">
 <Dropdown.Toggle variant='' type="button"  className="btn btn-primary dropdown-toggle"
     data-bs-toggle="dropdown" aria-expanded="false">
     Dropright
 </Dropdown.Toggle>
 <Dropdown.Menu as="ul">
     <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
     <Dropdown.Divider  className="dropdown-divider" />
     <Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
 </Dropdown.Menu>
</Dropdown>
<Dropdown drop="end"  className="btn-group dropend my-1">
 <Button variant='' type="button"  className="btn btn-info">
     Split dropend
 </Button>
 <Dropdown.Toggle variant='' type="button"
      className="btn btn-info dropdown-toggle dropdown-toggle-split"
     data-bs-toggle="dropdown" aria-expanded="false">
     <span  className="visually-hidden">Toggle Dropright</span>
 </Dropdown.Toggle>
 <Dropdown.Menu as="ul">
     <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
     <Dropdown.Divider  className="dropdown-divider" />
     <Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
 </Dropdown.Menu>
</Dropdown>`;

export const dropdown10 = `import { Dropdown ,Button } from "react-bootstrap";
<Dropdown  className="btn-group dropstart my-1 me-2" drop="start">
 <Dropdown.Toggle variant='' type="button"  className="btn btn-primary dropdown-toggle"
     data-bs-toggle="dropdown" aria-expanded="false">
     Dropstart
 </Dropdown.Toggle>
 <Dropdown.Menu as="ul">
     <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
     <Dropdown.Divider  className="dropdown-divider" />
     <Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
 </Dropdown.Menu>
 </Dropdown>
 <div  className="btn-group">
 <Dropdown  className="btn-group dropstart my-1" role="group" drop="start">
     <Dropdown.Toggle variant='' type="button"
          className="btn btn-info dropdown-toggle dropdown-toggle-split"
         data-bs-toggle="dropdown" aria-expanded="false">
         <span  className="visually-hidden">Toggle Dropstart</span>
     </Dropdown.Toggle>
     <Dropdown.Menu as="ul">
         <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
         <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
         <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
         <Dropdown.Divider  className="dropdown-divider" />
         <Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
     </Dropdown.Menu>
 </Dropdown>
 <Button variant='' type="button"  className="btn btn-info my-1">
     Split dropstart
 </Button>
 </div>`;

export const dropdown11 = `import { Dropdown } from "react-bootstrap";

<Dropdown>
 <Dropdown.Toggle variant='' type="button"  className="btn btn-primary dropdown-toggle"
     data-bs-toggle="dropdown" aria-expanded="false">
     Dropstart
 </Dropdown.Toggle>
 <Dropdown.Menu as="ul">
     <Dropdown.Item as="li" href="#!">Regular link</Dropdown.Item>
     <Dropdown.Item  className="dropdown-item active" href="#!" aria-current="true">Active
         link
     </Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Another link</Dropdown.Item>
 </Dropdown.Menu>
</Dropdown>`;

export const dropdown12 = ` import { Dropdown } from "react-bootstrap";

<Dropdown>
 <Dropdown.Toggle variant='' type="button"  className="btn btn-primary dropdown-toggle"
     data-bs-toggle="dropdown" aria-expanded="false">
     Dropstart
 </Dropdown.Toggle>
 <Dropdown.Menu as="ul">
     <Dropdown.Item as="li" href="#!">Regular link</Dropdown.Item>
     <Dropdown.Item  className="dropdown-item disabled" href="#!" aria-current="true">Active
         link</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Another link</Dropdown.Item>
 </Dropdown.Menu>
</Dropdown>`;

export const dropdown13 = `import { Dropdown } from "react-bootstrap";
import {  AutocloseButtons } from "../../../../../shared/data/elements/dropdownsdata";

<div className="btn-list">
{AutocloseButtons.map((idx) => (
    <div  className="btn-group" key={idx.id}>
        <Dropdown>
            <Dropdown.Toggle variant={idx.class}  className="btn btn-primary dropdown-toggle" type="button"
                id="defaultDropdown" data-bs-toggle="dropdown" data-bs-auto-close="true"
                aria-expanded="false">
                {idx.text}
            </Dropdown.Toggle>
            <Dropdown.Menu as="ul" aria-labelledby="defaultDropdown">
                <Dropdown.Item as="li" href="#!">Menu item</Dropdown.Item>
                <Dropdown.Item as="li" href="#!">Menu item</Dropdown.Item>
                <Dropdown.Item as="li" href="#!">Menu item</Dropdown.Item>
            </Dropdown.Menu>
        </Dropdown>
    </div>
))}
</div>`;
export const datadropdown13 = `export const AutocloseButtons = [
	{ id: 1, class: "primary", text: "Default dropdown" },
	{ id: 2, class: "secondary", text: "Clickable  outside" },
	{ id: 3, class: "info", text: "Clickable  inside" },
	{ id: 4, class: "warning", text: "Manual  close" },
]; `
export const dropdown14 = ` import {  Dropdown, Form } from "react-bootstrap";

<Dropdown>
 <Dropdown.Toggle variant=''  className="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenu2"
     data-bs-toggle="dropdown" aria-expanded="false">
     Dropdown
 </Dropdown.Toggle>
 <Dropdown.Menu  className="dropdown-menu">
     <Form  className="px-4 py-3">
         <div  className="mb-3">
             <Form.Label htmlFor="exampleDropdownFormEmail1"  className="form-label">Email
                 address</Form.Label>
             <Form.Control type="email"  className="form-control" id="exampleDropdownFormEmail1"
                 placeholder="email@example.com" />
         </div>
         <div  className="mb-3">
             <Form.Label htmlFor="exampleDropdownFormPassword1"
                  className="form-label">Password</Form.Label>
             <Form.Control type="password"  className="form-control"
                 id="exampleDropdownFormPassword1" placeholder="Password" />
         </div>
         <div  className="mb-3">
             <div  className="form-check">
                 <input type="checkbox"  className="form-check-input" id="dropdownCheck" />
                 <label  className="form-check-label" htmlFor="dropdownCheck">
                     Remember me
                 </label>
             </div>
         </div>
         <Button variant='' type="submit"  className="btn btn-primary">Sign in</Button>
     </Form>
     <div  className="dropdown-divider"></div>
     <Dropdown.Item as="li" href="#!">New around here? Sign up</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Forgot password?</Dropdown.Item>
 </Dropdown.Menu>
</Dropdown>`;

export const dropdown15 = `import { Dropdown  } from "react-bootstrap";

<p  className="card-title mb-3">Use <code>.dropdown-center</code> on the parent element.
 </p>
 <Dropdown  className="dropdown-center">
     <Dropdown.Toggle variant=''  className="btn btn-primary dropdown-toggle" type="button"
         id="dropdownCenterBtn" data-bs-toggle="dropdown" aria-expanded="false">
         Centered dropdown
     </Dropdown.Toggle>
     <Dropdown.Menu as="ul" aria-labelledby="dropdownCenterBtn">
         <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
         <Dropdown.Item as="li" href="#!">Action two</Dropdown.Item>
         <Dropdown.Item as="li" href="#!">Action three</Dropdown.Item>
     </Dropdown.Menu>
 </Dropdown>`;

export const dropdown16 = `import { Dropdown  } from "react-bootstrap";

<p  className="card-title mb-3">Use <code>.dropup-center</code>
 on the parent element.
</p>
<Dropdown  className="dropup-center dropup" drop="up">
 <Dropdown.Toggle variant=''  className="btn btn-secondary dropdown-toggle" type="button"
     id="dropupCenterBtn" data-bs-toggle="dropdown" aria-expanded="false">
     Centered dropup
 </Dropdown.Toggle>
 <Dropdown.Menu as="ul" aria-labelledby="dropupCenterBtn">
     <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Action two</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Action three</Dropdown.Item>
 </Dropdown.Menu>
</Dropdown>`;

export const dropdown17 = `import { Dropdown  } from "react-bootstrap";

<p  className="card-title mb-3">You can use <code>&lt;a&gt;</code> or <code>&lt;button&gt;</code> as
 dropdown items.</p>
<Dropdown  className="dropdown">
 <Dropdown.Toggle variant=''  className="btn btn-info dropdown-toggle" type="button"
     id="dropdownMenu1" data-bs-toggle="dropdown" aria-expanded="false">
     Dropdown
 </Dropdown.Toggle>
 <Dropdown.Menu as="ul" aria-labelledby="dropdownMenu1">
     <Dropdown.Item>Action</Dropdown.Item>
     <Dropdown.Item>Another action
     </Dropdown.Item>
     <Dropdown.Item>Something else
         here
     </Dropdown.Item>
 </Dropdown.Menu>
</Dropdown>`;

export const dropdown18 = `import { Dropdown  } from "react-bootstrap";

<p  className="card-title mb-3">Use <code>data-bs-offset</code> or <code>data-bs-reference</code> to change
 the location of the dropdown.</p>
 <div  className="d-flex align-items-center flex-wrap">
 <Dropdown  className="dropdown me-1 mt-1">
     <Dropdown.Toggle variant='' type="button"  className="btn btn-primary dropdown-toggle"
         id="dropdownMenuOffset" data-bs-toggle="dropdown" aria-expanded="false"
         data-bs-offset="10,20">
         Offset
     </Dropdown.Toggle>
     <Dropdown.Menu as="ul" aria-labelledby="dropdownMenuOffset">
         <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
         <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
         <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
     </Dropdown.Menu>
 </Dropdown>
 <ButtonGroup  className="btn-group custom-btn-group mt-1">
     <Button variant='' type="button"  className="btn btn-info">Reference</Button>
     <Dropdown>
         <Dropdown.Toggle variant='' type="button"
              className="btn btn-info dropdown-toggle dropdown-toggle-split"
             id="dropdownMenuReference" data-bs-toggle="dropdown"
             aria-expanded="false" data-bs-reference="parent">
             <span  className="visually-hidden">Toggle Dropdown</span>
         </Dropdown.Toggle>
         <Dropdown.Menu as="ul" aria-labelledby="dropdownMenuReference">
             <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
             <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
             <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
             <Dropdown.Divider  className="dropdown-divider" />
             <Dropdown.Item as="li" href="#!">Separated link</Dropdown.Item>
         </Dropdown.Menu>
     </Dropdown>
 </ButtonGroup>
 </div>`;

export const dropdown19 = `import { Dropdown  } from "react-bootstrap";
import {  AlignmentButtons } from "../../../../../shared/data/elements/dropdownsdata";


<div  className="btn-list">
 {AlignmentButtons.map((idx) => (
     <div  className="btn-group" key={idx.id}>
         <Dropdown drop={idx.dir}>
             <Dropdown.Toggle variant={idx.class}  className="btn btn-primary dropdown-toggle mb-0" type="button"
                 id="dropdownMenuButton" data-bs-toggle="dropdown"
                 aria-expanded="false">
                 {idx.text}
             </Dropdown.Toggle>
             <Dropdown.Menu as="ul" aria-labelledby="dropdownMenuButton">
                 <Dropdown.Item as="li" href="#!">Menu item</Dropdown.Item>
                 <Dropdown.Item as="li" href="#!">Menu item</Dropdown.Item>
                 <Dropdown.Item as="li" href="#!">Menu item</Dropdown.Item>
             </Dropdown.Menu>
         </Dropdown>
     </div>
 ))}
 </div>`;
 export const datadropdown19 = `export const AlignmentButtons= [
	{ id: 1, class: "primary", text: "Dropdown", dir: "" },
	{ id: 2, class: "secondary", text: "Right-aligned menu", dir: "" },
	{ id: 3, class: "info", text: "Left-aligned, right-aligned lg", dir: "" },
	{ id: 4, class: "warning", text: "Right-aligned, left-aligned lg", dir: "" },
	{ id: 5, class: "danger", text: "Dropend", dir: "end" },
	{ id: 6, class: "success", text: "Dropstart", dir: "start" },
	{ id: 7, class: "teal", text: "Dropup", dir: "up" }
]; `

export const dropdown20 = `import { Dropdown  } from "react-bootstrap";

<Dropdown>
 <Dropdown.Toggle variant=''  className="btn btn-dark dropdown-toggle" type="button"
     id="dropdownMenuButton3" data-bs-toggle="dropdown" aria-expanded="false">
     Dropdown button
 </Dropdown.Toggle>
 <Dropdown.Menu as="ul"  className="dropdown-menu dropdown-menu-dark">
     <Dropdown.Item as="li" href="#!">Action</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Another action</Dropdown.Item>
     <Dropdown.Item as="li" href="#!">Something else here</Dropdown.Item>
 </Dropdown.Menu>
</Dropdown>`;

export const dropdown21 = `import { Dropdown  } from "react-bootstrap";

<Dropdown>
 <Dropdown.Toggle variant='' type="button"  className="btn btn-primary dropdown-toggle"
     data-bs-toggle="dropdown" aria-expanded="false">
     Right-aligned menu example
 </Dropdown.Toggle>
 <Dropdown.Menu  className="dropdown-menu dropdown-menu-end">
     <Dropdown.Item>Action
     </Dropdown.Item>
     <Dropdown.Item>Another
         action</Dropdown.Item>
     <Dropdown.Item>Something else
         here
     </Dropdown.Item>
 </Dropdown.Menu>
</Dropdown>`;

export const dropdown22 = `import { Dropdown  } from "react-bootstrap";

<div className="btn-group ">
<Dropdown align={{ lg: "end" }}>
	<Dropdown.Toggle variant='' type="button" className="btn btn-secondary dropdown-toggle text-wrap"
		data-bs-toggle="dropdown" aria-expanded="false">
		Left-aligned but right aligned when large screen
	</Dropdown.Toggle>
	<Dropdown.Menu className="dropdown-menu dropdown-menu-end">
		<Dropdown.Item>Action
		</Dropdown.Item>
		<Dropdown.Item>Another
			action</Dropdown.Item>
		<Dropdown.Item>Something else
			here
		</Dropdown.Item>
	</Dropdown.Menu>
</Dropdown>
</div>`;

export const dropdown23 = `import { Dropdown  } from "react-bootstrap";

<div className="btn-group">
<Dropdown align={{ lg: "start" }}>
	<Dropdown.Toggle variant='' type="button" className="btn btn-info dropdown-toggle text-wrap"
		data-bs-toggle="dropdown" aria-expanded="false">
		Left-aligned but right aligned when large screen
	</Dropdown.Toggle>
	<Dropdown.Menu className="dropdown-menu dropdown-menu-end">
		<Dropdown.Item>Action
		</Dropdown.Item>
		<Dropdown.Item>Another
			action</Dropdown.Item>
		<Dropdown.Item>Something else
			here
		</Dropdown.Item>
	</Dropdown.Menu>
</Dropdown>
</div>`;

export const dropdown24 = `import { Dropdown  } from "react-bootstrap";
import {  CustomButtons } from "../../../../../shared/data/elements/dropdownsdata";

<div className="btn-list">
{CustomButtons.map((idx) => (
	<div className="btn-group" key={idx.id}>
		<Dropdown>
			<Dropdown.Toggle variant={idx.class} className="btn dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
				{idx.text}
			</Dropdown.Toggle>
			<Dropdown.Menu className={"dropdown-menu-&#{idx.class} dropdown-&#{idx.class1} dropmenu}"}>
				<li>
					<Dropdown.Item as="a" className="dropdown-item" href="#!">Action</Dropdown.Item>
				</li>
				<li>
					<Dropdown.Item as="a" className="dropdown-item" href="#!">Another action</Dropdown.Item>
				</li>
				<li>
					<Dropdown.Item as="a" className="dropdown-item" href="#!">Something else here</Dropdown.Item>
				</li>
			</Dropdown.Menu>
		</Dropdown>
	</div>
))}
</div>`;
export const datadropdown24 = `export const CustomButtons = [
	{ id: 1, class: "primary", text: "Primary", class1: "menu-primary", class2: "" },
	{ id: 2, class: "secondary", text: "Secondary", class1: "menu-secondary", class2: "" },
	{ id: 3, class: "warning", text: "warning", class2: "item-warning", class1: "" },
	{ id: 4, class: "info", text: "info", class2: "item-info", class1: "" },
	{ id: 5, class: "success", text: "success", class2: "light-success", class1: "" },
	{ id: 6, class: "danger", text: "danger", class2: "light-danger", class1: "" }
]; `
export const dropdown25 = `import { Dropdown } from "react-bootstrap";
import {  GhostButtons } from "../../../../../shared/data/elements/dropdownsdata";

<div  className="btn-list">
 {GhostButtons.map((idx) => (
     <div  className="btn-group" key={idx.id}>
         <Dropdown>
             <Dropdown.Toggle variant={idx.class} type="button"  className="btn btn-primary-ghost dropdown-toggle"
                 data-bs-toggle="dropdown" aria-expanded="false">
                 {idx.text}
             </Dropdown.Toggle>
             <Dropdown.Menu>
                 <Dropdown.Item  className="dropdown-item" href="#!">Action</Dropdown.Item>
                 <Dropdown.Item  className="dropdown-item" href="#!">Another action</Dropdown.Item>
                 <Dropdown.Item  className="dropdown-item" href="#!">Something else here</Dropdown.Item>
                 <Dropdown.Divider  className="dropdown-divider" />
                 <Dropdown.Item  className="dropdown-item" href="#!">Separated link</Dropdown.Item>
             </Dropdown.Menu>
         </Dropdown>
     </div>
 ))}
</div>`;
export const datadropdown25 = `export const GhostButtons= [
	{ id: 1, class: "primary-ghost", text: "Primary" },
	{ id: 2, class: "secondary-ghost", text: "Secondary" },
	{ id: 3, class: "warning-ghost", text: "warning" },
	{ id: 4, class: "info-ghost", text: "info" },
	{ id: 5, class: "success-ghost", text: "success" },
	{ id: 6, class: "danger-ghost", text: "danger" }
]; `
export const dropdown26 = `import { Dropdown  } from "react-bootstrap";

<p  className="card-title mb-3">Use <code>.dropdown-item-text.</code> to create non-interactive dropdown items.</p>
 <div  className="bd-example">
     <Dropdown.Menu  className="dropdown-menu" show>
         <Dropdown.Item><span  className="dropdown-item-text">Dropdown item text</span>
         </Dropdown.Item>
         <Dropdown.Item href="#!">Action</Dropdown.Item>
         <Dropdown.Item href="#!">Another action</Dropdown.Item>
         <Dropdown.Item href="#!">Something else here
         </Dropdown.Item>
     </Dropdown.Menu>
 </div>`;

export const dropdown27 = `import { Dropdown  } from "react-bootstrap";

<p  className="card-titlte mb-3">Add a <code>.dropdown-header</code> to label sections of actions in any dropdown menu.</p>
 <div  className="bd-example">
     <Dropdown.Menu show>
         <Dropdown.Header>
             <h6  className="dropdown-header">Dropdown header</h6>
         </Dropdown.Header>
         <Dropdown.Item  className="dropdown-item" href="#!">Action</Dropdown.Item>
         <Dropdown.Item  className="dropdown-item" href="#!">Another action</Dropdown.Item>
         <Dropdown.Item  className="dropdown-item" href="#!">Something else here</Dropdown.Item>
     </Dropdown.Menu>
 </div>`;

export const dropdown28 = `import { Dropdown  } from "react-bootstrap";

<div  className="bd-example">
 <Dropdown.Menu  className="dropdown-menu" show>
     <Dropdown.Header>Heading</Dropdown.Header>
     <Dropdown.Item  className="dropdown-item" href="#!">Action</Dropdown.Item>
     <Dropdown.Item  className="dropdown-item" href="#!">Another action</Dropdown.Item>
     <Dropdown.Item  className="dropdown-item" href="#!">Something else here</Dropdown.Item>
     <Dropdown.Divider  className="dropdown-divider" />
     <Dropdown.Item  className="dropdown-item" href="#!">Separated link</Dropdown.Item>
 </Dropdown.Menu>
</div>`;

export const dropdown29 = `import { Dropdown  } from "react-bootstrap";

<div  className="bd-example">
 <Dropdown.Menu show  className="dropdown-menu p-4 text-muted" style={{ maxWidth: 200 }}>
     <p>
         Some example text that's free-flowing within the dropdown menu.
     </p>
     <p  className="mb-0">
         And this is more example text.
     </p>
 </Dropdown.Menu>
</div>`;
/*------ Dropdowns(prism-code for showcode purpose) end ------*/

/*------ Images &figures (prism-code for showcode purpose) start ------*/
export const image1 = ` <div  className="text-center">
<img src="../../../assets/images/media/media-48.jpg"  className="img-fluid" alt="..."/>
</div>`;

export const image2 = `<div  className="text-center">
<img src="../../../assets/images/media/media-49.jpg"   className="img-fluid rounded" alt="..."/>
</div>`;

export const image3 = ` <div  className="text-center">
<img src="../../../assets/images/media/media-50.jpg"  className="img-fluid rounded-pill" alt="..."/>
</div>`;

export const image4 = ` <div  className="text-center">
<div  className="d-inline-block">
<img  className="rounded float-start" src="../../../assets/images/media/media-53.jpg" alt="..." />
</div>
</div>`;

export const image5 = ` <img  className="rounded mx-auto d-block" 
src="../../../assets/images/media/media-55.jpg" alt="..."/>`;

export const image6 = ` <div  className="d-inline-block">
<img  className="rounded float-end" src="../../../assets/images/media/media-54.jpg" alt="..." />
</div>`;

export const image7 = ` <figure  className="figure">
<img  className="bd-placeholder-img figure-img img-fluid rounded card-img"
 src="../../../assets/images/media/media-56.jpg" alt="..."/>
<figcaption  className="figure-caption">A caption for the above image.
</figcaption>
</figure>
<figure  className="figure float-end">
<img  className="bd-placeholder-img figure-img img-fluid rounded card-img" 
src="../../../assets/images/media/media-57.jpg" alt="..."/>
<figcaption  className="figure-caption text-end">A caption for the above image.
</figcaption>
</figure>`;

export const image8 = ` <p  className="card-title mb-3">Use <code> .img-thumbnail 
</code>to give an image a rounded 1px border.</p>
 <div  className="text-center">
     <img src="../../../assets/images/media/media-51.jpg"
       className="img-thumbnail" alt="..."/>
 </div>`;

export const image9 = ` <div  className="text-center">
<img src="../../../assets/images/media/media-52.jpg"
  className="img-thumbnail rounded-pill" alt="..."/>
</div>`;
/*------ Images &figures (prism-code for showcode purpose) end ------*/

/*------ ListGroup (prism-code for showcode purpose) start ------*/
export const Listgroup1 = `import { ListGroup } from "react-bootstrap";
import { BasicButtons } from "../../../../../shared/data/elements/listgroupdata";

<ListGroup as="ul">
 {BasicButtons.map((idx)=>(
    <ListGroup.Item as="li" key={idx.id}>
        <div  className="d-flex align-items-center">
            <span  className="avatar avatar-sm">
                <img src={idx.src} alt="img"/>
            </span>
            <div  className="ms-2 fw-semibold">
                {idx.text}
            </div>
        </div>
    </ListGroup.Item>
    ))}
    </ListGroup> `;
    export const dataListgroup1 = `export const BasicButtons= [
        { id: 1, src: "../../../assets/images/faces/1.jpg", text: "Alicia Sierra" },
        { id: 2, src: "../../../assets/images/faces/3.jpg", text: "Samantha Mery" },
        { id: 3, src: "../../../assets/images/faces/6.jpg", text: "Juliana Pena" },
        { id: 4, src: "../../../assets/images/faces/15.jpg", text: "Adam Smith" },
        { id: 5, src: "../../../assets/images/faces/13.jpg", text: "Farhaan Amhed" },
    ]; `
export const Listgroup2 = `import { ListGroup } from "react-bootstrap";
import { ActiveButtons } from "../../../../../shared/data/elements/listgroupdata";

<ListGroup as="ul">
{ActiveButtons.map((idx) => (
	<ListGroup.Item as="li" className={"list-group-item &#{idx.class1}"} aria-current="true" key={idx.id}>
		<div className="d-flex align-items-center">
			<div>
				<span className="fs-15 ">
					<i className={"bi bi-&#{idx.class}"}></i>
				</span>
			</div>
			<div className="ms-2">
				{idx.text}
			</div>
		</div>
	</ListGroup.Item>
))}
</ListGroup>`;
export const dataListgroup2 = `export const ActiveButtons= [
	{ id: 1, class: "house-door", text: "Home", class1: "active" },
	{ id: 2, class: "bell", text: "Notifications", class1: "" },
	{ id: 3, class: "gift", text: "Sent Messages", class1: "" },
	{ id: 4, class: "person", text: "New Requests", class1: "" },
	{ id: 5, class: "trash3", text: "Deleted Messages", class1: "" },
]; `
export const Listgroup3 = `import { ListGroup } from "react-bootstrap";

 <ListGroup as="ul">
<ListGroup.Item as="li" className="list-group-item disabled" aria-disabled="true">A disabled item meant to be disabled
</ListGroup.Item>
<ListGroup.Item as="li">Simply dummy text of the printing</ListGroup.Item>
<ListGroup.Item as="li">There are many variations of passages</ListGroup.Item>
<ListGroup.Item as="li">All the Lorem Ipsum generators</ListGroup.Item>
<ListGroup.Item as="li">Written in 45 BC. This book is a treatise on the theory</ListGroup.Item>
 </ListGroup>`;

export const Listgroup4 = `import { ListGroup } from "react-bootstrap";

<ListGroup variant='flush'  className="">
<ListGroup.Item  className="fw-semibold"><i  className="bi bi-envelope align-middle me-2 text-muted"></i>Asish Trivedhi<span  className="ms-1 text-muted fw-normal d-inline-block">(+1023-84534)</span></ListGroup.Item>
<ListGroup.Item  className="fw-semibold"><i  className="bi bi-tiktok align-middle me-2 text-muted"></i>Alezander Russo<span  className="ms-1 text-muted fw-normal d-inline-block">(+7546-12342)</span></ListGroup.Item>
<ListGroup.Item  className="fw-semibold"><i  className="bi bi-whatsapp align-middle me-2 text-muted"></i>Karem Smith<span  className="ms-1 text-muted fw-normal d-inline-block">(+9944-56632)</span></ListGroup.Item>
<ListGroup.Item  className="fw-semibold"><i  className="bi bi-facebook align-middle me-2 text-muted"></i>Melissa Brien<span  className="ms-1 text-muted fw-normal d-inline-block">(+1023-34323)</span></ListGroup.Item>
<ListGroup.Item  className="fw-semibold"><i  className="bi bi-instagram align-middle me-2 text-muted"></i>Kamala Harris<span  className="ms-1 text-muted fw-normal d-inline-block">(+91-63421)</span></ListGroup.Item>
</ListGroup>`;

export const Listgroup5 = `import { ListGroup } from "react-bootstrap";
import { LinksButtons } from "../../../../../shared/data/elements/listgroupdata";

<ListGroup className="list-group">
{LinksButtons.map((idx) => (
    <ListGroup.Item action className={"list-group-item-action &#{idx.class1}} key={idx.id}
        aria-current="true">
        <div className="d-flex align-items-center">
            <div>
                <span className={"avatar avatar-xs bg-&#{idx.class} text-&#{idx.color} avatar-rounded"}>
                    {idx.text1}
                </span>
            </div>
            <div className="ms-2">{idx.text}</div>
        </div>
    </ListGroup.Item>
))}
</ListGroup>`;
export const dataListgroup5 = `export const LinksButtons = [
	{ id: 1, class: "white", text: "California", class1: "active", text1: "C", color: "default" },
	{ id: 2, class: "secondary", text: "New Jersey", class1: "", text1: "N", color: "" },
	{ id: 3, class: "info", text: "Los Angeles", class1: "", text1: "L", color: "" },
	{ id: 4, class: "warning", text: "Miami Florida", class1: "", text1: "M", color: "" },
	{ id: 5, class: "success", text: "Washington D.C", class1: "disabled", text1: "W", color: "" },
]; `
export const Listgroup6 = `import { ListGroup } from "react-bootstrap";

<ListGroup  className="list-group">
<ListGroup.Item type="button"  className="list-group-item-action active" aria-current="true">Simply dummy text of the printing<span  className="badge float-end bg-primary">243</span></ListGroup.Item>
<ListGroup.Item type="button"  className="list-group-item-action">There are many variations of passages<span  className="badge float-end bg-secondary-transparent">35</span></ListGroup.Item>
<ListGroup.Item type="button"  className="list-group-item-action">All the Lorem Ipsum generators<span  className="badge float-end bg-info-transparent">132</span></ListGroup.Item>
<ListGroup.Item type="button"  className="list-group-item-action">All the Lorem Ipsum generators<span  className="badge float-end bg-success-transparent">2525</span></ListGroup.Item>
<ListGroup.Item type="button"  className="list-group-item-action" disabled>A disabled item meant to be disabled<span  className="badge float-end bg-danger-transparent">21</span></ListGroup.Item>
</ListGroup>`;

export const Listgroup7 = `import { ListGroup } from "react-bootstrap";
import { ContextualButtons } from "../../../../../shared/data/elements/listgroupdata";

 <ListGroup as="ul">
{ContextualButtons.map((idx)=>(
<ListGroup.Item as="li" variant={idx.class} key={idx.id}>{idx.text}</ListGroup.Item>
))}</ListGroup>`;
export const dataListgroup7 = `export const ContextualButtons = [
	{ id: 1, text: "A simple default list group item", class: " ", class1:"" },
	{ id: 2, text: "A simple primary list group item", class: "primary", class1:"" },
	{ id: 3, text: "A simple secondary list group item", class: "secondary", class1:"" },
	{ id: 4, text: "A simple success list group item", class: "success", class1:"" },
	{ id: 5, text: "A simple danger list group item", class: "danger", class1:"" },
	{ id: 6, text: "A simple warning list group item", class: "warning", class1:"" },
	{ id: 7, text: "A simple info list group item", class: "info", class1:"" },
	{ id: 8, text: "A simple light list group item", class: "light", class1:"" },
	{ id: 9, text: "A simple dark list group item", class: "dark", class1:"text-white" }
]; `
export const Listgroup8 = `import { ListGroup } from "react-bootstrap";
import { ContextualButtons } from "../../../../../shared/data/elements/listgroupdata";

<ListGroup as="ul">
{ContextualButtons.map((idx)=>(
    <ListGroup.Item variant={idx.class} action  className=" list-group-item-action">{idx.text}</ListGroup.Item>
))}</ListGroup>`;

export const Listgroup9 = `import { ListGroup } from "react-bootstrap";
import { ContextualButtons } from "../../../../../shared/data/elements/listgroupdata";

<ListGroup as="ul">
{ContextualButtons.map((idx) => (
    <ListGroup.Item className={"list-item-solid-&#{idx.class} &#{idx.class1}"} as="li" key={idx.id}>{idx.text}</ListGroup.Item>
))}

</ListGroup>`;

export const Listgroup10 = `import { ListGroup } from "react-bootstrap";
import { CustomButtons } from "../../../../../shared/data/elements/listgroupdata";

 <ListGroup className="list-group">
{CustomButtons.map((idx) => (
    <ListGroup.Item action className={"list-group-item-action &#{idx.class1}"} key={idx.id}
        aria-current="true">
        <div className="d-flex w-100 justify-content-between gap-1">
            <h6 className={"mb-1 fw-semibold text-&#{idx.color}"}>{idx.heading}</h6>
            <small className={idx.class2}>{idx.text1}</small>
        </div>
        <p className="mb-1">{idx.text2}</p>
        <small>{idx.text3}.</small>
    </ListGroup.Item>
))}
</ListGroup>`;
export const dataListgroup10 = `export const CustomButtons = [
	{ id: 1, heading: "Web page editors now use Lorem Ipsum?", text1: "3 days ago", class1: "active", text2: "There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour.", text3: "24,Nov 2022", class2: "" ,color: "fixed-white"},
	{ id: 2, heading: "Richard McClintock, a Latin professor?", text1: "4 hrs ago", class1: "", text2: "Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature.", text3: "30,Nov 2022.", class2: "text-muted",color: "" },
	{ id: 3, heading: "It uses a dictionary of over 200 Latin words?", text1: "15 hrs ago", class1: "", text2: "Lorem Ipsum has been the industrys standard dummy text ever since the 1500s.", text3: "4,Nov 2022.", class2: "text-muted" ,color: ""},
	{ id: 4, heading: "The standard Lorem Ipsum used since the 1500s?", text1: "45 mins ago", class1: "", text2: "All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet.", text3: "28,Oct 2022.", class2: "text-muted" ,color: ""},
]; `
export const Listgroup11 = `import { ListGroup,Badge } from "react-bootstrap";
import { SubheadingsButtons } from "../../../../../shared/data/elements/listgroupdata";

<ListGroup as="ol" numbered>
{SubheadingsButtons.map((idx)=>(
<ListGroup.Item as="li"  className="list-group-item d-flex justify-content-between align-items-start" key={idx.id}>
    <div  className="ms-2 me-auto text-muted">
        <div  className="fw-semibold fs-14 text-default">{idx.text1}</div>
        {idx.text2}
    </div>
    <Badge bg={idx.class}>{idx.text3}</Badge>
</ListGroup.Item>
))}</ListGroup>`;
export const dataListgroup11 = `export const SubheadingsButtons = [
	{ id: 1, text1: "What Happened?", text2: "Many experts have recently suggested may exist.", text3: "32 Views", class: "primary-transparent" },
	{ id: 2, text1: "It Was Amazing!", text2: " His idea involved taking red.", text3: "52 Views", class: "secondary-transparent" },
	{ id: 3, text1: "News Is A Great Weapon.", text2: "News can influence in many ways.", text3: "1,204 Views", class: "success-transparent" },
	{ id: 4, text1: "majority have suffered.", text2: " If you are going to use a passage of Lorem Ipsum, you need to be sure there isn't anything.", text3: "14 Views", class: "danger-transparent" }
];`
export const Listgroup12 = `import { ListGroup } from "react-bootstrap";

<ListGroup as="ol" numbered>
<ListGroup.Item as="li">Simply dummy text of the printing.</ListGroup.Item>
<ListGroup.Item as="li">There are many variations of passages.</ListGroup.Item>
<ListGroup.Item as="li">All the Lorem Ipsum generators.</ListGroup.Item>
<ListGroup.Item as="li">Written in 45 BC. This book is a treatise on the theory.</ListGroup.Item>
<ListGroup.Item as="li">Randomised words which don't look.</ListGroup.Item>
<ListGroup.Item as="li">Always free from repetition, injected humour.</ListGroup.Item>
 </ListGroup>`;

export const Listgroup13 = `import { ListGroup } from "react-bootstrap";

<ListGroup as="ul">
<ListGroup.Item as="li">
    <input  className="form-check-input me-2 fw-semibold" type="checkbox" value=""
        aria-label="..." defaultChecked/>
        Accurate information at any given point.
</ListGroup.Item>
<ListGroup.Item as="li">
    <input  className="form-check-input me-2 fw-semibold" type="checkbox" value=""
        aria-label="..."/>
        Hearing the information and responding.
</ListGroup.Item>
<ListGroup.Item as="li">
    <input  className="form-check-input me-2 fw-semibold" type="checkbox" value=""
        aria-label="..." defaultChecked/>
        Setting up and customizing your own sales.
</ListGroup.Item>
<ListGroup.Item as="li">
    <input  className="form-check-input me-2 fw-semibold" type="checkbox" value=""
        aria-label="..." defaultChecked/>
        New Admin Launched.
</ListGroup.Item>
<ListGroup.Item as="li">
    <input  className="form-check-input me-2 fw-semibold" type="checkbox" value=""
        aria-label="..."/>
        To maximize profits and improve productivity.
</ListGroup.Item>
<ListGroup.Item as="li">
    <input  className="form-check-input me-2 fw-semibold" type="checkbox" value=""
        aria-label="..."/>
        To have a complete 360° overview of sales information, having.
</ListGroup.Item>
</ListGroup>`;

export const Listgroup14 = `import { ListGroup } from "react-bootstrap";

<ListGroup  className="list-group">
<ListGroup.Item  className="list-group-item">
    <input  className="form-check-input me-1" type="radio" value=""
        name="list-radio" defaultChecked/>
        Accurate information at any given point.
</ListGroup.Item>
<ListGroup.Item  className="list-group-item">
    <input  className="form-check-input me-1" type="radio" value=""
        name="list-radio" defaultChecked/>
        Hearing the information and responding.
</ListGroup.Item>
<ListGroup.Item  className="list-group-item">
    <input  className="form-check-input me-1" type="radio" value=""
        name="list-radio" defaultChecked/>
        Setting up and customizing your own sales.
</ListGroup.Item>
<ListGroup.Item  className="list-group-item">
    <input  className="form-check-input me-1" type="radio" value=""
        name="list-radio"/>
        New Admin Launched.
</ListGroup.Item>
<ListGroup.Item  className="list-group-item">
    <input  className="form-check-input me-1" type="radio" value=""
        name="list-radio"/>
        To maximize profits and improve productivity.
</ListGroup.Item>
<ListGroup.Item  className="list-group-item">
    <input  className="form-check-input me-1" type="radio" value=""
        name="list-radio"/>
        To have a complete 360° overview of sales information, having.
</ListGroup.Item>
</ListGroup>`;

export const Listgroup15 = `import { ListGroup,Badge } from "react-bootstrap";
import { ListbadgesButtons } from "../../../../../shared/data/elements/listgroupdata";

{ListbadgesButtons.map((idx) => (
    <ListGroup.Item key={idx.id}
         className="list-group-item d-flex justify-content-between align-items-center fw-semibold">
        {idx.text1}
        <Badge bg={idx.class}  class={idx.color}>{idx.text2}</Badge>
    </ListGroup.Item>
    ))}`;
    export const dataListgroup15 = `export const ListbadgesButtons= [
        { id: 1, text1: "Groceries", text2: "Available", class: "primary", color: "" },
        { id: 2, text1: "Furniture", text2: "Buy", class: "secondary", color: "" },
        { id: 3, text1: "Beauty", text2: "32", class: "danger", color: "" },
        { id: 4, text1: "Books", text2: "New", class: "light", color: "text-default" },
        { id: 5, text1: "Toys", text2: "Hot", class: "info-gradient", color: "" },
        { id: 6, text1: "Mobiles", text2: "Sold Out", class: "warning", color: "" },
    ]; `
export const Listgroup16 = `import { ListGroup } from "react-bootstrap";
import { HorizontalButtons } from "../../../../../shared/data/elements/listgroupdata";

{HorizontalButtons.map((idx) => (
    <ListGroup as="ul" className={"mb-2 list-group-horizontal&#{idx.class} "} key={idx.id}>
        <ListGroup.Item as="li">An item</ListGroup.Item>
        <ListGroup.Item as="li">A second item</ListGroup.Item>
        <ListGroup.Item as="li">A third item</ListGroup.Item>
    </ListGroup>
))}`;
export const dataListgroup16 = `export const HorizontalButtons = [
	{ id: 1, class: "" },
	{ id: 2, class: "-sm" },
	{ id: 3, class: "-md" },
	{ id: 4, class: "-lg" },
	{ id: 5, class: "-xl" },
	{ id: 6, class: "-xxl" },
]; `
/*------ ListGroup (prism-code for showcode purpose) end ------*/

/*------ objectfit (prism-code for showcode purpose) start ------*/
export const objectfit1 = ` <img src="../../../assets/images/media/media-28.jpg" 
 className="object-fit-contain border rounded" alt="..."/>`;

export const objectfit2 = `<img src="../../../assets/images/media/media-28.jpg" 
 className="object-fit-cover border rounded" alt="..."/>`;

export const objectfit3 =
    `<img src="../../../assets/images/media/media-28.jpg"
 className="object-fit-fill border rounded" alt="..."/>`;

export const objectfit4 = ` <img src="../../../assets/images/media/media-28.jpg"
 className="object-fit-scale border rounded" alt="..."/>`;

export const objectfit5 = ` <img src="../../../assets/images/media/media-28.jpg" 
 className="object-fit-none border rounded" alt="..."/>`;

export const objectfit6 = ` <img src="../../../assets/images/media/media-28.jpg" 
 className="object-fit-sm-contain border
 rounded" alt="..."/>`;

export const objectfit7 = ` <img src="../../../assets/images/media/media-28.jpg" 
 className="object-fit-md-contain border 
rounded" alt="..."/>`;

export const objectfit8 = ` <img src="../../../assets/images/media/media-28.jpg" 
 className="object-fit-lg-contain border 
rounded" alt="..."/>`;

export const objectfit9 = `<img src="../../../assets/images/media/media-28.jpg" 
 className="object-fit-xl-contain border 
rounded" alt="..."/>`;

export const objectfit10 = ` <img src="../../../assets/images/media/media-28.jpg" 
 className="object-fit-xxl-contain border
 rounded" alt="..."/>`;

export const objectfit11 = ` <video src="../../../assets/video/1.mp4" 
 className="object-fit-contain rounded border" autoPlay>
</video>`;

export const objectfit12 = ` <video src="../../../assets/video/1.mp4"
 className="object-fit-cover rounded border" autoPlay>
</video>`;

export const objectfit13 = `<video src="../../../assets/video/1.mp4"
 className="object-fit-fill rounded border" autoPlay>
</video>`;

export const objectfit14 = `<video src="../../../assets/video/1.mp4" 
 className="object-fit-scale rounded border" autoPlay>
</video>`;

export const objectfit15 = ` <video src="../../../assets/video/1.mp4"
 className="object-fit-none 
rounded border" autoPlay></video>`;
/*------ objectfit (prism-code for showcode purpose) end ------*/

/*------ Pagination (prism-code for showcode purpose) start ------*/
export const pagination1 = `import { Pagination } from "react-bootstrap";

<nav aria-label="Page navigation">
<Pagination as="ul"  className="pagination mb-0">
<Pagination.Item as="li" disabled href="#!">Previous
</Pagination.Item>
<Pagination.Item as="li" href="#!">1</Pagination.Item>
<Pagination.Item as="li" href="#!">2</Pagination.Item>
<Pagination.Item as="li" href="#!">Next</Pagination.Item>
</Pagination>
</nav>`;

export const pagination2 = `import { Pagination } from "react-bootstrap";

<Pagination  className="pagination mb-0">
<Pagination.Item  className="page-item" as="li" href="#!" aria-label="Previous">
        <span aria-hidden="true"><i  className="bi bi-caret-left"></i></span></Pagination.Item>
<Pagination.Item as="li" href="#!">1</Pagination.Item>
<Pagination.Item as="li" href="#!">2</Pagination.Item>
<Pagination.Item as="li" href="#!">3</Pagination.Item>
<Pagination.Item as="li"  className="page-item" href="#!" aria-label="Next">
 <span aria-hidden="true"><i  className="bi bi-caret-right"></i></span></Pagination.Item> 
</Pagination>`;

export const pagination3 = `import { Pagination } from "react-bootstrap";

<nav aria-label="...">
<Pagination as="ul"  className="pagination pagination-sm mb-0">
	<Pagination.Item as="li" active aria-current="page">
		1
	</Pagination.Item>
	<Pagination.Item as="li" href="#!">2</Pagination.Item>
	<Pagination.Item as="li" href="#!">3</Pagination.Item>
</Pagination>
</nav>
<nav aria-label="...">
<Pagination as="ul"  className="pagination mb-0">
	<Pagination.Item as="li" active aria-current="page">
		1
	</Pagination.Item>
	<Pagination.Item as="li" href="#!">2</Pagination.Item>
	<Pagination.Item as="li" href="#!">3</Pagination.Item>
</Pagination>
</nav>
<nav aria-label="...">
<Pagination  className="pagination pagination-lg mb-0">
	<Pagination.Item as="li"  className=" active" aria-current="page">
		1
	</Pagination.Item>
	<Pagination.Item as="li" href="#!">2</Pagination.Item>
	<Pagination.Item as="li" href="#!">3</Pagination.Item>
</Pagination>
</nav>`;

export const pagination4 = `import { Pagination } from "react-bootstrap";

<nav aria-label="Page navigation">
<Pagination  className="justify-content-center">
    <Pagination.Item disabled>Previous
    </Pagination.Item>
    <Pagination.Item href="#!">1</Pagination.Item>
    <Pagination.Item href="#!">2</Pagination.Item>
    <Pagination.Item href="#!">3</Pagination.Item>
    <Pagination.Item  href="#!">Next
    </Pagination.Item>
</Pagination>
</nav>
<nav aria-label="Page navigation">
<Pagination  className="justify-content-end mb-0">
    <Pagination.Item disabled >Previous
    </Pagination.Item>
    <Pagination.Item href="#!">1</Pagination.Item>
    <Pagination.Item href="#!">2</Pagination.Item>
    <Pagination.Item href="#!">3</Pagination.Item>
    <Pagination.Item  href="#!">Next
    </Pagination.Item>
</Pagination>
</nav>`;

export const pagination5 = `import { Pagination } from "react-bootstrap";

<nav aria-label="..."  className="me-3">
<Pagination  className="pagination">
    <Pagination.Item disabled>Previous
    </Pagination.Item>
    <Pagination.Item  href="#!">1</Pagination.Item>
    <Pagination.Item active  aria-current="page"href="#!">2
    </Pagination.Item>
    <Pagination.Item  href="#!">Next
    </Pagination.Item>
</Pagination>
</nav>
<nav aria-label="...">
<Pagination  className="pagination">
    <Pagination.Item disabled>Previous
    </Pagination.Item>
    <Pagination.Item  href="#!">1</Pagination.Item>
    <Pagination.Item active aria-current="page">2
    </Pagination.Item>
    <Pagination.Item  href="#!">Next
    </Pagination.Item>
</Pagination>
</nav>`;

export const pagination6 = `import { Pagination } from "react-bootstrap";

<nav aria-label="Page navigation"  className="pagination-style-1">
<Pagination  className="pagination mb-0">
<Pagination.Item disabled href="#!">
<i  className="ri-arrow-left-s-line align-middle"></i>       
</Pagination.Item>
<Pagination.Item href="#!">1</Pagination.Item>
<Pagination.Item active href="#!">2</Pagination.Item>
<Pagination.Item href="#!">
<i  className="bi bi-three-dots"></i>
</Pagination.Item>
<Pagination.Item href="#!">21</Pagination.Item>
<Pagination.Item href="#!">
<i  className="ri-arrow-right-s-line align-middle"></i>
</Pagination.Item>
</Pagination>
</nav>`;

export const pagination7 = `import { Pagination } from "react-bootstrap";

<nav aria-label="Page navigation"  className="pagination-style-1">
<Pagination  className="pagination mb-0">
<Pagination.Item disabled href="#!">
<i  className="ri-arrow-left-s-line align-middle"></i>       
</Pagination.Item>
<Pagination.Item href="#!">1</Pagination.Item>
<Pagination.Item active href="#!">2</Pagination.Item>
<Pagination.Item href="#!">
<i  className="bi bi-three-dots"></i>
</Pagination.Item>
<Pagination.Item href="#!">21</Pagination.Item>
<Pagination.Item href="#!">
<i  className="ri-arrow-right-s-line align-middle"></i>
</Pagination.Item>
</Pagination>
</nav>`;

export const pagination8 = `import { Pagination } from "react-bootstrap";

<nav aria-label="Page navigation"  className="pagination-style-3">
<Pagination  className=" mb-0 flex-wrap">
<Pagination.Item as="li" disabled>Prev
</Pagination.Item>
<Pagination.Item as="li"  active href="#!">1</Pagination.Item>
<Pagination.Item as="li"  href="#!">2</Pagination.Item>
<Pagination.Item as="li"  href="#!">
<i  className="bi bi-three-dots"></i>        
</Pagination.Item>
<Pagination.Item as="li"  href="#!">16</Pagination.Item>
<Pagination.Item as="li"  className="pagination-next"
href="#!">next
</Pagination.Item>
</Pagination>
</nav>`;

export const pagination9 = `import { Pagination } from "react-bootstrap";

<nav aria-label="Page navigation" className="pagination-style-4">
<Pagination  className="mb-0 flex-wrap">
<Pagination.Item as="li"  disabled href="#!">
 Prev
</Pagination.Item>
<Pagination.Item as="li"  active href="#!">1</Pagination.Item>
<Pagination.Item as="li" href="#!">2</Pagination.Item>
<Pagination.Item as="li"  href="#!">
<i  className="bi bi-three-dots"></i>   
</Pagination.Item>
<Pagination.Item as="li" href="#!">16</Pagination.Item>
<Pagination.Item as="li" href="#!">17</Pagination.Item>
<Pagination.Item as="li"  className="pagination-next" href="#!">
 next       
</Pagination.Item>
</Pagination></nav>`;
/*------ Pagination (prism-code for showcode purpose) end ------*/

/*------ popovers (prism-code for showcode purpose) start ------*/
export const popovers1 = `import { Button, OverlayTrigger, Popover } from "react-bootstrap";
import { Defaultalerts } from "../../../../../shared/data/elements/popoversdata";

{Defaultalerts.map((idx)=>(
    <OverlayTrigger trigger="click" placement={idx.class}  key={idx.id}
    overlay={<Popover>
    <Popover.Header as="h3"> Popover {idx.text}</Popover.Header>
    <Popover.Body>
    Vivamus sagittis lacus vel augue laoreet rutrum faucibus.
    </Popover.Body>
    </Popover>}>
    <Button variant='' href="#!"  className="btn btn-outline-primary btn-wave">Popover {idx.text}</Button>
    </OverlayTrigger>))}`;
export const datapopovers1 = `export const Defaultalerts = [
	{ id: 1, text: "Top", class: "top" },
	{ id: 2, text: "Right", class: "auto" },
	{ id: 3, text: "Bottom", class: "bottom" },
	{ id: 4, text: "Left", class: "left" },
];`
export const popovers2 =
    `import { Button, OverlayTrigger, Popover } from "react-bootstrap";
    import { Colorheaderalerts } from "../../../../../shared/data/elements/popoversdata";

    <div className="btn-list">
    {Colorheaderalerts.map((idx) => (
        <OverlayTrigger trigger="click" placement={idx.class} key={idx.id}

            overlay={<Popover className={"header-&#{idx.color1} &#{idx.color2}"}>
                <Popover.Header as="h3" data-bs-custom-classname={"header-&#{idx.color1}"}> Color Header</Popover.Header>
                <Popover.Body>
                    Popover with primary header.
                </Popover.Body>
            </Popover>}>
            <Button variant={idx.color} href="#!" className="btn btn-wave ">Header {idx.text}</Button>
        </OverlayTrigger>
    ))}
    </div>
    `;
    export const datapopovers2 = `export const Colorheaderalerts= [
        { id: 1, text: "Primary", class: "top", color: "outline-primary", color1: "primary", color2:"" },
        { id: 2, text: "Secondary", class: "right", color: "outline-secondary", color1: "secondary", color2:"" },
        { id: 3, text: "Info", class: "bottom", color: "outline-info", color1: "info", color2:"bs-popover-auto" },
        { id: 4, text: "Warning", class: "left", color: "outline-warning", color1: "warning", color2:"" },
        { id: 4, text: "Success", class: "top", color: "outline-success", color1: "success", color2:"" },
        { id: 4, text: "Danger", class: "top", color: "outline-danger", color1: "danger", color2:"" },
    ];`
export const popovers3 =
    `import { Button, OverlayTrigger, Popover } from "react-bootstrap";
    import { Colredalerts } from "../../../../../shared/data/elements/popoversdata";

    <div className="btn-list">
    {Colredalerts.map((idx) => (
        <OverlayTrigger key={idx.id} placement={idx.class} trigger="click" overlay={<Popover className={"popover-$#{idx.color1}"}>
            <Popover.Header as="h3">Color Background</Popover.Header>
            <Popover.Body>Popover with {idx.text} background.</Popover.Body>
        </Popover>}>
            <Button variant={idx.color1}>{idx.text} </Button>
        </OverlayTrigger>
    ))}
</div>`;
export const datapopovers3 = `export const Colredalerts = [
	{ id: 1, text: "Primary", class: "top", color1: "primary" },
	{ id: 2, text: "Secondary", class: "right", color1: "secondary" },
	{ id: 3, text: "Info", class: "bottom", color1: "info" },
	{ id: 4, text: "Warning", class: "left", color1: "warning" },
	{ id: 4, text: "Success", class: "top", color1: "success" },
	{ id: 4, text: "Danger", class: "right", color1: "danger" },
	{ id: 4, text: "Teal", class: "bottom", color1: "teal" },
	{ id: 4, text: "Purple", class: "left", color1: "purple" },
];`
export const popovers4 = `import { Button, OverlayTrigger, Popover } from "react-bootstrap";
import { Colredalerts } from "../../../../../shared/data/elements/popoversdata";

<div className="btn-list">
{Colredalerts.map((idx) => (
    <OverlayTrigger key={idx.id} placement={idx.class} trigger="click" overlay={<Popover className={"popover-$#{idx.color1}-light"} id="tooltip-disabled">
        <Popover.Header as="h3">Light Background</Popover.Header>
        <Popover.Body>Popover with light {idx.text} background.</Popover.Body>
    </Popover>}>
        <Button variant='' className={"btn btn-$#{idx.color1}-light btn-wave"}>{idx.text} </Button>
    </OverlayTrigger>
))}
</div>`;

export const popovers5 = `import { Button, OverlayTrigger, Popover } from "react-bootstrap";
import { Dismissiblealerts } from "../../../../../shared/data/elements/popoversdata";

{Dismissiblealerts.map((idx) => (
	<OverlayTrigger rootClose={true} trigger="click" placement={idx.class} key={idx.id}
		overlay={<Popover>
			<Popover.Header as="h3"> Dismissible Popover</Popover.Header>
			<Popover.Body>
				And here's some amazing content. It's very engaging. Right?
			</Popover.Body>
		</Popover>}>
		<Button variant={idx.color}  className="btn  btn-wave">Popover Dismiss</Button>
	</OverlayTrigger>
))}`;
export const datapopovers5 = `export const Dismissiblealerts = [
	{ id: 1, color: "primary", class: "top" },
	{ id: 2, color: "secondary", class: "right" },
	{ id: 3, color: "info", class: "top" },
	{ id: 4, color: "warning", class: "left" },
];`
export const popovers6 = `import { Button, OverlayTrigger, Popover } from "react-bootstrap";

<OverlayTrigger placement='top' overlay={<Popover id="tooltip-disabled">
<Popover.Body>Disabled Popover!</Popover.Body>
</Popover>}>
<span className="d-inline-block mb-3 mb-sm-1 me-2">
    <Button variant="primary" disabled>
        Disabled button
    </Button>
</span>
</OverlayTrigger>`;

export const popovers7 = `<OverlayTrigger placement='top' trigger="click" overlay={<Popover className='popover-primary only-body' id="tooltip-disabled">
<Popover.Body>This popover is used to provide details about this icon.</Popover.Body>
</Popover>}>
<Link className="me-4" href="#!">
    <svg xmlns="http://www.w3.org/2000/svg" className="svg-primary" height="24px" viewBox="0 0 24 24" width="24px" fill="#000000">
        <path d="M0 0h24v24H0V0z" fill="none" /><path d="M11 18h2v-2h-2v2zm1-16C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm0-14c-2.21 0-4 1.79-4 4h2c0-1.1.9-2 2-2s2 .9 2 2c0 2-3 1.75-3 5h2c0-2.25 3-2.5 3-5 0-2.21-1.79-4-4-4z" /></svg>
</Link>
</OverlayTrigger>
<OverlayTrigger placement='top' trigger="click" overlay={<Popover className='popover-secondary  only-body' id="tooltip-disabled">
<Popover.Body>This popover is used to provide details about this icon.</Popover.Body>
</Popover>}>
<Link className="me-4" href="#!" >
    <svg xmlns="http://www.w3.org/2000/svg" className="svg-secondary " height="24px" viewBox="0 0 24 24" width="24px" fill="#000000"><path d="M0 0h24v24H0V0z" fill="none" /><path d="M11 7h2v2h-2zm0 4h2v6h-2zm1-9C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z" /></svg>
</Link>
</OverlayTrigger>`;
/*------ popovers (prism-code for showcode purpose) end ------*/

/*------ Progress (prism-code for showcode purpose) start ------*/
export const progress1 = `import { ProgressBar } from "react-bootstrap";

<ProgressBar variant="" now={0}  className="progress mb-3" />
<ProgressBar variant="" now={25}  className="progress mb-3" />
<ProgressBar variant="" now={50}  className="progress mb-3" />
<ProgressBar variant="" now={75}  className="progress mb-3" />
<ProgressBar variant="" now={100}  className="progress mb-0" />`;

export const progress2 = `import { ProgressBar } from "react-bootstrap";

<ProgressBar  variant='secondary' now={20}  className="progress mb-3" />
<ProgressBar  variant='warning' now={40}  className="progress mb-3" />
<ProgressBar  variant='info' now={60}  className="progress mb-3" />
<ProgressBar  variant='success' now={80}  className="progress mb-3" />
<ProgressBar  variant='danger' now={100}  className="progress mb-0" />`;

export const progress3 =
    `import { ProgressBar } from "react-bootstrap";
    
    <ProgressBar striped variant='primary' now={10}  className="progress mb-3" />
<ProgressBar striped variant='secondary' now={25}  className="progress mb-3" />
<ProgressBar striped variant='success' now={50}  className="progress mb-3" />
<ProgressBar striped variant='info' now={75}  className="progress mb-3" />
<ProgressBar striped variant='warning' now={100}  className="progress mb-0" />`;

export const progress4 =
    `import { ProgressBar } from "react-bootstrap";
    
    <ProgressBar  variant='primary' now={10}  className="progress progress-xs mb-3" />
<ProgressBar  variant='primary' now={25}  className="progress progress-sm mb-3" />
<ProgressBar  variant='primary' now={50}  className="progress  mb-3" />
<ProgressBar  variant='primary' now={75}  className="progress progress-lg mb-3" />
<ProgressBar  variant='primary' now={100} className="progress progress-xl mb-0" />`;

export const progress5 = `import { ProgressBar } from "react-bootstrap";

<ProgressBar  variant='primary'  className="progress mb-3" animated now={10} />
<ProgressBar  variant='secondary'  className="progress mb-3" animated now={20} />
<ProgressBar  variant='success'  className="progress mb-3" animated now={40} />
<ProgressBar  variant='info'  className="progress mb-3" animated now={60} />
<ProgressBar  variant='warning'  className="progress" animated now={80} />`;

export const progress6 = `import { ProgressBar } from "react-bootstrap";

<ProgressBar  variant='primary-gradient'  className="progress mb-3" animated now={10} />
<ProgressBar  variant='secondary-gradient'  className="progress mb-3" animated now={20} />
<ProgressBar  variant='success-gradient'  className="progress mb-3" animated now={40} />
<ProgressBar  variant='info-gradient'  className="progress mb-3" animated now={60} />
<ProgressBar  variant='warning-gradient'  className="progress" animated now={80} />`;

export const progress7 = `import { ProgressBar } from "react-bootstrap";

<ProgressBar variant='primary' now={10} label={10}  className="progress mb-3" />
<ProgressBar variant='secondary' now={20} label={20}  className="progress mb-3" />
<ProgressBar variant='success' now={40} label={40%}  className="progress mb-3" />
<ProgressBar variant='info' now={60} label={60}%  className="progress mb-3" />
<ProgressBar variant='warning' now={80} label={80%}  className="progress mb-0" />`;

export const progress8 = `import { ProgressBar } from "react-bootstrap";
import {  Multipleprogress } from "../../../../../shared/data/elements/progressbardata";

{Multipleprogress.map((idx) => (
    <ProgressBar className={"progress-stacked progress-$#{idx.size} mb-3"} key={idx.id}>
        <ProgressBar variant={idx.class1} now={idx.now1} key={1} />
        <ProgressBar variant={idx.class2} now={idx.now2} key={2} />
        <ProgressBar variant={idx.class3} now={idx.now3} key={3} />
    </ProgressBar>
))}`;
export const dataprogress8 = `export const Multipleprogress= [
	{ class1: "primary", class2: "secondary", class3: "success", now1: 5, now2: 10, now3: 15, size: "xs" },
	{ class1: "warning", class2: "info", class3: "danger", now1: 10, now2: 15, now3: 20, size: "sm" },
	{ class1: "info", class2: "success", class3: "primary", now1: 15, now2: 20, now3: 25, size: "" },
	{ class1: "purple", class2: "teal", class3: "orange", now1: 20, now2: 25, now3: 30, size: "lg" },
	{ class1: "success", class2: "danger", class3: "warning", now1: 25, now2: 30, now3: 35, size: "xl" },
  
];`
export const progress9 = `import { ProgressBar } from "react-bootstrap";

<ProgressBar  variant='primary-gradient'  className="progress mb-3 progress-animate" animated now={10} />
<ProgressBar  variant='secondary-gradient'  className="progress mb-3 progress-animate" animated now={20} />
<ProgressBar  variant='success-gradient'  className="progress mb-3 progress-animate" animated now={40} />
<ProgressBar  variant='info-gradient'  className="progress mb-3 progress-animate" animated now={60} />
<ProgressBar  variant='warning-gradient'  className="progress  progress-animate" animated now={80} />`;

export const progress10 = `import { ProgressBar } from "react-bootstrap";

<div  className="progress progress-sm progress-custom mb-5 progress-animate">
<h6  className="progress-bar-title">Mobiles</h6>
<ProgressBar variant="primary"  className="w-100 custom-height1" now={50} />
</div>
<div  className="progress progress-sm progress-custom mb-5 progress-animate">
<h6  className="progress-bar-title bg-secondary">Watches</h6>
<ProgressBar variant="secondary"  className="w-100 custom-height1" now={60} />
</div>
<div  className="progress progress-sm progress-custom mb-5 progress-animate">
<h6  className="progress-bar-title bg-success">Shirts</h6>
<ProgressBar variant="success"  className="w-100 custom-height1" now={70} />
</div>`;

export const progress11 =
    `import { ProgressBar } from "react-bootstrap";
    import { CustomProgress2data } from "../../../../../shared/data/elements/progressbardata";
   
    {CustomProgress2data.map((idx) => (
        <div className={"progress progress-bar progress-sm $#{idx.class3}"} key={idx.id} >
            <div className={"progress-item-1 bg-$#{idx.class}"}></div>
            <div className={"progress-item-2 bg-$#{idx.class2}"}></div>
            <div className={"progress-item-3 bg-$#{idx.class1}"}></div>
            <ProgressBar variant={idx.class} now={idx.now} />
        </div>
    ))}`;
    export const dataprogress11 = `export const CustomProgress2data = [
        { class: "primary", now: 50, class1: "", class2: "" ,class3:"mb-4"},
        { class: "secondary", now: 60, class1: "", class2: "secondary" ,class3:"mb-4"},
        { class: "success", now: 70, class1: "", class2: "success",class3:"mb-4" },
        { class: "info", now: 80, class1: "info", class2: "info" ,class3:"mb-4"},
        { class: "warning", now: 90, class1: "warning", class2: "warning",class3:"" },
    
    ];`

export const progress12 = `import { ProgressBar } from "react-bootstrap";

<div className="progress progress-lg mb-5 custom-progress-3 progress-animate" role="progressbar" aria-valuenow="50" aria-valuemin="0" aria-valuemax="100">
							<div className="progress-bar bg-primary" style={{ width: "50%" }}>
								<div className="progress-bar-value">50%</div>
							</div>
						</div>
						<div className="progress progress-lg mb-5 custom-progress-3 progress-animate" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100">
							<div className="progress-bar bg-secondary" style={{ width: "60%" }}>
								<div className="progress-bar-value secondary">60%</div>
							</div>
						</div>
						<div className="progress progress-lg custom-progress-3 progress-animate" role="progressbar" aria-valuenow="70" aria-valuemin="0" aria-valuemax="100">
							<div className="progress-bar bg-success" style={{ width: "70%" }}>
								<div className="progress-bar-value success">70%</div>
							</div>
						</div>`;

export const progress13 = `import { ProgressBar } from "react-bootstrap";

<div className="progress progress-xl mb-3 progress-animate custom-progress-4" role="progressbar" aria-valuenow="10" aria-valuemin="0" aria-valuemax="100">
							<div className="progress-bar bg-primary-gradient" style={{ width: "10%" }}></div>
							<div className="progress-bar-label">10%</div>
						</div>
						<div className="progress progress-xl mb-3 progress-animate custom-progress-4 secondary" role="progressbar" aria-valuenow="20" aria-valuemin="0" aria-valuemax="100">
							<div className="progress-bar bg-secondary-gradient" style={{ width: "20%" }}></div>
							<div className="progress-bar-label">20%</div>
						</div>
						<div className="progress progress-xl mb-3 progress-animate custom-progress-4 success" role="progressbar" aria-valuenow="40" aria-valuemin="0" aria-valuemax="100">
							<div className="progress-bar bg-success-gradient" style={{ width: "40%" }}></div>
							<div className="progress-bar-label">40%</div>
						</div>
						<div className="progress progress-xl mb-3 progress-animate custom-progress-4 info" role="progressbar" aria-valuenow="60" aria-valuemin="0" aria-valuemax="100">
							<div className="progress-bar bg-info-gradient" style={{ width: "60%" }}></div>
							<div className="progress-bar-label">60%</div>
						</div>
						<div className="progress progress-xl mb-3 progress-animate custom-progress-4 warning" role="progressbar" aria-valuenow="80" aria-valuemin="0" aria-valuemax="100">
							<div className="progress-bar bg-warning-gradient" style={{ width: "80%" }}></div>
							<div className="progress-bar-label">80%</div>
						</div>
						<div className="progress progress-xl progress-animate custom-progress-4 danger" role="progressbar" aria-valuenow="100" aria-valuemin="0" aria-valuemax="100">
							<div className="progress-bar bg-danger-gradient" style={{ width: "100%" }}></div>
							<div className="progress-bar-label text-fixed-white">100%</div>
						</div>`;

export const progress14 = `import { Row,ProgressBar,Col } from "react-bootstrap";

<h6  className="fw-semibold mb-2">Project Dependencies</h6>
<ProgressBar  className="progress-stacked progress-xl mb-5" >
   <ProgressBar  variant="primary" now={25} label={25%} key={1} />
   <ProgressBar  variant="secondary" now={35} label={35%} key={2} />
   <ProgressBar  variant="danger" now={40} label={40%} key={3} />    
</ProgressBar>
<Row  className="justify-content-center">
    <Col xl={5}>
        <div  className="border p-3">
            <p  className="fs-12 fw-semibold mb-0 text-muted">Html<span  className="float-end fs-10 fw-normal">25%<
            /span></p>
            <ProgressBar  className="progress progress-xs mb-4 progress-animate"  variant="primary" now={25} />   
            <p  className="fs-12 fw-semibold mb-0 text-muted">Css<span  className="float-end fs-10 fw-normal">35%
            </span></p>
            <ProgressBar  className="progress progress-xs mb-4 progress-animate"  variant="secondary" now={35} />  
            <p  className="fs-12 fw-semibold mb-0 text-muted">Js<span  className="float-end fs-10 fw-normal">40%
            </span></p>
            <ProgressBar  className="progress progress-xs mb-4 progress-animate"  variant="danger" now={40} />  
        </div>
    </Col>
</Row>`;
/*------ Progress (prism-code for showcode purpose) end ------*/

/*------ spinners (prism-code for showcode purpose) start ------*/
export const spinner1 = `<div className="spinner-border " role="status">
<span className="visually-hidden">Loading...</span>
</div>`;

export const spinner2 = `import { Colorspinner } from "../../../../../shared/data/elements/spinnersdata";
{Colorspinner.map((idx) => (
    <div className={"spinner-border me-2 text-$#{idx.color}"} role="status" key={idx.id}>
        <span className="visually-hidden">Loading...</span>
    </div>
))}`;
export const dataspinner2 = `export const Colorspinner=[
	{id:1,color:"primary"},
	{id:2,color:"secondary"},
	{id:3,color:"success"},
	{id:4,color:"danger"},
	{id:5,color:"warning"},
	{id:6,color:"info"},
	{id:7,color:"light"},
	{id:8,color:"dark"}
];`
export const spinner3 = `<div className="spinner-grow " role="status">
<span className="visually-hidden">Loading...</span>
</div>`;

export const spinner4 = `import { Colorspinner } from "../../../../../shared/data/elements/spinnersdata";
{Colorspinner.map((idx) => (
    <div className={"spinner-grow me-1 text-$3{idx.color}"} role="status" key={idx.id}>
        <span className="visually-hidden">Loading...</span>
    </div>
))}`;

export const spinner5 = `<div  className="d-flex justify-content-center mb-4">
<div  className="spinner-border" role="status">
    <span  className="visually-hidden">Loading...</span>
</div>
</div>
<div  className="d-flex align-items-center">
<strong>Loading...</strong>
<div  className="spinner-border  ms-auto" role="status" aria-hidden="true"></div>
</div>`;

export const spinner6 = ` <div  className="clearfix mb-4">
<div  className="spinner-border  float-end" role="status">
    <span  className="visually-hidden">Loading...</span>
</div>
</div>
<div  className="clearfix">
<div  className="spinner-border  float-start" role="status">
    <span  className="visually-hidden">Loading...</span>
</div>
</div>`;

export const spinner7 = ` <div  className="text-center">
<div  className="spinner-border " role="status">
    <span  className="visually-hidden">Loading...</span>
</div>
</div>`;

export const spinner8 = `<div  className="spinner-border  spinner-border-sm me-4" role="status">
<span  className="visually-hidden">Loading...</span>
</div>
<div  className="spinner-grow  spinner-grow-sm me-4" role="status">
<span  className="visually-hidden">Loading...</span>
</div>
<div  className="spinner-border  me-4" style={{ width: '3rem', height: '3rem' }}
role="status">
<span  className="visually-hidden">Loading...</span>
</div>
<div  className="spinner-grow " style={{ width: '3rem', height: '3rem' }} role="status">
<span  className="visually-hidden">Loading...</span>
</div>`;

export const spinner9 = ` <div  className="spinner-border  m-5" role="status">
<span  className="visually-hidden">Loading...</span>
</div>`;

export const spinner10 = `import { Button } from "react-bootstrap";
import { Buttonspinner } from "../../../../../shared/data/elements/spinnersdata";
<div  className="btn-list">
<Button variant='primary-light'  className="btn" type="button" disabled>
    <span  className="spinner-border spinner-border-sm align-middle" role="status"
        aria-hidden="true"></span>
    <span  className="visually-hidden">Loading...</span>
</Button>
<Button variant='primary-light'  className="btn" type="button" disabled>
    <span  className="spinner-border spinner-border-sm align-middle" role="status"
        aria-hidden="true"></span>
    Loading...
</Button>
<Button variant='primary-light'  className="btn" type="button" disabled>
    <span  className="spinner-grow spinner-grow-sm align-middle" role="status"
        aria-hidden="true"></span>
    <span  className="visually-hidden">Loading...</span>
</Button>
{Buttonspinner.map((idx) => (
<Button variant={idx.color}  className="" type="button" disabled key={idx.id}>
    <span  className="spinner-grow spinner-grow-sm align-middle" role="status"
        aria-hidden="true"></span>
    Loading...
</Button>
))}
</div>`;
export const dataspinner10 = `export const Buttonspinner =[
	{id:1,color:"primary-light", class:""},
	{id:2,color:"secondary-light", class:""},
	{id:3,color:"success-light", class:""},
	{id:4,color:"info-light", class:""},
	{id:5,color:"warning-light", class:""},
	{id:6,color:"danger-light", class:""},
	{id:7,color:"light", class:""},
	{id:8,color:"dark", class:"text-dark"}
];`
/*------ spinners (prism-code for showcode purpose) end ------*/

/*------ tooltips (prism-code for showcode purpose) start ------*/
export const tooltip1 = `import { Button,  OverlayTrigger, Tooltip } from "react-bootstrap";
import {  Tooltipdirtooltip } from "../../../../../shared/data/elements/tooltipsdata";

<div className="btn-list">
{Tooltipdirtooltip.map((idx) => (
    <OverlayTrigger placement={idx.text} overlay={<Tooltip>Tooltip on {idx.text} </Tooltip>} key={idx.id}>
        <Button type="button" className="btn btn-primary btn-wave">
            Tooltip on {idx.text}
        </Button>
    </OverlayTrigger>
))}
</div>`;
export const datatooltip1 = `export const Tooltipdirtooltip=[
	{id:1,text:"top"},
	{id:2,text:"right"},
	{id:3,text:"bottom"},
	{id:4,text:"left"}
];`
export const tooltip2 = ` import { Button,  OverlayTrigger, Tooltip } from "react-bootstrap";
 <div className="btn-list">
<OverlayTrigger placement="top" overlay={<Tooltip className='tooltip-primary'>Primary Tooltip </Tooltip>}>
    <Button type="button" variant='primary' className="btn  btn-wave">
        Primary Tooltip
    </Button>
</OverlayTrigger>
<OverlayTrigger placement="right" overlay={<Tooltip className='tooltip-secondary'>Secondary Tooltip </Tooltip>}>
    <Button type="button" variant='secondary' className="btn  btn-wave">
        Secondary Tooltip
    </Button>
</OverlayTrigger>
<OverlayTrigger placement="bottom" overlay={<Tooltip className='tooltip-warning'>Warning Tooltip </Tooltip>}>
    <Button type="button" variant='warning' className="btn  btn-wave">
        Warning Tooltip
    </Button>
</OverlayTrigger>
<OverlayTrigger placement="bottom" overlay={<Tooltip className='tooltip-info'>Info Tooltip </Tooltip>}>
    <Button type="button" variant='info' className="btn  btn-wave">
        Info Tooltip
    </Button>
</OverlayTrigger>
<OverlayTrigger placement="top" overlay={<Tooltip className='tooltip-success'>Success Tooltip </Tooltip>}>
    <Button type="button" variant='success' className="btn  btn-wave">
        Success Tooltip
    </Button>
</OverlayTrigger>
<OverlayTrigger placement="top" overlay={<Tooltip className='tooltip-danger'>Danger Tooltip </Tooltip>}>
    <Button type="button" variant='danger' className="btn  btn-wave">
        Danger Tooltip
    </Button>
</OverlayTrigger>
<OverlayTrigger placement="top" overlay={<Tooltip className='tooltip-light'>Light Tooltip </Tooltip>}>
    <Button type="button" variant='light' className="btn  btn-wave">
        Light Tooltip
    </Button>
</OverlayTrigger>
<OverlayTrigger placement="top" overlay={<Tooltip className='tooltip-dark'>Dark Tooltip </Tooltip>}>
    <Button type="button" variant='dark' className="btn  btn-wave">
        Dark Tooltip
    </Button>
</OverlayTrigger>
</div>`;

export const tooltip3 = `import {   OverlayTrigger, Tooltip } from "react-bootstrap";
  <p  className="text-muted mb-0">
Hover on the link to view the
<OverlayTrigger placement="top" overlay={<Tooltip  class='tooltip-primary'>
Link Tooltip </Tooltip>}>
<Link  scroll={false} href="#!"  className="text-primary">Tooltip</Link>
     </OverlayTrigger> 
</p>`;

export const tooltip4 = `import {   OverlayTrigger, Tooltip } from "react-bootstrap";
import { SVGtooltip} from "../../../../../shared/data/elements/tooltipsdata";

{SVGtooltip.map((idx) => (
    <OverlayTrigger key={idx.id} placement="top" overlay={<Tooltip className={"tooltip-$3{idx.color}"}>{idx.text} </Tooltip>}>
        <a href="#!" className="me-3">
            <svg xmlns="http://www.w3.org/2000/svg" className={"svg-$#{idx.color}"} height="24px" viewBox="0 0 24 24" width="24px" fill="#000000">
                <path d="M0 0h24v24H0V0z" fill="none" /><path
                    d={idx.class} /></svg>
        </a>
    </OverlayTrigger>
))}`;
export const datatooltip4 = `export const SVGtooltip=[
	{id:1, class:"M12 5.69l5 4.5V18h-2v-6H9v6H7v-7.81l5-4.5M12 3L2 12h3v8h6v-6h2v6h6v-8h3L12 3z", color:"primary", text:"Home"},
	{id:2, class:"M22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6zm-2 0l-8 5-8-5h16zm0 12H4V8l8 5 8-5v10z", color:"secondary", text:"Message"},
	{id:3, class:"M20,9V6h-2v3h-3v2h3v3h2v-3h3V9H20z M9,12c2.21,0,4-1.79,4-4c0-2.21-1.79-4-4-4S5,5.79,5,8C5,10.21,6.79,12,9,12z M9,6 c1.1,0,2,0.9,2,2c0,1.1-0.9,2-2,2S7,9.1,7,8C7,6.9,7.9,6,9,6z M15.39,14.56C13.71,13.7,11.53,13,9,13c-2.53,0-4.71,0.7-6.39,1.56  C1.61,15.07,1,16.1,1,17.22V20h16v-2.78C17,16.1,16.39,15.07,15.39,14.56z M15,18H3v-0.78c0-0.38,0.2-0.72,0.52-0.88 C4.71,15.73,6.63,15,9,15c2.37, 0,4.29,0.73,5.48,1.34C14.8,16.5,15,16.84,15,17.22V18z", color:"warning", text:"Add User"},
	{id:4, class:"M4.01 6.03l7.51 3.22-7.52-1 .01-2.22m7.5 8.72L4 17.97v-2.22l7.51-1M2.01 3L2 10l15 2-15 2 .01 7L23 12 2.01 3z", color:"info", text:"Send File"},
	{id:5, class:"M6 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z", color:"success", text:"Action"},
];`
export const tooltip5 = ` import { Button,  OverlayTrigger, Tooltip } from "react-bootstrap";
 <OverlayTrigger overlay={<Tooltip id="tooltip-disabled">Disabled tooltip!</Tooltip>}>
<span  className="d-inline-block">
 <Button disabled style={{ pointerEvents: 'none' }}>
            Disabled button
      </Button>
   </span>
</OverlayTrigger>`;

export const tooltip6 = `import {   OverlayTrigger, Tooltip } from "react-bootstrap";
import Link from "next/link";

<OverlayTrigger placement="top" overlay={<Tooltip  className="tooltip-primary">Alex Carey</Tooltip>}>
<Link  scroll={false} href="#!"
     className="avatar avatar-md me-2 online avatar-rounded">
    <img src="../../../assets/images/faces/12.jpg" alt="img" />
</Link>
</OverlayTrigger>

<OverlayTrigger placement="top" overlay={<Tooltip  className="tooltip-primary">Marina Kai</Tooltip>}>
<Link  scroll={false} href="#!"
     className="avatar avatar-lg me-2 online avatar-rounded">
    <img src="../../../assets/images/faces/3.jpg" alt="img" />
</Link>
</OverlayTrigger>
<OverlayTrigger placement="top" overlay={<Tooltip  className="tooltip-primary">Tim Cook</Tooltip>}>
<Link  scroll={false} href="#!"
     className="avatar avatar-xl me-2 online avatar-rounded">
    <img src="../../../assets/images/faces/15.jpg" alt="img" />
</Link>
</OverlayTrigger>`;
/*------ tooltips (prism-code for showcode purpose) end ------*/

/*------ Toasts (prism-code for showcode purpose) start ------*/
export const toast1 = `import { Button,  Toast, ToastContainer } from "react-bootstrap";
const [toasts, setToasts] = useState<{ [key: string]: boolean }>({});

    const addToast = (toastName: string) => {
        setToasts((prevToasts) => ({
          ...prevToasts,
          [toastName]: true,
        }));
      };

	const handleToasts = (toastName: string) => {
        setToasts((prevToasts) => ({ ...prevToasts, [toastName]: false }));
	};
<div className="btn-list">
    <Button variant='outline-primary' type="button" onClick={() => addToast('topLeft')} className="btn  me-2 btn-wave" id="topleftToastBtn">Top Left</Button>
    <Button variant='outline-primary' type="button" onClick={() => addToast('topCenter')} className="btn  me-2 btn-wave" id="topcenterToastBtn">Top Center</Button>
    <Button variant='outline-primary' type="button" onClick={() => addToast('topRight')} className="btn  me-2 btn-wave" id="toprightToastBtn">Top Right</Button>
    <Button variant='outline-primary' type="button" onClick={() => addToast('middleLeft')} className="btn  me-2 btn-wave" id="middleleftToastBtn">Middle Left</Button>
    <Button variant='outline-primary' type="button" onClick={() => addToast('middleCenter')} className="btn  me-2 btn-wave" id="middlecenterToastBtn">Middle Center</Button>
    <Button variant='outline-primary' type="button" onClick={() => addToast('middleRight')} className="btn  me-2 btn-wave" id="middlerightToastBtn">Middle Right</Button>
    <Button variant='outline-primary' type="button" onClick={() => addToast('bottomLeft')} className="btn  me-2 btn-wave" id="bottomleftToastBtn">Bottom Left</Button>
    <Button variant='outline-primary' type="button" onClick={() => addToast('bottomCenter')} className="btn  me-2 btn-wave" id="bottomcenterToastBtn">Bottom Center</Button>
    <Button variant='outline-primary' type="button" onClick={() => addToast('bottomRight')} className="btn  me-2 btn-wave" id="bottomrightToastBtn">Bottom Right</Button>
</div>
<ToastContainer className="toast-container position-fixed top-0 start-0 p-3">
    <Toast id="topleft-Toast" className="toast colored-toast bg-primary-transparent text-primary"
        onClose={() => handleToasts('topLeft')} show={toasts['topLeft'] || false} delay={3000} autohide>
        <Toast.Header className="toast-header bg-primary text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-white.png" alt="..." />
            <strong className="me-auto">Spruha</strong>

        </Toast.Header>
        <Toast.Body className="toast-body">
            Your,toast message here.
        </Toast.Body>
    </Toast>
</ToastContainer>
<ToastContainer className="toast-container position-fixed top-0 start-50 translate-middle-x p-3">
    <Toast id="topcenter-Toast" className="toast colored-toast bg-primary-transparent text-primary" onClose={() => handleToasts('topCenter')} show={toasts['topCenter'] || false} delay={3000} autohide>
        <Toast.Header className="toast-header bg-primary text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-white.png" alt="..." />
            <strong className="me-auto">Spruha</strong>
        </Toast.Header>
        <Toast.Body className="toast-body">
            Your,toast message here.
        </Toast.Body>
    </Toast>
</ToastContainer>
<ToastContainer className="toast-container position-fixed top-0 end-0 p-3">
    <Toast id="topright-Toast" className="toast colored-toast bg-primary-transparent text-primary"
        onClose={() => handleToasts('topRight')} show={toasts['topRight'] || false} delay={3000} autohide>
        <Toast.Header className="toast-header bg-primary text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-white.png" alt="..." />
            <strong className="me-auto">Spruha</strong>
        </Toast.Header>
        <Toast.Body className="toast-body">
            Your,toast message here.
        </Toast.Body>
    </Toast>
</ToastContainer>
<ToastContainer className="toast-container position-fixed top-50 start-0 translate-middle-y p-3">
    <Toast id="middleleft-Toast" className="toast colored-toast bg-primary-transparent text-primary"
        onClose={() => handleToasts('middleLeft')} show={toasts['middleLeft'] || false} delay={3000} autohide>
        <Toast.Header className="toast-header bg-primary text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-white.png" alt="..." />
            <strong className="me-auto">Spruha</strong>
        </Toast.Header>
        <Toast.Body className="toast-body">
            Your,toast message here.
        </Toast.Body>
    </Toast>
</ToastContainer>
<ToastContainer className="toast-container position-fixed top-50 start-50 translate-middle">
    <Toast id="middlecenter-Toast" className="toast colored-toast bg-primary-transparent text-primary"
        onClose={() => handleToasts('middleCenter')} show={toasts['middleCenter'] || false} delay={3000} autohide>
        <Toast.Header className="toast-header bg-primary text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-white.png" alt="..." />
            <strong className="me-auto">Spruha</strong>
        </Toast.Header>
        <Toast.Body className="toast-body">
            Your,toast message here.
        </Toast.Body>
    </Toast>
</ToastContainer>
<ToastContainer className="toast-container position-fixed top-50 end-0 translate-middle-y p-3">
    <Toast id="middleright-Toast" className="toast colored-toast bg-primary-transparent text-primary"
        onClose={() => handleToasts('middleRight')} show={toasts['middleRight'] || false} delay={3000} autohide>
        <Toast.Header className="toast-header bg-primary text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-white.png" alt="..." />
            <strong className="me-auto">Spruha</strong>
        </Toast.Header>
        <Toast.Body className="toast-body">
            Your,toast message here.
        </Toast.Body>
    </Toast>
</ToastContainer>
<ToastContainer className="toast-container position-fixed bottom-0 start-0 p-3">
    <Toast id="bottomleft-Toast" className="toast colored-toast bg-primary-transparent text-primary"
        onClose={() => handleToasts('bottomLeft')} show={toasts['bottomLeft'] || false} delay={3000} autohide>
        <Toast.Header className="toast-header bg-primary text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-white.png" alt="..." />
            <strong className="me-auto">Spruha</strong>
        </Toast.Header>
        <Toast.Body className="toast-body">
            Your,toast message here.
        </Toast.Body>
    </Toast>
</ToastContainer>
<ToastContainer className="toast-container position-fixed bottom-0 start-50 translate-middle-x p-3">
    <Toast id="bottomcenter-Toast" className="toast colored-toast bg-primary-transparent text-primary"
        onClose={() => handleToasts('bottomCenter')} show={toasts['bottomCenter'] || false} delay={3000} autohide>
        <Toast.Header className="toast-header bg-primary text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-white.png" alt="..." />
            <strong className="me-auto">Spruha</strong>
        </Toast.Header>
        <Toast.Body className="toast-body">
            Your,toast message here.
        </Toast.Body>
    </Toast>
</ToastContainer>
<ToastContainer className="toast-container position-fixed bottom-0 end-0 p-3">
    <Toast id="bottomright-Toast" className="toast colored-toast bg-primary-transparent text-primary"
        onClose={() => handleToasts('bottomRight')} show={toasts['bottomRight'] || false} delay={3000} autohide>
        <Toast.Header className="toast-header bg-primary text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-white.png" alt="..." />
            <strong className="me-auto">Spruha</strong>
        </Toast.Header>
        <Toast.Body className="toast-body">
            Your,toast message here.
        </Toast.Body>
    </Toast>
</ToastContainer>`;

export const toast2 = `import { Button,  Toast, ToastContainer } from "react-bootstrap";
//
const [toasts, setToasts] = useState<{ [key: string]: boolean }>({});

    const addToast = (toastName: string) => {
        setToasts((prevToasts) => ({
          ...prevToasts,
          [toastName]: true,
        }));
      };

	const handleToasts = (toastName: string) => {
        setToasts((prevToasts) => ({ ...prevToasts, [toastName]: false }));
	};
//
<div className="btn-list">
<Button type="button" variant='primary-light' className="btn me-2 btn-wave" id="primaryToastBtn" onClick={() => addToast('PrimaryColor')}>Primary</Button>
<Button variant='secondary-light' type="button" className="btn me-2 btn-wave" id="secondaryToastBtn" onClick={() => addToast('SecondaryColor')}>secondary</Button>
<Button variant='warning-light' type="button" className="btn  me-2 btn-wave" id="warningToastBtn" onClick={() => addToast('WarningColor')}>warning</Button>
<Button variant='info-light' type="button" className="btn  me-2 btn-wave" id="infoToastBtn" onClick={() => addToast('InfoColor')}>info</Button>
<Button variant='success-light' type="button" className="btn  me-2 btn-wave" id="successToastBtn" onClick={() => addToast('SuccessColor')}>success</Button>
<Button variant='danger-light' type="button" className="btn me-2 btn-wave" id="dangerToastBtn" onClick={() => addToast('DangerColor')}>danger</Button>
</div>
<ToastContainer className="toast-container position-fixed top-0 end-0 p-3">
<Toast id="primaryToast" bg="primary-transparent" className="toast colored-toast"
    onClose={() => handleToasts('PrimaryColor')} show={toasts['PrimaryColor'] || false} delay={2000} autohide
    aria-atomic="true">
    <Toast.Header className="toast-header bg-primary text-fixed-white">
        <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-white.png" alt="..." />
        <strong className="me-auto">Spruha</strong>
    </Toast.Header>
    <Toast.Body>
        Your,toast message here.
    </Toast.Body>
</Toast>
<Toast id="secondaryToast" className="toast colored-toast bg-secondary-transparent" role="alert" aria-live="assertive"
    aria-atomic="true" onClose={() => handleToasts('SecondaryColor')} show={toasts['SecondaryColor'] || false} delay={3000} autohide>
    <Toast.Header className="toast-header bg-secondary text-fixed-white">
        <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-dark.png" alt="..." />
        <strong className="me-auto">Spruha</strong>
    </Toast.Header>
    <Toast.Body>
        Your,toast message here.
    </Toast.Body>
</Toast>
<Toast id="warningToast" className="toast colored-toast bg-warning-transparent" role="alert" aria-live="assertive"
    onClose={() => handleToasts('WarningColor')} show={toasts['WarningColor'] || false} delay={3000} autohide
    aria-atomic="true">
    <Toast.Header className="toast-header bg-warning text-fixed-white">
        <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-dark.png" alt="..." />
        <strong className="me-auto">Spruha</strong>
    </Toast.Header>
    <Toast.Body>
        Your,toast message here.
    </Toast.Body>
</Toast>
<Toast id="infoToast" className="toast colored-toast bg-info-transparent" role="alert" aria-live="assertive"
    onClose={() => handleToasts('InfoColor')} show={toasts['InfoColor'] || false} delay={3000} autohide
    aria-atomic="true">
    <Toast.Header className="bg-info text-fixed-white">
        <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-dark.png" alt="..." />
        <strong className="me-auto">Spruha</strong>
    </Toast.Header>
    <Toast.Body>
        Your,toast message here.
    </Toast.Body>
</Toast>
<Toast id="successToast" className="toast colored-toast bg-success-transparent" role="alert" aria-live="assertive"
    onClose={() => handleToasts('SuccessColor')} show={toasts['SuccessColor'] || false} delay={3000} autohide
    aria-atomic="true">
    <Toast.Header className="bg-success text-fixed-white">
        <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-dark.png" alt="..." />
        <strong className="me-auto">Spruha</strong>
    </Toast.Header>
    <Toast.Body>
        Your,toast message here.
    </Toast.Body>
</Toast>
<Toast id="dangerToast" className="toast colored-toast bg-danger-transparent" role="alert" aria-live="assertive"
    onClose={() => handleToasts('DangerColor')} show={toasts['DangerColor'] || false} delay={3000} autohide
    aria-atomic="true">
    <Toast.Header className="toast-header bg-danger text-fixed-white">
        <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-dark.png" alt="..." />
        <strong className="me-auto">Spruha</strong>
    </Toast.Header>
    <Toast.Body className="toast-body">
        Your,toast message here.
    </Toast.Body>
</Toast>
</ToastContainer>`;

export const toast3 = `import { Button,  Toast, ToastContainer } from "react-bootstrap";
//
const [toasts, setToasts] = useState<{ [key: string]: boolean }>({});

    const addToast = (toastName: string) => {
        setToasts((prevToasts) => ({
          ...prevToasts,
          [toastName]: true,
        }));
      };

	const handleToasts = (toastName: string) => {
        setToasts((prevToasts) => ({ ...prevToasts, [toastName]: false }));
	};
//

<div className="btn-list">
    <Button variant='primary' type="button" className="btn btn-primary me-2 btn-wave" id="solidprimaryToastBtn" onClick={() => addToast('solidPrimary')}>Primary</Button>
    <Button variant='secondary' type="button" className="btn btn-secondary me-2 btn-wave" id="solidsecondaryToastBtn" onClick={() => addToast('solidSecondary')}>secondary</Button>
    <Button variant='warning' type="button" className="btn btn-warning me-2 btn-wave" id="solidwarningToastBtn" onClick={() => addToast('solidWarning')}>warning</Button>
    <Button variant='info' type="button" className="btn btn-info me-2 btn-wave" id="solidinfoToastBtn" onClick={() => addToast('solidInfo')}>info</Button>
    <Button variant='success' type="button" className="btn btn-success me-2 btn-wave" id="solidsuccessToastBtn" onClick={() => addToast('solidSuccess')}>success</Button>
    <Button variant='danger' type="button" className="btn btn-danger me-2 btn-wave" id="soliddangerToastBtn" onClick={() => addToast('solidDanger')}>danger</Button>
</div>
<ToastContainer className="toast-container position-fixed top-0 end-0 p-3">
    <Toast id="solid-primaryToast" className="toast colored-toast bg-primary text-fixed-white"
        onClose={() => handleToasts('solidPrimary')} show={toasts['solidPrimary'] || false} delay={3000} autohide>
        <Toast.Header className="toast-header bg-primary text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-white.png" alt="..." />
            <strong className="me-auto">Spruha</strong>
        </Toast.Header>
        <Toast.Body>
            Your,toast message here.
        </Toast.Body>
    </Toast>
    <Toast id="solid-secondaryToast" className="toast colored-toast bg-secondary text-fixed-white"
        onClose={() => handleToasts('solidSecondary')} show={toasts['solidSecondary'] || false} delay={3000} autohide
        aria-atomic="true">
        <Toast.Header className="toast-header bg-secondary text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-dark.png" alt="..." />
            <strong className="me-auto">Spruha</strong>
        </Toast.Header>
        <Toast.Body>
            Your,toast message here.
        </Toast.Body>
    </Toast>
    <Toast id="solid-warningToast" className="toast colored-toast bg-warning text-fixed-white"
        onClose={() => handleToasts('solidWarning')} show={toasts['solidWarning'] || false} delay={3000} autohide>
        <Toast.Header className="toast-header bg-warning text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-dark.png" alt="..." />
            <strong className="me-auto">Spruha</strong>
        </Toast.Header>
        <Toast.Body>
            Your,toast message here.
        </Toast.Body>
    </Toast>
    <Toast id="solid-infoToast" className="toast colored-toast bg-info text-fixed-white"
        onClose={() => handleToasts('solidInfo')} show={toasts['solidInfo'] || false} delay={3000} autohide>
        <Toast.Header className="toast-header bg-info text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-dark.png" alt="..." />
            <strong className="me-auto">Spruha</strong>
        </Toast.Header>
        <Toast.Body>
            Your,toast message here.
        </Toast.Body>
    </Toast>
    <Toast id="solid-successToast" className="toast colored-toast bg-success text-fixed-white"
        onClose={() => handleToasts('solidSuccess')} show={toasts['solidSuccess'] || false} delay={3000} autohide>
        <Toast.Header className="toast-header bg-success text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-dark.png" alt="..." />
            <strong className="me-auto">Spruha</strong>
        </Toast.Header>
        <Toast.Body>
            Your,toast message here.
        </Toast.Body>
    </Toast>
    <Toast id="solid-dangerToast" className="toast colored-toast bg-danger text-fixed-white"
        onClose={() => handleToasts('solidDanger')} show={toasts['solidDanger'] || false} delay={3000} autohide>
        <Toast.Header className="toast-header bg-danger text-fixed-white">
            <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/toggle-dark.png" alt="..." />
            <strong className="me-auto">Spruha</strong>
        </Toast.Header>
        <Toast.Body>
            Your,toast message here.
        </Toast.Body>
    </Toast>
</ToastContainer>`;

export const toast4 = `import { Button,  Toast, ToastContainer } from "react-bootstrap";
///
const [toasts, setToasts] = useState<{ [key: string]: boolean }>({});

    const addToast = (toastName: string) => {
        setToasts((prevToasts) => ({
          ...prevToasts,
          [toastName]: true,
        }));
      };

	const handleToasts = (toastName: string) => {
        setToasts((prevToasts) => ({ ...prevToasts, [toastName]: false }));
	};
///
<Button type="button" className="btn btn-primary btn-wave" id="liveToastBtn" onClick={() => addToast('live')}>
    Show live toast
</Button>
<Toast className="toast position-fixed top-0 end-0 p-0 me-3 mt-3 toast-zindex" show={toasts['live'] || false} onClose={() => handleToasts('live')} delay={3000} autohide>
    <Toast.Header className="text-default mb-0">
        <img className="bd-placeholder-img rounded me-2" src="../../assets/images/brand-logos/favicon.ico" alt="..." />
        <strong className="me-auto">Spruha</strong>
        <small>11 mins ago</small>
    </Toast.Header>
    <Toast.Body>
        Hello, world! This is a toast message.
    </Toast.Body>
</Toast>`;

export const toast5 = `import { Button, CloseButton, Toast, ToastContainer } from "react-bootstrap";
const [toasts, setToasts] = useState<{ [key: string]: boolean }>({});
	const handleToasts = (toastName: string) => {
        setToasts((prevToasts) => ({ ...prevToasts, [toastName]: false }));
	};
<Toast className="toast align-items-center text-bg-primary border-0 fade show mb-4" show={toasts["primary"]}>
    <div className="d-flex">
        <Toast.Body className=" text-fixed-white" >Hello, world! This is Primary toast message. </Toast.Body>
        <CloseButton aria-label="Close" className="btn-close btn-close-white me-2 m-auto" onClick={() => handleToasts('primary')}></CloseButton>
    </div>
</Toast>
<Toast className="toast align-items-center text-bg-secondary border-0 fade show mb-4" show={toasts["secondary"]}>
    <div className="d-flex">
        <Toast.Body className=" text-fixed-white" >Hello, world! This is Secondary toast message. </Toast.Body>
        <CloseButton aria-label="Close" className="btn-close btn-close-white me-2 m-auto" onClick={() => handleToasts('secondary')}></CloseButton>
    </div>
</Toast>
<Toast className="toast align-items-center text-bg-success border-0 fade show mb-4" show={toasts["success"]}>
    <div className="d-flex">
        <Toast.Body className=" text-fixed-white" >Hello, world! This is Success toast message. </Toast.Body>
        <CloseButton aria-label="Close" className="btn-close btn-close-white me-2 m-auto" onClick={() => handleToasts('success')}></CloseButton>
    </div>
</Toast>
<Toast className="toast align-items-center text-bg-info border-0 fade show mb-4" show={toasts["info"]}>
    <div className="d-flex">
        <Toast.Body className=" text-fixed-white" >Hello, world! This is info toast message. </Toast.Body>
        <CloseButton aria-label="Close" className="btn-close btn-close-white me-2 m-auto" onClick={() => handleToasts('info')}></CloseButton>
    </div>
</Toast>
`;

export const toast6 = `import { Button,  Toast, ToastContainer } from "react-bootstrap";
//
const [toasts, setToasts] = useState<{ [key: string]: boolean }>({});

	const handleToasts = (toastName: string) => {
        setToasts((prevToasts) => ({ ...prevToasts, [toastName]: false }));
	};
//
<Toast show={toasts['basic']} onClose={() => handleToasts('basic')} className="toast show"
    role="alert" aria-live="assertive" aria-atomic="true" data-bs-autohide="false">
    <Toast.Header className="text-default">
        <img src="../../assets/images/brand-logos/favicon.ico" alt="" className="me-2" height="18" />
        <strong className="me-auto">Spruha</strong>
        <small>11 mins ago</small>
    </Toast.Header>
    <Toast.Body> Hello, world! This is a toast message.</Toast.Body>
</Toast>`;

export const toast7 = `import { Button,  Toast, ToastContainer } from "react-bootstrap";
//
const [toasts, setToasts] = useState<{ [key: string]: boolean }>({});

	const handleToasts = (toastName: string) => {
        setToasts((prevToasts) => ({ ...prevToasts, [toastName]: false }));
	};
//
<ToastContainer className="toast-container position-static">
    <Toast show={toasts["stack"]} onClose={() => handleToasts('stack')} className="toast fade show">
        <Toast.Header className="toast-header text-default">
            <img src="../../assets/images/brand-logos/favicon.ico" alt="" className="me-2" height="18" />
            <strong className="me-auto">Spruha</strong>
            <small>just now</small>
        </Toast.Header>
        <Toast.Body> See? Just like this.</Toast.Body>
    </Toast>
    <Toast show={toasts["stack1"]} onClose={() => handleToasts('stack1')} className="toast fade show">
        <Toast.Header className="toast-header text-default">
            <img src="../../assets/images/brand-logos/favicon.ico" alt="" className="me-2" height="18" />
            <strong className="me-auto">Spruha</strong>
            <small>2 seconds ago</small>
        </Toast.Header>
        <Toast.Body> Heads up, toasts will stack automatically</Toast.Body>
    </Toast>
</ToastContainer>`;

export const toast8 = `import { Button,  Toast, ToastContainer } from "react-bootstrap";
///
const [toasts, setToasts] = useState<{ [key: string]: boolean }>({});

	const handleToasts = (toastName: string) => {
        setToasts((prevToasts) => ({ ...prevToasts, [toastName]: false }));
	};
///
<Toast onClose={() => handleToasts('transColor')} show={toasts['transColor']} className="toast show" role="alert" aria-live="assertive" aria-atomic="true" data-bs-autohide="false">
<Toast.Header className="text-default">
    <img src="../../assets/images/brand-logos/favicon.ico" alt="" className="me-2" height="18" />
    <strong className="me-auto">Spruha</strong>
    <small>11 mins ago</small>
</Toast.Header>
<Toast.Body> Hello, world! This is a toast message.</Toast.Body>
</Toast>`;

export const toast9 = `import { Button, CloseButton, Toast, ToastContainer } from "react-bootstrap";
//
const [toasts, setToasts] = useState<{ [key: string]: boolean }>({});

	const handleToasts = (toastName: string) => {
        setToasts((prevToasts) => ({ ...prevToasts, [toastName]: false }));
	};
//
<Toast role="alert" className="toast align-items-center fade show mb-3" show={toasts['customColor']}>
<div className="d-flex">
    <Toast.Body className=" text-dark" > Hello, world! This is a toast message.</Toast.Body>
    <CloseButton type="button" className="btn-close me-2 m-auto" onClick={() => handleToasts('customColor')}>
    </CloseButton>
</div>
</Toast>
<div>
<span className="my-4 text-muted">
    Alternatively, you can also add additional controls and components to
    toasts.
</span>
</div>
<Toast className="toast fade show mt-2" role="alert" aria-live="assertive" show={toasts['customsColor']}>
<Toast.Body>
    Hello, world! This is a toast message.
    <div className="mt-2 pt-2 border-top">
        <Button type="button" className="btn btn-primary btn-sm btn-wave me-2">Take
            action</Button>
        <Button type="button" className="btn btn-secondary btn-sm btn-wave" onClick={() => handleToasts('customsColor')}>Close</Button>
    </div>
</Toast.Body>
</Toast>`;

export const toast10 = `import { Button,  Toast, ToastContainer } from "react-bootstrap";
const [toasts, setToasts] = useState<{ [key: string]: boolean }>({});
	const handleToasts = (toastName: string) => {
        setToasts((prevToasts) => ({ ...prevToasts, [toastName]: false }));
	};
<div className="bd-example bg-light bd-example-toasts d-flex p-0 px-3">
<div aria-live="polite" aria-atomic="true"
    className="d-flex justify-content-center align-items-center w-100">
    <Toast show={toasts['alignColor']} onClose={() => handleToasts('alignColor')} className="toast fade show shadow-lg">
        <Toast.Header className="text-default">
            <img src="../../assets/images/brand-logos/favicon.ico" alt="" className="bd-placeholder-img rounded me-2" />
            <strong className="me-auto">Spruha</strong>
            <small>11 mins ago</small>
        </Toast.Header>
        <Toast.Body> Hello, world! This is a toast message.</Toast.Body>
    </Toast>
</div>
</div>`;
/*------ Toasts (prism-code for showcode purpose) end ------*/

/*------ typography (prism-code for showcode purpose) start ------*/
export const typography1 = `<h1  className="mb-3">h1. Bootstrap heading</h1>
<h2  className="mb-3">h2. Bootstrap heading</h2>
<h3  className="mb-3">h3. Bootstrap heading</h3>
<h4  className="mb-3">h4. Bootstrap heading</h4>
<h5  className="mb-3">h5. Bootstrap heading</h5>
<h6  className="mb-0">h6. Bootstrap heading</h6>`;

export const typography2 = `<p  className="h1 mb-3">h1. Bootstrap heading</p>
<p  className="h2 mb-3">h2. Bootstrap heading</p>
<p  className="h3 mb-3">h3. Bootstrap heading</p>
<p  className="h4 mb-3">h4. Bootstrap heading</p>
<p  className="h5 mb-3">h5. Bootstrap heading</p>
<p  className="h6 mb-0">h6. Bootstrap heading</p>`;

export const typography3 =
    `<h1  className="display-1">Display 1</h1>
<h1  className="display-2">Display 2</h1>
<h1  className="display-3">Display 3</h1>
<h1  className="display-4">Display 4</h1>
<h1  className="display-5">Display 5</h1>
<h1  className="display-6">Display 6</h1>`;

export const typography4 = `<h3>
Fancy display heading
<small  className="text-muted">With faded secondary text</small>
 </h3>`;

export const typography5 = `<p>You can use the mark tag to <mark>highlight</mark> text.</p>
<p><del>This line of text is meant to be treated as deleted text.</del>
</p>
<p><s>This line of text is meant to be treated as no longer
        accurate.</s>
</p>
<p><ins>This line of text is meant to be treated as an addition to the
        document.</ins></p>
<p><u>This line of text will render as underlined.</u></p>
<p><small>This line of text is meant to be treated as fine
        print.</small>
</p>
<p><strong>This line rendered as bold text.</strong></p>
<p  className="mb-0"><em>This line rendered as italicized text.</em></p>`;

export const typography6 = `<p  className="fs-1 mb-2">.fs-1 text</p>
<p  className="fs-2 mb-2">.fs-2 text</p>
<p  className="fs-3 mb-2">.fs-3 text</p>
<p  className="fs-4 mb-2">.fs-4 text</p>
<p  className="fs-5 mb-2">.fs-5 text</p>
<p  className="fs-6 mb-0">.fs-6 text</p>`;

export const typography7 =
    `<p  className="lead mb-0">
<b>This is a lead paragraph. It stands out from regular paragraphs</b>.There are many variations of passages of Lorem Ipsum available,
 but the majority have suffered alteration in some form, by injected humour, or randomised words which don't look even slightly believable.
  If you are going to use a passage of Lorem Ipsum, you need to be sure there isn't anything embarrassing hidden in the middle of text.
</p>`;

export const typography8 = `<dl  className="row mb-0">
<dt  className="col-sm-3">Description lists</dt>
<dd  className="col-sm-9">A description list is perfect for defining terms.</dd>

<dt  className="col-sm-3">Term</dt>
<dd  className="col-sm-9">
    <p>Definition for the term.</p>
    <p>And some more placeholder definition text.</p>
</dd>

<dt  className="col-sm-3">Another term</dt>
<dd  className="col-sm-9">This definition is short, so no extra paragraphs or
    anything.</dd>

<dt  className="col-sm-3 text-truncate">Truncated term is truncated</dt>
<dd  className="col-sm-9">This can be useful when space is tight. Adds an
    ellipsis at
    the end.</dd>

<dt  className="col-sm-3">Nesting</dt>
<dd  className="col-sm-9 mb-0">
    <dl  className="row mb-0">
        <dt  className="col-sm-4">Nested definition list</dt>
        <dd  className="col-sm-8 mb-0">I heard you like definition lists. Let me put a
            definition list inside your definition list.</dd>
    </dl>
</dd></dl>`;

export const typography9 = `<ul  className="list-unstyled">
<li>This is a list.</li>
<li>It appears completely unstyled.</li>
<li>Structurally, it's still a list.</li>
<li>However, this style only applies to immediate child elements.</li>
<li  className="mb-2">Nested lists:
    <ul>
        <li>are unaffected by this style</li>
        <li>will still show a bullet</li>
        <li>and have appropriate left margin</li>
    </ul>
</li>
<li>This may still come in handy in some situations.</li>
</ul>`;

export const typography10 = `<figure  className="blockquote-container">
<blockquote  className="blockquote mb-2">
    <h6>The greatest glory in living lies not in never falling, but in rising every time we fall.</h6>
</blockquote>
<figcaption  className="blockquote-footer mt-0 mb-0 text-muted op-7"><cite title="Source Title">Nelson Mandela</cite>
</figcaption> </figure>`;

export const typography11 = `<figure  className="blockquote-container text-end">
<blockquote  className="blockquote mb-2">
    <h6>The greatest glory in living lies not in never falling, but in rising every time we fall.</h6>
</blockquote>
<figcaption  className="blockquote-footer mt-0 mb-0 text-muted op-7"><cite title="Source Title">Nelson Mandela</cite>
</figcaption></figure>`;

export const typography12 = `<blockquote  className="blockquote custom-blockquote primary mb-0 text-center">
<h6>The future belongs to those who believe in the beauty of their dreams..</h6>
<footer  className="blockquote-footer mt-3 fs-14 text-muted op-7 mb-0">Someone famous as <cite title="Source Title">-Eleanor Roosevelt</cite></footer>
<span  className="quote-icon"><i  className="ri-information-line"></i></span></blockquote>`;

export const typography13 = `<blockquote  className="blockquote custom-blockquote secondary mb-0 text-center">
<h6>The future belongs to those who believe in the beauty of their dreams..</h6>
<footer  className="blockquote-footer mt-3 fs-14 text-muted op-7 mb-0">Someone famous as <cite title="Source Title">-Eleanor Roosevelt</cite></footer>
<span  className="quote-icon"><i  className="ri-information-line"></i></span>
</blockquote>`;

export const typography14 = `<blockquote  className="blockquote custom-blockquote warning mb-0 text-center">
<h6>The future belongs to those who believe in the beauty of their dreams..</h6>
<footer  className="blockquote-footer mt-3 fs-14 text-muted op-7 mb-0">Someone famous as <cite title="Source Title">-Eleanor Roosevelt</cite></footer>
<span  className="quote-icon"><i  className="ri-information-line"></i></span>`;

export const typography15 = `<blockquote  className="blockquote custom-blockquote success mb-0 text-center">
<h6>The future belongs to those who believe in the beauty of their dreams..</h6>
<footer  className="blockquote-footer mt-3 fs-14 text-muted op-7 mb-0">Someone famous as <cite title="Source Title">-Eleanor Roosevelt</cite></footer>
<span  className="quote-icon"><i  className="ri-information-line"></i></span>
</blockquote>`;

export const typography16 = `<blockquote  className="blockquote custom-blockquote info mb-0 text-center">
<h6>The future belongs to those who believe in the beauty of their dreams..</h6>
<footer  className="blockquote-footer mt-3 fs-14 text-muted op-7 mb-0">Someone famous as <cite title="Source Title">-Eleanor Roosevelt</cite></footer>
<span  className="quote-icon"><i  className="ri-information-line"></i></span>
</blockquote>`;

export const typography17 = `<blockquote  className="blockquote custom-blockquote danger mb-0 text-center">
<h6>The future belongs to those who believe in the beauty of their dreams..</h6>
<footer  className="blockquote-footer mt-3 fs-14 text-muted op-7 mb-0">Someone famous as <cite title="Source Title">-Eleanor Roosevelt</cite></footer>
<span  className="quote-icon"><i  className="ri-information-line"></i></span>
</blockquote>`;

export const typography18 = `<p><abbr title="attribute">attr</abbr></p>
<p  className="mb-0"><abbr title="HyperText Markup Language"  className="initialism">HTML</abbr></p>`;

export const typography19 = `<ul  className="list-inline mb-0">
<li  className="list-inline-item">This is a list item.</li>
<li  className="list-inline-item">And another one.</li>
<li  className="list-inline-item">But they're displayed inline.</li>
</ul>`;

export const typography20 = `<p  className="mb-1">Lorem ipsum dolor sit amet consectetur adipisicing elit. 
Rerum dolorem fuga iste obcaecati natus eos officiis adipisci voluptatibus ipsum, 
architecto veniam delectus vel dolor magni a vero sunt ut harum.</p>
<div  className="text-success">
    <hr/>
</div>
<p  className=" mb-1">Lorem, ipsum dolor sit amet consectetur adipisicing elit. Iusto perspiciatis, 
magni numquam quos perferendis nulla magnam odit amet excepturi quisquam provident.</p>
<hr  className="text-danger border-2 opacity-50"/>
<p  className="mb-0">Lorem ipsum dolor sit amet consectetur adipisicing elit. Repellendus aliquid consequatur
 aut doloremque assumenda voluptatem, id qui vero adipisci! Nostrum ipsam praesentium!</p>
<hr  className="border-primary border-3 opacity-75"/>`;

export const typography21 = "<p  class=\"font-monospace mb-0\">This is in monospace</p>";

export const typography22 = `<p  className="text-muted mb-0">
Muted text with a <a href="#!"  className="text-reset text-decoration-underline text-dark">reset link</a>.
</p>`;

export const typography23 = "<p  class=\"visible mb-0\">This is visible text</p>";

export const typography24 = "<p  class=\"invisible mb-0\">This is invisible text</p>";

export const typography25 = `<p  className="text-lowercase">Lowercased text.</p>
<p  className="text-uppercase">Uppercased text.</p>
<p  className="text-capitalize mb-0">CapiTaliZed text.</p>`;

export const typography26 = `<p  className="text-decoration-underline">This text has a line underneath it.
</p>
<p  className="text-decoration-line-through">This text has a line going
    through
    it.
</p>
<Link  scroll={false} href="#!"  className="text-decoration-none">This link has its text
    decoration
    removed
</Link>`;

export const typography27 = `<p  className="fw-bold">Bold text.</p>
<p  className="fw-bolder">Bolder weight text (relative to the parent element).</p>
<p  className="fw-semibold">Semibold weight text.</p>
<p  className="fw-normal">Normal weight text.</p>
<p  className="fw-light">Light weight text.</p>
<p  className="fw-lighter">Lighter weight text (relative to the parent element).</p>
<p  className="fst-italic">Italic text.</p>
<p  className="fst-normal mb-0">Text with normal font style</p>`;

export const typography28 = `<p  className="lh-1">This is a long paragraph written to show how the line-height of
an
element is affected by our utilities. Classes are applied to the element
itself
or sometimes the parent element. These classes can be customized as needed
with
our utility API.
</p>
<p  className="lh-sm">This is a long paragraph written to show how the line-height of
an
element is affected by our utilities. Classes are applied to the element
itself
or sometimes the parent element. These classes can be customized as needed
with
our utility API.
</p>
<p  className="lh-base">This is a long paragraph written to show how the line-height
of
an element is affected by our utilities. Classes are applied to the element
itself or sometimes the parent element. These classes can be customized as
needed with our utility API.
</p>
<p  className="lh-lg mb-0">This is a long paragraph written to show how the
line-height
of an
element is affected by our utilities. Classes are applied to the element
itself
or sometimes the parent element. These classes can be customized as needed
with
our utility API.
</p>`;

export const typography29 = `<p  className="text-start">Start aligned text on all viewport sizes.</p>
<p  className="text-center">Center aligned text on all viewport sizes.</p>
<p  className="text-end">End aligned text on all viewport sizes.</p>

<p  className="text-sm-start">Start aligned text on viewports sized SM (small) or
    wider.
</p>
<p  className="text-md-start">Start aligned text on viewports sized MD (medium) or
    wider.
</p>
<p  className="text-lg-start">Start aligned text on viewports sized LG (large) or
    wider.
</p>
<p  className="text-xl-start">Start aligned text on viewports sized XL (extra-large)
    or
    wider.</p>`;

export const typography30 = `<div  className="badge bg-primary text-wrap mb-3" style={{width: "6rem"}}>
This text should wrap.
</div>
<p  className="text-muted mb-2"> use class <code>.text-nowrap</code> to prevent text from wrapping</p>
<div  className="text-nowrap bg-light border" style={{width: "8rem"}}>
This text should overflow the parent.
</div>`;

export const typography31 = `<p  className="text-break mb-0">
mmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmmm
 </p>`;
/*------ typography (prism-code for showcode purpose) end ------*/

/*------ tags (prism-code for showcode purpose) start ------*/
export const tag1 = `<span className="tag tag-default mt-1 mb-1 me-1">Default</span>
<span className="tag tag-dark mt-1 mb-1 me-1">Dark</span>
<span className="tag tag-primary mt-1 mb-1 me-1">Primary</span>
<span className="tag tag-success mt-1 mb-1 me-1">Success</span>
<span className="tag tag-info mt-1 mb-1 me-1">Info</span>
<span className="tag tag-warning mt-1 mb-1 me-1">Warning</span>
<span className="tag tag-danger mt-1 mb-1 me-1">Danger</span>`;

export const tag2 = ` <span className="tag tag-default tag-pill mt-1 mb-1 me-1">Default</span>
<span className="tag tag-dark tag-pill mt-1 mb-1 me-1">Dark</span>
<span className="tag tag-primary tag-pill mt-1 mb-1 me-1">Primary</span>
<span className="tag tag-success tag-pill mt-1 mb-1 me-1">Success</span>
<span className="tag tag-info tag-pill mt-1 mb-1 me-1">Info</span>
<span className="tag tag-warning tag-pill mt-1 mb-1 me-1">Warning</span>
<span className="tag tag-danger tag-pill mt-1 mb-1 me-1">Danger</span>`;
export const tag3 = `<div className="tags">
<span className="tag tag-default">
  One
  <Link  scroll={false} href="#!" className="tag-addon"><i className="fe fe-x"></i></Link>
</span>
<span className="tag tag-default">
  Two
  <Link  scroll={false} href="#!" className="tag-addon"><i className="fe fe-x"></i></Link>
</span>
<span className="tag tag-default">
  Three
  <Link  scroll={false} href="#!" className="tag-addon"><i className="fe fe-x"></i></Link>
</span>
<span className="tag tag-default">
  Four
  <Link  scroll={false} href="#!" className="tag-addon"><i className="fe fe-x"></i></Link>
</span>
</div>`;
export const tag4 = `<div className="tags">
<span className="tag tag-primary br-5">primary tag<Link  scroll={false} href="#!" className="tag-addon bg-primary"><i className="fe fe-x"></i></Link> </span>
<span className="tag tag-secondary br-5">secondary tag<Link  scroll={false} href="#!" className="tag-addon bg-secondary"><i className="fe fe-x"></i></Link> </span>
<span className="tag tag-success br-5">success tag<Link  scroll={false} href="#!" className="tag-addon bg-success"><i className="fe fe-x"></i></Link> </span>
<span className="tag tag-warning br-5">warning tag<Link  scroll={false} href="#!" className="tag-addon bg-warning"><i className="fe fe-x"></i></Link> </span>
<span className="tag tag-teal br-5">teal tag<Link  scroll={false} href="#!" className="tag-addon bg-teal"><i className="fe fe-x"></i></Link> </span>
<span className="tag tag-danger br-5">danger tag<Link  scroll={false} href="#!" className="tag-addon bg-danger"><i className="fe fe-x"></i></Link> </span>
</div>`;
/*------ tags (prism-code for showcode purpose) end ------*/
