
"use client"
import React, { useEffect, useState } from "react";
import { Button } from "react-bootstrap";

const TabToTop = ({landingPage}:any) => {
	const [BacktoTop, setBacktopTop] = useState("");

	useEffect(() => {
	  const handleScroll = () => {
		  if (window.scrollY > 100) {
			  setBacktopTop("d-flex");
		  } else {
			  setBacktopTop("");
		  }
	  };
  
	  window.addEventListener("scroll", handleScroll);
  
	  return () => {
		  window.removeEventListener("scroll", handleScroll);
	  };
  }, []); 
  
	const screenup = () => {
	  window.scrollTo({
		top: 10,
		behavior: "auto",
	  });
	};
	return (
		
		<>
		{
			landingPage ? (
				<Button className={`scrollToTop ${BacktoTop}`} onClick={screenup} >
					<span className="arrow">
						<i className="ri-arrow-up-s-fill fs-20"></i>
					</span>
				</Button>
			) : (
				<div  onClick={screenup} className={`scrollToTop ${BacktoTop}`}>
					<span className="arrow">
						<i className="ti ti-arrow-narrow-up fs-20"></i>
					</span>
				</div>
			)
		}
	</>
	);
};

export default TabToTop;



