import Link from "next/link";
import { Fragment } from "react";
import { OverlayTrigger, Tooltip } from "react-bootstrap";

function Menuloop({ MENUITEMS, toggleSidemenu, level ,HoverToggleInnerMenuFn}:any) {

	const handleClick = (event: { preventDefault: () => void; }) => {
		// Your logic here
		event.preventDefault(); // Prevents the default anchor behavior (navigation)
		// ... other logic you want to perform on click
	};
	
	return (
		<Fragment>
			<Link href="#!" className={`side-menu__item ${MENUITEMS?.selected ? "active" : ""}`} onClick={(event) => { event.preventDefault(); toggleSidemenu(event, MENUITEMS); }} onMouseEnter={(event) => HoverToggleInnerMenuFn(event, MENUITEMS)} >

				{/* In case of doublemenu style the icon contains tooltip here is the style for sub menu items */}

				{((level <= 1) && MENUITEMS.icon) && (
					(typeof localStorage !== "undefined" && localStorage.spruhaverticalstyles === "doublemenu" && localStorage.spruhalayout !== "horizontal") ? (
						<>
							<span className="shape1"></span>
							<span className="shape2"></span>
							<>
								<OverlayTrigger placement={localStorage.spruhartl ? "left" : "right"} overlay={<Tooltip>{MENUITEMS.title}</Tooltip>}>
									<i className={`${MENUITEMS.icon} side-menu__icon`}></i>
								</OverlayTrigger>
							</>
						</>
					) : (
						<>
							<span className="shape1"></span>
							<span className="shape2"></span>
							<i className={`${MENUITEMS.icon} side-menu__icon`}></i>
						</>
					)
				)}

				<span className={`${level === 1 ? "side-menu__label" : ""}`}>{MENUITEMS.title}</span>

				<i className="fe fe-chevron-right side-menu__angle"></i>

			</Link>

			<ul
				className={`slide-menu child${level}  
				  ${MENUITEMS.active ? "double-menu-active" : ""} 
				  ${MENUITEMS?.dirchange ? "force-left" : ""}`} // Apply class to level 2 as well
				style={MENUITEMS.active ? { display: "block" } : { display: "none" }}
				
			>


				{level <= 1 ? (
					<li className="slide side-menu__label1">
						<Link href="#!">{MENUITEMS.title}</Link>
					</li>
				) : (
					""
				)}

				{MENUITEMS.children?.map((firstlevel:any) => (
					<li
						className={`${firstlevel.menutitle ? "slide__category" : ""}
									 ${firstlevel?.type === "empty" ? "slide" : ""} 
									${firstlevel?.type === "link" ? "slide" : ""} 
									${firstlevel?.type === "sub" ? "slide has-sub" : ""} 
									${firstlevel?.active ? "open" : ""} 
									${firstlevel?.selected ? "active" : ""}`}
									key={firstlevel.id || firstlevel.title}
					>
						{/* if it is a single link like Dashboard or Widgets or landingpage */}
						{firstlevel.type === "link" ? (
							<Link href={firstlevel.path || "#!"} className={`side-menu__item ${firstlevel.selected ? "active" : ""}`}>
								{firstlevel.icon} <span className="">{firstlevel.title}</span>
							</Link>
						) : (
							""
						)}

						{/* if empty type  */}
					
						{firstlevel.type === "empty" ? (
							<Link href="#!" className="side-menu__item" onClick={handleClick}>
								{firstlevel.icon} <span className=""> {firstlevel.title} </span>
							</Link>
						) : (
							""
						)}

						{/* //for sub level refer the Menuloop.jsx component */}
						{firstlevel.type === "sub" ? (
							<Menuloop MENUITEMS={firstlevel} toggleSidemenu={toggleSidemenu} HoverToggleInnerMenuFn={HoverToggleInnerMenuFn} level={level + 1} />
						) : (
							""
						)}
					</li>
				))}
			</ul>

		</Fragment>
	);
}

export default Menuloop;
