const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');

const Admin = db.define('Admin', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    username: {
        type: DataTypes.STRING,
        allowNull: false
    },
    email: {
        type: DataTypes.STRING,
        allowNull: false
    },
    password: {
        type: DataTypes.STRING,
        allowNull: false
    },
    phone: {
        type: DataTypes.STRING,
        allowNull: false
    },
    first: {
        type: DataTypes.STRING,
        allowNull: false
    },
    last: {
        type: DataTypes.STRING,
        allowNull: true
    },
    role: {
        type: DataTypes.STRING,
        allowNull: true
    },

    is_loggedin: {
        type: DataTypes.STRING,
        allowNull: true
    },
    ban: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    otp: {
        type: DataTypes.STRING,
        allowNull: true
    },
    otp_token: {
        type: DataTypes.STRING,
        allowNull: true
    },
    reason: {
        type: DataTypes.STRING,
        allowNull: true
    },
    first_login: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: 0
    },
    pref: {
        type: DataTypes.STRING,
        allowNull: true,
        defaultValue: 'magiclink'
    },
    latest_activity: {
        type: DataTypes.STRING,
        allowNull: true
    },
    otp_allow: {
        type: DataTypes.STRING,
        allowNull: true
    },

}, {
    tableName: 'admin',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = Admin;