
// Associations
const Admin = require('./Admin')
const ManagerOwed = require('./ManagerOwed')
const MiscLog = require('./MiscLog')
const MiscTxn = require('./MiscTxn')
const ShortShift = require('./ShortShift')

ManagerOwed.belongsTo(Admin, { foreignKey: 'manager_id' })
MiscLog.belongsTo(Admin, { foreignKey: 'admin_id' })
MiscTxn.belongsTo(Admin, { foreignKey: 'admin_id' })

ShortShift.belongsTo(Admin, { foreignKey: 'current_admin', as: 'currentAdmin' });
ShortShift.belongsTo(Admin, { foreignKey: 'last_admin', as: 'lastAdmin' });

module.exports = {
    Admin, ManagerOwed, MiscLog, MiscTxn, ShortShift
};