const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');

const MiscLog = db.define('MiscLog', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    admin_id: {
        type: DataTypes.STRING,
        allowNull: true
    },
    initial_amount: {
        type: DataTypes.STRING,
        allowNull: true
    },
    withdraw_amount: {
        type: DataTypes.STRING,
        allowNull: true
    },
    withdraw_reason: {
        type: DataTypes.STRING,
        allowNull: true
    },
   
    withdraw_manager: {
        type: DataTypes.STRING,
        allowNull: true
    },
}, {
    tableName: 'misclogs',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = MiscLog;