const express = require('express');
const router = express.Router();
const multer = require('multer');

const authController = require('../controllers/Auth');

const dashboardController = require('../controllers/Dashboard');
const cashierController = require('../controllers/Cashiers');
const upload = require('../middleware/upload');
const rateLimit = require('express-rate-limit');
// const upload = multer();

const ipLock = require('../middleware/ipLockMiddleware');
const ipLockWare = ipLock.ipLockMiddleware;


// router.use((req, res, next) => {
//     console.log(req.path)
//     console.log("Processed by requestHandler:", req.processedByRequestHandler ? "Yes" : "No");

//     if (excludedRoutes.includes(req.path)) {
//         return next();
//     }
//     ipLockWare(req, res, next);
// });

const otpLoginLimiter = rateLimit({
    windowMs: 1 * 60 * 1000, // 1 minutes
    max: 5, // Limit each IP to 1 requests per windowMs
    message: 'Too many requests from this IP, please try again later.',
});
// Route to get all admins
// router.get('/admins', authController.getAllAdmins);

// // Route to get an admin by ID
// router.get('/admins/:id', authController.getAdminById);

router.post('/loginOtp', authController.loginOtp);
router.post('/sendLoginOtp', otpLoginLimiter, authController.sendLoginOtp);
router.post('/resendLoginOtp', otpLoginLimiter, authController.resendLoginOtp);
router.post('/verifyLoginOtp', authController.verifyLoginOtp);
router.get('/logout', authController.logout);
router.get('/getAdmin', authController.getAdmin);
router.get('/dashboard', dashboardController.dashboard);

router.post('/initialBalance', dashboardController.initialBalance);
router.post('/fillBalance', dashboardController.fillBalance);
router.post('/resetPos', dashboardController.resetPos);
router.post('/saveWithdraw', upload.single('image'), dashboardController.saveWithdraw);
router.post('/saveShortShift', dashboardController.saveShortShift);

router.post('/endOtp', dashboardController.endOtp);
router.post('/sendEndOtp', dashboardController.sendEndOtp);
router.post('/resendEndOtp', dashboardController.resendEndOtp);
router.post('/verifyEndOtp', dashboardController.verifyEndOtp);
router.post('/saveEndShift', upload.any(), dashboardController.saveEndShift);

router.get('/transactions', dashboardController.transactions);
router.get('/shortShift', dashboardController.shortShift);

router.get('/cashiers', cashierController.cashiers);
router.post('/updateOTP', cashierController.updateOTP);
router.post('/banCashier', cashierController.banCashier);
router.post('/unbanCashier', cashierController.unbanCashier);
router.post('/deleteCashier', cashierController.deleteCashier);
router.post('/createCashier', cashierController.createCashier);

router.get('/loggedInCashier', cashierController.loggedInCashier);
router.post('/logoutCashier', cashierController.logoutCashier);

router.get('/managerWithdrawals', dashboardController.managerWithdrawals);
router.get('/clearManagerWithdrawals', dashboardController.clearManagerWithdrawals);
router.post('/clearDebt', dashboardController.clearDebt);

router.get('/rcllcClicks', dashboardController.rcllcClicks);

module.exports = router;