import React from 'react'
import CodeDialog from "@/app/components/shared/CodeDialog";

function BasicCustomIconsCode() {
    return (
        <CodeDialog>
            {`
import * as React from 'react';
import Box from '@mui/material/Box';
import AddBoxIcon from '@mui/icons-material/AddBox';
import IndeterminateCheckBoxIcon from '@mui/icons-material/IndeterminateCheckBox';
import SvgIcon, { SvgIconProps } from '@mui/material/SvgIcon';
import { styled } from '@mui/material/styles';
import { SimpleTreeView } from '@mui/x-tree-view/SimpleTreeView';
import { TreeItem, treeItemClasses } from '@mui/x-tree-view/TreeItem';
 const BCrumb = [
{
to: '/',
title: 'Home',
},
{
title: 'BasicCustomIcons ',
},
]; 


const CustomTreeItem = styled(TreeItem)({
    [\`\& .\${treeItemClasses.iconContainer}\`]: {
                '& .close': {
                opacity: 0.3,
        },
    },
});

            function CloseSquare(props) {
    return (
            <SvgIcon
                className="close"
                fontSize="inherit"
                style={{ width: 14, height: 14 }}
                {...props}
            >
                {/* tslint:disable-next-line: max-line-length */}
                <path d="M17.485 17.512q-.281.281-.682.281t-.696-.268l-4.12-4.147-4.12 4.147q-.294.268-.696.268t-.682-.281-.281-.682.294-.669l4.12-4.147-4.12-4.147q-.294-.268-.294-.669t.281-.682.682-.281.696 .268l4.12 4.147 4.12-4.147q.294-.268.696-.268t.682.281 .281.669-.294.682l-4.12 4.147 4.12 4.147q.294.268 .294.669t-.281.682zM22.047 22.074v0 0-20.147 0h-20.12v0 20.147 0h20.12zM22.047 24h-20.12q-.803 0-1.365-.562t-.562-1.365v-20.147q0-.776.562-1.351t1.365-.575h20.147q.776 0 1.351.575t.575 1.351v20.147q0 .803-.575 1.365t-1.378.562v0z" />
            </SvgIcon>
            );
}

            export default function BasicCustomIcons() {
    return (

            <Box sx={{ minHeight: 352, minWidth: 250 }}>
                <SimpleTreeView
                    defaultExpandedItems={['grid']}
                    slots={{
                        expandIcon: AddBoxIcon,
                        collapseIcon: IndeterminateCheckBoxIcon,
                        endIcon: CloseSquare,
                    }}
                >
                    <CustomTreeItem itemId="grid" label="Data Grid">
                        <CustomTreeItem itemId="grid-community" label="@mui/x-data-grid" />
                        <CustomTreeItem itemId="grid-pro" label="@mui/x-data-grid-pro" />
                        <CustomTreeItem itemId="grid-premium" label="@mui/x-data-grid-premium" />
                    </CustomTreeItem>
                    <CustomTreeItem itemId="pickers" label="Date and Time Pickers">
                        <CustomTreeItem itemId="pickers-community" label="@mui/x-date-pickers" />
                        <CustomTreeItem itemId="pickers-pro" label="@mui/x-date-pickers-pro" />
                    </CustomTreeItem>
                    <CustomTreeItem itemId="charts" label="Charts">
                        <CustomTreeItem itemId="charts-community" label="@mui/x-charts" />
                    </CustomTreeItem>
                    <CustomTreeItem itemId="tree-view" label="Tree View">
                        <CustomTreeItem itemId="tree-view-community" label="@mui/x-tree-view" />
                    </CustomTreeItem>
                </SimpleTreeView>
            </Box>

            );
}


            `}
        </CodeDialog>
    )
}

export default BasicCustomIconsCode