"use client";
import * as React from "react";
import {
  TableContainer,
  Table,
  TableRow,
  TableCell,
  TableBody,
  Typography,
  TableHead,
  Box,
  Grid,
  Button,
} from "@mui/material";

import BaseCard from "@/app/components/shared/BaseCard";
import {
  EnTableType,
} from "@/app/components/tables/tableData";

import {
  createColumnHelper,
  flexRender,
  getCoreRowModel,
  useReactTable,
} from "@tanstack/react-table";
import { redirect } from "next/navigation";

const columnHelper = createColumnHelper<EnTableType>();

const TableBasicReact = ({ games, kioskId }: any) => {
  // define columns inside component so kioskId is accessible
  const columns = [
    columnHelper.accessor("id", {
      header: () => "ID",
      cell: ({ row }) => (
        <Typography variant="h6" fontWeight={400}>
          {row.index + 1}
        </Typography>
      ),
    }),
    columnHelper.accessor("name", {
      header: () => "Name",
      cell: ({ row }) => (
        <Typography variant="h6" fontWeight={400}>
          {row.original.name}
        </Typography>
      ),
    }),
    columnHelper.display({
      id: "view",
      header: () => "Completed",
      cell: ({ row }) => (
        <Button
          onClick={() =>
            redirect(`/creationsByGame/${row.original.id}?kioskId=${kioskId}`)
          }
        >
          View
        </Button>
      ),
    }),
    columnHelper.display({
      id: "requested",
      header: () => "Requested",
      cell: ({ row }) => {
        const gameId = row.original.id;
        const allowedGameIds = [1, 58]; // ✅ Only these IDs can show View button

        if (allowedGameIds.includes(Number(gameId))) {
          return (
            <Button
              onClick={() =>
                redirect(`/creationsByGameRequested/${gameId}?kioskId=${kioskId}`)
              }
            >
              View
            </Button>
          );
        }

        // For other games → show ---
        return (
          <Typography variant="h6" fontWeight={400} sx={{ color: "gray" }}>
            ---
          </Typography>
        );
      },
    }),
  ];

  const table = useReactTable({
    data: games,
    columns,
    getCoreRowModel: getCoreRowModel(),
  });

  return (
    <BaseCard title="Creations">
      <Grid container spacing={3}>
        <Grid size={12}>
          <Box>
            <TableContainer>
              <Table sx={{ whiteSpace: "nowrap" }}>
                <TableHead>
                  {table.getHeaderGroups().map((headerGroup) => (
                    <TableRow key={headerGroup.id}>
                      {headerGroup.headers.map((header) => (
                        <TableCell key={header.id}>
                          <Typography variant="h6">
                            {header.isPlaceholder
                              ? null
                              : flexRender(
                                header.column.columnDef.header,
                                header.getContext()
                              )}
                          </Typography>
                        </TableCell>
                      ))}
                    </TableRow>
                  ))}
                </TableHead>
                <TableBody>
                  {table.getRowModel().rows.map((row) => (
                    <TableRow key={row.id}>
                      {row.getVisibleCells().map((cell) => (
                        <TableCell key={cell.id}>
                          {flexRender(
                            cell.column.columnDef.cell,
                            cell.getContext()
                          )}
                        </TableCell>
                      ))}
                    </TableRow>
                  ))}
                </TableBody>
              </Table>
            </TableContainer>
          </Box>
        </Grid>
      </Grid>
    </BaseCard>
  );
};

export default TableBasicReact;
