"use client";
import React from "react";
import { useEffect, useState } from "react";

import { Grid, Box, Alert, LinearProgress } from "@mui/material";
import PageContainer from "@/app/components/container/PageContainer";
// components
import YearlyBreakup from "@/app/components/dashboards/modern/YearlyBreakup";
import MonthlyEarnings from "@/app/components/dashboards/modern/MonthlyEarnings";
import TopCards from "@/app/components/dashboards/modern/TopCards";
import RevenueUpdates from "@/app/components/dashboards/modern/RevenueUpdates";
import EmployeeSalary from "@/app/components/dashboards/modern/EmployeeSalary";
import Customers from "@/app/components/dashboards/modern/Customers";
import Projects from "@/app/components/dashboards/modern/Projects";
import Social from "@/app/components/dashboards/modern/Social";
import SellingProducts from "@/app/components/dashboards/modern/SellingProducts";
import WeeklyStats from "@/app/components/dashboards/modern/WeeklyStats";
import TopPerformers from "@/app/components/dashboards/modern/TopPerformers";
import axios from "axios";
import { useRouter, useSearchParams } from "next/navigation";
import { getSession } from '@/utils/sessionData';
import TopCardsNew from "../components/dashboards/modern/TopCardsNew";
import TableBasicReact from "./TableBasicReact";

export default function Dashboard() {
  const [isLoading, setIsLoading] = useState(true);
  useEffect(() => {
    setIsLoading(false);
  }, []);

  const router = useRouter();
  const checkSession = async () => {
    const session = getSession()
    if (!session?.admin_id && !session?.token) {
      router.push('/login')
    }
  }
  useEffect(() => {
    checkSession()
  }, [])
  // const { isLoading } = useGetAnalyticsDashboardWidgetsQuery();

  const [sessionData, setSessionData] = useState<any>();
  // const [isLoading, setIsLoading] = useState(false);
  const [games, setGames] = useState<any>([])
  const fetchGames = async () => {
    try {
      setIsLoading(true)
      const token = sessionData?.token;
      const response = await axios.post('/api/getAutoGameList', { token })
      if (response?.data?.status !== 'error') {
        setIsLoading(false)
        setGames(response?.data?.games)
      }
      setIsLoading(false)

    } catch (error: any) {
      setIsLoading(false)

      console.log(error.message)
    }
  }


  useEffect(() => {
    const session = getSession();
    setSessionData(session);
  }, []);

  useEffect(() => {
    if (sessionData?.token && sessionData?.admin_id) {
      fetchGames()
    }
  }, [sessionData?.token, sessionData?.admin_id]);

  const searchParams = useSearchParams();
  const kioskId = searchParams?.get("kioskId") ?? searchParams?.get("kiosk_id");

  return (
    (<PageContainer title="Creations" description="this is Creations">
      <Box >
        <Grid container spacing={3}>
          {/* column */}
          <Grid
            size={{
              xs: 12,
              lg: 12
            }}>
            {isLoading && <LinearProgress />}

            <TableBasicReact games={games} kioskId={kioskId} />
            {/* <TopCardsNew
              receiverStatus={
                isLoading ? (
                  '...'
                ) : kioskRunning ? (
                  <Alert variant="filled" severity="success" className="text-white">
                    Active
                  </Alert>
                ) : (
                  <Alert variant="filled" severity="error">
                    Inactive
                  </Alert>
                )
              }
              kioskBalance={
                isLoading ? '...' : `$${kioskData && (parseInt(kioskData?.amountStacked) / 100)}`
              }
              kioskBillCount={
                isLoading ? '...' : `${kioskData && kioskData?.notesStacked}`
              }
              kioskTotalDeposits={
                isLoading ? '...' : `$${dashData && dashData?.totalDeposit}`
              }
            /> */}
          </Grid>
          {/* column */}
          {/* <Grid
            size={{
              xs: 12,
              lg: 8
            }}>
            <RevenueUpdates isLoading={isLoading} />
          </Grid> */}
          {/* column */}
          {/* <Grid
            size={{
              xs: 12,
              lg: 4
            }}>
            <Grid container spacing={3}>
              <Grid
                size={{
                  xs: 12,
                  sm: 6,
                  lg: 12
                }}>
                <YearlyBreakup isLoading={isLoading} />
              </Grid>
              <Grid
                size={{
                  xs: 12,
                  sm: 6,
                  lg: 12
                }}>
                <MonthlyEarnings isLoading={isLoading} />
              </Grid>
            </Grid>
          </Grid> */}
          {/* column */}
          {/* <Grid
            size={{
              xs: 12,
              lg: 4
            }}>
            <EmployeeSalary isLoading={isLoading} />
          </Grid> */}
          {/* column */}
          {/* <Grid
            size={{
              xs: 12,
              lg: 4
            }}>
            <Grid container spacing={3}>
              <Grid
                size={{
                  xs: 12,
                  sm: 6
                }}>
                <Customers isLoading={isLoading} />
              </Grid>
              <Grid
                size={{
                  xs: 12,
                  sm: 6
                }}>
                <Projects isLoading={isLoading} />
              </Grid>
              <Grid size={12}>
                <Social />
              </Grid>
            </Grid>
          </Grid> */}
          {/* column */}
          {/* <Grid
            size={{
              xs: 12,
              lg: 4
            }}>
            <SellingProducts />
          </Grid> */}
          {/* column */}
          {/* <Grid
            size={{
              xs: 12,
              lg: 4
            }}>
            <WeeklyStats isLoading={isLoading} />
          </Grid> */}
          {/* column */}
          {/* <Grid
            size={{
              xs: 12,
              lg: 8
            }}>
            <TopPerformers />
          </Grid> */}
        </Grid>

      </Box>
    </PageContainer>)
  );
}
