"use client";

import { Button } from "@mui/material";
import Tooltip from "@mui/material/Tooltip";
import InlineItemCard from "@/app/components/shared/InlineItemCard";

import PositionsTooltipCode from "@/app/components/ui-components/tooltip/code/PositionsTooltipCode";

// common component
import ChildCard from "@/app/components/shared/ChildCard";

const TooltipPosition = () => (
  <ChildCard title="Positions" codeModel={<PositionsTooltipCode />}>
    <InlineItemCard>
      <Tooltip title="Top Start" placement="top-start">
        <Button variant="outlined" color="primary">
          Top Start
        </Button>
      </Tooltip>
      <Tooltip title="Top" placement="top">
        <Button variant="outlined" color="secondary">
          Top
        </Button>
      </Tooltip>
      <Tooltip title="Top End" placement="top-end">
        <Button variant="outlined" color="warning">
          Top End
        </Button>
      </Tooltip>
      <Tooltip title="Left Start" placement="left-start">
        <Button variant="outlined" color="success">
          Left Start
        </Button>
      </Tooltip>
      <Tooltip title="Left" placement="left">
        <Button variant="outlined" color="error">
          Left
        </Button>
      </Tooltip>
      <Tooltip title="Left End" placement="left-end">
        <Button variant="outlined" color="primary">
          Left End
        </Button>
      </Tooltip>
      <Tooltip title="Right Start" placement="right-start">
        <Button variant="outlined" color="secondary">
          Right Start
        </Button>
      </Tooltip>
      <Tooltip title="Right" placement="right">
        <Button variant="outlined" color="warning">
          Right
        </Button>
      </Tooltip>
      <Tooltip title="Right End" placement="right-end">
        <Button variant="outlined" color="success">
          Right End
        </Button>
      </Tooltip>
      <Tooltip title="Bottom Start" placement="bottom-start">
        <Button variant="outlined" color="error">
          Bottom Start
        </Button>
      </Tooltip>
      <Tooltip title="Bottom" placement="bottom">
        <Button variant="outlined" color="primary">
          Bottom
        </Button>
      </Tooltip>
      <Tooltip title="Bottom End" placement="bottom-end">
        <Button variant="outlined" color="secondary">
          Bottom End
        </Button>
      </Tooltip>
    </InlineItemCard>
  </ChildCard>
);
export default TooltipPosition;
