export function withKiosk(path: string, kioskId?: string | null) {
    if (!kioskId) return path;
    // preserve query if path already has ?
    return path.includes("?")
        ? `${path}&kioskId=${encodeURIComponent(kioskId)}`
        : `${path}?kioskId=${encodeURIComponent(kioskId)}`;
}