const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const KioskLoginToken = db.define('KioskLoginToken', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    token: {
        type: DataTypes.STRING,
        allowNull: true
    },
    status: {
        type: DataTypes.STRING,
        allowNull: true
    },
    login: {
        type: DataTypes.STRING,
        allowNull: true
    },
    logout: {
        type: DataTypes.STRING,
        allowNull: true
    },
    deposit_amount: {
        type: DataTypes.STRING,
        allowNull: true
    },
    deposit_done: {
        type: DataTypes.STRING,
        allowNull: true
    },
    webhook_sent: {
        type: DataTypes.STRING,
        allowNull: true
    },
}, {
    tableName: 'kiosk_login_token',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});



module.exports = KioskLoginToken;