const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');

const Admin = db.define('Admin', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    username: {
        type: DataTypes.STRING,
        allowNull: false
    },
    email: {
        type: DataTypes.STRING,
        allowNull: false
    },
    password: {
        type: DataTypes.STRING,
        allowNull: false
    },
    phone: {
        type: DataTypes.STRING,
        allowNull: false
    },
    first: {
        type: DataTypes.STRING,
        allowNull: false
    },
    last: {
        type: DataTypes.STRING,
        allowNull: true
    },
    role: {
        type: DataTypes.STRING,
        allowNull: true
    },

    is_loggedin: {
        type: DataTypes.STRING,
        allowNull: true
    },
    ban: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    otp: {
        type: DataTypes.STRING,
        allowNull: true
    },
    reason: {
        type: DataTypes.STRING,
        allowNull: true
    },
    first_login: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: 0
    },
    pref: {
        type: DataTypes.STRING,
        allowNull: true,
        defaultValue: 'magiclink'
    },


    latest_activity: {
        type: DataTypes.STRING,
        allowNull: true
    },
    retry_count: {
        type: DataTypes.INTEGER,
        allowNull: true
    }
    ,
    user: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    creation: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    deposit: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    redeem: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    auto_redeem: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    games: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    userip: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    addnote: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    verify: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    userpaymentmethods: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
     userpayoutmethods: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    userwheel: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    usergifting: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    usermodify: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    userskipmob: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    useractivities: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    userdelete: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    usertotals: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    useremails: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    withdraw: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    ach: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    bonus: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    bonus_codes: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    raffles: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    paymentmethods: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    paymentmethodsupdate: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    payoutmethods: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    payoutmethodsupdate: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    flaggedpayments: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    avsban: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    codb: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    fraudusers: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    wheelspins: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    giftcards: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    refferals: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    blockedbins: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    uips: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    gamelinks: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    searchtxn: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    email_logs: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    allow_new_login: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    auto_pilot_deposit: {
        type: DataTypes.STRING,
        allowNull: true
    },
    auto_pilot_redeem: {
        type: DataTypes.STRING,
        allowNull: true
    },
    auto_pilot_resets: {
        type: DataTypes.STRING,
        allowNull: true
    },
    pass_resets: {
        type: DataTypes.STRING,
        allowNull: true
    },
    api_logs: {
        type: DataTypes.STRING,
        allowNull: true
    },
    webhook_ip_logs: {
        type: DataTypes.STRING,
        allowNull: true
    },
    dashboard_charts: {
        type: DataTypes.STRING,
        allowNull: true
    },
    dep_with_charts: {
        type: DataTypes.STRING,
        allowNull: true
    },
    game_charts: {
        type: DataTypes.STRING,
        allowNull: true
    },
    createcashier: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cashierban: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cashierdelete: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cashiervers: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cashiercreations: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cashierpermissions: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cashierpassword: {
        type: DataTypes.STRING,
        allowNull: true
    },
    activity_logs: {
        type: DataTypes.STRING,
        allowNull: true
    },
    bonuses: {
        type: DataTypes.STRING,
        allowNull: true
    },
    endis_bonus: {
        type: DataTypes.STRING,
        allowNull: true
    },
    bonususers: {
        type: DataTypes.STRING,
        allowNull: true
    },
    bonuscreate: {
        type: DataTypes.STRING,
        allowNull: true
    },
    bonusdashboard: {
        type: DataTypes.STRING,
        allowNull: true
    },
    reported_withdraw: {
        type: DataTypes.STRING,
        allowNull: true
    },
    reported_deposit: {
        type: DataTypes.STRING,
        allowNull: true
    },
}, {
    tableName: 'admin',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = Admin;