
const Game = require('./Game');

const KioskCreation = require('./KioskCreation');
const KioskTxns = require('./KioskTxns');
const Kiosks = require('./Kiosks');

const KioskUser = require('./KioskUser');
const KioskCashout = require('./KioskCashout');
const StackingNoteLog = require('./StackingNoteLog');
const ApiLogs = require('./ApiLogs');

KioskCreation.belongsTo(Game, { foreignKey: 'gameid' })
KioskTxns.belongsTo(Game, { foreignKey: 'gameid' })

KioskTxns.belongsTo(ApiLogs, { foreignKey: 'id', targetKey: 'txn_id' })
KioskCreation.belongsTo(ApiLogs, { foreignKey: 'id', targetKey: 'txn_id' })
KioskCashout.belongsTo(ApiLogs, { foreignKey: 'id', targetKey: 'txn_id' })
StackingNoteLog.belongsTo(ApiLogs, { foreignKey: 'id', targetKey: 'txn_id' })


KioskUser.hasMany(KioskCreation, { foreignKey: 'phone', sourceKey: 'phone' });
KioskUser.hasMany(KioskTxns, { foreignKey: 'phone', sourceKey: 'phone' });
KioskUser.hasMany(KioskCashout, { foreignKey: 'phone', sourceKey: 'phone' });
KioskUser.hasMany(StackingNoteLog, { foreignKey: 'phone', sourceKey: 'phone' });
KioskUser.hasMany(ApiLogs, { foreignKey: 'txn_id', sourceKey: 'id' });


KioskCreation.belongsTo(KioskUser, { foreignKey: 'phone', targetKey: 'phone' });
KioskTxns.belongsTo(KioskUser, { foreignKey: 'phone', targetKey: 'phone' });
KioskCashout.belongsTo(KioskUser, { foreignKey: 'phone', targetKey: 'phone' });
StackingNoteLog.belongsTo(KioskUser, { foreignKey: 'phone', targetKey: 'phone' });
ApiLogs.belongsTo(KioskUser, { foreignKey: 'txn_id', targetKey: 'id' });

KioskCashout.belongsTo(Kiosks, {
    foreignKey: 'kiosk_name',
    targetKey: 'kiosk_name',
    as: 'Kiosk'
});

Kiosks.hasMany(KioskCashout, {
    foreignKey: 'kiosk_name',
    targetKey: 'kiosk_name',
    as: 'Cashouts'
});
module.exports = {
    Game, KioskCreation, KioskTxns, KioskUser, KioskCashout, StackingNoteLog, Kiosks, ApiLogs
};