const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const StackingStats = db.define('StackingStats', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    kiosk_name: {
        type: DataTypes.STRING,
        allowNull: true
    },
    stacked_notes: {
        type: DataTypes.STRING,
        allowNull: true
    },
    total_amount: {
        type: DataTypes.INTEGER,
        allowNull: true
    },
    last_note: {
        type: DataTypes.INTEGER,
        allowNull: true
    },

}, {
    tableName: 'StackingStats',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});



module.exports = StackingStats;