const express = require('express');
const router = express.Router();
const multer = require('multer');


const rateLimit = require('express-rate-limit');
const upload = multer();

const kiosk = require('../controllers/Kiosk');

const ipLock = require('../middleware/ipLockMiddleware');
const ipLockWare = ipLock.ipLockMiddleware;

const apiLogger = require('../middleware/apiLogger');

// 🔹 Apply logger to all /kiosk routes handled by this router
router.use('/kiosk', apiLogger);

router.get('/kiosk/getUser', kiosk.getUser);

router.get('/kiosk/getAutoGameList', kiosk.getAutoGameList);
router.post('/kiosk/getAutoGameLists', kiosk.getAutoGameLists);

router.post('/kiosk/getCreationsByGame', kiosk.getCreationsByGame);

router.post('/kiosk/getPendingCreationsByGame', kiosk.getPendingCreationsByGame);
router.post('/kiosk/getDeposits', kiosk.getDeposits);
router.post('/kiosk/getRedeems', kiosk.getRedeems);
router.post('/kiosk/getCashouts', kiosk.getCashouts);
router.post('/kiosk/getUsers', kiosk.getUsers);
router.post('/kiosk/viewUser', kiosk.viewUser);

router.post('/kiosk/deposit', kiosk.deposit);
router.post('/kiosk/redeem', kiosk.redeem);
router.post('/kiosk/creation', kiosk.creation);
router.post('/kiosk/cashout', kiosk.cashout);

router.post('/kiosk/login', kiosk.login);
router.post('/kiosk/resendLoginOTP', kiosk.resendLoginOTP);

router.post('/kiosk/verifyOTP', kiosk.verifyOTP);

router.post('/kiosk/adminLogin', kiosk.adminLogin);
router.get('/kiosk/getAdmin', kiosk.getAdmin);
router.get('/kiosk/getDashboardData', kiosk.getDashboardData);
router.get('/kiosk/getKioskNotes', kiosk.getKioskNotes);
router.post('/kiosk/setKioskNotes', kiosk.setKioskNotes);
router.post('/kiosk/resetKioskNotes', kiosk.resetKioskNotes);

router.get('/kiosk/cashDepositQR', kiosk.cashDepositQR);
router.post('/kiosk/renameKiosk', kiosk.renameKiosk);

router.post('/kiosk/QRLoginResponse', kiosk.QRLoginResponse);
router.post('/kiosk/depositCash', kiosk.depositCash);
router.post('/kiosk/depositDone', kiosk.depositDone);

router.get('/kiosk/cashDepositWebhook', kiosk.cashDepositWebhook);

router.get('/kiosk/sweepLoginQR', kiosk.sweepLoginQR);
router.post('/kiosk/sweepQRLoginResponse', kiosk.sweepQRLoginResponse);
router.post('/kiosk/sweepLoginComplete', kiosk.sweepLoginComplete);
router.get('/kiosk/getF53Cassettes', kiosk.getF53Cassettes);
router.post('/kiosk/setF53Cassettes', kiosk.setF53Cassettes);

router.get('/kiosk/getKiosks', kiosk.getKiosks);
router.post('/kiosk/setKiosk', kiosk.setKiosk);

router.get('/kiosk/getTodayDeposits', kiosk.getTodayDeposits);
router.get('/kiosk/getDayWiseDeposits', kiosk.getDayWiseDeposits);

router.get('/kiosk/getTodayCashouts', kiosk.getTodayCashouts);
router.get('/kiosk/getDayWiseCashouts', kiosk.getDayWiseCashouts);

router.post('/kiosk/cashWithdraw', kiosk.cashWithdraw);

router.post('/kiosk/signup', kiosk.signup)
router.post('/kiosk/resendSignupOTP', kiosk.resendSignupOTP)

router.post('/kiosk/verifySignupOTP', kiosk.verifySignupOTP)
router.post('/kiosk/retryVerify', kiosk.retryVerify)

router.post('/kiosk/checkIdenfyToken', kiosk.checkIdenfyToken)

router.post('/kiosk/idenfyWebhook', kiosk.idenfyWebhook);

router.post('/kiosk/updateIdenfyUser', kiosk.updateIdenfyUser);
router.post('/kiosk/verifyMobiPoll', kiosk.verifyMobiPoll);

router.get('/kiosk/getKioskStatus', kiosk.getKioskStatus);

router.post('/kiosk/updateStackingStats', kiosk.updateStackingStats);
router.post('/kiosk/loadStatsFromDatabase', kiosk.loadStatsFromDatabase);
router.post('/kiosk/getStackingStats', kiosk.getStackingStats);

router.post('/kiosk/getTransactions', kiosk.getTransactions);
router.post('/kiosk/getTransactionsByUser', kiosk.getTransactionsByUser);
router.post('/kiosk/getTransaction', kiosk.getTransaction);

router.post('/kiosk/requestCreation', kiosk.requestCreation);
router.post('/kiosk/approveCreation', kiosk.approveCreation);
router.post('/kiosk/rejectCreation', kiosk.rejectCreation);

router.post('/kiosk/requestDeposit', kiosk.requestDeposit);
router.post('/kiosk/approveDeposit', kiosk.approveDeposit);
router.post('/kiosk/rejectDeposit', kiosk.rejectDeposit);

router.post('/kiosk/requestRedeem', kiosk.requestRedeem);
router.post('/kiosk/approveRedeem', kiosk.approveRedeem);
router.post('/kiosk/rejectRedeem', kiosk.rejectRedeem);
router.post('/kiosk/verifyUser', kiosk.verifyUser);

router.post('/kiosk/generateIdenfyToken', kiosk.generateIdenfyToken);


router.post('/kiosk/remakeCreation', kiosk.remakeCreation);
router.get('/kiosk/receiptQR', kiosk.receiptQR);
router.post('/kiosk/generateReceipt', kiosk.generateReceipt);
router.get('/kiosk/receipt/:id', kiosk.receipt);

const otpLoginLimiter = rateLimit({
    windowMs: 1 * 60 * 1000, // 1 minutes
    max: 5, // Limit each IP to 1 requests per windowMs
    message: 'Too many requests from this IP, please try again later.',
});
// Route to get all admins
// router.get('/admins', authController.getAllAdmins);


module.exports = router;