'use client';

const Footer = () => {
    return (
        <footer>
            <div className="bg-[#FBE3C6] py-12 px-6 md:px-16">
                <div className="grid grid-cols-1 md:grid-cols-6 gap-10 text-gray-900 max-w-7xl mx-auto">

                    {/* About Petheros */}
                    <div className="md:col-span-2">
                        <h3 className="text-xl font-bold mb-4">About Petheros</h3>
                        <p className="mb-3 leading-relaxed text-[15px]">
                            PetHeros is built with a simple vision — to create a safer, healthier, and
                            more compassionate world for stray and abandoned animals. We believe every
                            dog deserves love, care, and the chance to live a dignified life.
                        </p>
                        <p className="leading-relaxed text-[15px]">
                            Our team works tirelessly to rescue, provide medical support, food, and
                            shelter, and to find forever homes for those in need. Through programs like
                            mass sterilization and rabies vaccination, we aim to reduce suffering and
                            ensure a brighter future for our four-legged friends.
                        </p>
                    </div>

                    {/* Our Work */}
                    <div>
                        <h3 className="text-lg font-semibold mb-4">Our Work</h3>
                        <ul className="space-y-2 text-[15px]">
                            <li className="hover:underline cursor-pointer">Active Campaigns</li>
                            <li className="hover:underline cursor-pointer">Successful Campaigns</li>
                            <li className="hover:underline cursor-pointer">Our Charity Events</li>
                        </ul>
                    </div>

                    {/* Surrender A Dog */}
                    <div>
                        <h3 className="text-lg font-semibold mb-4">Surrender A Dog</h3>
                        <ul className="space-y-2 text-[15px]">
                            <li className="hover:underline cursor-pointer">Old Stray Dogs</li>
                            <li className="hover:underline cursor-pointer">Hospice</li>
                            <li className="hover:underline cursor-pointer">Cruelty Survivor Dogs</li>
                            <li className="hover:underline cursor-pointer">Blind Stray Dog</li>
                            <li className="hover:underline cursor-pointer">Terminally Ill Pet Parent Dog</li>
                            <li className="hover:underline cursor-pointer">Retired Service / Patriot Dog</li>
                            <li className="hover:underline cursor-pointer">Failed Adoption Dogs</li>
                            <li className="hover:underline cursor-pointer">Special Needs Dogs</li>
                        </ul>
                    </div>

                    {/* Get Involved */}
                    <div>
                        <h3 className="text-lg font-semibold mb-4">Get Involved</h3>
                        <ul className="space-y-2 text-[15px]">
                            <li className="hover:underline cursor-pointer">Volunteer</li>
                            <li className="hover:underline cursor-pointer">Sponsor a Meal</li>
                            <li className="hover:underline cursor-pointer">Employee Engagement</li>
                            <li className="hover:underline cursor-pointer">CSR Support</li>
                            <li className="hover:underline cursor-pointer">Leave a gift in your will</li>
                        </ul>
                    </div>

                    {/* Know More */}
                    <div>
                        <h3 className="text-lg font-semibold mb-4">Know More</h3>
                        <ul className="space-y-2 text-[15px]">
                            <li className="hover:underline cursor-pointer">Blog</li>
                            <li className="hover:underline cursor-pointer">FAQs</li>
                            <li className="hover:underline cursor-pointer">Career</li>
                        </ul>
                    </div>
                </div>
            </div>
        </footer>

    );
};

export default Footer;  