'use client';

import Link from "next/link";
import { usePathname } from "next/navigation";
import { useState } from "react";
import { Menu } from "lucide-react";
import { Button } from "@/components/ui/button";
import {
  Sheet,
  SheetTrigger,
  SheetContent,
  SheetHeader,
  SheetTitle,
} from "@/components/ui/sheet";

const navItems = [
  { name: "Home", href: "/" },
  { name: "Nearby Dogs", href: "/nearbyDogs" },
  { name: "Adoption", href: "/adoption" },
  { name: "About Us", href: "/about" },
  { name: "Objectives", href: "/objectives" },
  { name: "Gallery", href: "/gallery" },
  { name: "Contact Us", href: "/contact" },
];

export default function Header() {
  const pathname = usePathname();
  const [navOpen, setNavOpen] = useState(false);

  return (
    <header className="bg-[#FDE4C9] w-full sticky top-0 left-0 z-50">
      <nav className="max-w-[85rem] mx-auto px-6 py-4 flex items-center justify-between">
        {/* Logo */}
        <Link href="/" className="text-xl font-semibold text-gray-900 dark:text-white">
          Pet Hero
        </Link>

        {/* Desktop Nav */}
        <div className="hidden sm:flex justify-center gap-6 items-center">
          {navItems.map((item) => {
            const isActive = pathname === item.href;
            return (
              <Link
                key={item.href}
                href={item.href}
                className={`font-medium hover:text-gray-800 dark:hover:text-neutral-300 
                ${
                  isActive
                    ? "text-[#FF4B2B] font-semibold"
                    : "text-gray-600 dark:text-neutral-400"
                }`}
              >
                {item.name}
              </Link>
            );
          })}
        </div>

        {/* Mobile Menu */}
        <div className="sm:hidden">
          <Sheet open={navOpen} onOpenChange={setNavOpen}>
            <SheetTrigger asChild>
              <Button className="bg-[#FDE4C9]" variant="outline" size="icon" onClick={() => setNavOpen(true)}>
                <Menu className="h-5 w-5" />
              </Button>
            </SheetTrigger>
            <SheetContent side="left" className="px-5 w-[60%] sm:w-[40%] bg-[#FDE4C9]">
              <SheetHeader>
                <SheetTitle className="text-lg font-bold">Pet Hero</SheetTitle>
              </SheetHeader>
              <div className="mt-4 flex flex-col gap-4">
                {navItems.map((item) => {
                  const isActive = pathname === item.href;
                  return (
                    <Link
                      key={item.href}
                      href={item.href}
                      className={`font-medium hover:text-gray-800 dark:hover:text-neutral-300 
                      ${
                        isActive
                          ? "text-[#FF4B2B] font-semibold"
                          : "text-gray-600 dark:text-neutral-400"
                      }`}
                      onClick={() => setNavOpen(false)}
                    >
                      {item.name}
                    </Link>
                  );
                })}
              </div>
            </SheetContent>
          </Sheet>
        </div>
      </nav>
    </header>
  );
}
