// const User = require('../models/User')
const Admin = require('../models/Admin')
const BrDeposit = require('../models/BRTransactions');
const WheelSpin = require('../models/WheelSpin')
const Wheel = require('../models/Wheel')

const FlaggedPayments = require('../models/FlaggedPayments');
const Sharer = require('../models/Sharer');
const STPBonus2 = require('../models/STPBonus2');
const UPBonus = require('../models/UPBonus');

const Refs = require('../models/Referrals');
const bcrypt = require('bcrypt');
const crypto = require('crypto');
const jwt = require('jsonwebtoken');
const axios = require('axios');
const date = require('date-and-time')
const xss = require('xss');
const lockfile = require('proper-lockfile');
const validator = require('validator');
const { Op, QueryTypes, fn, col } = require('sequelize');
const db = require('../config/db.config')
const fs = require("fs");
const path = require('path');
const base64url = require('base64url');
const moment = require('moment-timezone');

const {
    User,
    Game,
    Transactions,
    Withdraw,
    Redeem,
    BRTransactions,
    LinkedGames,
    SavedCards,
    ActivityLog,
    Creation,
    RefCodes,
    GamePassReset,
    WheelTxn,
    Bonus
} = require('../models/Associations');
const PayoutMethods = require('../models/PayoutMethods');
const FKBonus = require('../models/FKBonus');
const VBBonus = require('../models/VBBonus');
const VXBonus = require('../models/VXBonus');
const GRBonus = require('../models/GRBonus');
const OSBonus = require('../models/OSBonus');
const GVBonus = require('../models/GVBonus');
const DGBonus = require('../models/DGBonus');
const BDBonus = require('../models/BDBonus');
const JWBonus = require('../models/JWBonus');
const OStarsBonus = require('../models/OStarsBonus');
const GDBonus = require('../models/GDBonus');
const MCBonus = require('../models/MCBonus');
const NewEmailToken = require('../models/NewEmailToken');
const VB2Bonus = require('../models/VB2Bonus');
const GSBonus = require('../models/GSBonus');
const CCBonus = require('../models/CCBonus');
const AllBonuses = require('../models/AllBonuses');
const TrexBonus = require('../models/TrexBonus');
const BMBonus = require('../models/BMBonus');
const RSBonus = require('../models/RSBonus');
const FKNewBonus = require('../models/FKNewBonus');
const createBonusModel = require('../models/dynamicBonus');
const ENC_KEY = process.env.ENC_KEY;
const JWT_SECRET = process.env.JWT_SECRET;
const CARD_ENC_KEY = process.env.CARD_ENC_KEY;

require('dotenv').config()

exports.gameLinksWeb = async (req, res) => {
    try {
        const [games] = await db.query(`
             SELECT 
        gd.*, 
        g.image 
    FROM gamedownload gd
    JOIN games g 
      ON gd.name COLLATE utf8mb4_general_ci = g.name COLLATE utf8mb4_general_ci
        `);

        res.json(games);
    } catch (error) {
        console.error('Error fetching game links:', error);
        res.status(500).json({ error: 'Failed to fetch game links' });
    }
};

//New
function generateID(length) {
    const chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
    let result = '';
    for (let i = 0; i < length; i++) {
        result += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    return result;
}
function generateRandomString(length) {
    const characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    return Array.from({ length }, () => characters[Math.floor(Math.random() * characters.length)]).join('');
}
function decrypt(encodedText, cryptKey) {
    const cipher = 'aes-256-cbc';

    const keyBuffer = Buffer.from(cryptKey, 'utf8');
    let key = keyBuffer;
    if (key.length < 32) {
        key = Buffer.concat([key, Buffer.alloc(32 - key.length)], 32);
    } else if (key.length > 32) {
        key = key.slice(0, 32);
    }
    const encryptedBuffer = Buffer.from(encodedText, 'base64');
    const ivlen = 16;
    const iv = encryptedBuffer.slice(0, ivlen);
    const hmac = encryptedBuffer.slice(ivlen, ivlen + 32);
    const ciphertext = encryptedBuffer.slice(ivlen + 32);

    const decipher = crypto.createDecipheriv(cipher, key, iv);
    let decrypted = decipher.update(ciphertext, 'binary', 'utf8');
    decrypted += decipher.final('utf8');

    const verify = crypto.createHmac('sha256', key);
    verify.update(ciphertext);
    const calculatedHmac = verify.digest();

    if (!crypto.timingSafeEqual(hmac, calculatedHmac)) {
        throw new Error('Integrity check failed.');
    }

    return decrypted;
}
function encrypt(plainText, cryptKey) {
    const cipher = 'aes-256-cbc';

    // Prepare key
    const keyBuffer = Buffer.from(cryptKey, 'utf8');
    let key = keyBuffer;
    if (key.length < 32) {
        key = Buffer.concat([key, Buffer.alloc(32 - key.length)], 32);
    } else if (key.length > 32) {
        key = key.slice(0, 32);
    }

    // Generate a random IV
    const ivlen = 16;
    const iv = crypto.randomBytes(ivlen);

    // Create cipher
    const cipherInstance = crypto.createCipheriv(cipher, key, iv);
    let encrypted = cipherInstance.update(plainText, 'utf8', 'binary');
    encrypted += cipherInstance.final('binary');
    const ciphertext = Buffer.from(encrypted, 'binary');

    // Generate HMAC for integrity verification
    const hmac = crypto.createHmac('sha256', key);
    hmac.update(ciphertext);
    const hmacDigest = hmac.digest();

    // Combine IV, HMAC, and ciphertext
    const resultBuffer = Buffer.concat([iv, hmacDigest, ciphertext]);
    return resultBuffer.toString('base64');
}
exports.decryptData = (req, res) => {
    try {
        const { data: encdata, code: decCode } = req.body; // Destructure request body
        const dec = decrypt(encdata, decCode); // Decrypt data
        res.json({ data: dec }); // Send response
    } catch (error) {
        res.status(200).json({ error: error.message }); // Handle errors
    }
};
async function verifyPassword(plainPassword, storedPHPHash) {
    const compatibleHash = storedPHPHash.replace(/^\$2y\$/, '$2b$');
    const isMatch = await bcrypt.compare(plainPassword, compatibleHash);
    return isMatch;
}
exports.login = async (req, res) => {
    try {
        const { email, password } = req.body;

        // Validate email format
        if (!validator.isEmail(email)) {
            const encdata = encrypt(JSON.stringify({ status: 'error', message: 'Invalid email format!' }), process.env.ENC_KEY);
            return res.status(200).json(encdata);
        }

        // Validate password length
        if (!password || password.length < 4) {
            const encdata = encrypt(JSON.stringify({ status: 'error', message: 'Password must be at least 4 characters long!' }), process.env.ENC_KEY);
            return res.status(200).json(encdata);

        }
        // Find the user by email
        const user = await User.findOne({ where: { email } });

        if (!user) {
            const encdata = encrypt(JSON.stringify({ status: 'error', message: 'Email does not exist!' }), process.env.ENC_KEY);
            return res.status(200).json(encdata);
        }
        const compatibleHash = user.password.replace(/^\$2y\$/, '$2b$');

        const passwordMatch = await bcrypt.compare(password, compatibleHash);
        // const encdatax = JSON.stringify({ status: 'success', data: req.body, user_password: user, passwordMatch });
        // return res.status(200).json(encdatax);
        if (!passwordMatch) {
            const encdata = encrypt(JSON.stringify({ status: 'error', message: 'Incorrect Password!' }), process.env.ENC_KEY);
            return res.status(200).json(encdata);
        }

        // Prepare the JWT data
        const jwtData = {
            id: user.id,
            first: user.first,
            last: user.last,
            email: user.email,
            phone: user.phone,
        };
        const token = jwt.sign(jwtData, process.env.JWT_SECRET, { algorithm: 'HS256' });

        // Determine the response based on user status and verification fields
        let responseData;
        if (user.status === 5 && user.verified === 1 && user.pidv === 0 && user.namev === 0) {
            responseData = { status: 'success', token, userid: user.id, user_status: '5', isEmailVerified: '1', message: 'KYC Pending', isVerified: '0' };
        } else if (user.status === 5 && user.verified === 1 && user.pidv === 1 && user.namev === 1) {
            responseData = { status: 'success', token, userid: user.id, user_status: '5', isEmailVerified: '1', message: 'KYC Pending', isVerified: '1' };
        } else if (user.status === 5 && user.verified === 2 && user.pidv === 2 && user.namev === 2) {
            responseData = { status: 'success', token, userid: user.id, user_status: '5', isEmailVerified: '1', message: 'Verification Rejected', isVerified: '2' };
        } else if (user.status === 5 && user.verified === 0) {
            responseData = { status: 'success', token, userid: user.id, user_status: '5', isEmailVerified: '0', message: 'Verification Pending' };
        } else if (user.status === 0 && user.verified === 1) {
            responseData = { status: 'success', token, userid: user.id, user_status: '0', isEmailVerified: '1', message: 'Inactive Account' };
        } else if (user.status === 2 && user.verified === 1) {
            responseData = { status: 'success', token, userid: user.id, user_status: '2', isEmailVerified: '1', message: 'Banned Account' };
        } else if (user.status === 3 && user.verified === 1) {
            responseData = { status: 'success', token, userid: user.id, user_status: '3', isEmailVerified: '1', message: 'PhotoID Rejected' };
        } else if (user.status === 4 && user.verified === 1) {
            responseData = { status: 'success', token, userid: user.id, user_status: '4', isEmailVerified: '1', message: 'Selfie Rejected' };
        } else {
            const userData = user.get({ plain: true });
            // Delete sensitive data
            delete userData.password; // Ensure password is removed
            userData.walbalance = userData.rebalance; // Add walbalance
            delete userData.pidv;
            delete userData.namev;
            delete userData.verified;
            delete userData.rebalance;
            responseData = {
                status: 'success',
                user_status: `${user.status}`,
                everified: `${user.isEmailVerified}`,
                userid: user.id,
                token,
                data: userData,
            };
            // delete responseData.data.rebalance;
            // delete responseData.data.password;
        }

        const encdata = encrypt(JSON.stringify(responseData), process.env.ENC_KEY);
        return res.json(encdata);

    } catch (error) {
        console.error(error);
        const encdata = encrypt(JSON.stringify({ status: 'error', message: 'Something went wrong!' }), process.env.ENC_KEY);
        return res.status(200).json(encdata);
    }
};
exports.register = async (req, res) => {
    const { first, last, country, password, email, phone, referral, site } = req.body;

    const sanitizedFirst = first ? first.replace(/[\W]/g, '') : '';
    const sanitizedLast = last ? last.replace(/[\W]/g, '') : '';
    const sanitizedEmail = email ? email.trim().toLowerCase() : '';
    const sanitizedPhone = phone ? String(phone).replace(/[^\d]/g, '') : '';

    const lockFilePath = path.join('/', `register_wallet_${sanitizedEmail}.lock`);
    let releaseLock;

    try {
        // Ensure lock file exists
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });

        // Acquire lock
        releaseLock = await lockfile.lock(lockFilePath);

        if (!sanitizedFirst || !sanitizedLast || !password || !sanitizedEmail || !sanitizedPhone) {
            const encdata = encrypt(JSON.stringify({ status: 'error', message: 'Missing required fields' }), process.env.ENC_KEY);
            return res.status(200).json(encdata);
        }

        const hashedPassword = await bcrypt.hash(password, 10);

        // Check for duplicate email or phone
        const existingEmail = await User.findOne({ where: { email: sanitizedEmail } });
        const existingPhone = await User.findOne({ where: { phone: sanitizedPhone } });

        if (existingEmail && existingPhone) {
            const encdata = encrypt(JSON.stringify({ status: 'error', message: 'Email and Phone no already exists' }), process.env.ENC_KEY);
            return res.status(200).json(encdata);
        }

        if (existingEmail) {
            const encdata = encrypt(JSON.stringify({ status: 'error', message: 'Email already exists' }), process.env.ENC_KEY);
            return res.status(200).json(encdata);
        }

        if (existingPhone) {
            const encdata = encrypt(JSON.stringify({ status: 'error', message: 'Phone number already exists' }), process.env.ENC_KEY);
            return res.status(200).json(encdata);
        }

        // Create user
        const vid = generateID(8);
        const vcode = Math.floor(10000000 + Math.random() * 90000000);
        const newUser = await User.create({
            first: sanitizedFirst,
            last: sanitizedLast,
            country,
            password: hashedPassword,
            email: sanitizedEmail,
            phone: sanitizedPhone,
            vid,
            vcode,
            status: '5',
        });

        // Handle referral
        if (referral) {
            const refData = await Refs.findOne({ where: { refcode: referral } });
            if (refData) {
                await Refs.create({ userid: newUser.id, refcode: referral });
            }
        }

        // Send verification email (simplified for this example)
        // console.log(`Verification code sent to ${sanitizedEmail}: ${vcode}`);
        const payload = {
            subject: 'Verification successful!',
            email: email,
            name: `${first} ${last}`,
            mail: `<!DOCTYPE html>
                                <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                
                                <head>
                                  <meta charset='utf-8'>
                                  <meta name='x-apple-disable-message-reformatting'>
                                  <meta name='viewport' content='width=device-width, initial-scale=1'>
                                  <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                  <title>Please confirm your email address</title>
                                  <style>
                                    .hover-bg-brand-600:hover {
                                      background-color: #0047C3 !important;
                                    }
                                
                                    .hover-text-brand-700:hover {
                                      color: #003CA5 !important;
                                    }
                                
                                    .hover-text-decoration-underline:hover {
                                      text-decoration: underline !important;
                                    }
                                @media(max-width:640px){
                                  .btn-class{
                                    width:100% !important;
                                    
                                  }
                                }
                                    @media (max-width: 768px) {
                                      .sm-mt-4 {
                                        margin-top: 16px !important;
                                      }
                                
                                      .sm-block {
                                        display: block !important;
                                      }
                                
                                      .sm-w-full {
                                        width: 100% !important;
                                      }
                                      .btn-class{
                                        width:40% !important;
                                        margin: 0 auto;
                                      }
                                      .sm-px-4 {
                                        padding-left: 16px !important;
                                        padding-right: 16px !important;
                                      }
                                
                                      .sm-py-6 {
                                        padding-top: 24px !important;
                                        padding-bottom: 24px !important;
                                      }
                                    }
                                  </style>
                                </head>
                                
                                <body
                                  style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                  <div style='display: none'>
                                    Please confirm your email address
                                
                                  </div>
                                  <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                    <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                      cellpadding='0' cellspacing='0' role='none'>
                                      <tr>
                                        <td align='center' style='background-color: #fff;'>
                                          <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                            <tr>
                                              <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                <div style='margin-bottom: 24px'>
                                                  <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                    <p>SweepStake Mobi</p>
                                                  </a>
                                                </div>
                                                <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                  Hi <b>${first}</b>,
                                                </p>
                                                <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                Your account verification code is<br><br> <b>${vcode}</b>
                                                </p>
                                                <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                  In order to start using your account, you need to confirm your email.
                                                </p>
                                                <br>
                                                <div role='separator' style='line-height: 16px'>&zwj;</div>
                                                <div class='btn-class'>
                                                <a href='${site}/verify'
                                                  class='sm-block hover-bg-brand-600'
                                                  style='text-decoration: none; display: inline-block; border-radius: 4px; background-color: #0052E2; padding: 16px 32px; text-align: center; font-size: 16px; line-height: 16px; font-weight: 700; color: #fff; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06)'>
                                                  <!--[if mso]><i style='letter-spacing: 32px; mso-font-width: -100%; mso-text-raise:30px;'>&#8202;</i><![endif]-->
                                                  <span style='mso-text-raise: 16px'>Confirm your email address</span>
                                                  <!--[if mso]><i style='letter-spacing: 32px; mso-font-width: -100%;'>&#8202;</i><![endif]-->
                                                </a>
                                                </div>
                                                <br><br>
                                                <div role='separator' style='line-height: 16px'>&zwj;</div>
                                                
                                                <div style='text-align: center;'>
                                                  <div role='separator'
                                                    style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                  <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                    This email was sent to you as a registered member of
                                                    <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                      style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                      class='sm-block sm-mt-4'>
                                                      Use of the service and website is subject to our
                                                      <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                        style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                      and
                                                      <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                        style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                    </span>
                                                  </p>
                                                  <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                    rights reserved.</p>
                                                </div>
                                              </td>
                                            </tr>
                                          </table>
                                        </td>
                                      </tr>
                                    </table>
                                  </div>
                                </body>
                                
                                </html>`
        };

        //Mail
        await axios.post('https://bend.logiclane.tech/api/email', payload, {
            headers: {
                'Content-Type': 'application/json',
                'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
            }
        });

        // Generate JWT
        const token = jwt.sign(
            { id: newUser.id, email: sanitizedEmail, vid },
            process.env.JWT_SECRET,
            { expiresIn: '1h' }
        );
        const encdata = encrypt(JSON.stringify({
            status: 'success',
            userid: newUser.id,
            firstName: newUser.first,
            lastName: newUser.last,
            token,
            vid,
            message: 'User created successfully'
        }), process.env.ENC_KEY);
        return res.status(201).json(encdata);
    } catch (error) {
        console.error(error);
        const encdata = encrypt(JSON.stringify({ status: 'error', message: 'Server error', details: error.message }), process.env.ENC_KEY);
        return res.status(200).json(encdata);
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}
exports.resendSignupEmail = async (req, res) => {
    const { userid } = req.body;

    if (!userid) {
        const encData = encrypt(JSON.stringify({ status: 'error', message: 'User ID is required' }), ENC_KEY);
        return res.status(200).json(encData);
    }

    try {
        // Fetch the user from the database
        const user = await User.findOne({ where: { id: userid } });

        if (!user) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'User not found' }), ENC_KEY);
            return res.status(200).json(encData);
        }

        // Generate verification code if not already set
        const vcode = user.vcode || generateVerificationCode();
        if (!user.vcode) {
            // Here you would update the user record in your database with the new verification code
            await user.update({ vcode });
        }

        // Prepare the email payload
        const emailPayload = {
            subject: 'Verify your account!',
            email: user.email,
            name: `${user.first} ${user.last}`,
            mail: `
          <!DOCTYPE html>
                                <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                
                                <head>
                                  <meta charset='utf-8'>
                                  <meta name='x-apple-disable-message-reformatting'>
                                  <meta name='viewport' content='width=device-width, initial-scale=1'>
                                  <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                  <title>Please confirm your email address</title>
                                  <style>
                                    .hover-bg-brand-600:hover {
                                      background-color: #0047C3 !important;
                                    }
                                
                                    .hover-text-brand-700:hover {
                                      color: #003CA5 !important;
                                    }
                                
                                    .hover-text-decoration-underline:hover {
                                      text-decoration: underline !important;
                                    }
                                @media(max-width:640px){
                                  .btn-class{
                                    width:100% !important;
                                    
                                  }
                                }
                                    @media (max-width: 768px) {
                                      .sm-mt-4 {
                                        margin-top: 16px !important;
                                      }
                                
                                      .sm-block {
                                        display: block !important;
                                      }
                                
                                      .sm-w-full {
                                        width: 100% !important;
                                      }
                                      .btn-class{
                                        width:40% !important;
                                        margin: 0 auto;
                                      }
                                      .sm-px-4 {
                                        padding-left: 16px !important;
                                        padding-right: 16px !important;
                                      }
                                
                                      .sm-py-6 {
                                        padding-top: 24px !important;
                                        padding-bottom: 24px !important;
                                      }
                                    }
                                  </style>
                                </head>
                                
                                <body
                                  style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                  <div style='display: none'>
                                    Please confirm your email address
                                
                                  </div>
                                  <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                    <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                      cellpadding='0' cellspacing='0' role='none'>
                                      <tr>
                                        <td align='center' style='background-color: #fff;'>
                                          <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                            <tr>
                                              <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                <div style='margin-bottom: 24px'>
                                                  <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                    <p>SweepStake Mobi</p>
                                                  </a>
                                                </div>
                                                <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                  Hi <b>${user.first}</b>,
                                                </p>
                                                <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                Your account verification code is<br><br> <b>${vcode}</b>
                                                </p>
                                                <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                  In order to start using your account, you need to confirm your email.
                                                </p>
                                                
                                                <br><br>
                                                <div role='separator' style='line-height: 16px'>&zwj;</div>
                                                
                                                <div style='text-align: center;'>
                                                  <div role='separator'
                                                    style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                  <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                    This email was sent to you as a registered member of
                                                    <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                      style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                      class='sm-block sm-mt-4'>
                                                      Use of the service and website is subject to our
                                                      <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                        style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                      and
                                                      <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                        style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                    </span>
                                                  </p>
                                                  <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                    rights reserved.</p>
                                                </div>
                                              </td>
                                            </tr>
                                          </table>
                                        </td>
                                      </tr>
                                    </table>
                                  </div>
                                </body>
                                
                                </html>
        `,
        };

        // Send the email using axios
        // const response = await axios.post('https://bend.logiclane.tech/api/email', emailPayload, {
        //     headers: {
        //         'Content-Type': 'application/json',
        //         Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
        //     },
        // });

        const encData = encrypt(JSON.stringify({
            status: 'success',
            message: 'Verification email sent successfully!',
        }), ENC_KEY);

        return res.status(200).json(encData);

    } catch (error) {
        console.error('Error occurred:', error);
        const encData = encrypt(JSON.stringify({
            status: 'error',
            message: 'An error occurred while sending the email',
        }), ENC_KEY);
        return res.status(200).json(encData);
    }
}
exports.checkPhoneEmail = async (req, res) => {
    const { email, phone } = req.body;

    try {
        if (!email || !phone) {
            const encryptedResponse = encrypt(JSON.stringify({ status: 'error', message: 'Email and Phone are required' }), ENC_KEY);
            return res.status(200).json(encryptedResponse);
        }
        // Query database for email and phone
        const emailExists = await User.findOne({ where: { email }, attributes: ['id', 'email'] });
        const phoneExists = await User.findOne({ where: { phone }, attributes: ['id', 'phone'] });

        let responseMessage;
        if (emailExists && phoneExists) {
            responseMessage = { status: 'error', message: 'Email & Phone No. already exists!' };
        } else if (emailExists) {
            responseMessage = { status: 'error', message: 'Email already exists!' };
        } else if (phoneExists) {
            responseMessage = { status: 'error', message: 'Phone No. already exists!' };
        } else {
            responseMessage = { status: 'success', message: 'Both email and phone are available' };
        }

        const encryptedResponse = encrypt(JSON.stringify(responseMessage), ENC_KEY);
        return res.status(200).json(encryptedResponse);

    } catch (error) {
        console.error('Error in checkPhoneEmail:', error);
        return res.status(200).json({ status: 'error', message: 'Server error' });
    }
}
exports.checkEmail = async (req, res) => {
    const { email } = req.body;

    if (email) {
        try {
            const emailExists = await User.findOne({ where: { email } });

            let responseData;
            if (emailExists) {
                responseData = {
                    status: 'error',
                    message: 'Email already exists!',
                };
            } else {
                responseData = {
                    status: 'success',
                    message: 'Email available!',
                };
            }

            const encdata = JSON.stringify(responseData);
            const encryptedData = encrypt(encdata, ENC_KEY);

            return res.json({ data: encryptedData });

        } catch (error) {
            // Handle error if any
            const encdata = JSON.stringify({
                status: 'error',
                message: 'An error occurred while checking the email.',
            });
            const encryptedData = encrypt(encdata, ENC_KEY);
            return res.json({ data: encryptedData });
        }
    } else {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Email not provided!',
        });
        const encryptedData = encrypt(encdata, ENC_KEY);
        return res.json({ data: encryptedData });
    }
};
exports.getUser = async (req, res) => {
    // console.log(req.params)
    const { id: user_id } = req.params;

    if (!user_id) {
        const encData = encrypt(JSON.stringify({ status: 'error', message: 'User ID is missing' }), ENC_KEY);
        return res.status(200).json(encData);
    }
    try {

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'Authorization header is missing' }), ENC_KEY);
            return res.status(200).json(encData);
        }

        const token = authHeader.split(' ')[1];
        if (!token) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'Token is missing' }), ENC_KEY);
            return res.status(200).json(encData);
        }

        const decoded = jwt.verify(token, JWT_SECRET);
        const userId = decoded.id;

        if (user_id != userId) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'Invalid token provided!' }), ENC_KEY);
            return res.status(200).json(encData);
        }

        const user = await User.findOne({ where: { id: user_id } });
        if (user) {
            const userData = user.toJSON();
            delete userData.password;
            userData.walbalance = userData.rebalance;
            delete userData.rebalance;

            const encData = encrypt(JSON.stringify({ status: 'success', data: userData }), ENC_KEY);
            return res.status(200).json({ status: 'success', data: encData });
        } else {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'User not found!' }), ENC_KEY);
            return res.status(200).json({ status: 'error', data: encData });
        }
    } catch (error) {
        console.error('Error in getUser:', error);

        const encData = encrypt(JSON.stringify({ status: 'error', message: 'Server error!' }), ENC_KEY);
        return res.status(200).json({ status: 'error', data: encData });
    }
}
exports.verifyUser = async (req, res) => {
    const { userid, vcode, vcode2 = '' } = req.body;

    // Sanitize input
    const sanitizedUserId = parseInt(userid, 10);
    const sanitizedVcode = parseInt(vcode, 10);
    const sanitizedVcode2 = parseInt(vcode2, 10);

    if (!sanitizedUserId || !sanitizedVcode) {
        const encData = encrypt(JSON.stringify({ status: 'error', message: 'Invalid input' }), ENC_KEY);
        return res.status(200).json(encData);
    }

    // Lock file setup
    const lockFilePath = path.join('/', `verify_user_lock_${sanitizedUserId}.lock`);
    let releaseLock;

    try {
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });

        // Acquire lock
        releaseLock = await lockfile.lock(lockFilePath);

        // Fetch user by ID
        const user = await User.findOne({ where: { id: sanitizedUserId } });

        if (!user) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'User not found' }), ENC_KEY);
            return res.status(200).json(encData);
        }
        // console.log(user,sanitizedVcode)
        // Verify codes
        if (user.vcode === sanitizedVcode.toString()) {
            // Update user verification status
            user.verified = 1;
            user.isEmailVerified = 1;
            user.vcode = '';
            await user.save();

            // Send verification email
            const payload = {
                subject: 'Verification successful!',
                email: user.email,
                name: `${user.first} ${user.last}`,
                mail: `<!DOCTYPE html>
                                                          <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                                          
                                                          <head>
                                                            <meta charset='utf-8'>
                                                            <meta name='x-apple-disable-message-reformatting'>
                                                            <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                            <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                            <title>Please confirm your email address</title>
                                                            <style>
                                                              .hover-bg-brand-600:hover {
                                                                background-color: #0047C3 !important;
                                                              }
                                                          
                                                              .hover-text-brand-700:hover {
                                                                color: #003CA5 !important;
                                                              }
                                                          
                                                              .hover-text-decoration-underline:hover {
                                                                text-decoration: underline !important;
                                                              }
                                                          
                                                              @media (max-width: 640px) {
                                                                .sm-mt-4 {
                                                                  margin-top: 16px !important;
                                                                }
                                                          
                                                                .sm-block {
                                                                  display: block !important;
                                                                }
                                                          
                                                                .sm-w-full {
                                                                  width: 100% !important;
                                                                }
                                                          
                                                                .sm-px-4 {
                                                                  padding-left: 16px !important;
                                                                  padding-right: 16px !important;
                                                                }
                                                          
                                                                .sm-py-6 {
                                                                  padding-top: 24px !important;
                                                                  padding-bottom: 24px !important;
                                                                }
                                                              }
                                                            </style>
                                                          </head>
                                                          
                                                          <body
                                                            style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                            <div style='display: none'>
                                                              Please confirm your email address
                                                          
                                                            </div>
                                                            <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                              <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                                cellpadding='0' cellspacing='0' role='none'>
                                                                <tr>
                                                                  <td align='center' style='background-color: #fff;'>
                                                                    <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                                      <tr>
                                                                        <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                          <div style='margin-bottom: 24px'>
                                                                            <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                              <p>SweepStake Mobi</p>
                                                                            </a>
                                                                          </div>
                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                            Hi <b>${user.first}</b>,
                                                                          </p>
                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                          Thank you for registering on SweepStake Mobi!
                                                                          </p>
                                                                          <br>
                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                          Your email id has been verified!
                                                                          </p>
                                                                          <br>
                                                                          <br>
                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                          Thank you for choosing SweepStake Mobi!
                                                                          </p>
                                                                          <div role='separator' style='line-height: 16px'>&zwj;</div> 
                                                                                                                         
                                                                          <div style='text-align: center;'>
                                                                            <div role='separator'
                                                                              style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                            <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                              This email was sent to you as a registered member of
                                                                              <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                                class='sm-block sm-mt-4'>
                                                                                Use of the service and website is subject to our
                                                                                <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                  style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                                and
                                                                                <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                  style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                              </span>
                                                                            </p>
                                                                            <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                              rights reserved.</p>
                                                                          </div>
                                                                        </td>
                                                                      </tr>
                                                                    </table>
                                                                  </td>
                                                                </tr>
                                                              </table>
                                                            </div>
                                                          </body>
                                                          
                                                          </html>`
            };

            await axios.post('https://bend.logiclane.tech/api/email', payload, {
                headers: {
                    'Content-Type': 'application/json',
                    'Authorization': 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61'
                }
            });

            const encData = encrypt(JSON.stringify({ status: 'success', message: 'Email verification successful!' }), ENC_KEY);
            return res.status(200).json(encData);
        } else {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'Invalid Verification Code!' }), ENC_KEY);
            return res.status(200).json({ status: 'error', data: encData });
        }
    } catch (error) {
        console.error(error);
        const encData = encrypt(JSON.stringify({ status: 'error', message: 'An error occurred during verification.' }), ENC_KEY);
        return res.status(200).json({ status: 'error', data: encData });
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}

exports.generateIdenfyToken = async (req, res) => {
    const { userid, first, last, site, country } = req.body;
    if (!userid || !first || !last || !site || !country) {
        const encData = encrypt(JSON.stringify({ status: 'error', message: 'Invalid input' }), ENC_KEY);
        return res.status(200).json(encData);
    }
    try {
        const iToken = {
            clientId: userid,
            firstName: first,
            lastName: last,
            country: country,
            successUrl: site + "/authentication/pendingVerification/",
            errorUrl: site + "/authentication/pendingVerification/",
            unverifiedUrl: site + "/authentication/pendingVerification/"
        };
        console.log("iDenfy Token Request", iToken);
        const response = await axios.post(
            "https://ivs.idenfy.com/api/v2/token",
            iToken, {
            auth: {
                // username: "MqQuxwqdY4r",
                // password: "LOjIiF3apWISOWB4UGDW"
                username: "zRf88d0uCAk",
                password: "2IK73MlssycZlXhkKb10"
            }
        });

        if (response?.data) {
            console.log("iDenfy Token Response", response.data);
            const user = await User.findOne({ where: { id: userid } });
            if (!user) {
                const encData = encrypt(JSON.stringify({ status: 'error', message: 'User not found' }), ENC_KEY);
                return res.status(200).json(encData);
            }
            // console.log('iDenfy Token', response?.data)
            if (user.isVerified != '1') {
                user.autoverauth = response?.data?.authToken;
                user.autoverref = response?.data?.scanRef;
                user.status = '1';
                user.autoverify = '1';
                user.vid = '';
                user.vcode = '';
                user.vcode2 = '';
                await user.save();
                const data = {
                    authToken: response?.data?.authToken,
                    scanRef: response?.data?.scanRef,
                    authUrl: `https://ivs.idenfy.com/api/v2/redirect?authToken=${response?.data?.authToken}`
                }
                const encData = encrypt(JSON.stringify({ status: 'success', idenfyData: data }), ENC_KEY);
                return res.status(200).json({ status: 'success', data: encData });
            } else {
                const encData = encrypt(JSON.stringify({ status: 'error', message: 'User already verified' }), ENC_KEY);
                return res.status(200).json(encData);
            }
        } else {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'Unable to generate iDenfy token' }), ENC_KEY);
            return res.status(200).json(encData);
        }
    } catch (error) {
        const encData = encrypt(JSON.stringify({ status: 'error', message: 'Unable to generate iDenfy token' }), ENC_KEY);
        return res.status(200).json(encData);
    }
}
exports.checkIdenfyToken = async (req, res) => {
    const { scanRef } = req.body;
    if (!scanRef) {
        const encData = encrypt(JSON.stringify({ status: 'error', message: 'Invalid input' }), ENC_KEY);
        return res.status(200).json(encData);
    }
    const iToken = {
        scanRef
    };
    try {
        console.log("iToken", iToken);
        const response = await axios.post(
            "https://ivs.idenfy.com/api/v2/status",
            iToken, {
            auth: {
                // username: "MqQuxwqdY4r",
                // password: "LOjIiF3apWISOWB4UGDW"
                username: "zRf88d0uCAk",
                password: "2IK73MlssycZlXhkKb10"
            }
        });
        if (response?.data) {
            const encData = encrypt(JSON.stringify({ status: 'success', idenfyData: response?.data }), ENC_KEY);
            return res.status(200).json({ status: 'success', data: encData });
        } else {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'Unable to check iDenfy token' }), ENC_KEY);
            return res.status(200).json(encData);
        }
    } catch (error) {
        const encData = encrypt(JSON.stringify({ status: 'error', message: 'Unable to check iDenfy token' }), ENC_KEY);
        return res.status(200).json(encData);
    }
}

function pnm_signature(secretKey, params) {
    const requiredParams = ["version", "site_identifier", "timestamp"];
    const exemptParams = ["format", "signature", "call", "secret_key"];

    const missingParams = requiredParams.filter(p => !(p in params));
    if (missingParams.length > 0) {
        throw new Error(`Missing required parameter(s): ${missingParams.join(', ')}`);
    }

    // Sort params by key
    const sortedKeys = Object.keys(params).sort();

    // Build string to sign, excluding exempted params
    let stringToSign = '';
    for (const key of sortedKeys) {
        if (exemptParams.includes(key)) continue;
        stringToSign += key + params[key];
    }

    // Generate HMAC SHA-256 signature
    return crypto.createHmac('sha256', secretKey).update(stringToSign).digest('hex');
}
exports.createPnmPaymentMethod = async (req, res) => {
    const data = req.data;
    const siteIdentifier = 'S1305824156';
    const version = '3.0';
    const secretKey = '4ebaffb3f0a3481d4616fa9f5';
    const url = 'https://api.paynearme-sandbox.com/json-api/create_payment_method';
    const timestamp = Math.floor(Date.now() / 1000).toString();
    const user = await findByPk(data.userid)

    if (data.type === 'ach') {
        const {
            accountHolder,
            accountNumber,
            routingNumber,
            pnm_order_identifier,
            zipcode,
            addr1
        } = data.datax;

        const params = {
            pnm_order_identifier,
            payment_method_type: 'ach',
            payment_method_billing_name: accountHolder,
            payment_method_billing_zipcode: zipcode,
            payment_method_ach_account_pii: accountNumber,
            payment_method_ach_aba_pii: routingNumber,
            site_identifier: siteIdentifier,
            version,
            timestamp
        };

        const signature = pnm_signature(secretKey, params);
        const requestData = { ...params, signature };

        const response = await axios.post(url, requestData);
        const resx = response.data;

        if (resx.status === 'ok') {
            const paymentMethods = resx.order?.electronic_payments?.payment_methods || [];
            for (const method of paymentMethods) {
                if (method.type === 'ach_push') {
                    const paymentMethodId = method.accounts?.[0]?.payment_method_identifier;
                    if (paymentMethodId) {
                        user.pnm_ach_id = paymentMethodId;
                        await user.save(); // assuming `user` is a Sequelize or Mongoose model
                    }
                }
            }
        }

        return resx;

    } else if (data.type === 'savecard') {
        const {
            card,
            cardholderName,
            cvv,
            expiry,
            pnm_order_identifier,
            zipcode,
            addr1,
            card_id
        } = data.datax;

        const cardRecord = await SavedCards.findOne({ where: { id: card_id } });

        let hdata = {};
        let paymentMethodId = cardRecord?.pnm_method_id;

        if (!paymentMethodId) {
            const params = {
                pnm_order_identifier,
                payment_method_type: 'card',
                payment_method_billing_name: cardholderName,
                payment_method_billing_zipcode: zipcode,
                payment_method_card_number_pii: card,
                payment_method_card_expiry_pii: expiry,
                payment_method_cvv_pii: cvv,
                payment_method_billing_address: addr1,
                payment_method_billing_phone: '7135555555',
                site_identifier: siteIdentifier,
                version,
                timestamp
            };

            const signature = pnm_signature(secretKey, params);
            const requestData = { ...params, signature };

            const response = await axios.post(url, requestData);
            hdata = response.data;

            if (hdata.status === 'ok') {
                const paymentMethods = hdata.order?.electronic_payments?.payment_methods || [];
                for (const method of paymentMethods) {
                    if (method.type === 'debit') {
                        paymentMethodId = method.accounts?.[0]?.payment_method_identifier;
                        if (paymentMethodId) {
                            cardRecord.pnm_method_id = paymentMethodId
                            await cardRecord.save()
                            // await capsule('saved_cards').where({ id: card_id }).update({ pnm_method_id: paymentMethodId });
                        }
                    }
                }
            }
        }

        return res.json({
            status: 'success',
            pnm_method_id: paymentMethodId || cardRecord?.pnm_method_id || null
        });
    }

    // throw new Error('Unsupported type');
}
async function createPnmPaymentMethod(data) {
    console.log(data)
    const siteIdentifier = 'S1305824156';
    const version = '3.0';
    const secretKey = '4ebaffb3f0a3481d4616fa9f5';
    const url = 'https://api.paynearme-sandbox.com/json-api/create_payment_method';
    const timestamp = Math.floor(Date.now() / 1000).toString();
    const user = await User.findByPk(data.userid)
    const datax = data.datax;
    if (datax.type === 'ach') {
        const {
            accountHolder,
            accountNumber,
            routingNumber,
            pnm_order_identifier,
            zipcode,
            addr1
        } = datax;

        const params = {
            pnm_order_identifier,
            payment_method_type: 'ach',
            payment_method_billing_name: accountHolder,
            payment_method_billing_zipcode: zipcode,
            payment_method_ach_account_pii: accountNumber,
            payment_method_ach_aba_pii: routingNumber,
            site_identifier: siteIdentifier,
            version,
            timestamp
        };

        const signature = pnm_signature(secretKey, params);
        const requestData = { ...params, signature };

        const response = await axios.post(url, requestData);
        const resx = response.data;
        console.log(resx);
        if (resx.status === 'ok') {
            const paymentMethods = resx.order?.electronic_payments?.payment_methods || [];
            for (const method of paymentMethods) {
                if (method.type === 'ach_push') {
                    const paymentMethodId = method.accounts?.[0]?.payment_method_identifier;
                    if (paymentMethodId) {
                        user.pnm_ach_id = paymentMethodId;
                        await user.save(); // assuming `user` is a Sequelize or Mongoose model
                    }
                }
            }
        }

        return resx;

    } else if (datax.type === 'savecard') {
        const {
            card,
            cardholderName,
            cvv,
            expiry,
            pnm_order_identifier,
            zipcode,
            addr1,
            card_id
        } = datax;

        const cardRecord = await SavedCards.findOne({ where: { id: card_id } });

        let hdata = {};
        let paymentMethodId = cardRecord?.pnm_method_id;

        if (!paymentMethodId) {
            const params = {
                pnm_order_identifier,
                payment_method_type: 'card',
                payment_method_billing_name: cardholderName,
                payment_method_billing_zipcode: zipcode,
                payment_method_card_number_pii: card,
                payment_method_card_expiry_pii: expiry,
                payment_method_cvv_pii: cvv,
                payment_method_billing_address: addr1,
                payment_method_billing_phone: '7135555555',
                site_identifier: siteIdentifier,
                version,
                timestamp
            };

            const signature = pnm_signature(secretKey, params);
            const requestData = { ...params, signature };

            const response = await axios.post(url, requestData);
            hdata = response.data;
            console.log(hdata);

            if (hdata.status === 'ok') {
                const paymentMethods = hdata.order?.electronic_payments?.payment_methods || [];
                for (const method of paymentMethods) {
                    if (method.type === 'debit') {
                        paymentMethodId = method.accounts?.[0]?.payment_method_identifier;
                        if (paymentMethodId) {
                            cardRecord.pnm_method_id = paymentMethodId
                            await cardRecord.save()
                            // await capsule('saved_cards').where({ id: card_id }).update({ pnm_method_id: paymentMethodId });
                        }
                    }
                }
            }
        }

        return {
            status: 'success',
            pnm_method_id: paymentMethodId || cardRecord?.pnm_method_id || null
        };
    }

    // throw new Error('Unsupported type');
}
exports.updateBankDetailsAndPushOrder = async (req, res) => {
    const data = req.body;
    const {
        yob = '',
        street = '',
        city = '',
        state = '',
        zip = '',
        country = ''
    } = req.body;
    const user = await User.findByPk(data.userid);
    if (!user) {
        return res.status(404).json({ status: 'error', message: 'User not found' });
    }
    console.log(user.pnm_order_id, user.pnm_push_order_id)
    const ac_no = data.account_number;
    const rt_no = data.routing_number;
    if (user.account_number && user.pnm_ach_id) {
        return res.json({ status: 'error', message: 'Bank account already exists' })
    }
    // if (!user.account_number) {
    await user.update({
        account_number: ac_no,
        routing_number: rt_no
    });
    // }

    const timestamp = Math.floor(Date.now() / 1000).toString(); // Unix timestamp
    let pnm_push_order_id = user.pnm_push_order_id;

    // Step 1: Create Order if not exists
    if (!user.pnm_order_id) {
        const orderPayload = {
            order_currency: 'USD',
            order_type: 'any',
            order_is_standing: 'true',
            site_customer_identifier: user.id,
            site_identifier: 'S1305824156',
            version: '3.0',
            site_customer_first_name: user.first,
            site_customer_last_name: user.last,
            site_customer_year_of_birth: yob,
            site_customer_email: user.email,
            site_customer_phone: user.phone,
            site_customer_street: street,
            site_customer_city: city,
            site_customer_state: state,
            site_customer_postal_code: zip,
            timestamp
        };

        const orderSignature = pnm_signature('4ebaffb3f0a3481d4616fa9f5', orderPayload);

        const createOrder = await axios.post('https://api.paynearme-sandbox.com/json-api/create_order', {
            ...orderPayload,
            signature: orderSignature
        });

        user.pnm_order_id = createOrder.data?.order?.pnm_order_identifier;
        await user.save();
    }

    // Step 2: Create Push Order if not exists
    if (!user.pnm_push_order_id && user.pnm_order_id) {
        const pushPayload = {
            order_currency: 'USD',
            order_type: 'any',
            order_is_standing: 'true',
            site_identifier: 'S1305824156',
            version: '3.0',
            push_user_identifier: user.id,
            site_customer_identifier: user.id,
            push_city: city,
            push_country: country,
            push_first_name: user.first,
            push_last_name: user.last,
            push_postal_code: zip,
            push_street: street,
            push_year_of_birth: yob,
            site_customer_email: user.email,
            site_customer_phone: user.phone,
            timestamp
        };

        const pushSignature = pnm_signature('4ebaffb3f0a3481d4616fa9f5', pushPayload);

        const createPushOrder = await axios.post('https://api.paynearme-sandbox.com/json-api/create_push_order', {
            ...pushPayload,
            signature: pushSignature
        });

        pnm_push_order_id = createPushOrder.data?.order?.pnm_order_identifier;
        user.pnm_push_order_id = pnm_push_order_id;
        await user.save();
    }

    // Step 3: Create PNM Payment Method
    const pnmMethod = {
        userid: user.id,
        datax: {
            type: 'ach',
            accountHolder: `${user.first} ${user.last}`,
            accountNumber: ac_no,
            routingNumber: rt_no,
            pnm_order_identifier: pnm_push_order_id,
            site_identifier: 'S1305824156',
            zipcode: zip,
            addr1: street
        }
    };
    const create = await createPnmPaymentMethod(pnmMethod);
    // await axios.post('https://nodewall.logiclane.tech/api/createPnmPaymentMethod', pnmMethod, {
    //     headers: {
    //         'Content-Type': 'application/json'
    //     }
    // });
    if (create) {
        const encdata = JSON.stringify({ status: 'success', message: 'Bank Details Updated!' });
        const enc = encrypt(encdata, ENC_KEY);
        return res.status(200).json(enc);
    }
};

exports.updateUser = async (req, res) => {
    const { lastName, userid, pidtype, pidno, photoid, selfie, status, verify, profilephoto, paypal, venmo, account_number, routing_number, authtoken, scanref } = req.body;

    if (!userid) {
        const encData = encrypt(JSON.stringify({ status: 'error', message: 'User ID is required' }), ENC_KEY);
        return res.status(200).json(encData);
    }

    const lockFilePath = path.join('/', `update_user_lock_${userid}.lock`);
    let releaseLock;
    try {
        // if (!lockFile) throw new Error('Lock file error');
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        // Acquire lock
        releaseLock = await lockfile.lock(lockFilePath);
        const user = await User.findOne({ where: { id: userid } });
        if (!user) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'User not found' }), ENC_KEY);
            return res.status(200).json(encData);
        }

        if (lastName) {
            const sanitizedLast = lastName ? lastName.replace(/[\W]/g, '') : '';
            if (!sanitizedLast) {
                const encData = encrypt(JSON.stringify({ status: 'error', message: 'Unable to update Lastname!' }), ENC_KEY);
                return res.json(encData);
            }
            await user.update({ last: sanitizedLast });
            const encData = encrypt(JSON.stringify({ status: 'success', message: 'Lastname Updated!' }), ENC_KEY);
            return res.json(encData);
        }

        // Update fields based on the provided data
        if (pidtype && pidno) {
            await user.update({ pidtype, pidno });
            const encData = encrypt(JSON.stringify({ status: 'success', message: 'Document Data Saved!' }), ENC_KEY);
            return res.json(encData);
        }

        if (photoid) {
            await user.update({ photoid, pidv: '0', namev: '0' });
            const encData = encrypt(JSON.stringify({ status: 'success', message: 'Photo ID Uploaded!' }), ENC_KEY);
            return res.json(encData);
        }

        if (selfie) {
            await user.update({ propic: selfie, pidv: '0', namev: '0' });
            const encData = encrypt(JSON.stringify({ status: 'success', message: 'Selfie Uploaded!' }), ENC_KEY);
            return res.json(encData);
        }

        if (status) {
            if (status === '1' || status === '5') {
                await user.update({
                    status,
                    vid: null,
                    vcode: null,
                    vcode2: null,
                    autoverify: '1',
                    autoverauth: authtoken,
                    autoverref: scanref
                });
                const encData = encrypt(JSON.stringify({ status: 'success', message: 'Status Updated!', scanRef: scanref, authToken: authtoken }), ENC_KEY);
                return res.json(encData);
            }
        }

        if (verify && pidno) {
            const whApi = JSON.stringify({
                final: true,
                platform: 'OTHER',
                status: { overall: 'APPROVED' },
                data: { docNo: pidno },
                scanRef: user.autoverref,
                clientId: userid
            });

            await user.update({
                status: '1',
                pidv: '1',
                namev: '1',
                isVerified: '1',
                pidno,
                autoverify: '2',
                autoverauth: null,
                autoverref: null,
                idenfy_webhook: whApi,
                cname: 'AML System'
            });
            const encData = encrypt(JSON.stringify({
                status: 'success',
                message: 'Verification Updated!',
                scanRef: scanref,
                authToken: authtoken,
                pidno
            }), ENC_KEY);
            return res.json(encData);
        }

        if (profilephoto) {
            await user.update({ profilephoto });
            const encData = encrypt(JSON.stringify({ status: 'success', message: 'Profile Photo Updated!' }), ENC_KEY);
            return res.json(encData);
        }

        if (paypal) {
            if (!user.paypal) {
                await user.update({ paypal });
                const encData = encrypt(JSON.stringify({ status: 'success', message: 'PayPal Updated!' }), ENC_KEY);
                return res.json(encData);
            } else {
                const encData = encrypt(JSON.stringify({ status: 'error', message: 'PayPal already exists!' }), ENC_KEY);
                return res.status(200).json(encData);
            }
        }

        if (venmo) {
            if (!user.venmo) {
                await user.update({ venmo });
                const encData = encrypt(JSON.stringify({ status: 'success', message: 'Venmo Updated!' }), ENC_KEY);
                return res.json(encData);
            } else {
                const encData = encrypt(JSON.stringify({ status: 'error', message: 'Venmo already exists!' }), ENC_KEY);
                return res.status(200).json(encData);
            }
        }

        if (account_number && routing_number) {
            await user.update({ account_number, routing_number });
            // Additional logic for payment integration would go here
            const encData = encrypt(JSON.stringify({ status: 'success', message: 'Bank Details Updated!' }), ENC_KEY);
            return res.json(encData);
        }
        const encData = encrypt(JSON.stringify({ status: 'error', message: 'Invalid data' }), ENC_KEY);
        return res.status(200).json(encData);
    } catch (err) {
        console.error(err);
        const encData = encrypt(JSON.stringify({ status: 'error', message: 'Internal server error' }), ENC_KEY);
        return res.status(200).json(encData);
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}
exports.appleLogin = async (req, res) => {
    try {
        const authResponse = req.body; // Assuming JSON payload
        // console.log(authResponse)
        const { id_token: idToken } = authResponse;

        if (!idToken) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'ID token is required' }), ENC_KEY);
            return res.status(200).json(encData);
        }

        // Decode JWT payload
        const jwtParts = idToken.split('.');
        const decodedPayload = JSON.parse(base64url.decode(jwtParts[1]));
        const email = decodedPayload.email;
        const state = authResponse.state || '';
        // console.log(decodedPayload, email, state);
        if (!email) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'Email is missing in ID token' }), ENC_KEY);
            return res.status(200).json(encData);
        }

        if (state) {
            const stateData = JSON.parse(Buffer.from(state, 'base64').toString('utf8'));
            // console.log("stateData", stateData);

            const { type, origin } = stateData;
            const name = decodedPayload.name || '';
            const authData = Buffer.from(JSON.stringify({ email })).toString('base64');

            if (type === 'signup') {
                return res.redirect(`${origin}/signup?auth=${authData}`);
            } else if (type === 'signin') {
                const user = await User.findOne({ where: { email } });

                if (user) {
                    const jwtData = {
                        id: user.id,
                        first: user.first,
                        last: user.last,
                        email: user.email,
                        phone: user.phone,
                    };

                    const token = jwt.sign(jwtData, process.env.JWT_SECRET, { algorithm: 'HS256' });
                    if (origin === 'https://playgds.mobi') {
                        // return res.json({ message: 'test' });

                        return res.redirect(`${origin}/signin?auth=${authData}`);
                    } else {
                        // return res.json({ message: 'test', origin: origin, redirect: `/signin/?auth=${authData}` });
                        return res.redirect(`${origin}/signin/?auth=${authData}`);
                    }
                } else {
                    // return res.json({ message: 'test' });
                    // return res.json({ message: 'test', origin: origin, redirect: `/signin/?auth=${authData}` });

                    return res.redirect(`${origin}/signin/?auth=${authData}`);
                }
            }
        }

        const user = await User.findOne({ where: { email } });

        if (user) {
            const jwtData = {
                id: user.id,
                first: user.first,
                last: user.last,
                email: user.email,
                phone: user.phone,
            };

            const token = jwt.sign(jwtData, process.env.JWT_SECRET, { algorithm: 'HS256' });
            // return res.json({ message: 'test' });

            return res.redirect(`https://wallet.sweepstake.mobi/signin/?auth=${Buffer.from(JSON.stringify({ email })).toString('base64')}`);
        } else {
            // return res.json({ message: 'test' });

            return res.redirect(`https://wallet.sweepstake.mobi/signin/?auth=${Buffer.from(JSON.stringify({ email })).toString('base64')}`);
        }
    } catch (err) {
        console.error('Error:', err.message);
        return res.status(200).json({ status: 'error', message: 'Internal server error' });
    }
}
exports.loginAppleSuccess = async (req, res) => {
    try {
        const { authData } = req.body;

        if (!authData) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'authData is required' }), ENC_KEY);
            return res.status(200).json(encData);
        }

        const decodedJson = Buffer.from(authData, 'base64').toString('utf8');
        const newJson = JSON.parse(decodedJson);
        const email = newJson.email;

        if (!email) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'Email is missing in authData' }), ENC_KEY);
            return res.status(200).json(encData);
        }

        const user = await User.findOne({ where: { email } });
        // Preparing response data

        if (user) {

            const userData = user.get({ plain: true });
            // Delete sensitive data
            delete userData.password; // Ensure password is removed
            userData.walbalance = userData.rebalance; // Add walbalance
            delete userData.rebalance; // Remove rebalance after assigning it to walbalance

            const jwtData = {
                id: user.id,
                first: user.first,
                last: user.last,
                email: user.email,
                phone: user.phone,
            };

            const token = jwt.sign(jwtData, process.env.JWT_SECRET, { algorithm: 'HS256' });
            user.walbalance = user.rebalance;
            delete user.rebalance;
            delete user.password;
            const responseData = JSON.stringify({
                status: 'success',
                user_status: user.status,
                everified: user.verified,
                userid: user.id,
                token: token,
                data: userData,
            });

            const encryptedData = encrypt(responseData, process.env.ENC_KEY);
            return res.json(encryptedData);
        } else {
            const responseData = JSON.stringify({
                status: 'error',
                message: 'Email does not exist! Please sign up.',
            });

            const encryptedData = encrypt(responseData, process.env.ENC_KEY);
            return res.json(encryptedData);
        }
    } catch (err) {
        console.error('Error:', err.message);
        const encData = encrypt(JSON.stringify({ status: 'error', message: 'Internal server error' }), ENC_KEY);
        return res.status(200).json(encData);
    }
}
exports.setUserIP = async (req, res) => {
    const { userid, site, ip } = req.body;
    console.log(req.body, req.headers)
    // Authorization Header Validation
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Authorization header is missing',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    const token = authHeader.split(' ')[1];
    if (!token) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Token is missing',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    // Verify the token
    let userIdFromToken;
    try {
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        userIdFromToken = decoded.id;
    } catch (err) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Invalid token',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    if (userid.toString() != userIdFromToken.toString()) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Invalid token provided!',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.json(encryptedData);
    }

    const sanitizedUserid = parseInt(userid, 10);
    // const sanitizedGameId = parseInt(game, 10);

    const lockFilePath = path.join('/', `request_game_${sanitizedUserid}.lock`);
    let releaseLock;

    try {

        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const user = await User.findOne({ where: { id: sanitizedUserid } });
        if (!user) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'User not found',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        const [datachk] = await db.query(
            'SELECT * FROM `ips` WHERE `userid` = ? AND `ip` = ?',
            {
                replacements: [userid, ip],
                type: db.QueryTypes.SELECT
            }
        );

        // Second query: latest user token (if needed)
        // const [datachk2] = await db.query(
        //     'SELECT * FROM `usertokens` WHERE `userid` = ? ORDER BY `id` DESC LIMIT 1',
        //     {
        //         replacements: [userid],
        //         type: db.QueryTypes.SELECT
        //     }
        // );

        if (datachk) {
            const encdata = JSON.stringify({
                status: 'success',
                message: 'IP Exists',
                ip: datachk.ip
            });
            const encrypted = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encrypted);
        }

        // Insert new IP if not found
        const [result] = await db.query(
            'INSERT INTO `ips` (`userid`, `ip`) VALUES (?, ?)',
            {
                replacements: [userid, ip],
                type: db.QueryTypes.INSERT
            }
        );

        if (result) {
            const encdata = JSON.stringify({
                status: 'success',
                message: 'IP logged',
                ip: ip
            });

            const encrypted = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encrypted);
        }


    } catch (error) {
        console.error('Error handling request:', error.message);
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Internal server error',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}
exports.getGames = async (req, res) => {
    try {
        // Fetch games data from the database
        const games = await Game.findAll({
            attributes: ['id', 'name', 'image', 'description', 'redirect_url', 'isShow'], // Select specific fields
        });

        // Prepare response data
        const responseData = JSON.stringify({
            status: 'success',
            data: games,
        });

        // Encrypt response data
        const encryptedData = encrypt(responseData, ENC_KEY);

        // Send encrypted response
        return res.json(encryptedData);
    } catch (error) {
        console.error('Error fetching games:', error);

        // Handle error response
        const errorResponse = JSON.stringify({
            status: 'error',
            message: 'An error occurred while fetching games.',
        });
        const encryptedError = encrypt(errorResponse, ENC_KEY);

        return res.json({ data: encryptedError });
    }
};
exports.getPublicGames = async (req, res) => {
    try {
        const games = await Game.findAll({
            attributes: ['id', 'name', 'image', 'description', 'redirect_url', 'isShow'],
        });

        const responseData = JSON.stringify({
            status: 'success',
            data: games,
        });

        return res.json(responseData);
    } catch (error) {
        console.error('Error fetching games:', error);

        const errorResponse = JSON.stringify({
            status: 'error',
            message: 'An error occurred while fetching games.',
        });
        return res.json(errorResponse);
    }
};
exports.linkedGames = async (req, res) => {
    const { userid } = req.body; // Parsed body
    // console.log(userid)
    if (!userid) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'User ID is required!',
        });
        const encryptedData = encrypt(encdata, ENC_KEY);
        return res.json({ data: encryptedData });
    }
    try {
        // Sanitize user ID
        if (!userid) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'User ID is missing' }), ENC_KEY);
            return res.status(200).json(encData);
        }

        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'Authorization header is missing' }), ENC_KEY);
            return res.status(200).json(encData);
        }

        const token = authHeader.split(' ')[1];
        if (!token) {
            const encData = encrypt(JSON.stringify({ status: 'error', message: 'Token is missing' }), ENC_KEY);
            return res.status(200).json(encData);
        }

        const decoded = jwt.verify(token, JWT_SECRET);
        const userId = decoded.id;

        if (userid !== userId.toString()) {
            console.log(userid, userId.toString())
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Invalid token provided!',
            });
            const encryptedData = encrypt(encdata, ENC_KEY);
            return res.json({ data: encryptedData });
        }

        // Fetch user and linked games
        const user = await User.findByPk(userId);
        if (!user) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'User not found!',
            });
            const encryptedData = encrypt(encdata, ENC_KEY);
            return res.json({ data: encryptedData });
        }

        const linkedGames = await db.query(
            'SELECT * FROM linkedgames WHERE userid = :userId ORDER BY id DESC',
            {
                replacements: { userId },
                type: db.QueryTypes.SELECT,
            }
        );

        // const games = [];
        // for (const game of linkedGames) {
        //     const gameDetails = await Game.findByPk(game.gameid, {
        //         attributes: ['id', 'name'],
        //     });

        //     if (gameDetails) {
        //         games.push({
        //             id: gameDetails.id,
        //             name: gameDetails.name,
        //             linked_id: game.gameuser,
        //         });
        //     }
        // }
        const gameIds = linkedGames.map(game => game.gameid);

        // Fetch all game details in a single query
        const gameDetails = await Game.findAll({
            where: { id: { [Op.in]: gameIds } },
            attributes: ['id', 'name'],
        });

        // Create a lookup map for game details
        const gameDetailsMap = gameDetails.reduce((map, game) => {
            map[game.id] = game;
            return map;
        }, {});

        // Prepare the final games array
        const games = linkedGames.map(game => ({
            id: gameDetailsMap[game.gameid]?.id || null,
            name: gameDetailsMap[game.gameid]?.name || null,
            linked_id: game.gameuser,
        }));
        const encdata = JSON.stringify({
            status: 'success',
            games: games,
        });
        const encryptedData = encrypt(encdata, ENC_KEY);
        return res.json(encryptedData);

    } catch (error) {
        console.error('Error fetching linked games:', error);

        const encdata = JSON.stringify({
            status: 'error',
            message: 'An error occurred while fetching linked games.',
        });
        const encryptedData = encrypt(encdata, ENC_KEY);
        return res.json(encryptedData);
    }
};
exports.linkedGamesReset = async (req, res) => {
    const { userid } = req.body;

    if (!userid) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'User ID is required!',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.json(encryptedData);
    }

    try {
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Authorization header is missing',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        const token = authHeader.split(' ')[1];
        if (!token) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Token is missing',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Verify the token
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const userIdFromToken = decoded.id;

        if (userid !== userIdFromToken.toString()) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Invalid token provided!',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        }

        // Fetch user
        const user = await User.findByPk(userid);
        if (!user) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'User not found!',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        }

        // Step 1: Get all linked games
        const linkedGames = await db.query(
            'SELECT * FROM linkedgames WHERE userid = :userid ORDER BY id DESC',
            {
                replacements: { userid },
                type: db.QueryTypes.SELECT
            }
        );

        const gameIds = linkedGames.map(g => g.gameid);

        // Step 2: Batch fetch game details
        const gameDetails = await Game.findAll({
            where: { id: { [Op.in]: gameIds } },
            attributes: ['id', 'name']
        });

        const gameMap = {};
        gameDetails.forEach(g => {
            gameMap[g.id] = g;
        });

        // Step 3: Batch fetch latest reset statuses using raw SQL
        const resetStatusRows = await db.query(
            `
            SELECT r1.*
            FROM gamepassreset r1
            INNER JOIN (
                SELECT gameid, MAX(id) as max_id
                FROM gamepassreset
                WHERE userid = :userid AND gameid IN (:gameIds)
                GROUP BY gameid
            ) r2 ON r1.id = r2.max_id
            `,
            {
                replacements: { userid, gameIds },
                type: db.QueryTypes.SELECT
            }
        );

        const resetStatusMap = {};
        resetStatusRows.forEach(r => {
            resetStatusMap[r.gameid] = r.status;
        });

        // Step 4: Construct response
        const games = linkedGames.map(game => {
            const gameData = gameMap[game.gameid] || {};
            return {
                id: gameData.id || null,
                name: gameData.name || null,
                linked_id: game.gameuser,
                status: resetStatusMap[game.gameid] === '0' ? '0' : '1',
            };
        });

        const encdata = JSON.stringify({
            status: 'success',
            games
        });
        return res.json(encrypt(encdata, process.env.ENC_KEY));
    } catch (error) {
        console.error('Error in linkedGamesReset:', error);

        const encdata = JSON.stringify({
            status: 'error',
            message: 'An error occurred while processing your request.',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.json(encryptedData);
    }
};


exports.requestGame = async (req, res) => {
    const { userid, game } = req.body;

    // Authorization Header Validation
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Authorization header is missing',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    const token = authHeader.split(' ')[1];
    if (!token) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Token is missing',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    // Verify the token
    let userIdFromToken;
    try {
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        userIdFromToken = decoded.id;
    } catch (err) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Invalid token',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    if (userid !== userIdFromToken.toString()) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Invalid token provided!',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.json(encryptedData);
    }

    const sanitizedUserid = parseInt(userid, 10);
    const sanitizedGameId = parseInt(game, 10);

    const lockFilePath = path.join('/', `request_game_${sanitizedUserid}.lock`);
    let releaseLock;

    try {

        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const user = await User.findOne({ where: { id: sanitizedUserid } });
        if (!user) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'User not found',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        const gameData = await Game.findOne({ where: { id: sanitizedGameId }, attributes: ['id', 'name', 'status', 'enabled'] });
        if (!gameData) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Game not found',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        if (gameData.enabled === 0) {
            const encdata = JSON.stringify({
                status: 'error',
                message: `Creation of the game ${gameData.name} is temporarily disabled`,
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        }

        const existingRequest = await Creation.findOne({
            where: {
                userid: sanitizedUserid,
                game: sanitizedGameId,
            },
        });

        if (existingRequest) {
            const statusMessage =
                existingRequest.status === '1'
                    ? 'You already have this game!'
                    : 'You already have a pending request for this game!';
            const encdata = JSON.stringify({
                status: 'error',
                message: statusMessage,
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        }

        const linkedGame = await LinkedGames.findOne({
            where: {
                userid: sanitizedUserid,
                gameid: sanitizedGameId,
            },
        });

        if (linkedGame) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'You already have this game linked!',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        }

        await Creation.create({
            userid: sanitizedUserid,
            game: sanitizedGameId,
        });

        // Send notification email using Axios
        try {
            await axios.post('https://bend.logiclane.tech/api/email', {
                subject: 'Creation request submitted!',
                email: user.email,
                name: `${user.first} ${user.last}`,
                mail: `
              <!DOCTYPE html>
                                                                          <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                                                          
                                                                          <head>
                                                                            <meta charset='utf-8'>
                                                                            <meta name='x-apple-disable-message-reformatting'>
                                                                            <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                                            <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                                            <title>Creation request submitted!</title>
                                                                            <style>
                                                                              .hover-bg-brand-600:hover {
                                                                                background-color: #0047C3 !important;
                                                                              }
                                                                          
                                                                              .hover-text-brand-700:hover {
                                                                                color: #003CA5 !important;
                                                                              }
                                                                          
                                                                              .hover-text-decoration-underline:hover {
                                                                                text-decoration: underline !important;
                                                                              }
                                                                          
                                                                              @media (max-width: 768px) {
                                                                                .sm-mt-4 {
                                                                                  margin-top: 16px !important;
                                                                                }
                                                                          
                                                                                .sm-block {
                                                                                  display: block !important;
                                                                                }
                                                                          
                                                                                .sm-w-full {
                                                                                  width: 100% !important;
                                                                                }
                                                                          
                                                                                .sm-px-4 {
                                                                                  padding-left: 16px !important;
                                                                                  padding-right: 16px !important;
                                                                                }
                                                                          
                                                                                .sm-py-6 {
                                                                                  padding-top: 24px !important;
                                                                                  padding-bottom: 24px !important;
                                                                                }
                                                                              }
                                                                            </style>
                                                                          </head>
                                                                          
                                                                          <body
                                                                            style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                                            <div style='display: none'>
                                                                            Creation request submitted!
                                                                          
                                                                            </div>
                                                                            <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                                              <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                                                cellpadding='0' cellspacing='0' role='none'>
                                                                                <tr>
                                                                                  <td align='center' style='background-color: #fff;'>
                                                                                    <table class='sm-w-full' style='width:768px;margin:0 auto !important' cellpadding='0' cellspacing='0' role='none'>
                                                                                      <tr>
                                                                                        <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                                          <div style='margin-bottom: 24px'>
                                                                                            <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                                              <p>SweepStake Mobi</p>
                                                                                            </a>
                                                                                          </div>
                                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                            Hi <b>${user.first}</b>,
                                                                                          </p>
                                                                                          <img src='${gameData.image}.jpg' class='sm-w-full' width='90% !important'>
                                                                                          <br>
                                                                                          <br>
                                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                          Thank you for requesting account of<br><br> <b>${gameData.name}</b>
                                                                                          </p>
                                                                                         <br><br>
                                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                                          Thank you for choosing SweepStake Mobi!
                                                                                          </p>
                                                                                          <div role='separator' style='line-height: 16px'>&zwj;</div> 
                                                                                                                                         
                                                                                          <div style='text-align: center;'>
                                                                                            <div role='separator'
                                                                                              style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                                            <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                                              This email was sent to you as a registered member of
                                                                                              <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                                                class='sm-block sm-mt-4'>
                                                                                                Use of the service and website is subject to our
                                                                                                <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                  style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                                                and
                                                                                                <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                  style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                                              </span>
                                                                                            </p>
                                                                                            <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                                              rights reserved.</p>
                                                                                          </div>
                                                                                        </td>
                                                                                      </tr>
                                                                                    </table>
                                                                                  </td>
                                                                                </tr>
                                                                              </table>
                                                                            </div>
                                                                          </body>
                                                                          
                                                                          </html>
            `,
            }, {
                headers: {
                    'Content-Type': 'application/json',
                    Authorization: 'Bearer YOUR_AUTH_TOKEN',
                },
            });
        } catch (emailError) {
            console.error('Error sending email:', emailError.message);
        }

        const encdata = JSON.stringify({
            status: 'success',
            message: 'The game creation request has been submitted successfully!',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.json(encryptedData);

    } catch (error) {
        console.error('Error handling request:', error.message);
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Internal server error',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}
exports.cashoutMethods = async (req, res) => {
    const { userid } = req.body;

    // Authorization Header Validation
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Authorization header is missing',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    const token = authHeader.split(' ')[1];
    if (!token) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Token is missing',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    // Verify the token
    let userIdFromToken;
    try {
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        userIdFromToken = decoded.id;
    } catch (err) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Invalid token',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    if (userid !== userIdFromToken.toString()) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Invalid token provided!',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.json(encryptedData);
    }
    const sanitizedUserid = parseInt(userid, 10);
    try {
        const user = await User.findOne({ where: { id: sanitizedUserid } });
        if (!user) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'User not found',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
        const cashoutMethods = await PayoutMethods.findOne();
        let paypal = 0;
        let venmo = 0;
        let ach = 0;
        let gtw = 0;
        let pnmach = 0;
        let pnmcard = 0;
        let coinflow = 0;

        // Check if the user has any cashout methods
        if (
            !user.paypal &&
            !user.venmo &&
            !user.account_number &&
            !user.cfallowed &&

            user.gtallowed === '0'
        ) {
            const encdata = JSON.stringify({
                status: 'error',
                message:
                    'You do not have any cash out methods added to your account, please visit profile page to add Paypal/Venmo/Bank Account',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        } else if (
            !user.paypal &&
            !user.venmo &&
            !user.account_number &&
            cashoutMethods.gtw === 0
        ) {
            const encdata = JSON.stringify({
                status: 'error',
                message:
                    'You do not have any cash out methods added to your account, please visit profile page to add Paypal/Venmo/Bank Account',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        } else {
            // Determine available methods
            if (user.paypal && cashoutMethods.paypal === 1) {
                paypal = 1;
            }
            if (user.venmo && cashoutMethods.venmo === 1) {
                venmo = 1;
            }
            if (user.payoutach === 1 && cashoutMethods.ach === 1) {
                if (user.account_number !== '' && user.routing_number !== '') {
                    ach = 1;
                }
            }
            if (user.payoutgtw === 1 && user.gtallowed === 1 && cashoutMethods.gtw === 1) {
                gtw = 1;
            }
            if (user.pnm_ach_payout === 1 && cashoutMethods.pnm_ach_payout === 1) {
                pnmach = 1;
            }
            if (user.pnm_card_payout === 1 && cashoutMethods.pnm_card_payout === 1) {
                pnmcard = 1;
            }
            if (user.payoutcf && cashoutMethods.coinflow === 1) {
                coinflow = 1;
            }
            const encdata = JSON.stringify({
                status: 'success',
                methods: { paypal, venmo, ach, gtw, pnmach, pnmcard, coinflow },
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        }
    } catch (error) {
        console.error('Error handling request:', error.message);
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Internal server error',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
}
exports.referrals = async (req, res) => {
    try {
        // Authorization header
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Authorization header is missing',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        const token = authHeader.split(' ')[1];
        if (!token) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Token is missing',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const userIdFromToken = decoded.id;

        const { userid } = req.body;
        const sanitizedUserId = parseInt(userid, 10);

        if (userIdFromToken != sanitizedUserId.toString()) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Invalid token provided!',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Fetch user data
        const user = await User.findOne({ where: { id: sanitizedUserId } });
        if (!user) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'User not found',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Fetch referral code
        const referralCode = await RefCodes.findOne({ where: { userid: user.id } });
        if (!referralCode) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Referral Code not available',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        }

        // Fetch referrals associated with the referral code
        const referrals = await Refs.findAll({ where: { refcode: referralCode.refcode } });
        const referralData = [];

        for (const [index, referral] of referrals.entries()) {
            const referredUser = await User.findOne({
                where: { id: referral.userid },
                attributes: ['id', 'first', 'last', 'email'],
            });
            const statusMap = {
                1: 'Rewarded $5',
                2: 'No Rewards',
            };
            if (referredUser) {
                referralData.push({
                    id: index + 1,
                    name: `${referredUser.first} ${referredUser.last}`,
                    status: statusMap[referral.status] || 'Pending',
                    status_code: referral.status,
                });
            }
        }
        const response = {
            referrals: referralData,
            ref_code: referralCode.refcode,
        };

        const encdata = JSON.stringify({ status: 'success', data: response });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.json(encryptedData);
    } catch (error) {
        console.error('Error in referrals function:', error.message);
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Internal server error',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
}
exports.createRefCode = async (req, res) => {
    try {
        // Authorization header
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Authorization header is missing',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        const token = authHeader.split(' ')[1];
        if (!token) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Token is missing',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const userIdFromToken = decoded.id;

        const { userid } = req.body;
        const sanitizedUserId = parseInt(userid, 10);

        if (userIdFromToken != sanitizedUserId.toString()) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Invalid token provided!',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Fetch user data
        const user = await User.findOne({ where: { id: sanitizedUserId } });
        if (!user) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'User not found',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Check if referral code already exists
        const existingRefCode = await RefCodes.findOne({ where: { userid: user.id } });
        if (existingRefCode) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Referral Code already generated',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        }

        // Create new referral code
        const newRefCode = generateRandomString(10);
        await RefCodes.create({ userid: user.id, refcode: newRefCode });

        const encdata = JSON.stringify({
            status: 'success',
            ref_code: newRefCode,
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.json(encryptedData);
    } catch (error) {
        console.error('Error in createRefCode function:', error.message);
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Internal server error',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
}
exports.requestGamePassword = async (req, res) => {

    // Authorization header
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Authorization header is missing',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    const token = authHeader.split(' ')[1];
    if (!token) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Token is missing',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    const decoded = jwt.verify(token, process.env.JWT_SECRET);
    const userIdFromToken = decoded.id;

    const { userid, gameid, gameuser } = req.body;
    const sanitizedUserId = parseInt(userid, 10);
    const sanitizedGameId = parseInt(gameid, 10);
    const sanitizedGameUser = gameuser?.toString() || '';

    if (userIdFromToken != sanitizedUserId.toString()) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Invalid token provided!',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    if (!sanitizedUserId || !sanitizedGameId || !sanitizedGameUser) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Missing required parameters',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    const lockFilePath = path.join('/', `request_game_password_${sanitizedUserId}.lock`);
    let releaseLock;
    try {
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);
        // Check if the user has already submitted a reset request
        const existingRequest = await GamePassReset.findOne({
            where: { userid: sanitizedUserId, gameid: sanitizedGameId },
            order: [['id', 'DESC']],
        });

        if (existingRequest && existingRequest.status === '0') {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Reset request for this game has already been submitted',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        }
        const [results] = await db.query(
            `SELECT COUNT(*) AS count 
             FROM gamepassreset 
             WHERE userid = :userid AND status = '0'`,
            {
                replacements: { userid: sanitizedUserId },
                type: db.QueryTypes.SELECT
            }
        );

        if (results.count >= 3) {
            const encdata = JSON.stringify({ status: 'error', message: 'Maximum of 3 pending password resets allowed' });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        }
        if (sanitizedGameId == '6') {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Skill TX password reset is not allowed!',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        }
        // Fetch game details
        const game = await Game.findOne({ where: { id: sanitizedGameId }, attributes: ['id', 'name', 'status', 'enabled'] });
        if (!game || game.enabled != '1') {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Game is temporarily disabled, please try again after some time',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        }

        // Insert a new reset request
        const insertResult = await GamePassReset.create({
            userid: sanitizedUserId,
            gameid: sanitizedGameId,
            gameuser: sanitizedGameUser,
            created_at: moment().format('YYYY-MM-DD HH:mm:ss'),
            status: '0',
        });

        if (insertResult) {
            const encdata = JSON.stringify({
                status: 'success',
                message: 'Game password reset submitted',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.json(encryptedData);
        }
    } catch (error) {
        console.error('Error in requestGamePassword function:', error.message);
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Internal server error',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}
exports.getUserEmail = async (req, res) => {
    try {
        const authHeader = req.headers['authorization'] || req.headers['Authorization'];
        if (!authHeader) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Authorization header is missing',
            });
            const encryptedData = encrypt(encdata, ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        const token = authHeader.split(' ')[1];
        if (!token) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Token is missing',
            });
            const encryptedData = encrypt(encdata, ENC_KEY);
            return res.status(200).json(encryptedData);
        }


        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const userIdFromToken = decoded.id;


        const data = req.body;
        const userId = parseInt(data.userid, 10);
        let email = (data.email || '').trim().toLowerCase();

        if (userIdFromToken != userId.toString()) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Invalid token provided!',
            });
            const encryptedData = encrypt(encdata, ENC_KEY);
            return res.json(encryptedData);
        }

        if (userId && email) {
            const user = await User.findByPk(userId);
            if (!user) {
                const encdata = JSON.stringify({
                    status: 'error',
                    message: 'User not found',
                });
                const encryptedData = encrypt(encdata, ENC_KEY);
                return res.json(encryptedData);
            }

            if (email != user.email) {
                const searchEmail = await User.findOne({ where: { email } });

                if (searchEmail) {
                    const data = {
                        id: searchEmail.id,
                        first: searchEmail.first,
                        last: searchEmail.last,
                        email: searchEmail.email,
                    };
                    const encdata = JSON.stringify({
                        status: 'success',
                        data: data,
                    });
                    const encryptedData = encrypt(encdata, ENC_KEY);
                    return res.json(encryptedData);
                } else {
                    const encdata = JSON.stringify({
                        status: 'error',
                        message: 'User not found',
                    });
                    const encryptedData = encrypt(encdata, ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encdata = JSON.stringify({
                    status: 'error',
                    message: 'Cannot send money to yourself',
                });
                const encryptedData = encrypt(encdata, ENC_KEY);
                return res.json(encryptedData);
            }
        } else {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'User ID and email must be provided',
            });
            const encryptedData = encrypt(encdata, ENC_KEY);
            return res.json(encryptedData);
        }
    } catch (error) {
        console.error('Error fetching user email:', error);

        const encdata = JSON.stringify({
            status: 'error',
            message: 'An error occurred',
        });
        const encryptedData = encrypt(encdata, ENC_KEY);
        return res.json(encryptedData);
    }
};
exports.sendMoney = async (req, res) => {
    // Get token from Authorization header
    const { userid, email, amount } = req.body;

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Authorization header is missing',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    const token = authHeader.split(' ')[1];
    if (!token) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Token is missing',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    const lockFilePath = path.join('/', `send_money_${userid}.lock`);
    let releaseLock;
    try {
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);
        // Verify token
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const userIdFromToken = decoded.id;

        // Sanitize inputs
        const sanitizedUserId = parseInt(userid, 10);
        const sanitizedEmail = email.trim().toLowerCase();
        const sanitizedAmount = parseFloat(amount);

        if (userIdFromToken.toString() == sanitizedUserId.toString()) {
            if (sanitizedUserId && sanitizedEmail && sanitizedAmount) {
                const userData = await User.findByPk(sanitizedUserId);

                if (!userData) {
                    const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
                    const encryptedData = encrypt(encdata, ENC_KEY);
                    return res.json(encryptedData);
                }

                // Check if the user is verified and allowed to send money
                if (userData.pidv === '1' && userData.namev === '1') {
                    if (userData.giftallowed == '1') {
                        if (sanitizedEmail !== userData.email) {
                            if (sanitizedAmount <= userData.rebalance) {
                                if (sanitizedAmount >= 5 && sanitizedAmount <= 100) {
                                    const dataFriend = await User.findOne({
                                        where: { email: sanitizedEmail },
                                        attributes: ['id', 'email', 'first', 'last', 'rebalance', 'giftallowed', 'pidv', 'namev']
                                    });

                                    if (dataFriend) {
                                        if (dataFriend.pidv == '1' && dataFriend.namev == '1') {
                                            if (dataFriend.giftallowed == '1') {
                                                const fid = dataFriend.id;
                                                const uid = userData.id;
                                                const amtD = sanitizedAmount;


                                                const userBalance = await User.findOne({
                                                    where: { id: uid },
                                                    attributes: ['id', 'balance', 'rebalance']
                                                });
                                                const friendBalance = await User.findOne({
                                                    where: { id: fid },
                                                    attributes: ['id', 'balance', 'rebalance']
                                                });


                                                await User.update(
                                                    { balance: parseFloat(friendBalance.balance) + parseFloat(amtD) },
                                                    { where: { id: fid } }
                                                );
                                                await User.update(
                                                    { rebalance: parseFloat(userBalance.rebalance) - parseFloat(amtD) },
                                                    { where: { id: uid } }
                                                );

                                                const updatedUserBalance = parseFloat(userBalance.rebalance) - parseFloat(amtD);
                                                const updatedFriendBalance = parseFloat(friendBalance.balance) + parseFloat(amtD);


                                                await BrDeposit.create({
                                                    userid: uid,
                                                    txnby: `st:${fid}`,
                                                    type: 2,
                                                    amount: amtD,
                                                    method: 'Wallet Balance',
                                                    status: 1,
                                                    cbalance: userBalance.balance,
                                                    ubalance: userBalance.balance,
                                                    crebalance: userBalance.rebalance,
                                                    urebalance: updatedUserBalance,
                                                });

                                                await BrDeposit.create({
                                                    userid: fid,
                                                    txnby: `rf:${uid}`,
                                                    type: 1,
                                                    amount: amtD,
                                                    method: 'SweepCoin Balance',
                                                    status: 1,
                                                    cbalance: friendBalance.balance,
                                                    ubalance: updatedFriendBalance,
                                                    crebalance: friendBalance.rebalance,
                                                    urebalance: friendBalance.rebalance,
                                                });

                                                const encdata = JSON.stringify({
                                                    status: 'success',
                                                    message: 'Money sent successfully',
                                                });
                                                const encryptedData = encrypt(encdata, ENC_KEY);
                                                return res.json(encryptedData);
                                            } else {
                                                const encdata = JSON.stringify({
                                                    status: 'error',
                                                    message: 'Sending money not allowed to this user',
                                                });
                                                const encryptedData = encrypt(encdata, ENC_KEY);
                                                return res.json(encryptedData);
                                            }
                                        } else {
                                            const encdata = JSON.stringify({
                                                status: 'error',
                                                message: 'Receiver needs to be verified to send money',
                                            });
                                            const encryptedData = encrypt(encdata, ENC_KEY);
                                            return res.json(encryptedData);
                                        }
                                    } else {
                                        const encdata = JSON.stringify({
                                            status: 'error',
                                            message: 'User not found',
                                        });
                                        const encryptedData = encrypt(encdata, ENC_KEY);
                                        return res.json(encryptedData);
                                    }
                                } else {
                                    const encdata = JSON.stringify({
                                        status: 'error',
                                        message: 'Amount must be between $5 and $100',
                                    });
                                    const encryptedData = encrypt(encdata, ENC_KEY);
                                    return res.json(encryptedData);
                                }
                            } else {
                                const encdata = JSON.stringify({
                                    status: 'error',
                                    message: 'Insufficient Balance',
                                });
                                const encryptedData = encrypt(encdata, ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encdata = JSON.stringify({
                                status: 'error',
                                message: 'You cannot send money to yourself',
                            });
                            const encryptedData = encrypt(encdata, ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encdata = JSON.stringify({
                            status: 'error',
                            message: 'This feature is disabled for you.',
                        });
                        const encryptedData = encrypt(encdata, ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encdata = JSON.stringify({
                        status: 'error',
                        message: 'You need to be verified to send money',
                    });
                    const encryptedData = encrypt(encdata, ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encdata = JSON.stringify({
                    status: 'error',
                    message: 'Missing required parameters',
                });
                const encryptedData = encrypt(encdata, process.env.ENC_KEY);
                return res.status(200).json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error sending money:', error);
        const encdata = JSON.stringify({
            status: 'error',
            message: 'An error occurred',
        });
        const encryptedData = encrypt(encdata, ENC_KEY);
        return res.json(encryptedData);
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
function validateCreditCard(cardNumber) {
    cardNumber = cardNumber.replace(/\D/g, '');
    if (!cardNumber || isNaN(cardNumber)) {
        return false;
    }
    const reversedCardNumber = cardNumber.split('').reverse();
    let total = 0;
    for (let i = 0; i < reversedCardNumber.length; i++) {
        let digit = parseInt(reversedCardNumber[i], 10);
        if (i % 2 === 1) {
            digit *= 2;
        }
        if (digit > 9) {
            digit -= 9;
        }
        total += digit;
    }
    return total % 10 === 0;
}
exports.saveCard = async (req, res) => {
    const { userid, cardData } = req.body;

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Authorization header is missing',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    const token = authHeader.split(' ')[1];
    if (!token) {
        const encdata = JSON.stringify({
            status: 'error',
            message: 'Token is missing',
        });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    const decoded = jwt.verify(token, process.env.JWT_SECRET);
    const userIdFromToken = decoded.id;

    try {
        if (!userid) {
            const encryptedData = encrypt(JSON.stringify({ status: 'error', message: 'Invalid user ID' }), process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        if (userIdFromToken.toString() !== userid.toString()) {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Invalid token provided!',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        if (!cardData || !cardData.card_holder || !cardData.card_number || !cardData.expiry) {
            const encryptedData = encrypt(JSON.stringify({ status: 'error', message: 'Please provide card details' }), process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Validate the card number
        if (!validateCreditCard(cardData.card_number)) {
            const encryptedData = encrypt(JSON.stringify({ status: 'error', message: 'Invalid card number' }), process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Fetch the user
        const user = await User.findByPk(userid);
        if (!user) {
            const encryptedData = encrypt(JSON.stringify({ status: 'error', message: 'User not found' }), process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Get all saved cards for the user
        const savedCards = await SavedCards.findAll({ where: { userid } });

        // Check if the card number is already saved
        const cardExists = savedCards.some((card) => {
            const decryptedCardNumber = decrypt(card.card_number, CARD_ENC_KEY);
            return decryptedCardNumber == cardData.card_number;
        });

        if (cardExists) {
            const encryptedData = encrypt(JSON.stringify({ status: 'error', message: 'Card already saved' }), process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Prepare card details for saving
        const last4 = cardData.card_number.slice(-4);
        const bin = cardData.card_number.slice(0, 6);

        const saveCard = await SavedCards.create({
            userid: userid,
            card_holder: encrypt(`${user.first} ${user.last}`, CARD_ENC_KEY),
            card_number: encrypt(cardData.card_number, CARD_ENC_KEY),
            last4: encrypt(last4, CARD_ENC_KEY),
            bin: encrypt(bin, CARD_ENC_KEY),
            expiry: encrypt(cardData.expiry, CARD_ENC_KEY),
            created_at: moment().toISOString(),
        });

        if (saveCard) {
            const encryptedData = encrypt(JSON.stringify({ status: 'success', message: 'Card saved' }), process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        } else {
            const encryptedData = encrypt(JSON.stringify({ status: 'error', message: 'Failed to save card' }), process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    } catch (error) {
        const encryptedData = encrypt(JSON.stringify({ status: 'error', message: 'Server error', error: error.message }), process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
};
exports.getCards = async (req, res) => {
    const { userid } = req.body;

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization header is missing' });
        const encryptedData = encrypt(encdata, ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    const token = authHeader.split(' ')[1];
    if (!token) {
        const encdata = JSON.stringify({ status: 'error', message: 'Token is missing' });
        const encryptedData = encrypt(encdata, ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    try {
        // Verify JWT token
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const userIdFromToken = decoded.id;

        if (!userid || userIdFromToken.toString() !== userid.toString()) {
            const encdata = JSON.stringify({ status: 'error', message: 'Invalid user ID or token mismatch' });
            const encryptedData = encrypt(encdata, ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Fetch user and cards
        const user = await User.findByPk(userid);
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            const encryptedData = encrypt(encdata, ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        const cards = await SavedCards.findAll({ where: { userid } });

        if (cards.length === 0) {
            const encdata = JSON.stringify({ status: 'success', cards: [] });
            const encryptedData = encrypt(encdata, ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        const cardData = cards.map(card => ({
            id: card.id,
            bin: decrypt(card.bin, CARD_ENC_KEY),
            last4: decrypt(card.last4, CARD_ENC_KEY),
            expiry: decrypt(card.expiry, CARD_ENC_KEY),
            card_number: decrypt(card.card_number, CARD_ENC_KEY),
            pnm_method_id: card.pnm_method_id,
            cfToken: card.cfToken,

        }));

        const encdata = JSON.stringify({ status: 'success', cards: cardData });
        const encryptedData = encrypt(encdata, ENC_KEY);
        return res.status(200).json(encryptedData);
    } catch (error) {
        const encdata = JSON.stringify({ status: 'error', message: 'Server error', error: error.message });
        const encryptedData = encrypt(encdata, ENC_KEY);
        return res.status(200).json(encryptedData);
    }
};
exports.removeCard = async (req, res) => {
    const { userid, cardid } = req.body;

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization header is missing' });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    const token = authHeader.split(' ')[1];
    if (!token) {
        const encdata = JSON.stringify({ status: 'error', message: 'Token is missing' });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    try {
        // Verify JWT token
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const userIdFromToken = decoded.id;

        // Sanitize and validate inputs
        const sanitizedUserId = parseInt(userid, 10);
        const sanitizedCardId = parseInt(cardid, 10);

        if (!sanitizedUserId || !sanitizedCardId) {
            const encdata = JSON.stringify({ status: 'error', message: 'Invalid user ID or card ID' });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        if (userIdFromToken.toString() != sanitizedUserId) {
            const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Check if the user exists
        const user = await User.findByPk(sanitizedUserId);
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Check if the card exists
        const card = await SavedCards.findByPk(sanitizedCardId);
        if (!card) {
            const encdata = JSON.stringify({ status: 'error', message: 'Card not found' });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Delete the card
        const deleteResult = await SavedCards.destroy({ where: { id: sanitizedCardId } });
        if (deleteResult) {
            const encdata = JSON.stringify({ status: 'success', message: 'Card removed' });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        } else {
            const encdata = JSON.stringify({ status: 'error', message: 'Failed to remove card' });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    } catch (error) {
        const encdata = JSON.stringify({ status: 'error', message: 'Server error', error: error.message });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
};
exports.cardUsed = async (req, res) => {
    const { userid } = req.body;

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization header is missing' });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    const token = authHeader.split(' ')[1];
    if (!token) {
        const encdata = JSON.stringify({ status: 'error', message: 'Token is missing' });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }

    try {
        // Verify JWT token
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        const userIdFromToken = decoded.id;

        // Validate userid
        if (!userid) {
            const encdata = JSON.stringify({ status: 'error', message: 'User ID is required' });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Check if the token's user ID matches the provided user ID
        if (userIdFromToken.toString() != userid.toString()) {
            const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }

        // Check flagged payments for the user
        const existingRecord = await FlaggedPayments.findOne({ where: { firstuser: userid } });

        if (existingRecord) {
            const encdata = JSON.stringify({
                status: 'success',
                message: 'Your Credit / Debit Card is being used by someone else',
            });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        } else {
            const encdata = JSON.stringify({ status: 'success', message: '' });
            const encryptedData = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    } catch (error) {
        const encdata = JSON.stringify({ status: 'error', message: 'Server error', error: error.message });
        const encryptedData = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
};
exports.wheel = async (req, res) => {
    const { userid } = req.body;
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];

    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization header is missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    try {
        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        if (decoded.id != parseInt(userid)) {
            const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }

        const user = await User.findByPk(userid);
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }

        if (user.isVerified == '1') {
            if (user.wheelallowed == '1') {
                const lastDeposit = await Transactions.findOne({
                    where: {
                        userid: user.id,
                        paidmethod: {
                            [Op.in]: ['CreditCard2', 'GameTimeWallet', 'Crypto', 'Google Pay', 'Apple Pay', 'ForumPay']
                        },
                        status: '1'
                    },
                    order: [['id', 'DESC']]
                });

                if (lastDeposit) {
                    const spinsForCurrentDeposit = await WheelSpin.count({
                        where: {
                            userid: user.id,
                            deposit_id: lastDeposit.id
                        }
                    });

                    if (spinsForCurrentDeposit >= 7) {
                        const data = encrypt(JSON.stringify({
                            status: 'error',
                            wheel_allowed: 0,
                            share_post: 0,
                            verified: 1,
                            message: 'You can only participate in this SweepStake 7 times after any successful deposit to wallet.',
                            deposit_required: 1
                        }), process.env.ENC_KEY);
                        return res.json(data);
                    }

                    const lastSpin = await WheelSpin.findOne({
                        where: { userid: user.id },
                        order: [['created_at', 'DESC']]
                    });

                    if (lastSpin) {
                        const lastSpinTime = moment.utc(lastSpin.created_at);
                        const now = moment.utc();

                        const hoursSinceLastSpin = now.diff(lastSpinTime, 'hours');
                        if (hoursSinceLastSpin < 24) {
                            const hoursRemaining = 24 - hoursSinceLastSpin;
                            const data = encrypt(JSON.stringify({
                                status: 'error',
                                wheel_allowed: 0,
                                share_post: 0,
                                verified: 1,
                                message: 'You can only participate in this SweepStake once every 24 hours.',
                                time_remaining: `${hoursRemaining} hours left`
                            }), process.env.ENC_KEY);
                            return res.json(data);
                        }
                    }

                    if (user.tickets > 0) {
                        const data = encrypt(JSON.stringify({
                            status: 'success',
                            share_post: 0,
                            verified: 1,
                            wheel_allowed: 1
                        }), process.env.ENC_KEY);
                        return res.json(data);
                    } else {
                        const data = encrypt(JSON.stringify({
                            status: 'error',
                            wheel_allowed: 0,
                            verified: 1,
                            share_post: 1,
                            message: 'Share post to play!'
                        }), process.env.ENC_KEY);
                        return res.json(data);
                    }

                } else {
                    const data = encrypt(JSON.stringify({
                        status: 'error',
                        wheel_allowed: 0,
                        share_post: 0,
                        verified: 1,
                        message: 'You can only participate in this SweepStake after a successful deposit.',
                        deposit_required: 1
                    }), process.env.ENC_KEY);
                    return res.json(data);
                }

            } else {
                const data = encrypt(JSON.stringify({
                    status: 'error',
                    share_post: 0,
                    verified: 1,
                    wheel_allowed: 0
                }), process.env.ENC_KEY);
                return res.json(data);
            }
        } else {
            const data = encrypt(JSON.stringify({
                status: 'error',
                wheel_allowed: 0,
                share_post: 0,
                verified: 0,
                message: 'You can only participate in this SweepStake after your Photo ID and Selfie have been verified! Please contact the live chat on our website to get your account verified!'
            }), process.env.ENC_KEY);
            return res.json(data);
        }

    } catch (err) {
        console.log(err)
        const encdata = JSON.stringify({ status: 'error', message: 'Server error', error: err.message });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }
};
exports.wheelShare = async (req, res) => {
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    const { userid } = req.body;

    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization header is missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `wheel_sharer_${userid}.lock`);
    let releaseLock;

    const token = authHeader.split(' ')[1];
    try {
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const decoded = jwt.verify(token, process.env.JWT_SECRET);
        if (decoded.id != parseInt(userid)) {
            const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }

        const user = await User.findByPk(userid);
        if (user) {
            const updated = await user.update({ tickets: 1 });
            if (updated) {
                const encdata = JSON.stringify({
                    status: 'success',
                    message: 'Shared and ticket added',
                });

                return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
            }
        }

    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.wheelSharer = async (req, res) => {
    try {
        const sharer = await Sharer.findOne(); // Fetch the first Sharer record

        if (sharer) {
            const encdata = JSON.stringify({
                status: 'success',
                data: sharer,
            });
            const enc = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(enc);
        } else {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'No sharer found',
            });
            const enc = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(enc);
        }
    } catch (err) {
        console.error(err);
        const encdata = JSON.stringify({
            status: 'error',
            message: 'An error occurred while fetching the sharer',
        });
        const enc = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(enc);
    }
};
exports.getWheelUserStat = async (req, res) => {
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    const { userid, userID } = req.body;
    const userId = parseInt(userid || userID, 10);

    if (!authHeader || !userId) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid token or user ID!' });
        const enc = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(enc);
    }

    try {
        // Decode the token using JWT
        const token = authHeader.split(' ')[1];
        const decoded = jwt.verify(token, process.env.JWT_SECRET);

        // Check if the decoded token ID matches the user ID in the request
        if (decoded.id != parseInt(userId)) {
            const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
            const enc = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(enc);
        }

        // Continue processing the request after token verification
        const userData = await User.findByPk(userId);
        if (!userData) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found!' });
            const enc = encrypt(encdata, process.env.ENC_KEY);
            return res.status(200).json(enc);
        }

        const tAmtData = await WheelSpin.findAll({
            where: { userid: userData.id },
            order: [['id', 'DESC']],
        });

        const tDate = [];
        const tStatus = [];
        tAmtData.forEach(dTamt2 => {
            tStatus.push(dTamt2.status);
            tDate.push(new Date(dTamt2.created_at).toISOString());
        });

        const timeDifference = (start, stop) => {
            const diff = new Date(stop) - new Date(start);
            const fullHours = Math.floor(diff / (60 * 60 * 1000));
            const fullMinutes = Math.floor((diff - (fullHours * 60 * 60 * 1000)) / (60 * 1000));
            const fullSeconds = Math.floor((diff - (fullHours * 60 * 60 * 1000) - (fullMinutes * 60 * 1000)) / 1000);
            return `${String(fullHours).padStart(2, '0')}:${String(fullMinutes).padStart(2, '0')}:${String(fullSeconds).padStart(2, '0')}`;
        };

        const btwdDate = tDate.length > 0 ? tDate[0] : 0;
        const qAmtData = await WheelSpin.findAll({
            where: {
                userid: userData.id,
                status: 1,
                created_at: {
                    [Op.between]: [new Date(new Date(btwdDate).getTime() - 24 * 60 * 60 * 1000), new Date(btwdDate)],
                },
            },
        });

        let data = { userid: userData.id, tickets: userData.tickets, status: 'success' };

        if (tDate.length === 0) {
            data = { userid: userData.id, tickets: userData.tickets, status: 'success' };
        } else {
            const datetime1 = new Date(tDate[0]);
            const datetime2 = new Date();
            const interval = new Date(datetime2 - datetime1);

            if (interval.getUTCDate() < 1 && interval.getUTCHours() < 100) {
                data = { userid: userData.id, status: 'timelimitreached' };
            } else {
                data = { userid: userData.id, tickets: userData.tickets, status: 'success' };
            }
        }

        return res.status(200).json(data);
    } catch (err) {
        console.error(err);
        const encdata = JSON.stringify({ status: 'error', message: 'An error occurred while fetching the data' });
        const enc = encrypt(encdata, process.env.ENC_KEY);
        return res.status(200).json(enc);
    }
};
exports.updateTickets = async (req, res) => {
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    const data = req.body || {};
    const userid = data.userid || data.userID || '';
    const sanitizedUserId = parseInt(userid, 10);

    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `update_tickets_lock_${sanitizedUserId}.lock`);
    let releaseLock;

    try {
        // Ensure lock file exists
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        // JWT Verification
        const token = authHeader.split(' ')[1];
        const decoded = jwt.verify(token, process.env.JWT_SECRET);

        if (decoded.id !== sanitizedUserId) {
            const encdata = JSON.stringify({ status: 'error', message: 'Invalid token provided!' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }

        const user = await User.findByPk(sanitizedUserId);
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }

        const tickets = data.tickets - 1;

        // Fetch last successful deposit
        const lastDeposit = await Transactions.findOne({
            where: {
                userid: sanitizedUserId,
                paidmethod: ['CreditCard2', 'GameTimeWallet', 'Crypto', 'Google Pay', 'Apple Pay', 'ForumPay'],
                status: '1'
            },
            order: [['id', 'DESC']]
        });

        // Update tickets
        await user.update({ tickets });

        // Insert into wheelspins
        await WheelSpin.create({
            userid: user.id,
            deposit_id: lastDeposit ? lastDeposit.id : null
        });

        const responseArray = {
            userid: user.id,
            tickets,
            status: 'success',
        };

        return res.json(responseArray);

    } catch (err) {
        console.error(err);
        const encdata = JSON.stringify({ status: 'error', message: 'Something went wrong!' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    } finally {
        try {
            if (releaseLock) await releaseLock();
            if (fs.existsSync(lockFilePath)) fs.unlinkSync(lockFilePath);
        } catch (cleanupErr) {
            console.error('Error cleaning up lock file:', cleanupErr);
        }
    }
};
exports.saveScore = async (req, res) => {
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    const data = req.body;
    const userid = data.userid || data.userID || '';
    const sanitizedUserId = parseInt(userid, 10);

    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `save_score_${sanitizedUserId}.lock`);
    let releaseLock;

    try {
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const token = authHeader.split(' ')[1];
        const decoded = jwt.verify(token, process.env.JWT_SECRET);

        if (decoded.id.toString() !== sanitizedUserId.toString()) {
            const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }

        const user = await User.findByPk(sanitizedUserId);
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }

        const lastSpin = await Wheel.findOne({
            where: { userid: user.id },
            order: [['id', 'desc']],
        });

        const now = moment();
        if (lastSpin) {
            const lastSpinTime = moment(lastSpin.date);
            const hoursDiff = now.diff(lastSpinTime, 'hours');

            if (hoursDiff < 24) {
                return res.status(200).json({ status: 'error', message: 'Time limit reached', time_diff: hoursDiff });
            }
        }

        const points = data.pts;
        const amount = points / 100 > 5 ? 0 : points / 100;

        await Wheel.create({
            userid: user.id,
            amount,
            status: 1,
        });

        const userd = await User.findOne({
            attributes: ['id', 'balance', 'rebalance'],
            where: { id: user.id },
        });

        await User.update(
            { balance: parseFloat(userd.balance) + parseFloat(amount) },
            { where: { id: user.id } }
        );

        const ubalance = parseFloat(user.balance) + parseFloat(amount);

        await WheelTxn.create({
            userid: user.id,
            amount,
            cbalance: user.balance,
            ubalance,
            crebalance: user.rebalance,
            urebalance: user.rebalance,
        });

        return res.json({
            userid: user.id,
            status: 'success',
        });

    } catch (err) {
        console.error(err.message);
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid token provided' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    } finally {
        try {
            if (releaseLock) await releaseLock();
            if (fs.existsSync(lockFilePath)) fs.unlinkSync(lockFilePath);
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.forgotPassword = async (req, res) => {
    const { email, site } = req.body;

    if (!email || !site) {
        const encdata = encrypt(JSON.stringify({
            status: 'error',
            message: 'Email and site are required.',
        }), ENC_KEY);
        return res.json(encdata);
    }

    const lockFilePath = path.join('/', `forgot_password_${email}.lock`);
    let releaseLock;

    try {
        // Open or create lock file

        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);
        // Process request
        const user = await User.findOne({ where: { email: email.trim().toLowerCase() } });

        if (!user) {
            const encdata = encrypt(JSON.stringify({
                status: 'error',
                message: 'User not found.',
            }), ENC_KEY);
            return res.json(encdata);
        }

        const vid = `${Math.floor(10000 + Math.random() * 90000)}${crypto.randomUUID()}`;
        const vcodeN = Math.floor(100000 + Math.random() * 900000);
        user.vid = vid;
        user.vcode2 = vcodeN;
        await user.save();
        // await user.update({
        //     vid,
        //     vcode2: vcodeN,
        // });

        const payload = {
            subject: 'Reset Password!',
            email: user.email,
            name: `${user.first} ${user.last}`,
            mail: `
          <!DOCTYPE html>
                                                  <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                                  
                                                  <head>
                                                    <meta charset='utf-8'>
                                                    <meta name='x-apple-disable-message-reformatting'>
                                                    <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                    <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                    <title>Reset Password!</title>
                                                    <style>
                                                      .hover-bg-brand-600:hover {
                                                        background-color: #0047C3 !important;
                                                      }
                                                  
                                                      .hover-text-brand-700:hover {
                                                        color: #003CA5 !important;
                                                      }
                                                  
                                                      .hover-text-decoration-underline:hover {
                                                        text-decoration: underline !important;
                                                      }
                                                      @media(max-width: 640px) {
                                                        .sm-block {
                                                          display: block !important;
                                                         
                                                        }
                                                        .btn-class{
                                                          width:100% !important;
                                                        }
                                                      }
                                                      @media (max-width: 768px) {
                                                        .sm-mt-4 {
                                                          margin-top: 16px !important;
                                                        }
                                                  
                                                        .sm-block {
                                                          display: block !important;
                                                        }
                                                  
                                                        .sm-w-full {
                                                          width: 100% !important;
                                                        }
                                                        .btn-class{
                                                          width:40% !important;
                                                          margin:0 auto;
                                                        }
                                                        .sm-px-4 {
                                                          padding-left: 16px !important;
                                                          padding-right: 16px !important;
                                                        }
                                                  
                                                        .sm-py-6 {
                                                          padding-top: 24px !important;
                                                          padding-bottom: 24px !important;
                                                        }
                                                      }
                                                    </style>
                                                  </head>
                                                  
                                                  <body
                                                    style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                    <div style='display: none'>
                                                    Your password reset request has been submitted!
                                                  
                                                    </div>
                                                    <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                      <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                        cellpadding='0' cellspacing='0' role='none'>
                                                        <tr>
                                                          <td align='center' style='background-color: #fff;'>
                                                            <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                              <tr>
                                                                <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                  <div style='margin-bottom: 24px'>
                                                                    <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                      <p>SweepStake Mobi</p>
                                                                    </a>
                                                                  </div>
                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                    Hi <b>${user.first},</b>
                                                                  </p>
                                                                  <br>
                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                  Your password reset request has been submitted!
                                                                  </p>
                                                                 <br>
                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                  Your reset verification code is <br><br><b>${vcodeN}</b>
                                                                  </p>
                                                                  <br>
                                                                  <div role='separator' style='line-height: 16px'>&zwj;</div>
                                                                  <div class='btn-class' >
                                                                  <a href='${site}/reset?vid=${vid}'
                                                                  class='sm-block hover-bg-brand-600'
                                                                  style='text-decoration: none; display: inline-block; border-radius: 4px; background-color: #0052E2; padding: 16px 32px; text-align: center; font-size: 16px; line-height: 16px; font-weight: 700; color: #fff; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06)'>
                                                                  <!--[if mso]><i style='letter-spacing: 32px; mso-font-width: -100%; mso-text-raise:30px;'>&#8202;</i><![endif]-->
                                                                  <span style='mso-text-raise: 16px'>Reset Password</span>
                                                                  <!--[if mso]><i style='letter-spacing: 32px; mso-font-width: -100%;'>&#8202;</i><![endif]-->
                                                                </a>  
                                                                </div>
                                                                <br>
                                                                <br>
                                                                <p style='margin: 0; font-size: 18px; line-height: 28px; color: #4A5566;'>
                                                                Thank you for choosing SweepStake Mobi!
                                                                  </p>  
                                                                  <div style='text-align: center;'>
                                                                    <div role='separator'
                                                                      style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                    <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                      This email was sent to you as a registered member of
                                                                      <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                        style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                        class='sm-block sm-mt-4'>
                                                                        Use of the service and website is subject to our
                                                                        <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                          style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                        and
                                                                        <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                          style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                      </span>
                                                                    </p>
                                                                    <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                      rights reserved.</p>
                                                                  </div>
                                                                </td>
                                                              </tr>
                                                            </table>
                                                          </td>
                                                        </tr>
                                                      </table>
                                                    </div>
                                                  </body>
                                                  
                                                  </html>
        `,
        };

        // Send email
        await axios.post(
            'https://bend.logiclane.tech/api/email',
            payload,
            {
                headers: {
                    'Content-Type': 'application/json',
                    Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
                },
            }
        );

        const encdata = encrypt(JSON.stringify({
            status: 'success',
            message: 'Reset Email Sent',
            vid,
        }), ENC_KEY);
        return res.json(encdata);
    } catch (error) {
        console.error('Error in forgotPassword:', error);
        const encdata = encrypt(JSON.stringify({
            status: 'error',
            message: 'An error occurred while processing the request.',
        }), ENC_KEY);
        return res.json(encdata);
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}
const attemptTracker = new Map();
exports.resetPassword = async (req, res) => {
    const { vid, newpassword, newpassword2, vcode } = req.body;

    if (!vid || !newpassword || !newpassword2 || !vcode) {
        const encdata = encrypt(JSON.stringify({
            status: 'error',
            message: 'All fields are required.',
        }), ENC_KEY);
        return res.json(encdata);
    }

    if (newpassword != newpassword2) {
        const encdata = encrypt(JSON.stringify({
            status: 'error',
            message: 'Passwords do not match!',
        }), ENC_KEY);
        return res.json(encdata);
    }

    try {
        // Check or initialize attempts for this VID
        if (!attemptTracker.has(vid)) {
            attemptTracker.set(vid, { attempts: 0 });
        }

        const attemptData = attemptTracker.get(vid);

        if (attemptData.attempts >= 3) {
            attemptTracker.delete(vid); // Reset attempts if exceeded
            const encdata = encrypt(JSON.stringify({
                status: 'error',
                message: 'OTP attempts exceeded. Please start the process again.',
                exceeded: 1,
            }), ENC_KEY);
            return res.json(encdata);
        }

        // Find the user by VID
        const user = await User.findOne({ where: { vid } });
        if (user && user.vcode2 == '') {
            const encdata = encrypt(JSON.stringify({
                status: 'error',
                message: 'Please start the process again.',
                exceeded: 1,
            }), ENC_KEY);
            return res.json(encdata);
        }
        if (!user || user.vcode2 != vcode) {
            // Increment attempts if verification fails
            attemptData.attempts += 1;
            attemptTracker.set(vid, attemptData);

            if (attemptData.attempts >= 3) {
                // Reset user VID and vcode2 after max attempts
                user.vid = '';
                user.vcode2 = '';
                await user.save();

                attemptTracker.delete(vid);
                const encdata = encrypt(JSON.stringify({
                    status: 'error',
                    message: 'OTP attempts exceeded. Please start the process again.',
                    exceeded: 1,
                }), ENC_KEY);
                return res.json(encdata);
            }
            const encdata = encrypt(JSON.stringify({
                status: 'error',
                message: 'Invalid verification code',
                exceeded: 0,
            }), ENC_KEY);
            return res.json(encdata);
        }

        // Reset the user's password
        const hashedPassword = await bcrypt.hash(newpassword, 10);
        await user.update({
            vid: '',
            vcode2: '',
            password: hashedPassword,
            cpass: '1',
        });

        // Remove VID from the tracker after success
        attemptTracker.delete(vid);

        // Send confirmation email
        const payload = {
            subject: 'Reset Password Successful!',
            email: user.email,
            name: `${user.first} ${user.last}`,
            mail: `
          <!DOCTYPE html>
                                                      <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                                      
                                                      <head>
                                                        <meta charset='utf-8'>
                                                        <meta name='x-apple-disable-message-reformatting'>
                                                        <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                        <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                        <title>Reset Password Successful!</title>
                                                        <style>
                                                          .hover-bg-brand-600:hover {
                                                            background-color: #0047C3 !important;
                                                          }
                                                      
                                                          .hover-text-brand-700:hover {
                                                            color: #003CA5 !important;
                                                          }
                                                      
                                                          .hover-text-decoration-underline:hover {
                                                            text-decoration: underline !important;
                                                          }
                                                      @media(max-width:640px;){
                                                        .btn-class{
                                                          width:100% !important;
                                                        }
                                                      }
                                                          @media (max-width: 768px) {
                                                            .sm-mt-4 {
                                                              margin-top: 16px !important;
                                                            }
                                                      
                                                            .sm-block {
                                                              display: block !important;
                                                            }
                                                      
                                                            .sm-w-full {
                                                              width: 100% !important;
                                                            }
                                                            .btn-class{
                                                              width:40% !important;
                                                              margin:0 auto;
                                                            }
                                                            .sm-px-4 {
                                                              padding-left: 16px !important;
                                                              padding-right: 16px !important;
                                                            }
                                                      
                                                            .sm-py-6 {
                                                              padding-top: 24px !important;
                                                              padding-bottom: 24px !important;
                                                            }
                                                          }
                                                        </style>
                                                      </head>
                                                      
                                                      <body
                                                        style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                        <div style='display: none'>
                                                        Reset Password Successful!
                                                      
                                                        </div>
                                                        <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                          <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                            cellpadding='0' cellspacing='0' role='none'>
                                                            <tr>
                                                              <td align='center' style='background-color: #fff;'>
                                                                <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                                  <tr>
                                                                    <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                      <div style='margin-bottom: 24px'>
                                                                        <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                          <p>SweepStake Mobi</p>
                                                                        </a>
                                                                      </div>
                                                                      <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                        Hi <b>${user.first}</b>,
                                                                      </p>
                                                                      <br>
                                                                      <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                      Your password reset request has been successful!
                                                                      </p>
                                                                     <br>
                                                                      <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                      Thank you for choosing SweepStake Mobi!
                                                                      </p>
                                                                      <div role='separator' style='line-height: 16px'>&zwj;</div> 
                                                                     
                                                                      <div style='text-align: center;'>
                                                                        <div role='separator'
                                                                          style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                        <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                          This email was sent to you as a registered member of
                                                                          <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                            style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                            class='sm-block sm-mt-4'>
                                                                            Use of the service and website is subject to our
                                                                            <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                              style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                            and
                                                                            <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                              style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                          </span>
                                                                        </p>
                                                                        <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                          rights reserved.</p>
                                                                      </div>
                                                                    </td>
                                                                  </tr>
                                                                </table>
                                                              </td>
                                                            </tr>
                                                          </table>
                                                        </div>
                                                      </body>
                                                      
                                                      </html>
        `,
        };

        // await axios.post(
        //     'https://bend.logiclane.tech/api/email',
        //     payload,
        //     {
        //         headers: {
        //             'Content-Type': 'application/json',
        //             Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
        //         },
        //     }
        // );
        const encdata = encrypt(JSON.stringify({
            status: 'success',
            message: 'Reset successful',
        }), ENC_KEY);
        return res.json(encdata);
    } catch (error) {
        console.error('Error in resetPassword:', error);
        const encdata = encrypt(JSON.stringify({
            status: 'error',
            message: 'An error occurred while processing your request.',
        }), ENC_KEY);
        return res.json(encdata);
    }
}
exports.updatePassword = async (req, res) => {

    const { userid, password } = req.body;

    // Check Authorization header

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];

    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }


    if (!userid || !password) {
        const encdata = encrypt(JSON.stringify({
            status: 'error',
            message: 'User ID and password are required!',
        }), ENC_KEY);
        return res.json(encdata);
    }

    const lockFilePath = path.join('/', `update_password_${userid}.lock`);
    let releaseLock;
    try {
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const token = authHeader.split(' ')[1];
        const decoded = jwt.verify(token, process.env.JWT_SECRET);

        if (decoded.id != parseInt(userid)) {
            const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }
        // Fetch user
        const user = await User.findByPk(userid);
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }

        // Update password
        const hashedPassword = await bcrypt.hash(password, 10);
        const updateResult = await user.update({ password: hashedPassword });

        if (updateResult) {
            const encdata = encrypt(JSON.stringify({
                status: 'success',
                message: 'Password updated',
            }), ENC_KEY);
            return res.json(encdata);
        } else {
            const encdata = encrypt(JSON.stringify({
                status: 'error',
                message: 'Unable to update password',
            }), ENC_KEY);
            return res.status(200).json(encdata);
        }
    } catch (error) {
        console.error('Error in updatePassword:', error);
        const encdata = encrypt(JSON.stringify({
            status: 'error',
            message: 'Invalid token provided',
        }), ENC_KEY);
        return res.status(200).json(encdata);
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }

}
exports.updateEmail = async (req, res) => {
    const { userid, email, site } = req.body;

    // Authorization header handling
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (!userid || !email || !site) {
        const encdata = JSON.stringify({ status: 'error', message: 'Missing required parameters' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `update_password_${userid}.lock`);
    let releaseLock;

    try {
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        const user = await User.findByPk(userid);
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }

        if (user.pidv == '1' && user.namev == '1') {
            if (email.trim().toLowerCase() != user.email.toLowerCase()) {
                const existingUser = await User.findOne({ where: { email: email.trim().toLowerCase() } });
                if (existingUser) {
                    const encdata = JSON.stringify({ status: 'error', message: 'Email already exists' });
                    return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
                }

                const vid = `${Math.floor(10000 + Math.random() * 90000)}${Date.now()}`;
                const vcode = Math.floor(100000 + Math.random() * 900000);
                const vcode2 = Math.floor(100000 + Math.random() * 900000);
                const token_old = generateID(16);
                const token_new = generateID(16);

                await NewEmailToken.create({
                    userid: userid,
                    new_email: email.trim().toLowerCase(),
                    magic_token_old: token_old,
                    magic_token_new: token_new

                })
                await user.update({
                    nemail: email.trim().toLowerCase(),
                    vid,
                    vcode,
                    vcode2,
                    verified: 1,
                });

                const payload1 = {
                    subject: 'Verify your account!',
                    email: user.email,
                    name: `${user.first} ${user.last}`,
                    mail: `
                    <!DOCTYPE html>
                                                                          <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                                                          
                                                                          <head>
                                                                            <meta charset='utf-8'>
                                                                            <meta name='x-apple-disable-message-reformatting'>
                                                                            <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                                            <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                                            <title>Verify your account!</title>
                                                                            <style>
                                                                              .hover-bg-brand-600:hover {
                                                                                background-color: #0047C3 !important;
                                                                              }
                                                                          
                                                                              .hover-text-brand-700:hover {
                                                                                color: #003CA5 !important;
                                                                              }
                                                                          
                                                                              .hover-text-decoration-underline:hover {
                                                                                text-decoration: underline !important;
                                                                              }
                                                                              @media (max-width: 640px) {
                                                                              .btn-class{
                                                                                width:100% !important;
                                                                              }
                                                                            }
                                                                              @media (max-width: 768px) {
                                                                                .sm-mt-4 {
                                                                                  margin-top: 16px !important;
                                                                                }
                                                                          
                                                                                .sm-block {
                                                                                  display: block !important;
                                                                                }
                                                                          
                                                                                .sm-w-full {
                                                                                  width: 100% !important;
                                                                                }
                                                                                .btn-class{
                                                                                  width:40% !important;
                                                                                  margin: 0 auto;
                                                                                }
                                                                                .sm-px-4 {
                                                                                  padding-left: 16px !important;
                                                                                  padding-right: 16px !important;
                                                                                }
                                                                          
                                                                                .sm-py-6 {
                                                                                  padding-top: 24px !important;
                                                                                  padding-bottom: 24px !important;
                                                                                }
                                                                              }
                                                                            </style>
                                                                          </head>
                                                                          
                                                                          <body
                                                                            style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                                            <div style='display: none'>
                                                                            Updating your email account!
                                                                          
                                                                            </div>
                                                                            <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                                              <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                                                cellpadding='0' cellspacing='0' role='none'>
                                                                                <tr>
                                                                                  <td align='center' style='background-color: #fff;'>
                                                                                    <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                                                      <tr>
                                                                                        <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                                          <div style='margin-bottom: 24px'>
                                                                                            <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                                              <p>SweepStake Mobi</p>
                                                                                            </a>
                                                                                          </div>
                                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                            Hi <b>${user.first}</b>,
                                                                                          </p>
                                                                                          <br>
                                                                                          <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                          Your password reset request has been submitted!
                                                                                          </p>
                                                                                         <br>
                                                                                          
                                                                                          <div role='separator' style='line-height: 16px'>&zwj;</div> 
                                                                                          <div class='btn-class'>
                                                                                          <a href='${site}/verifyetokenold?token=${token_old}'
                                                                                          class='sm-block hover-bg-brand-600'
                                                                                          style='text-decoration: none; display: inline-block; border-radius: 4px; background-color: #0052E2; padding: 16px 32px; text-align: center; font-size: 16px; line-height: 16px; font-weight: 700; color: #fff; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06)'>
                                                                                          <!--[if mso]><i style='letter-spacing: 32px; mso-font-width: -100%; mso-text-raise:30px;'>&#8202;</i><![endif]-->
                                                                                          <span style='mso-text-raise: 16px'>Confirm your email</span>
                                                                                          <!--[if mso]><i style='letter-spacing: 32px; mso-font-width: -100%;'>&#8202;</i><![endif]-->
                                                                                        </a>  
                                                                                        </div>
                                                                                        <br><br>
                                                                                        <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                                        Thank you for choosing SweepStake Mobi!
                                                                                          </p>  
                                                                                          <div style='text-align: center;'>
                                                                                            <div role='separator'
                                                                                              style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                                            <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                                              This email was sent to you as a registered member of
                                                                                              <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                                                class='sm-block sm-mt-4'>
                                                                                                Use of the service and website is subject to our
                                                                                                <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                  style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                                                and
                                                                                                <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                                  style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                                              </span>
                                                                                            </p>
                                                                                            <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                                              rights reserved.</p>
                                                                                          </div>
                                                                                        </td>
                                                                                      </tr>
                                                                                    </table>
                                                                                  </td>
                                                                                </tr>
                                                                              </table>
                                                                            </div>
                                                                          </body>
                                                                          
                                                                          </html>
                    `, // Simplified for brevity
                };

                await axios.post('https://bend.logiclane.tech/api/email', payload1, {
                    headers: {
                        'Content-Type': 'application/json',
                        Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
                    },
                });


                const encdata = JSON.stringify({ status: 'success', message: 'Verification email sent' });
                return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
            } else {
                const encdata = JSON.stringify({ status: 'error', message: 'Emails cannot be the same' });
                return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
            }
        } else {
            const encdata = JSON.stringify({
                status: 'error',
                message: 'Please contact support to get your account verified',
            });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }
    } catch (error) {
        console.error('Error in updateEmail:', error);
        const encdata = JSON.stringify({ status: 'error', message: 'Internal server error' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}
exports.verifyTokenOld = async (req, res) => {
    const { token, site } = req.body;

    if (!token || !site) {
        const encdata = JSON.stringify({ status: 'error', message: 'Missing required parameters' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `update_password_${token}.lock`);
    let releaseLock;

    try {
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);
        const magicToken = await NewEmailToken.findOne({ where: { magic_token_old: token } });
        if (!magicToken) {
            const encdata = JSON.stringify({ status: 'error', message: 'Token not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }
        if (magicToken.status_old != '0') {
            const encdata = JSON.stringify({ status: 'error', message: 'Old email already verified!' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }
        magicToken.status_old = '1';
        await magicToken.save();
        const user = await User.findByPk(magicToken.userid);
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }

        const payload1 = {
            subject: 'Verify your account!',
            email: magicToken.new_email,
            name: `${user.first} ${user.last}`,
            mail: `<!DOCTYPE html>
                                                                  <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                                                  
                                                                  <head>
                                                                    <meta charset='utf-8'>
                                                                    <meta name='x-apple-disable-message-reformatting'>
                                                                    <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                                    <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                                    <title>Verify your account!</title>
                                                                    <style>
                                                                      .hover-bg-brand-600:hover {
                                                                        background-color: #0047C3 !important;
                                                                      }
                                                                  
                                                                      .hover-text-brand-700:hover {
                                                                        color: #003CA5 !important;
                                                                      }
                                                                  
                                                                      .hover-text-decoration-underline:hover {
                                                                        text-decoration: underline !important;
                                                                      }
                                                                  @media(max-width:640px){
                                                                    .btn-class{
                                                                      width:100% !important;
                                                                      
                                                                    }
                                                                  }
                                                                      @media (max-width: 768px) {
                                                                        .sm-mt-4 {
                                                                          margin-top: 16px !important;
                                                                        }
                                                                  
                                                                        .sm-block {
                                                                          display: block !important;
                                                                        }
                                                                  
                                                                        .sm-w-full {
                                                                          width: 100% !important;
                                                                        }
                                                                        .btn-class{
                                                                          width:40% !important;
                                                                          margin: 0 auto;
                                                                        }
                                                                        .sm-px-4 {
                                                                          padding-left: 16px !important;
                                                                          padding-right: 16px !important;
                                                                        }
                                                                  
                                                                        .sm-py-6 {
                                                                          padding-top: 24px !important;
                                                                          padding-bottom: 24px !important;
                                                                        }
                                                                      }
                                                                    </style>
                                                                  </head>
                                                                  
                                                                  <body
                                                                    style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                                    <div style='display: none'>
                                                                    Updating your email account!
                                                                  
                                                                    </div>
                                                                    <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                                      <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                                        cellpadding='0' cellspacing='0' role='none'>
                                                                        <tr>
                                                                          <td align='center' style='background-color: #fff;'>
                                                                            <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                                              <tr>
                                                                                <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                                  <div style='margin-bottom: 24px'>
                                                                                    <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                                      <p>SweepStake Mobi</p>
                                                                                    </a>
                                                                                  </div>
                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                    Hi ${user.first},
                                                                                  </p>
                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                  Your password reset request has been submitted!
                                                                                  </p>
                                                                                 
                                                                                  
                                                                                  <div role='separator' style='line-height: 16px'>&zwj;</div> 
                                                                                  <div class='btn-class'>
                                                                                  <a href='${site}/verifyetokennew?token=${magicToken.magic_token_new}'
                                                                                  class='sm-block hover-bg-brand-600'
                                                                                  style='text-decoration: none; display: inline-block; border-radius: 4px; background-color: #0052E2; padding: 16px 32px; text-align: center; font-size: 16px; line-height: 16px; font-weight: 700; color: #fff; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06)'>
                                                                                  <!--[if mso]><i style='letter-spacing: 32px; mso-font-width: -100%; mso-text-raise:30px;'>&#8202;</i><![endif]-->
                                                                                  <span style='mso-text-raise: 16px'>Confirm your email</span>
                                                                                  <!--[if mso]><i style='letter-spacing: 32px; mso-font-width: -100%;'>&#8202;</i><![endif]-->
                                                                                </a>  
                                                                                </div>
                                                                                <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                                Thank you for choosing SweepStake Mobi!
                                                                                  </p>  
                                                                                  <div style='text-align: center;'>
                                                                                    <div role='separator'
                                                                                      style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                                    <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                                      This email was sent to you as a registered member of
                                                                                      <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                        style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                                        class='sm-block sm-mt-4'>
                                                                                        Use of the service and website is subject to our
                                                                                        <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                          style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                                        and
                                                                                        <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                          style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                                      </span>
                                                                                    </p>
                                                                                    <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                                      rights reserved.</p>
                                                                                  </div>
                                                                                </td>
                                                                              </tr>
                                                                            </table>
                                                                          </td>
                                                                        </tr>
                                                                      </table>
                                                                    </div>
                                                                  </body>
                                                                  
                                                                  </html>
                    `,
        };

        await axios.post('https://bend.logiclane.tech/api/email', payload1, {
            headers: {
                'Content-Type': 'application/json',
                Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
            },
        });

        const encdata = JSON.stringify({ status: 'success', message: 'Old Email Verified, New Email Sent.' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));

    } catch (error) {
        console.error('Error in updateEmail:', error);
        const encdata = JSON.stringify({ status: 'error', message: 'Internal server error' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}
exports.verifyTokenNew = async (req, res) => {
    const { token } = req.body;

    if (!token) {
        const encdata = JSON.stringify({ status: 'error', message: 'Missing required parameters' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `update_password_${token}.lock`);
    let releaseLock;

    try {
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);
        const magicToken = await NewEmailToken.findOne({ where: { magic_token_new: token } });
        if (!magicToken) {
            const encdata = JSON.stringify({ status: 'error', message: 'Token not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }
        if (magicToken.status_old == '0') {
            const encdata = JSON.stringify({ status: 'error', message: 'Old Email has not been verified, please verify it before verifying the new email' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }
        if (magicToken.status_new != '0') {
            const encdata = JSON.stringify({ status: 'error', message: 'New email already verified' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }
        magicToken.status_new = '1';
        await magicToken.save();
        const user = await User.findByPk(magicToken.userid);
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }
        user.verified = '1';
        user.isVerified = '1';
        user.vid = '';
        user.vcode = '';
        user.vcode2 = '';
        user.email = magicToken.new_email;
        await user.save();

        const payload1 = {
            subject: 'Verification successful!',
            email: magicToken.new_email,
            name: `${user.first} ${user.last}`,
            mail: `<!DOCTYPE html>
                                                      <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                                      
                                                      <head>
                                                        <meta charset='utf-8'>
                                                        <meta name='x-apple-disable-message-reformatting'>
                                                        <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                        <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                        <title>Verification successful!</title>
                                                        <style>
                                                          .hover-bg-brand-600:hover {
                                                            background-color: #0047C3 !important;
                                                          }
                                                      
                                                          .hover-text-brand-700:hover {
                                                            color: #003CA5 !important;
                                                          }
                                                      
                                                          .hover-text-decoration-underline:hover {
                                                            text-decoration: underline !important;
                                                          }
                                                      
                                                          @media (max-width: 768px) {
                                                            .sm-mt-4 {
                                                              margin-top: 16px !important;
                                                            }
                                                      
                                                            .sm-block {
                                                              display: block !important;
                                                            }
                                                      
                                                            .sm-w-full {
                                                              width: 100% !important;
                                                            }
                                                      
                                                            .sm-px-4 {
                                                              padding-left: 16px !important;
                                                              padding-right: 16px !important;
                                                            }
                                                      
                                                            .sm-py-6 {
                                                              padding-top: 24px !important;
                                                              padding-bottom: 24px !important;
                                                            }
                                                          }
                                                        </style>
                                                      </head>
                                                      
                                                      <body
                                                        style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                        <div style='display: none'>
                                                        Email Update Successful!
                                                      
                                                        </div>
                                                        <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                          <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                            cellpadding='0' cellspacing='0' role='none'>
                                                            <tr>
                                                              <td align='center' style='background-color: #fff;'>
                                                                <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                                  <tr>
                                                                    <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                      <div style='margin-bottom: 24px'>
                                                                        <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                          <p>SweepStake Mobi</p>
                                                                        </a>
                                                                      </div>
                                                                      <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                        Hi <b>${user.first}</b>,
                                                                      </p>
                                                                      <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                      Your email id has been verified!
                                                                      </p>
                                                                     <br>
                                                                      <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                      Thank you for choosing SweepStake Mobi!
                                                                      </p>
                                                                      <div role='separator' style='line-height: 16px'>&zwj;</div> 
                                                                     
                                                                      <div style='text-align: center;'>
                                                                        <div role='separator'
                                                                          style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                        <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                          This email was sent to you as a registered member of
                                                                          <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                            style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                            class='sm-block sm-mt-4'>
                                                                            Use of the service and website is subject to our
                                                                            <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                              style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                            and
                                                                            <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                              style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                          </span>
                                                                        </p>
                                                                        <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                          rights reserved.</p>
                                                                      </div>
                                                                    </td>
                                                                  </tr>
                                                                </table>
                                                              </td>
                                                            </tr>
                                                          </table>
                                                        </div>
                                                      </body>
                                                      
                                                      </html>
                    `,
        };

        await axios.post('https://bend.logiclane.tech/api/email', payload1, {
            headers: {
                'Content-Type': 'application/json',
                Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
            },
        });

        const encdata = JSON.stringify({ status: 'success', message: 'New Email Verified' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));

    } catch (error) {
        console.error('Error in updateEmail:', error);
        const encdata = JSON.stringify({ status: 'error', message: 'Internal server error' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    } finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
}
exports.setNewEmail = async (req, res) => {
    const { newemail = '', vid = '', vcode = '', vcode2 = '' } = req.body;

    if (!newemail || !vid || !vcode || !vcode2) {
        const encdata = JSON.stringify({ status: 'error', message: 'Empty fields' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    try {
        const user = await User.findOne({ where: { vid } });

        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }

        if (user.vcode.toString() == vcode.toString() && user.vcode2.toString() == vcode2.toString()) {
            // Update user information
            await user.update({
                verified: 1,
                vid: '',
                vcode: '',
                vcode2: '',
                email: newemail,
            });

            // Prepare email payload
            const payload = {
                subject: 'Verification successful!',
                email: newemail,
                name: user.first,
                mail: `
               <!DOCTYPE html>
                                                      <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                                      
                                                      <head>
                                                        <meta charset='utf-8'>
                                                        <meta name='x-apple-disable-message-reformatting'>
                                                        <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                        <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                        <title>Verification successful!</title>
                                                        <style>
                                                          .hover-bg-brand-600:hover {
                                                            background-color: #0047C3 !important;
                                                          }
                                                      
                                                          .hover-text-brand-700:hover {
                                                            color: #003CA5 !important;
                                                          }
                                                      
                                                          .hover-text-decoration-underline:hover {
                                                            text-decoration: underline !important;
                                                          }
                                                      
                                                          @media (max-width: 768px) {
                                                            .sm-mt-4 {
                                                              margin-top: 16px !important;
                                                            }
                                                      
                                                            .sm-block {
                                                              display: block !important;
                                                            }
                                                      
                                                            .sm-w-full {
                                                              width: 100% !important;
                                                            }
                                                      
                                                            .sm-px-4 {
                                                              padding-left: 16px !important;
                                                              padding-right: 16px !important;
                                                            }
                                                      
                                                            .sm-py-6 {
                                                              padding-top: 24px !important;
                                                              padding-bottom: 24px !important;
                                                            }
                                                          }
                                                        </style>
                                                      </head>
                                                      
                                                      <body
                                                        style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                        <div style='display: none'>
                                                        Email Update Successful!
                                                      
                                                        </div>
                                                        <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                          <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                            cellpadding='0' cellspacing='0' role='none'>
                                                            <tr>
                                                              <td align='center' style='background-color: #fff;'>
                                                                <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                                  <tr>
                                                                    <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                      <div style='margin-bottom: 24px'>
                                                                        <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                          <p>SweepStake Mobi</p>
                                                                        </a>
                                                                      </div>
                                                                      <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                        Hi <b>${user.first}</b>,
                                                                      </p>
                                                                      <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                      Your email id has been verified!
                                                                      </p>
                                                                     <br>
                                                                      <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                      Thank you for choosing SweepStake Mobi!
                                                                      </p>
                                                                      <div role='separator' style='line-height: 16px'>&zwj;</div> 
                                                                     
                                                                      <div style='text-align: center;'>
                                                                        <div role='separator'
                                                                          style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                        <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                          This email was sent to you as a registered member of
                                                                          <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                            style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                            class='sm-block sm-mt-4'>
                                                                            Use of the service and website is subject to our
                                                                            <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                              style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                            and
                                                                            <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                              style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                          </span>
                                                                        </p>
                                                                        <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                          rights reserved.</p>
                                                                      </div>
                                                                    </td>
                                                                  </tr>
                                                                </table>
                                                              </td>
                                                            </tr>
                                                          </table>
                                                        </div>
                                                      </body>
                                                      
                                                      </html>`,
            };

            // Send email
            // await axios.post('https://bend.logiclane.tech/api/email', payload, {
            //     headers: {
            //         'Content-Type': 'application/json',
            //         Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
            //     },
            // });

            const encdata = JSON.stringify({ status: 'success', message: 'Email updated' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        } else {
            const encdata = JSON.stringify({ status: 'error', message: 'Invalid Verification Code(s)' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }
    } catch (error) {
        console.error('Error in setNewEmail:', error);
        const encdata = JSON.stringify({ status: 'error', message: 'Internal server error' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }
}
exports.resendNewEmail = async (req, res) => {
    const { userid, site } = req.body;
    if (!userid || !site) {
        const encdata = JSON.stringify({ status: 'error', message: 'Missing required parameters' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }
    try {
        const user = await User.findByPk(userid);
        if (!user) {
            const encdata = JSON.stringify({ status: 'error', message: 'User not found' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }
        const payload1 = {
            subject: 'Verify your account!',
            email: user.email,
            name: `${user.first} ${user.last}`,
            mail: `
            <!DOCTYPE html>
                                                                  <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                                                  
                                                                  <head>
                                                                    <meta charset='utf-8'>
                                                                    <meta name='x-apple-disable-message-reformatting'>
                                                                    <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                                    <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                                    <title>Verify your account!</title>
                                                                    <style>
                                                                      .hover-bg-brand-600:hover {
                                                                        background-color: #0047C3 !important;
                                                                      }
                                                                  
                                                                      .hover-text-brand-700:hover {
                                                                        color: #003CA5 !important;
                                                                      }
                                                                  
                                                                      .hover-text-decoration-underline:hover {
                                                                        text-decoration: underline !important;
                                                                      }
                                                                      @media (max-width: 640px) {
                                                                      .btn-class{
                                                                        width:100% !important;
                                                                      }
                                                                    }
                                                                      @media (max-width: 768px) {
                                                                        .sm-mt-4 {
                                                                          margin-top: 16px !important;
                                                                        }
                                                                  
                                                                        .sm-block {
                                                                          display: block !important;
                                                                        }
                                                                  
                                                                        .sm-w-full {
                                                                          width: 100% !important;
                                                                        }
                                                                        .btn-class{
                                                                          width:40% !important;
                                                                          margin: 0 auto;
                                                                        }
                                                                        .sm-px-4 {
                                                                          padding-left: 16px !important;
                                                                          padding-right: 16px !important;
                                                                        }
                                                                  
                                                                        .sm-py-6 {
                                                                          padding-top: 24px !important;
                                                                          padding-bottom: 24px !important;
                                                                        }
                                                                      }
                                                                    </style>
                                                                  </head>
                                                                  
                                                                  <body
                                                                    style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                                    <div style='display: none'>
                                                                    Updating your email account!
                                                                  
                                                                    </div>
                                                                    <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                                      <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                                        cellpadding='0' cellspacing='0' role='none'>
                                                                        <tr>
                                                                          <td align='center' style='background-color: #fff;'>
                                                                            <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                                              <tr>
                                                                                <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                                  <div style='margin-bottom: 24px'>
                                                                                    <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                                      <p>SweepStake Mobi</p>
                                                                                    </a>
                                                                                  </div>
                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                    Hi <b>${user.first}</b>,
                                                                                  </p>
                                                                                  <br>
                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                  Your password reset request has been submitted!
                                                                                  </p>
                                                                                 <br>
                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                                  Your reset verification code is <br><br><b>${user.vcode}</b>
                                                                                  </p>
                                                                                  <div role='separator' style='line-height: 16px'>&zwj;</div> 
                                                                                  <div class='btn-class'>
                                                                                  <a href='${site}/newemail?vid=${user.vid}'
                                                                                  class='sm-block hover-bg-brand-600'
                                                                                  style='text-decoration: none; display: inline-block; border-radius: 4px; background-color: #0052E2; padding: 16px 32px; text-align: center; font-size: 16px; line-height: 16px; font-weight: 700; color: #fff; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06)'>
                                                                                  <!--[if mso]><i style='letter-spacing: 32px; mso-font-width: -100%; mso-text-raise:30px;'>&#8202;</i><![endif]-->
                                                                                  <span style='mso-text-raise: 16px'>Confirm your email</span>
                                                                                  <!--[if mso]><i style='letter-spacing: 32px; mso-font-width: -100%;'>&#8202;</i><![endif]-->
                                                                                </a>  
                                                                                </div>
                                                                                <br><br>
                                                                                <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                                Thank you for choosing SweepStake Mobi!
                                                                                  </p>  
                                                                                  <div style='text-align: center;'>
                                                                                    <div role='separator'
                                                                                      style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                                    <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                                      This email was sent to you as a registered member of
                                                                                      <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                        style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                                        class='sm-block sm-mt-4'>
                                                                                        Use of the service and website is subject to our
                                                                                        <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                          style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                                        and
                                                                                        <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                          style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                                      </span>
                                                                                    </p>
                                                                                    <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                                      rights reserved.</p>
                                                                                  </div>
                                                                                </td>
                                                                              </tr>
                                                                            </table>
                                                                          </td>
                                                                        </tr>
                                                                      </table>
                                                                    </div>
                                                                  </body>
                                                                  
                                                                  </html>
            `, // Simplified for brevity
        };

        const payload2 = {
            subject: 'Verify your account!',
            email: user.nemail,
            name: user.first,
            mail: `
            <!DOCTYPE html>
                                                                  <html lang='en' dir='ltr' xmlns:v='urn:schemas-microsoft-com:vml'>
                                                                  
                                                                  <head>
                                                                    <meta charset='utf-8'>
                                                                    <meta name='x-apple-disable-message-reformatting'>
                                                                    <meta name='viewport' content='width=device-width, initial-scale=1'>
                                                                    <meta name='format-detection' content='telephone=no, date=no, address=no, email=no, url=no'>
                                                                    <title>Verify your account!</title>
                                                                    <style>
                                                                      .hover-bg-brand-600:hover {
                                                                        background-color: #0047C3 !important;
                                                                      }
                                                                  
                                                                      .hover-text-brand-700:hover {
                                                                        color: #003CA5 !important;
                                                                      }
                                                                  
                                                                      .hover-text-decoration-underline:hover {
                                                                        text-decoration: underline !important;
                                                                      }
                                                                  @media(max-width:640px){
                                                                    .btn-class{
                                                                      width:100% !important;
                                                                      
                                                                    }
                                                                  }
                                                                      @media (max-width: 768px) {
                                                                        .sm-mt-4 {
                                                                          margin-top: 16px !important;
                                                                        }
                                                                  
                                                                        .sm-block {
                                                                          display: block !important;
                                                                        }
                                                                  
                                                                        .sm-w-full {
                                                                          width: 100% !important;
                                                                        }
                                                                        .btn-class{
                                                                          width:40% !important;
                                                                          margin: 0 auto;
                                                                        }
                                                                        .sm-px-4 {
                                                                          padding-left: 16px !important;
                                                                          padding-right: 16px !important;
                                                                        }
                                                                  
                                                                        .sm-py-6 {
                                                                          padding-top: 24px !important;
                                                                          padding-bottom: 24px !important;
                                                                        }
                                                                      }
                                                                    </style>
                                                                  </head>
                                                                  
                                                                  <body
                                                                    style='margin: 0; width: 100%; background-color: #fff; padding: 0; -webkit-font-smoothing: antialiased; word-break: break-word'>
                                                                    <div style='display: none'>
                                                                    Updating your email account!
                                                                  
                                                                    </div>
                                                                    <div role='article' aria-roledescription='email' aria-label='Please confirm your email address' lang='en'>
                                                                      <table style='width: 100%; font-family: ui-sans-serif, system-ui, -apple-system, 'Segoe UI', sans-serif'
                                                                        cellpadding='0' cellspacing='0' role='none'>
                                                                        <tr>
                                                                          <td align='center' style='background-color: #fff;'>
                                                                            <table class='sm-w-full' style='width: 768px;margin:0 auto' cellpadding='0' cellspacing='0' role='none'>
                                                                              <tr>
                                                                                <td class='sm-px-4 sm-py-6' style='background-color: #fff; padding: 48px 40px; text-align: center'>
                                                                                  <div style='margin-bottom: 24px'>
                                                                                    <a href='https://wallet.sweepstake.mobi' style='text-decoration: none; color: #0047C3'>
                                                                                      <p>SweepStake Mobi</p>
                                                                                    </a>
                                                                                  </div>
                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                    Hi ${user.first},
                                                                                  </p>
                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566'>
                                                                                  Your password reset request has been submitted!
                                                                                  </p>
                                                                                 
                                                                                  <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                                  Your reset verification code is: ${user.vcode2}
                                                                                  </p>
                                                                                  <div role='separator' style='line-height: 16px'>&zwj;</div> 
                                                                                  <div class='btn-class'>
                                                                                  <a href='${site}/newemail?vid=${user.vid}'
                                                                                  class='sm-block hover-bg-brand-600'
                                                                                  style='text-decoration: none; display: inline-block; border-radius: 4px; background-color: #0052E2; padding: 16px 32px; text-align: center; font-size: 16px; line-height: 16px; font-weight: 700; color: #fff; box-shadow: 0 1px 3px 0 rgba(0, 0, 0, 0.1), 0 1px 2px 0 rgba(0, 0, 0, 0.06)'>
                                                                                  <!--[if mso]><i style='letter-spacing: 32px; mso-font-width: -100%; mso-text-raise:30px;'>&#8202;</i><![endif]-->
                                                                                  <span style='mso-text-raise: 16px'>Confirm your email</span>
                                                                                  <!--[if mso]><i style='letter-spacing: 32px; mso-font-width: -100%;'>&#8202;</i><![endif]-->
                                                                                </a>  
                                                                                </div>
                                                                                <p style='margin: 0; font-size: 21px; line-height: 28px; color: #4A5566;'>
                                                                                Thank you for choosing SweepStake Mobi!
                                                                                  </p>  
                                                                                  <div style='text-align: center;'>
                                                                                    <div role='separator'
                                                                                      style='background-color: #E1E1EA; height: 1px; line-height: 1px; margin: 64px 0 16px'>&zwj;</div>
                                                                                    <p style='margin: 0 0 16px; font-size: 12px; line-height: 16px; color: #8492A6'>
                                                                                      This email was sent to you as a registered member of
                                                                                      <a href='https://sweepstake.mobi' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                        style='text-decoration: none; color: #0047C3; display: inline-block;'>SweepStake Mobi</a>. <span
                                                                                        class='sm-block sm-mt-4'>
                                                                                        Use of the service and website is subject to our
                                                                                        <a href='https://sweepstake.mobi/tnc.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                          style='text-decoration: none; color: #0047C3; display: inline-block;'>Terms of Use</a>
                                                                                        and
                                                                                        <a href='https://sweepstake.mobi/privacy-policy.php' class='hover-text-brand-700 hover-text-decoration-underline'
                                                                                          style='text-decoration: none; color: #0047C3; display: inline-block;'>Privacy Statement</a>.
                                                                                      </span>
                                                                                    </p>
                                                                                    <p style='margin: 0; font-size: 12px; line-height: 16px; color: #8492A6;'>&copy; 2024 SweepStake Mobi. All
                                                                                      rights reserved.</p>
                                                                                  </div>
                                                                                </td>
                                                                              </tr>
                                                                            </table>
                                                                          </td>
                                                                        </tr>
                                                                      </table>
                                                                    </div>
                                                                  </body>
                                                                  
                                                                  </html>
            `,
        };

        // await axios.post('https://bend.logiclane.tech/api/email', payload1, {
        //     headers: {
        //         'Content-Type': 'application/json',
        //         Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
        //     },
        // });

        // await axios.post('https://bend.logiclane.tech/api/email', payload2, {
        //     headers: {
        //         'Content-Type': 'application/json',
        //         Authorization: 'Bearer 4d0f394ec46be1c61d203a4df09da3277aa8c520d922533bf332c7db2c261f61',
        //     },
        // });

        const encdata = JSON.stringify({ status: 'success', message: 'Verification emails re-sent' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    } catch (error) {
        console.error('Error in updateEmail:', error);
        const encdata = JSON.stringify({ status: 'error', message: 'Internal server error' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }
}
exports.getUserIP = async (req, res) => {

    const { userid } = req.body;
    const sanitizedUserId = parseInt(userid, 10);

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }
    // Sanitize input

    try {
        // Fetch data from `ips` table
        const [datachk] = await db.query(
            'SELECT * FROM `ips` WHERE `userid` = :sanitizedUserId',
            {
                replacements: { sanitizedUserId },
                type: db.QueryTypes.SELECT,
            }
        );

        // Fetch the latest user token
        const [datachk2] = await db.query(
            'SELECT * FROM `usertokens` WHERE `userid` = :sanitizedUserId ORDER BY `id` DESC LIMIT 1',
            {
                replacements: { sanitizedUserId },
                type: db.QueryTypes.SELECT,
            }
        );

        if (datachk && datachk2) {
            const dtx = {
                changed: datachk.changed,
                changeverified: datachk.changeverified,
                ip: datachk.ip,
                userid: datachk.userid,
                vtoken: datachk2.token,
            };

            const encdata = JSON.stringify({ status: 'success', data: dtx });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        } else {
            const encdata = JSON.stringify({ status: 'error', message: 'IP does not exist!' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        }
    } catch (error) {
        console.error('Error in getUserIP:', error);
        const encdata = JSON.stringify({ status: 'error', message: 'Internal server error' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }
}
exports.requestBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await Bonus.findOne({ where: { userid: sanitizedUserId } });

                if (!bonus) {
                    const createReq = await Bonus.create({ userid: sanitizedUserId });

                    if (createReq) {
                        const encData = JSON.stringify({ status: 'success', message: 'Bonus requested!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.bonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await Bonus.findOne({ where: { userid: sanitizedUserId } });

            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestRiverSweepsBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_rs_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await STPBonus2.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '3' } });
                if (!bonus) {
                    if (linkedGame) {
                        const createReq = await STPBonus2.create({ userid: sanitizedUserId, status: '0' });
                        const bonusReq = await Transactions.create({
                            userid: user.id,
                            txnby: 'SELF',
                            type: 1,
                            amount: 1,
                            gameid: linkedGame.gameid,
                            gameuser: linkedGame.gameuser,
                            paidmethod: "River Sweeps Bonus",
                            capp: "",
                            paidto: "River Sweeps",
                            status: '0',
                        });
                        createReq.txn_id = bonusReq.id;
                        await createReq.save();
                        if (createReq) {
                            const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'You dont have RiverSweeps game, please request for the game from Request Game section!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.riverSweepsBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await STPBonus2.findOne({ where: { userid: sanitizedUserId } });

            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestUPBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_up_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await UPBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '9' } });
                if (!bonus) {
                    if (linkedGame) {
                        const createReq = await UPBonus.create({ userid: sanitizedUserId, status: '0' });
                        const bonusReq = await Transactions.create({
                            userid: user.id,
                            txnby: 'SELF',
                            type: 1,
                            amount: 1,
                            gameid: linkedGame.gameid,
                            gameuser: linkedGame.gameuser,
                            paidmethod: "Ultra Panda Bonus",
                            capp: "",
                            paidto: "Ultra Panda",
                            status: '0',
                        });
                        createReq.txn_id = bonusReq.id;
                        await createReq.save();
                        if (createReq) {
                            const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'You dont have Ultra Panda game, please request for the game from Request Game section!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.upBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await UPBonus.findOne({ where: { userid: sanitizedUserId } });

            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestFKBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_up_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await FKBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '2' } });
                if (!bonus) {
                    if (linkedGame) {
                        const createReq = await FKBonus.create({ userid: sanitizedUserId, status: '0' });
                        const bonusReq = await Transactions.create({
                            userid: user.id,
                            txnby: 'SELF',
                            type: 1,
                            amount: 1,
                            gameid: linkedGame.gameid,
                            gameuser: linkedGame.gameuser,
                            paidmethod: "Fire Kirin Bonus",
                            capp: "",
                            paidto: "Fire Kirin",
                            status: '0',
                        });
                        createReq.txn_id = bonusReq.id;
                        await createReq.save();
                        if (createReq) {
                            const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'You dont have Fire Kirin game, please request for the game from Request Game section!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.fkBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await FKBonus.findOne({ where: { userid: sanitizedUserId } });

            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestVBBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_vb_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await VBBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '4' } });
                if (!bonus) {
                    if (linkedGame) {
                        const createReq = await VBBonus.create({ userid: sanitizedUserId, status: '0' });
                        const bonusReq = await Transactions.create({
                            userid: user.id,
                            txnby: 'SELF',
                            type: 1,
                            amount: 1,
                            gameid: linkedGame.gameid,
                            gameuser: linkedGame.gameuser,
                            paidmethod: "VBlink Bonus",
                            capp: "",
                            paidto: "VBlink",
                            status: '0',
                        });
                        createReq.txn_id = bonusReq.id;
                        await createReq.save();
                        if (createReq) {
                            const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'You dont have VBlink game, please request for the game from Request Game section!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.vbBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await VBBonus.findOne({ where: { userid: sanitizedUserId } });

            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestVXBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid, bonus_code } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_vx_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await VXBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '15' } });
                if (!bonus) {
                    if (bonus_code == 'VXRC777') {
                        if (linkedGame) {
                            const createReq = await VXBonus.create({ userid: sanitizedUserId, status: '0' });
                            const bonusReq = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: 1,
                                gameid: linkedGame.gameid,
                                gameuser: linkedGame.gameuser,
                                paidmethod: "Vegas X Bonus",
                                capp: "",
                                paidto: "Vegas X",
                                status: '0',
                            });
                            createReq.txn_id = bonusReq.id;
                            await createReq.save();
                            if (createReq) {
                                const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encData = JSON.stringify({ status: 'error', message: 'You dont have Vegas X game, please request for the game from Request Game section!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'Incorrect Bonus Code!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.vxBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await VXBonus.findOne({ where: { userid: sanitizedUserId } });

            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestGRBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_gr_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await GRBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '26' } });
                if (!bonus) {
                    if (linkedGame) {
                        const createReq = await GRBonus.create({ userid: sanitizedUserId, status: '0' });
                        const bonusReq = await Transactions.create({
                            userid: user.id,
                            txnby: 'SELF',
                            type: 1,
                            amount: 1,
                            gameid: linkedGame.gameid,
                            gameuser: linkedGame.gameuser,
                            paidmethod: "Gameroom Bonus",
                            capp: "",
                            paidto: "Gameroom",
                            status: '0',
                        });
                        createReq.txn_id = bonusReq.id;
                        await createReq.save();
                        if (createReq) {
                            const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'You dont have Gameroom game, please request for the game from Request Game section!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.grBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await GRBonus.findOne({ where: { userid: sanitizedUserId } });

            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestOSBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_os_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await OSBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '14' } });
                if (!bonus) {
                    if (linkedGame) {
                        const createReq = await OSBonus.create({ userid: sanitizedUserId, status: '0' });
                        const bonusReq = await Transactions.create({
                            userid: user.id,
                            txnby: 'SELF',
                            type: 1,
                            amount: 1,
                            gameid: linkedGame.gameid,
                            gameuser: linkedGame.gameuser,
                            paidmethod: "Orion Stars Bonus",
                            capp: "",
                            paidto: "Orion Stars",
                            status: '0',
                        });
                        createReq.txn_id = bonusReq.id;
                        await createReq.save();
                        if (createReq) {
                            const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'You dont have Orion Stars game, please request for the game from Request Game section!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.osBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await OSBonus.findOne({ where: { userid: sanitizedUserId } });

            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestGVBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_gv_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await GVBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '36' } });
                if (!bonus) {
                    if (linkedGame) {
                        const createReq = await GVBonus.create({ userid: sanitizedUserId, status: '0' });
                        const bonusReq = await Transactions.create({
                            userid: user.id,
                            txnby: 'SELF',
                            type: 1,
                            amount: 1,
                            gameid: linkedGame.gameid,
                            gameuser: linkedGame.gameuser,
                            paidmethod: "Game Vault Bonus",
                            capp: "",
                            paidto: "Game Vault",
                            status: '0',
                        });
                        createReq.txn_id = bonusReq.id;
                        await createReq.save();
                        if (createReq) {
                            const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'You dont have Game Vault game, please request for the game from Request Game section!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.gvBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await GVBonus.findOne({ where: { userid: sanitizedUserId } });

            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestDGBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_dg_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await DGBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '50' } });
                if (!bonus) {
                    if (linkedGame) {
                        const createReq = await DGBonus.create({ userid: sanitizedUserId, status: '0' });
                        const bonusReq = await Transactions.create({
                            userid: user.id,
                            txnby: 'SELF',
                            type: 1,
                            amount: 1,
                            gameid: linkedGame.gameid,
                            gameuser: linkedGame.gameuser,
                            paidmethod: "Dragon Game Bonus",
                            capp: "",
                            paidto: "Dragon Game",
                            status: '0',
                        });
                        createReq.txn_id = bonusReq.id;
                        await createReq.save();
                        if (createReq) {
                            const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'You dont have Dragon Game game, please request for the game from Request Game section!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.dgBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await DGBonus.findOne({ where: { userid: sanitizedUserId } });

            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestBDBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid, bonus_code } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_bd_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await BDBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '7' } });
                if (!bonus) {
                    if (bonus_code == 'RC777') {
                        if (linkedGame) {
                            const createReq = await BDBonus.create({ userid: sanitizedUserId, status: '0' });
                            const bonusReq = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: 1,
                                gameid: linkedGame.gameid,
                                gameuser: linkedGame.gameuser,
                                paidmethod: "Blue Dragon Bonus",
                                capp: "",
                                paidto: "Blue Dragon",
                                status: '0',
                            });
                            createReq.txn_id = bonusReq.id;
                            await createReq.save();
                            if (createReq) {
                                const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encData = JSON.stringify({ status: 'error', message: 'You dont have Blue Dragon game, please request for the game from Request Game section!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'Incorrect Bonus Code!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.bdBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await BDBonus.findOne({ where: { userid: sanitizedUserId } });

            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestJuwaNewBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid, bonus_code } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_juwa_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await JWBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '12' } });
                if (!bonus) {
                    if (bonus_code == 'JUWA7') {
                        if (linkedGame) {
                            const createReq = await JWBonus.create({ userid: sanitizedUserId, status: '0' });
                            const bonusReq = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: 1,
                                gameid: linkedGame.gameid,
                                gameuser: linkedGame.gameuser,
                                paidmethod: "Juwa Bonus",
                                capp: "",
                                paidto: "Juwa",
                                status: '0',
                            });
                            createReq.txn_id = bonusReq.id;
                            await createReq.save();
                            if (createReq) {
                                const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encData = JSON.stringify({ status: 'error', message: 'You dont have Juwa game, please request for the game from Request Game section!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'Incorrect Bonus Code!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.juwaNewBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await JWBonus.findOne({ where: { userid: sanitizedUserId } });
            const allowed = await checkUserNMIStatus(user.id);
            if (!allowed) {
                const encData = JSON.stringify({ status: '6' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestOStarsBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid, bonus_code } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_ostars_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await OStarsBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '14' } });
                if (!bonus) {
                    if (bonus_code == 'OSRC7') {
                        if (linkedGame) {
                            const createReq = await OStarsBonus.create({ userid: sanitizedUserId, status: '0' });
                            const bonusReq = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: 1,
                                gameid: linkedGame.gameid,
                                gameuser: linkedGame.gameuser,
                                paidmethod: "Orion Stars Bonus",
                                capp: "",
                                paidto: "Orion Stars",
                                status: '0',
                            });
                            createReq.txn_id = bonusReq.id;
                            await createReq.save();
                            if (createReq) {
                                const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encData = JSON.stringify({ status: 'error', message: 'You dont have Orion Stars game, please request for the game from Request Game section!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'Incorrect Bonus Code!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.ostarsBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await OStarsBonus.findOne({ where: { userid: sanitizedUserId } });

            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestGDBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid, bonus_code } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_gd_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await GDBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '14' } });
                if (!bonus) {
                    if (bonus_code == 'GDNCRC') {
                        if (linkedGame) {
                            const createReq = await GDBonus.create({ userid: sanitizedUserId, status: '0' });
                            const bonusReq = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: 1,
                                gameid: linkedGame.gameid,
                                gameuser: linkedGame.gameuser,
                                paidmethod: "Golden Dragon Bonus",
                                capp: "",
                                paidto: "Golden Dragon",
                                status: '0',
                            });
                            createReq.txn_id = bonusReq.id;
                            await createReq.save();
                            if (createReq) {
                                const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encData = JSON.stringify({ status: 'error', message: 'You dont have Golden Dragon game, please request for the game from Request Game section!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'Incorrect Bonus Code!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.gdBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await GDBonus.findOne({ where: { userid: sanitizedUserId } });

            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestMCBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid, bonus_code } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_mc_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await MCBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '22' } });
                if (!bonus) {
                    if (bonus_code == 'MC777') {
                        if (linkedGame) {
                            const createReq = await MCBonus.create({ userid: sanitizedUserId, status: '0' });
                            const bonusReq = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: 1,
                                gameid: linkedGame.gameid,
                                gameuser: linkedGame.gameuser,
                                paidmethod: "Magic City Bonus",
                                capp: "",
                                paidto: "Magic City",
                                status: '0',
                            });
                            createReq.txn_id = bonusReq.id;
                            await createReq.save();
                            if (createReq) {
                                const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encData = JSON.stringify({ status: 'error', message: 'You dont have Magic City game, please request for the game from Request Game section!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'Incorrect Bonus Code!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.mcBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await MCBonus.findOne({ where: { userid: sanitizedUserId } });

            if (bonus) {
                const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.ostarsStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '14' } });
            console.log(linkedGame)
            if (!linkedGame) {
                const encdata = JSON.stringify({ status: 'success', has_game: '2' });
                return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
            }
            const encdata = JSON.stringify({ status: 'success', has_game: '1' });
            return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}

exports.requestVB2Bonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid, bonus_code } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_juwa_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await VB2Bonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '4' } });
                if (!bonus) {
                    if (bonus_code == 'VBRC777') {
                        if (linkedGame) {
                            const createReq = await VB2Bonus.create({ userid: sanitizedUserId, status: '0' });
                            const bonusReq = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: 1,
                                gameid: linkedGame.gameid,
                                gameuser: linkedGame.gameuser,
                                paidmethod: "VBlink Bonus",
                                capp: "",
                                paidto: "VBlink",
                                status: '0',
                            });
                            createReq.txn_id = bonusReq.id;
                            await createReq.save();
                            if (createReq) {
                                const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encData = JSON.stringify({ status: 'error', message: 'You dont have VBlink game, please request for the game from Request Game section!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'Incorrect Bonus Code!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.vb2BonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await VB2Bonus.findOne({ where: { userid: sanitizedUserId } });
            const allowed = await checkUserNMIStatus(user.id);
            if (!allowed) {
                const encData = JSON.stringify({ status: '6' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
            if (bonus) {
                const txn = await Transactions.findOne({ where: { id: bonus.txn_id } })
                const encData = JSON.stringify({ status: txn.status });
                // const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestGSBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid, bonus_code } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_juwa_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await GSBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '53' } });
                if (!bonus) {
                    if (bonus_code == 'GSRC777') {
                        if (linkedGame) {
                            const createReq = await GSBonus.create({ userid: sanitizedUserId, status: '0' });
                            const bonusReq = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: 1,
                                gameid: linkedGame.gameid,
                                gameuser: linkedGame.gameuser,
                                paidmethod: "Golden Spin Bonus",
                                capp: "",
                                paidto: "Golden Spin",
                                status: '0',
                            });
                            createReq.txn_id = bonusReq.id;
                            await createReq.save();
                            if (createReq) {
                                const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encData = JSON.stringify({ status: 'error', message: 'You dont have Golden Spin game, please request for the game from Request Game section!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'Incorrect Bonus Code!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.gsBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await GSBonus.findOne({ where: { userid: sanitizedUserId } });
            const allowed = await checkUserNMIStatus(user.id);
            if (!allowed) {
                const encData = JSON.stringify({ status: '6' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
            if (bonus) {
                console.log(bonus)
                const txn = await Transactions.findOne({ where: { id: bonus.txn_id } })
                console.log(txn)

                const encData = JSON.stringify({ status: txn.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestCCBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid, bonus_code } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_juwa_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await CCBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '54' } });
                if (!bonus) {
                    if (bonus_code == 'CCRCSWPS') {
                        if (linkedGame) {
                            const createReq = await CCBonus.create({ userid: sanitizedUserId, status: '0' });
                            const bonusReq = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: 1,
                                gameid: linkedGame.gameid,
                                gameuser: linkedGame.gameuser,
                                paidmethod: "Clover Crown Bonus",
                                capp: "",
                                paidto: "Clover Crown",
                                status: '0',
                            });
                            createReq.txn_id = bonusReq.id;
                            await createReq.save();
                            if (createReq) {
                                const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encData = JSON.stringify({ status: 'error', message: 'You dont have Clover Crown game, please request for the game from Request Game section!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'Incorrect Bonus Code!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.ccBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await CCBonus.findOne({ where: { userid: sanitizedUserId } });
            const allowed = await checkUserNMIStatus(user.id);
            if (!allowed) {
                const encData = JSON.stringify({ status: '6' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
            if (bonus) {
                const txn = await Transactions.findOne({ where: { id: bonus.txn_id } })
                const encData = JSON.stringify({ status: txn.status });
                // const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestTREXBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid, bonus_code } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_trex_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await TrexBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '39' } });
                if (!bonus) {
                    if (bonus_code == 'DUMMY777') {
                        if (linkedGame) {
                            const createReq = await TrexBonus.create({ userid: sanitizedUserId, status: '0' });
                            const bonusReq = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: 1,
                                gameid: linkedGame.gameid,
                                gameuser: linkedGame.gameuser,
                                paidmethod: "TRex Bonus",
                                capp: "",
                                paidto: "TRex",
                                status: '0',
                            });
                            createReq.txn_id = bonusReq.id;
                            await createReq.save();
                            if (createReq) {
                                const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encData = JSON.stringify({ status: 'error', message: 'You dont have TRex game, please request for the game from Request Game section!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'Incorrect Bonus Code!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.trexBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await TrexBonus.findOne({ where: { userid: sanitizedUserId } });
            const allowed = await checkUserNMIStatus(user.id);
            if (!allowed) {
                const encData = JSON.stringify({ status: '6' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
            if (bonus) {
                const txn = await Transactions.findOne({ where: { id: bonus.txn_id } })
                const encData = JSON.stringify({ status: txn.status });
                // const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}

exports.requestBMBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid, bonus_code } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_bm_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await BMBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '55' } });
                if (!bonus) {
                    if (bonus_code == 'BM777RC') {
                        if (linkedGame) {
                            const createReq = await BMBonus.create({ userid: sanitizedUserId, status: '0' });
                            const bonusReq = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: 1,
                                gameid: linkedGame.gameid,
                                gameuser: linkedGame.gameuser,
                                paidmethod: "Black Mamba Bonus",
                                capp: "",
                                paidto: "Black Mamba",
                                status: '0',
                            });
                            createReq.txn_id = bonusReq.id;
                            await createReq.save();
                            if (createReq) {
                                const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encData = JSON.stringify({ status: 'error', message: 'You dont have Black Mamba game, please request for the game from Request Game section!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'Incorrect Bonus Code!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.bmBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await BMBonus.findOne({ where: { userid: sanitizedUserId } });
            const allowed = await checkUserNMIStatus(user.id);
            if (!allowed) {
                const encData = JSON.stringify({ status: '6' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
            if (bonus) {
                const txn = await Transactions.findOne({ where: { id: bonus.txn_id } })
                const encData = JSON.stringify({ status: txn.status });
                // const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}

exports.requestRSBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid, bonus_code } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_rs_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await RSBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '3' } });
                if (!bonus) {
                    if (bonus_code == 'RS777RC') {
                        if (linkedGame) {
                            const createReq = await RSBonus.create({ userid: sanitizedUserId, status: '0' });
                            const bonusReq = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: 1,
                                gameid: linkedGame.gameid,
                                gameuser: linkedGame.gameuser,
                                paidmethod: "River Sweeps Bonus",
                                capp: "",
                                paidto: "River Sweeps",
                                status: '0',
                            });
                            createReq.txn_id = bonusReq.id;
                            await createReq.save();
                            if (createReq) {
                                const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encData = JSON.stringify({ status: 'error', message: 'You dont have River Sweeps game, please request for the game from Request Game section!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'Incorrect Bonus Code!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.rsBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await RSBonus.findOne({ where: { userid: sanitizedUserId } });
            const allowed = await checkUserNMIStatus(user.id);
            if (!allowed) {
                const encData = JSON.stringify({ status: '6' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
            if (bonus) {
                const txn = await Transactions.findOne({ where: { id: bonus.txn_id } })
                const encData = JSON.stringify({ status: txn.status });
                // const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestFKXBonus = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid, bonus_code } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_fkx_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                const bonus = await FKNewBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: '2' } });
                if (!bonus) {
                    if (bonus_code == 'FK777RC') {
                        if (linkedGame) {
                            const createReq = await FKNewBonus.create({ userid: sanitizedUserId, status: '0' });
                            const bonusReq = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: 1,
                                gameid: linkedGame.gameid,
                                gameuser: linkedGame.gameuser,
                                paidmethod: "Fire Kirin Bonus",
                                capp: "",
                                paidto: "Fire Kirin",
                                status: '0',
                            });
                            createReq.txn_id = bonusReq.id;
                            await createReq.save();
                            if (createReq) {
                                const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encData = JSON.stringify({ status: 'error', message: 'You dont have Fire Kirin game, please request for the game from Request Game section!' });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'Incorrect Bonus Code!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.fkxBonusStatus = async (req, res) => {

    const { userid } = req.body;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });
            const bonus = await FKNewBonus.findOne({ where: { userid: sanitizedUserId } });
            const allowed = await checkUserNMIStatus(user.id);
            if (!allowed) {
                const encData = JSON.stringify({ status: '6' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
            if (bonus) {
                const txn = await Transactions.findOne({ where: { id: bonus.txn_id } })
                const encData = JSON.stringify({ status: txn.status });
                // const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.requestB = async (req, res) => {
    // Assuming middleware attaches the token to the request
    const { userid, bonus_code } = req.body;
    const bonusShort = req.params.bonus;

    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid
    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;


    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const lockFilePath = path.join('/', `request_fkx_bonus_${userid}.lock`);
    let releaseLock;

    try {
        // Lock the file for exclusive access
        fs.writeFileSync(lockFilePath, '', { flag: 'w' });
        releaseLock = await lockfile.lock(lockFilePath);
        const bonuses = await AllBonuses.findOne({ where: { table: bonusShort } })
        if (!bonuses) {
            const encData = JSON.stringify({ status: 'error', message: 'Bonus not found' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.json(encryptedData);
        }

        const tableName = bonuses.table;

        // Create model dynamically
        const BonusModel = createBonusModel(tableName);

        const bonus = await BonusModel.findOne({ where: { userid: sanitizedUserId } });

        if (sanitizedUserId) {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            if (user.pidv == '1' && user.namev == '1') {
                // const bonus = await FKNewBonus.findOne({ where: { userid: sanitizedUserId } });
                const linkedGame = await LinkedGames.findOne({ where: { userid: sanitizedUserId, gameid: bonuses.game } });
                const game = await Game.findOne({
                    where: { id: bonuses.game },
                    attributes: ['id', 'name']
                })
                if (!bonus) {
                    if (bonus_code == bonuses.bonus_code) {
                        if (linkedGame) {
                            const createReq = await BonusModel.create({ userid: sanitizedUserId, status: '0' });
                            const bonusReq = await Transactions.create({
                                userid: user.id,
                                txnby: 'SELF',
                                type: 1,
                                amount: 1,
                                gameid: linkedGame.gameid,
                                gameuser: linkedGame.gameuser,
                                paidmethod: bonuses.bonus,
                                capp: "",
                                paidto: game.name,
                                status: '0',
                            });
                            createReq.txn_id = bonusReq.id;
                            await createReq.save();
                            if (createReq) {
                                const encData = JSON.stringify({ status: 'success', message: 'Bonus has been requested to your account!' });
                                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                                return res.json(encryptedData);
                            }
                        } else {
                            const encData = JSON.stringify({ status: 'error', message: `You dont have ${game.name} game, please request for the game from Request Game section!` });
                            const encryptedData = encrypt(encData, process.env.ENC_KEY);
                            return res.json(encryptedData);
                        }
                    } else {
                        const encData = JSON.stringify({ status: 'error', message: 'Incorrect Bonus Code!' });
                        const encryptedData = encrypt(encData, process.env.ENC_KEY);
                        return res.json(encryptedData);
                    }
                } else {
                    const encData = JSON.stringify({ status: 'error', message: 'You already have requested for bonus!' });
                    const encryptedData = encrypt(encData, process.env.ENC_KEY);
                    return res.json(encryptedData);
                }
            } else {
                const encData = JSON.stringify({ status: 'error', message: 'Please verify your account to proceed' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        }

    } catch (error) {
        console.error('Error processing bonus request:', error);
        const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
        const encryptedData = encrypt(encData, process.env.ENC_KEY);
        return res.status(200).json(encryptedData);
    }
    finally {
        try {
            // Release the lock
            if (releaseLock) {
                await releaseLock();
            }

            // Delete the lock file
            if (fs.existsSync(lockFilePath)) {
                fs.unlinkSync(lockFilePath);
            }
        } catch (cleanupError) {
            console.error('Error cleaning up lock file:', cleanupError);
        }
    }
};
exports.bStatus = async (req, res) => {

    const { userid } = req.body;
    const bonusShort = req.params.bonus;
    const sanitizedUserId = parseInt(userid, 10); // Sanitize userid

    const authHeader = req.headers['authorization'] || req.headers['Authorization'];
    if (!authHeader) {
        const encdata = JSON.stringify({ status: 'error', message: 'Authorization token missing' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    const token = authHeader.split(' ')[1];
    let decoded;
    try {
        decoded = jwt.verify(token, process.env.JWT_SECRET);
    } catch (err) {
        const encdata = JSON.stringify({ status: 'error', message: 'Invalid or expired token' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (decoded.id != parseInt(userid)) {
        const encdata = JSON.stringify({ status: 'error', message: 'Unauthorized action' });
        return res.status(200).json(encrypt(encdata, process.env.ENC_KEY));
    }

    if (sanitizedUserId) {
        try {
            const user = await User.findOne({ where: { id: sanitizedUserId } });

            const bonuses = await AllBonuses.findOne({ where: { table: bonusShort } })
            if (!bonuses) {
                const encData = JSON.stringify({ status: 'error', message: 'Bonus not found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }

            const tableName = bonuses.table;

            // Create model dynamically
            const BonusModel = createBonusModel(tableName);

            const bonus = await BonusModel.findOne({ where: { userid: sanitizedUserId } });
            const allowed = await checkUserNMIStatus(user.id);
            if (!allowed) {
                const encData = JSON.stringify({ status: '6' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
            if (bonus) {
                const txn = await Transactions.findOne({ where: { id: bonus.txn_id } })
                const encData = JSON.stringify({ status: txn.status });
                // const encData = JSON.stringify({ status: bonus.status });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else if (user.pidv != '1' && user.namev != '1') {
                const encData = JSON.stringify({ status: '4' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            } else {
                const encData = JSON.stringify({ status: '5', message: 'No request found' });
                const encryptedData = encrypt(encData, process.env.ENC_KEY);
                return res.json(encryptedData);
            }
        } catch (error) {
            console.error('Error fetching user or bonus:', error);
            const encData = JSON.stringify({ status: 'error', message: 'Internal server error' });
            const encryptedData = encrypt(encData, process.env.ENC_KEY);
            return res.status(200).json(encryptedData);
        }
    }

}
exports.allBonuses = async (req, res) => {
    const allBonuses = await AllBonuses.findAll({ attributes: ['id', 'request_ep', 'status_ep', 'info', 'link', 'enabled', 'table', 'short', 'bonus', 'game'] });
    const encData = JSON.stringify({ status: 'success', data: allBonuses });
    // console.log(encData)
    const encryptedData = encrypt(encData, process.env.ENC_KEY);
    return res.json(encryptedData);
}
async function checkUserNMIStatus(userid) {
    const user = await User.findOne({ where: { id: userid } });

    if (user) {
        const card2allowed = user.card2allowed === '1';
        const apallowed = user.apallowed === '1';
        const gpallowed = user.gpallowed === '1';

        if (card2allowed && apallowed && gpallowed) {
            return '1';
        } else {
            return '0';
        }
    }

    return '0'; // Return 0 if user not found, to mimic PHP's implicit behavior
}