const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const ActivityLog = db.define('ActivityLog', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    date: {
        type: DataTypes.STRING,
        allowNull: true
    },
    admin: {
        type: DataTypes.STRING,
        allowNull: true
    },
    activity: {
        type: DataTypes.STRING,
        allowNull: true
    },
    userid: {
        type: DataTypes.STRING,
        allowNull: true
    }
}, {
    tableName: 'activitylog',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = ActivityLog;