const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const AllBonuses = db.define('AllBonuses', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    bonus: {
        type: DataTypes.STRING,
        allowNull: true
    },
    short: {
        type: DataTypes.STRING,
        allowNull: true
    },
    table: {
        type: DataTypes.STRING,
        allowNull: true
    },
    enabled: {
        type: DataTypes.STRING,
        allowNull: true
    },
    info: {
        type: DataTypes.STRING,
        allowNull: true
    },
    link: {
        type: DataTypes.STRING,
        allowNull: true
    },
    status_ep: {
        type: DataTypes.STRING,
        allowNull: true
    },
    request_ep: {
        type: DataTypes.STRING,
        allowNull: true
    },
    game: {
        type: DataTypes.STRING,
        allowNull: true
    },
    bonus_code: {
        type: DataTypes.STRING,
        allowNull: true
    }
}, {
    tableName: 'all_bonuses',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});



module.exports = AllBonuses;