const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');
const User = require('./User')
const BRTransactions = db.define('BRTransactions', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    userid: {
        type: DataTypes.STRING,
        allowNull: false
    },
    time: {
        type: DataTypes.DATE,
        allowNull: true
    },
    txnby: {
        type: DataTypes.STRING,
        allowNull: false
    },
    type: {
        type: DataTypes.STRING,
        allowNull: false
    },
    amount: {
        type: DataTypes.DECIMAL,
        allowNull: false
    }, 
    method: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cashier: {
        type: DataTypes.STRING,
        allowNull: true
    },
    status: {
        type: DataTypes.STRING,
        allowNull: true
    },
    cbalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    ubalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    crebalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    urebalance: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    ccancelbal: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    ucancelbal: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    cbonusbal: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
    ubonusbal: {
        type: DataTypes.FLOAT,
        allowNull: true
    },
}, {
    tableName: 'brdeposits',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});
BRTransactions.belongsTo(User, { foreignKey: 'userid' });

module.exports = BRTransactions;