const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');

const LinkedGames = db.define('LinkedGames', {
    id: {
        type: DataTypes.INTEGER,
        allowNull: false,
        autoIncrement: true,
        primaryKey: true
    },
    userid: {
        type: DataTypes.STRING,
        allowNull: true
    },
    gameid: {
        type: DataTypes.STRING,
        allowNull: true
    },
    gameuser: {
        type: DataTypes.STRING,
        allowNull: true
    },
    enabled: {
        type: DataTypes.STRING,
        allowNull: true
    },
   

}, {
    tableName: 'linkedgames',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = LinkedGames;