const { DataTypes } = require('sequelize');
const bcrypt = require('bcryptjs');
const db = require('../config/db.config');

const PayoutMethods = db.define('PayoutMethods', {
    paypal: {
        type: DataTypes.STRING,
        allowNull: false
    },
    venmo: {
        type: DataTypes.STRING,
        allowNull: false
    },
    gtw: {
        type: DataTypes.STRING,
        allowNull: false
    },
    ach: {
        type: DataTypes.STRING,
        allowNull: false
    },
    pnmach: {
        type: DataTypes.STRING,
        allowNull: false
    },
    pnmcard: {
        type: DataTypes.STRING,
        allowNull: false
    },
    coinflow:{
        type: DataTypes.STRING,
        allowNull: false
    }
}, {
    tableName: 'cashoutsettings',
    timestamps: true,
    createdAt: 'created_at',
    updatedAt: 'updated_at'
});

module.exports = PayoutMethods;